<?php

class Claims extends CI_Controller 
{
	var $viewfile = "generator_xml_dynamic_resized_288x216-C";

	public function __construct()
	{
		parent::__construct();
		$this->load->helper('generator');
		$this->load->model('generator_model', 'ticket_generator');
		$this->load->model('users_model', 'users');
		$this->load->model('venues_model', 'venues');
		$this->load->model('sections_model', 'sections');
		$this->load->model('seatplans_model', 'seatplans');
		$this->load->model('events_model', 'events');
		$this->load->model('transactions_model', 'transactions');
		$this->load->model('prices_model', 'prices');
		$this->load->model('tickets_model', 'tickets');
		$this->load->model('ticket_types_model', 'ticket_types');
		$this->load->model('customers_model', 'customers');
		$this->load->model('reservations_model', 'reservations');
		$this->load->model('logs_model', 'logs');
		$this->load->model('payment_types_model', 'payment_types');
		$this->load->model('payments_model', 'payments');
		$this->load->model('branches_model', 'branches');
		$this->load->model('printer_model', 'printer');
		$this->load->model('eplus_model', 'eplus');
		$this->load->model('promos_model', 'promo');
		$this->load->model('claims_model', 'claims');
		$this->load->model('ticket_layouts_model', 'ticket_layouts');
		$this->load->model('configurations_model', 'configurations');
		$this->load->model('extension_model', 'extension');
		$this->load->model('printout_model', 'printout');
		$this->load->database('default');
		
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * index
	 *
	 * @access	public
	 */
	function index()
	{
		show_404();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * transaction
	 *
	 * @access	public
	 */
	function transaction($type = false)
	{
		// check user session
		$this->users->check_session(array('Admin', 'Seller', 'Manager','Reservation'));
		
		// prepare data for the template
		$data['page_title'] = 'Claim Tickets';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		$this->form_validation->set_rules('t_id', 'Transaction ID', 'trim|required|strip_tags');
		$this->form_validation->set_error_delimiters('<div class="errors">', '</div>');

		
		if ($this->form_validation->run() != FALSE)
		{
			if ($type == 'print')
			{
				$data['transactions'] = $this->claims->get_by_transaction($this->input->post('t_id'));
				$data['transactions_tickets'] = $this->claims->get_by_transaction_ticket_breakdown($this->input->post('t_id'));
				
				// echo "<pre>";
				// print_r($data);
				// echo "</pre>";
				// die();
			}
		}
		
		$this->load->view('transactions_claim_tickets.php', $data);
	}	
	
	function print_tickets($eid = 0, $transaction_id = false, $barcode = false, $ticket_count = 0)
    {
		if (!$transaction_id and !$barcode) show_404();
		
		if ($ticket_count > 0) {}
		else { 
			show_404();
		}
		
		// prepare data for the template
		$data['page_title'] = 'Claim Tickets';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);

		$transaction = $this->claims->get_trans_details($transaction_id);
		
		// echo "<pre>";
		// print_r($transaction);
		// echo "</pre>";
		// die();
		
		$tickets = $this->claims->get_tickets_details($transaction_id);
		
		// echo "<pre>";
		// print_r($tickets);
		// echo "</pre>";
		// die();
		
		
		if ($ticket_count == count($tickets)) {}
		else {
			show_404();
		}

		if ($transaction->transaction_status != 'done')
		{
			$this->load->model('smbarcode_model', 'smbarcode');
			$success = $this->smbarcode->attach_smcode_to_transaction_tickets($transaction, $tickets, true);
			// $done = $this->claims->mark_for_ticket_claim($transaction_id);
			if ($success) {
				$this->smbarcode->mark_printer_for_online_ticket_claim($transaction_id);
				redirect("/claims/createXMLTickets/$eid/$transaction_id/$ticket_count/1/");
			} else {
				show_404();
			}

			// mark transaction and tickets as done
			// $this->transactions->transaction_done($transaction_id);
			// $postrequest = @$this->extension->post2mci($transaction_id);
			// moved to delete_pdf call by printapp
			
		}
		else
		{	
			// $done = $this->claims->mark_for_ticket_claim($transaction_id);
			// if ($done) {
				redirect("/claims/createXMLTickets/$eid/$transaction_id/$ticket_count/");
			// } else {
				// show_404();
			// }
		}
			
		//exit;
	}
	
	function createXMLTickets($event_id = 0, $transaction_id = 0, $ticket_count = 0, $online_claim = false) {

		if ($ticket_count > 0) {
			// continue
		} else {
			show_404();
		}
		
		// for proper display of XML output on browser
		$this->load->helper('file');
		$this->output->set_header('Content-type: '.get_mime_by_extension('test.xml'));
		echo '<?xml version="1.0"?>';
		echo PHP_EOL;

		$this->db->where("event_id", $event_id);
		$event = $this->db->get('events')->row();
		$season_pass = $event->event_season_pass;
		
		if($season_pass == 1){
			
			$this->db->where("event_long_title", $event->event_long_title);
			$this->db->where("event_id !=", $event_id);
			$query = $this->db->get('events');
			
			
			if($query->num_rows() > 0){
				$event_ids = array();
				foreach($query->result() as $x){
					 
					$event_ids[] = $x->event_id;
					 
				}
				
				$loop = count($event_ids); 
				
			}else{
				$season_pass = 0;
				$loop = 1;
				
			}
			 
			
		}else{
			
			$loop = 1;
			
		}
		  
		
		//for special season pass
		$cpi = $this->tickets->get_price_id($transaction_id);
 
		//toy con 2017
		$toycon = array(32830, 32829, 32823);
		
		// 32830 price id = 5791, 5792, 5793 event id 
		if (in_array($cpi, $toycon)){ 
		
			$event_ids = array(5791, 5792, 5793);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		 
		
		//bora season pass 
		$bora_season_pass = array(31503, 31504);
		
		
		if (in_array($cpi, $bora_season_pass)){ 
		
			$event_ids = array(5557, 5558,5559,5560);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
	  
		//end of bora season pass
		
		
		//shine forth 
 		
		if($cpi == 31542){ 
		
			$event_ids = array(5570,5569,5563);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		
		if($cpi == 31543){ 
		
			$event_ids = array(5570,5569,5563);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		if($cpi == 31533){ 
		
			$event_ids = array(5568,5569,5563);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		
		if($cpi == 31532){ 
		
			$event_ids = array(5568,5569);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		
		if($cpi == 31645){ 
		
			$event_ids = array(5568, 5569,5563);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		//end of shine forth season pass
		
		
		//PSL
		if($cpi == 31364){ 
		
			$event_ids = array(5539, 5540,5541);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		//end of psl
		 
		
		 
		for ($x = 0; $x <= $loop-1; $x++) {
		   
			if($season_pass == 1){ 
				$eid = $event_ids[$x]; 
				
				
			}else{
				$eid = $event_id;
			}
			
			 
			   
				list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
				$data["layout"] = $layout;
				$data["bgimage"] = $bgimage;
	
				
				// empty array of logo (not to be used for new ticket layout)
				$logo1 = array();

				$event = $this->events->get($event_id);
				if(is_object($event)) {
					$eventcode = $event->event_code;
				}
				
				$payments = $this->payments->get_payments($transaction_id);
					
				if(count($payments) > 1){
						
						$payment_type = 'Multi';
					}elseif(count($payments) == 0){
						
						$payment_type = '';
						
					}else{
						
						$payment_type = $payments[0]->payment_type_code;
					}
					
				$type = "paid";
				$ticketlist = $this->claims->get_paid_tickets_for_printing($transaction_id);
				
				// echo "<pre>";
				// print_r($ticketlist);
				// echo "</pre>";
				// die();
				
				$transaction = $this->transactions->get($transaction_id);
				if ($transaction->transaction_user_id == $this->config->item('online_seller_id')) {
					$isweb = 'WEB';
				}
				if ($ticket_count == count($ticketlist)) {
					// ticket count verified, please proceed to next step
				} else {
					// count mismatch
					show_404();
				}
					
				$current_price = '';			
				foreach($ticketlist as $tix) {
					
				
					// serial number
					$serial = 1;
					$serial_number = $this->prices_model->get_serial_number($tix->ticket_price_id);
					
					// per ticket price (discount aapplied)
					$ticket_price = 0;
					if ($tix->ticket_type_discount_type == 'Amount')
					{
						$ticket_price = ceil($tix->price_price - $tix->ticket_type_discount);
					}
					elseif ($tix->ticket_type_discount_type == 'Percentage')
					{
						$ticket_price= ceil($tix->price_price - (($tix->price_price * $tix->ticket_type_discount)/100));
					}

					// acknowledgement number
					if ($tix->ticket_type_discount_type == 'Percentage' and $tix->ticket_type_discount == 100)
					{
						$receipt_number = 'COMPLIMENTARY';
					}
					else
					{
						if ($tix->ticket_acknowledgment_receipt > 0) { 
							$receipt_number = $tix->ticket_acknowledgment_receipt;
						}
						else {
							// get receipt number
							$receipt_number = $this->branches->get_last_receipt_number($tix->ticket_branch_id);
							
							// update transactions table
							$this->tickets->update_acknowledgment_receipt($tix->ticket_id, $receipt_number);
						}
					}

					$tix_info[$tix->ticket_id] = array (
						"tid" => $tix->ticket_id,
						"evc" => strtoupper($eventcode),
						"serial" => $serial_number,
						"secname" => $tix->section_name,
						"row" => $tix->ticket_row,
						"seat" => $tix->ticket_seat,
						"ttcode" => $tix->ticket_type_code,
						"paytype" => strtoupper($payment_type),
						"price" => $ticket_price,
						"termcode" => $tix->terminal_code,
						"printer" => strtoupper($tix->username),
						"arnum" => $receipt_number,
						"eid" => sprintf('%06s', $tix->event_id),
						// "bc_prefix" => sprintf('%04s', $tix->sm_prefix),
						"bc_prefix" => sprintf('%04s', $tix->sm_prefix_alt),
						"bc_access" => sprintf('%04s', $tix->sm_code),
					);
					
					$data["branch"] = array(
							'city' => strtoupper($tix->branch_city),
							'address' => strtoupper($tix->branch_address),
							'tin' => $tix->branch_tin,
						);

						
					$price_id = $tix->price_id;
					
					 
					$price_ids = array(25500,25497,25505);
					
					if (in_array($price_id, $price_ids)){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 4577;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}

					
				 
					$dreamplay_vip = array(27280, 27281, 27284, 27285, 27288, 27289,27107,27115,27114,27118,27121,27124, 27135, 27136, 27139, 27140, 27143, 27144,27218,27217,27222,27221,27225,27226,27229,27230);
					if (in_array($price_id, $dreamplay_vip)){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 4656;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
 
 
 
					$rakrakan = array(28628 , 28636 );
					if (in_array($price_id, $rakrakan)){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5022;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
 
					$neverland = array(28892 , 28890 );
					if (in_array($price_id, $neverland)){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 4948;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
 
					$neverland2 = array(28893 , 28891 );
					if (in_array($price_id, $neverland2)){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 4949;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
						
					if ($price_id  == 28929){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5087;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					if ($price_id  == 28928){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5086;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					
 
					
					if ($price_id  == 28867){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5073;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
				
					if ($price_id  == 28866){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5072;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					if ($price_id  == 28865){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5074;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
 
					if ($price_id  == 27529){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 4796;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					
					if ($price_id  == 28720){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5037;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					

					if ($price_id  == 27530){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 4797;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					if ($price_id  == 27531){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 4798;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					
					
					if ($price_id  == 29285){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5158;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					
					//disney
					
					if ($price_id  == 29616){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5228;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					if ($price_id  == 29617){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5229;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					if ($price_id  == 29632){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5230;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					if ($price_id  == 29633){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5231;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					if ($price_id  == 29655){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5233;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					if ($price_id  == 29656){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5234;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					if ($price_id  == 29868){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5235;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					if ($price_id  == 29869){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5236;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					if ($price_id  == 29870){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5237;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					if ($price_id  == 29871){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5238;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					if ($price_id  == 29872){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5239;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					if ($price_id  == 29873){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5240;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					if ($price_id  == 29874){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5241;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					if ($price_id  == 29875){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5242;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					if ($price_id  == 29876){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5243;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					if ($price_id  == 29877){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5244;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					if ($price_id  == 29878){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5245;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					if ($price_id  == 29879){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5246;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					if ($price_id  == 29880){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5247;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					if ($price_id  == 29881){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5248;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					if ($price_id  == 29882){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5249;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					if ($price_id  == 29883){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5250;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					if ($price_id  == 29884){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5251;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					if ($price_id  == 29885){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5252;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					if ($price_id  == 29886){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5253;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					if ($price_id  == 29887){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5254;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					if ($price_id  == 29888){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5255;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					if ($price_id  == 29889){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5256;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					if ($price_id  == 29890){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5257;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					if ($price_id  == 29891){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5258;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					if ($price_id  == 29892){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5259;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					if ($price_id  == 29893){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5260;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					if ($price_id  == 29894){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5261;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					if ($price_id  == 29895){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5262;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					if ($price_id  == 29896){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5263;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					if ($price_id  == 29897){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5264;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					if ($price_id  == 29918 ){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5275;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					if ($price_id  == 30579  ){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5385;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					if ($price_id  == 30633  ){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5394;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					
					if ($price_id  == 30634  ){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5394;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					
					if ($price_id  == 30635  ){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5395;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					//last
					if ($price_id  == 30952){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5453;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					
					//dota
					if ($price_id  == 31076 && $x == 0){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5482;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					if ($price_id  == 31461 ){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5385;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					//boracay music festival
					$bora = array(31475,31473);
					if (in_array($price_id, $bora)){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5558;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					$bora2 = array(31472, 31470);
					if (in_array($price_id, $bora2)){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5559;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					
					if ($price_id  == 31471){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5560;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					//5565 hot imports night 31520 priceid = 5566
					if ($price_id  == 31520){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5566;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					//31519 priceid = 5567
					if ($price_id  == 31519){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5567;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					
					//31571 price id  = 5575 event id
					if ($price_id  == 31571){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5575;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					
					//31571 price id  = 5575 event id
					if ($price_id  == 31591){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5581;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					
					//one kings
					$one_kings = array(32009, 32010, 32011, 32012, 32013);
					if (in_array($price_id, $bora2)){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5646;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					
					//motoring music festival 32473 ticket id  = 5728 event id for layout
					if ($price_id  == 32473){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5728;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					//anime and cosplay expo
					if ($price_id  == 32572){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5741;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					
					
					
				}
				
				$data["transaction"] = array(
					"id" => $transaction->transaction_id,
					"uid" => $transaction->transaction_user_id,
					"datetime" => $transaction->transaction_date,
					"tickets" => $tix_info,
				);

				//for special event
				$data['price_id'] = $price_id;
				$data['event_id'] = $event_id;
				
				// $xmltext = $this->load->view("generator_xml_dynamic_rev", $data, true);
				 
				
				$xmltext = $this->load->view($this->viewfile, $data, true);
				// $xmltext = 'test';
 	
				 
				
			
			
			  // echo '<pre>';
					// print_r(array_values($tix_info));
					// echo '</pre><br>';
				
				
				// echo '<pre>';
				// print_r( $tix_info);
				// echo '</pre>';
				// echo '<br><br><br><br><br>';
				
				// echo $xmltext . '<br><br><br><br>';
				
				$valid = false;
				$insert_id = 0;
				$yearmonth = date('ym');
				$__isql = "";
			
				if (!empty($xmltext)) {
					$fields = array(
						'xml_yearmonth' => $yearmonth,
						'xml_content' => $xmltext,
						'xml_trans_id' => $transaction_id,
					);
					
					$tr = $this->claims->get_trans_details($transaction_id);
					
					// if($tr->transaction_status == 'done'){
						// $__isql = "UPDATE generator SET xml_yearmonth = '{$yearmonth}', xml_content = '{$xmltext}' WHERE xml_trans_id = $transaction_id;";
						// $valid = $this->db->simple_query($__isql);
						
						 
						// $this->db->query('set transaction isolation level read uncommitted');
						// $this->db->select('xml_id');
						// $this->db->where('xml_trans_id',$transaction_id);
						// $query = $this->db->get('generator');
						// $insert_id = $query->row()->xml_id;
					// }else{
					
					// build insert SQL
					$__isql = $this->db->insert_string("generator", $fields);
					$valid = $this->db->simple_query($__isql);
					$insert_id = $this->db->insert_id();
					// }	
						
					
				}

				
 			}	 
			
	
		
			// die();
		
		if (($valid) && ($insert_id > 0)) {
			if ($online_claim) {
				redirect("/claims/print_online/$transaction_id/$event_id/$yearmonth/$ticket_count/$insert_id");
			} else {
				redirect("/claims/done_rev/$transaction_id/$event_id/$yearmonth/$ticket_count/$insert_id/");
			}
			// echo anchor("/printer/db2xml2pdf/$yearmonth/$insert_id","PDF Display - /printer/db2xml2pdf/$yearmonth/$insert_id","target=_blank");
		} else {
			show_404();
			// echo $__isql;
		}
		
		

	}
	
	function print_online($transaction_id = 0, $event_id = 0, $param1 = 0, $ticket_count = 0, $param2 = 0)
	{
		if (($transaction_id > 0) && ($event_id > 0) && ($ticket_count > 0)) {}
		else {
			show_404();
		}
		
		// prepare data for the template
		$data['page_title'] = 'Claiming Online Tickets';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		$claim = $this->claims->get_by_transaction_ticket_breakdown($transaction_id);
		
		if(count($claim) <= 0){
		$this->claims->mark_for_ticket_claim($transaction_id);
		$printcall = site_url("/claims/payment_done_db2xml2pdf/$param1/$param2/$transaction_id");
		$printcall = str_replace("http://","smtickets:", $printcall);
		$data['onload'] =  "onLoad='window.location=\"$printcall\"'";
		}
		
		$data["transaction_id"] = $transaction_id;
		
		// display the page
		$this->load->view('transactions_print_online', $data);
	}
	
	function done_rev($transaction_id = 0, $event_id = 0, $param1 = 0, $ticket_count = 0, $param2 = 0)
	{
		if (($transaction_id > 0) && ($event_id > 0) && ($ticket_count > 0)) {}
		else {
			show_404();
		}
		
		// prepare data for the template
		$data['page_title'] = 'Transaction Done';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin', 'Seller', 'Manager'));
		// get data
		$tickets = $this->claims->get_otc_tickets($transaction_id);
		$cei = $event_id;
		$cpi = $tickets[0]->price_id;
		// print_r($tickets);
		// check if there are tickets to print
		 
		if ($ticket_count == count($tickets))
		{
			$data['tickets'] = $tickets;
			$data['event'] = $this->events->get_by_transaction_id($transaction_id);
			$data['price'] =  $this->prices->get($cpi);
			$ticket_types = $this->ticket_types->get_ticket_types($cei);
			$data['transaction'] = $this->transactions->get($transaction_id);
			$data['payments'] = $this->payments->get_payments($transaction_id);
			$data['customer'] = $this->customers->get($data['transaction']->transaction_customer_id);
			$claim = $this->claims->get_by_transaction_ticket_breakdown($transaction_id);
			$data['transaction_id'] = $transaction_id;
			// body onload

			if(count($claim) <= 0){
			$this->claims->mark_for_ticket_claim($transaction_id);
			$printcall = site_url("/claims/payment_done_db2xml2pdf/$param1/$param2/$transaction_id");
			$printcall = str_replace("http://","smtickets:", $printcall);			
			$data['onload'] =  "onLoad='window.location=\"$printcall\"'";
			}
		 
			//EPLUS
			// $epluscall = site_url("/printer/generate_card_details/$transaction_id");
			// $epluscall = str_replace("http://","ecs://", $epluscall);
			// $data['onload'] =  "onLoad='window.location=\"$epluscall\"'";
			
			// check ticket status
			// $this->transactions->_check_tix_stat($this->session->userdata('customer_session_id'), $data['event']->event_id, array('paid'), $this->session->userdata('tix_qty'));
		 
			// display the page
			$this->load->view('transactions_print_online', $data);
			// $this->load->view('transactions_done', $data);

		}
		else
		{
			// redirect
			// $this->session->set_flashdata('message', assemble_message('Something went wrong with your transaction.  Please try again.'));
			// redirect('/');
		}
	}
	
	function payment_done_db2xml2pdf($yearmonth = false, $id = false, $trans_id = false){
		// called by PrinterApp - remove .pdf filename extension
		$trans_id = str_replace(".pdf","",$trans_id);
		
		$xmldata = "";
		$validcall = false;
		if (($trans_id > 0) && ($yearmonth > 0) && ($id > 0)){
			// validate transaction 
			$validcall = $this->claims->validatePaidTransactionWithXML($yearmonth, $id, $trans_id);
		}
		
		if (!$validcall) {
			show_404();
			// echo $this->db->last_query();
			die("invalid call");
		}
		
		if ($yearmonth && $id) {
			
			$event_id = $this->tickets->get_event_id($trans_id);
			$data['event'] = $this->events->get_event_details($event_id->ticket_event_id);
			$data['date_validity'] = $this->transactions->get_date_validity($trans_id);
		
		
			$this->db->where("xml_trans_id", $trans_id);
			$this->db->where("xml_yearmonth", $yearmonth);
			$query = $this->db->get("generator");
		
			$this->load->library('simplexml');  
			
			foreach($query->result() as $row) {
				$xmldata = $row->xml_content;
				
				$content[] = $this->simplexml->xml_parse($xmldata, "&amp");
				
			}
		} else {
			die ("Invalid access.");
		}


		
		
		$data['layout'] = $content[0]['layout']['@attributes'];
		if(isset( $content[0]['ticket'][0])){
			$data['tickets']  = $content[0]['ticket'];
		} else {
			$data['tickets'][0]  = $content[0]['ticket'];
		}
		$this->load->helper('file'); 
		
	
		
		
		// echo '<pre>';
		// print_r($data['tickets']);
		// echo '</pre>';
		
		// die();
		
		//get customer info for harry styles
		if($event_id->ticket_event_id == 5803){ 
		
			$this->db->select('customer_firstname, customer_lastname');
			$this->db->join('customers','transaction_customer_id = customer_id');
			$this->db->where('transaction_id',$trans_id);
			$customer = $this->db->get('transactions');
			$data['customer'] = $customer->row();
		}
		
		
		$season_price = array(32830, 32829, 32823 , 31503 , 31504, 31542,31543,31533,31532 , 31645 , 31364);
		if($data['event']->season_pass == 1 || in_array($event_id->price_id, $season_price)){
		
			$data['content'] = $content;
			$this->load->view('pdf_rev_season_pass',$data);
		
		}elseif($event_id->price_package > 1){
		
			$data['count'] = $event_id->price_package;
			$this->load->view('printer_xml2pdf_dynamic',$data);
			
		}else{
		 
			$this->load->view('printer_xml2pdf',$data);
			
		}
		

	}
	
	// --------------------------------------------------------------------
	
}	
