<?php

class Branches extends CI_Controller 
{

	public function __construct()
	{
		parent::__construct();
		$this->load->model('users_model', 'users');
		$this->load->model('promoters_model', 'promoters');
		$this->load->model('venues_model', 'venues');
		$this->load->model('contacts_model', 'contacts');
		$this->load->model('branches_model', 'branches');
		$this->load->model('logs_model', 'logs');
		$this->load->database('default');
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * index
	 *
	 * @access	public
	 */
	function index()
	{
		redirect('branches/listing');
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * listing
	 *
	 * @access	public
	 */
	function listing()
	{
		// prepare data for the template
		$data['page_title'] = 'Branches';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// get all venues
		$data['branches'] = $this->branches->get_branches();
		
		// check users session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Account','Finance','IT','Super Admin'));
		
		$this->load->view('branches_listing', $data);
	}
	// --------------------------------------------------------------------
	
	/**
	 * view
	 *
	 * @access	public
	 */
	function view($branch_id = FALSE)
	{
		if (! $branch_id) show_404();
		
		// prepare data for the template
		$data['page_title'] = 'View Branch';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Finance','Admin2','IT','Super Admin'));
	
		// get user's data
		$data['branches'] = $this->branches->get($branch_id);
		
		// get contacts
		$data['contacts'] = $this->contacts->get_contacts('branches', $branch_id);
		
		// display the page
		$this->load->view('branches_view', $data);
	}		
	// --------------------------------------------------------------------
	
	/**
	 * add
	 *
	 * @access	public
	 */
	function add()
	{
		// prepare data for the template
		$data['page_title'] = 'Add Branch';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('IT','Super Admin','Account'));
			
		$config = array(
			array(
				'field'   => 'branch_name',
				'label'   => 'Name',
				'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[255]|callback__branchname_check'
			),
			array(
				'field'   => 'branch_category',
				'label'   => 'Category',
				'rules'   => 'trim|required|strip_tags|min_length[1]|max_length[255]'
			),
			array(
				'field'   => 'branch_address',
				'label'   => 'Address 1',
				'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[255]'
			),
			array(
				'field'   => 'branch_address2',
				'label'   => 'Address 2',
				'rules'   => 'trim|strip_tags|min_length[2]|max_length[255]'
			),
			array(
				'field'   => 'branch_city',
				'label'   => 'City',
				'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[80]'
			),
			array(
				'field'   => 'branch_zip',
				'label'   => 'ZIP',
				'rules'   => 'trim|strip_tags|exact_length[4]'
			),
			array(
				'field'   => 'branch_tin',
				'label'   => 'TIN',
				'rules'   => 'trim|required|strip_tags|min_length[10]|max_length[20]'
			),
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
		if ($this->form_validation->run() == FALSE)
		{
					
			// display the page
			$this->load->view('branches_add', $data);
		}
		else
		{
			$branches_id = $this->branches->add();
			$this->session->set_flashdata('message', assemble_message('Branch has been successfully added.  Please add the contact person.'));
			redirect('contacts/add/branches/'.$branches_id);
		}
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * _branchname_check
	 *
	 * @access	private
	 */
	function _branchname_check($str)
	{	
		$branchname_exists = $this->branches->is_branchname_exist($str);
		if ($branchname_exists)
		{
			$this->form_validation->set_message('_branchname_check', "The branch $str already exists.");
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * edit
	 *
	 * @access	public
	 */
	function edit($branch_id = FALSE)
	{
		if (! $branch_id)
		{
			show_404();
		}
		
		// prepare data for the template
		$data['page_title'] = 'Edit branch';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		// $this->users->check_session(array('Admin','Super Admin','Admin2','Account'));
		$this->users->check_session(array('IT','Super Admin','Account'));
			
		$config = array(
			array(
				'field'   => 'branch_name',
				'label'   => 'Name',
				'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[255]'
			),
			array(
				'field'   => 'branch_category',
				'label'   => 'Category',
				'rules'   => 'trim|required|strip_tags|min_length[1]|max_length[255]'
			),
			array(
				'field'   => 'branch_address',
				'label'   => 'Address 1',
				'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[255]'
			),
			array(
				'field'   => 'branch_address2',
				'label'   => 'Address 2',
				'rules'   => 'trim|strip_tags|min_length[2]|max_length[255]'
			),
			array(
				'field'   => 'branch_city',
				'label'   => 'City',
				'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[80]'
			),
			array(
				'field'   => 'branch_zip',
				'label'   => 'ZIP',
				'rules'   => 'trim|strip_tags|exact_length[4]'
			),
			array(
				'field'   => 'branch_tin',
				'label'   => 'TIN',
				'rules'   => 'trim|required|strip_tags|min_length[10]|max_length[20]'
			),
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
		if ($this->form_validation->run() == FALSE)
		{
		
			// get contacts
			//$data['contacts'] = $this->contacts->get_contacts_dropdown();
			
			// get data
			$data['branch'] = $this->branches->get($branch_id);
			
			// get all contacts
			$data['contacts'] = $this->contacts->get_contacts('branches', $branch_id);
					

			
			// display the page
			$this->load->view('branches_edit', $data);
		}
		else
		{
			$this->branches->edit($branch_id);
			$this->session->set_flashdata('message', assemble_message('Branch has been successfully modified'));
			//redirect('venues/listing');
			redirect('branches/view/'.$branch_id);
		}
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * delete
	 *
	 * @access	public
	 */
	function delete($branch_id = FALSE)
	{	
		// log this
		$this->logs->add('Delete Branch');
		
		// check user session
		// $this->users->check_session(array('Admin','Super Admin','Admin2','Account'));
		$this->users->check_session(array('IT','Super Admin','Account'));
		
		$this->branches->delete($branch_id);
		$this->session->set_flashdata('message', assemble_message('Branch has been successfully deleted'));
		redirect('branches/listing/');
	}
}
/* End of file branches.php */
/* Location: ./application/controllers/branches.php */	
