<?php
require 'vendor/autoload.php';
use Aws\S3\S3Client;
class Background extends CI_Controller
 {

	public function __construct()
	{
		parent::__construct();
		$this->load->model('users_model', 'users');
		$this->load->model('branches_model', 'branches');
		$this->load->model('terminals_model', 'terminals');
		$this->load->model('background_model', 'background');
		$this->load->model('files_model', 'files');
		$this->load->model('logs_model', 'logs');
		$this->load->database('default');
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * index
	 *
	 * @access	public
	 */
	function index()
	{
		redirect('background/listing');
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * listing
	 *
	 * @access	public
	 */
	function listing()
	{
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Finance'));
		
		// prepare data for the template
		$data['page_title'] = 'Ticket Background';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		$data['background'] = $this->background->get_background();
		
		$this->load->view('background_listing', $data);
	}	
	
	/**
	 * background active
	 *
	 * @access	public
	 */
	function background_active()
	{
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Finance'));
		
		// prepare data for the template
		$data['page_title'] = 'Ticket Background';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		$data['background'] = $this->background->get_background_active();
		
		$this->load->view('background_listing', $data);
	}
	
	/**
	 * background inactive
	 *
	 * @access	public
	 */
	function background_inactive()
	{
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Finance'));
		
		// prepare data for the template
		$data['page_title'] = 'Ticket Background';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		$data['background'] = $this->background->get_background_inactive();
		
		$this->load->view('background_listing', $data);
	}
	
	/**
	 * upload
	 *
	 * @access	public
	 */
	function upload()
	{
		// prepare data for the template
		$data['page_title'] = 'Upload Ticket Background';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		
		$config = array(
			array(
				'field'   => 'background',
				'label'   => 'Background',
				'rules'   => 'trim|strip_tags'
			),
			array(
				'field'   => 'background_row',
				'label'   => 'Background Row',
				'rules'   => 'trim|strip_tags'
			),
			array(
				'field'   => 'event_title',
				'label'   => 'Name of Background',
				'rules'   => 'trim|required|strip_tags|max_length[255]'
			),
		);
			
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');

		if ($this->form_validation->run() == FALSE)
		{
			// display the page
			$this->load->view('background_upload', $data);
		}
		else
		{
			$bucketName = 'images.smtickets.com';
			$bucketPath = 'images5.smtickets.com';
			$imageTmp = $_FILES['background']['tmp_name'];
			$imageName = $_FILES['background']['name'];
			$imageType = $_FILES['background']['type'];

			$date = new DateTime('now');
			$timestamp = $date->format('dmYHis');
			$ext = pathinfo($imageName, PATHINFO_EXTENSION);

			$imageNameOnly = "background_".$timestamp.".".$ext;
			$imageNewName = "images/"."background_".$timestamp.".".$ext;
			$imagePath = "https://" . $bucketPath . "/" . $imageNewName;

			list($filename, $image_path, $filewh, $filesize) = $this->files->upload_background($imageNameOnly);

			if(strpos($filename, "You did not select a file to upload.") == true) {
				$error_message = strip_tags($filename);
				$this->session->set_flashdata('message', assemble_message($error_message));
				redirect('background/upload');
			}  
			else if(strpos($filename, "The uploaded file exceeds the maximum allowed size in your PHP configuration file.") == true || strpos($filename, "The file you are attempting to upload is larger than the permitted size.") == true) {
				$error_message = "Unable to upload image. Image size exceeded 200 KB max size. Please reduce the image size.";
				$this->session->set_flashdata('message', assemble_message($error_message));
				redirect('background/upload');
			}  
			else if (strpos($filename, "The filetype you are attempting to upload is not allowed.") == true) {
				$error_message = strip_tags($filename);
				$this->session->set_flashdata('message', assemble_message($error_message));
				redirect('background/upload');
			} 
			else {
				$this->background->upload($filename, $image_path, $filewh, $filesize);

				list($width, $height, $type, $attr) = getimagesize($imageTmp);
				$imageSize = filesize($imageTmp);
				$imageWH = $width . " x " . $height; 

				// $this->background->upload($imageNewName, $imagePath, $imageWH, $imageSize, $imagePath);

				$s3 = new S3Client([
				    'version' => 'latest',
				    'region'  => 'ap-southeast-1',
				    'credentials' => [
				        'key'    => 'AKIARGTGZ65DTYI5F6FU',
				        'secret' => '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'
				    ],
				    'http' => [ 'verify' => false ]
				]);
				 
				// Upload a publicly accessible file. The file size and type are determined by the SDK.
				try {
				    $result = $s3->putObject([
				        'Bucket' => $bucketName,
				        'Key'    => $imageNewName,
				        'SourceFile' => $imageTmp,
				        'ContentType' => $imageType
				    ]);
				    // echo $result->get('ObjectURL');
				} 
				catch (Aws\S3\Exception\S3Exception $e) {
				    // echo "There was an error uploading the file.\n";
				    // echo $e->getMessage();
				}

				$this->session->set_flashdata('message', assemble_message('Ticket background has been successfully added'));
				redirect('background/listing');
			}
		}
	}
	
	/**
	 * delete
	 *
	 * @access	public
	 */
	function delete($background_id = FALSE)
	{	
		// log this
		$this->logs->add('Delete Ticket Background');
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		
		$this->background->delete($background_id);
		$this->session->set_flashdata('message', assemble_message('Ticket Background has been successfully deleted'));
		redirect('background/listing/');
	}
	
	/**
	 * active
	 *
	 * @access	public
	 */
	function active($background_id = FALSE)
	{
		// log this
		$this->logs->add('Ticket Background Active');
			
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		
		$this->background->active($background_id);
		$this->session->set_flashdata('message', assemble_message('Ticket Background has been successfully activated'));
		redirect('background/listing/');
	}
	
	/**
	 * inactive
	 *
	 * @access	public
	 */
	function inactive($background_id = FALSE)
	{
		// log this
		$this->logs->add('Ticket Background Inactive');
			
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		
		$this->background->inactive($background_id);
		$this->session->set_flashdata('message', assemble_message('Ticket Background has been successfully deactivated'));
		redirect('background/listing/');
	}
}

/* End of file logos.php */
/* Location: ./application/controllers/logos.php */	
