<?php

class Auto_email extends CI_Controller 
{
	public function __construct()
	{
		parent::__construct();
		$this->load->model('users_model', 'users');
		// $this->load->model('promocodes_model', 'promocodes');
		$this->load->model('promo_codes_model', 'promo_codes');
		$this->load->model('ticket_types_model', 'ticket_types');
		$this->load->model('venues_model', 'venues');
		$this->load->model('seatplans_model', 'seatplans');
		$this->load->model('prices_model', 'prices');
		$this->load->model('events_model', 'events');
		$this->load->model('sections_model', 'sections');
		$this->load->model('logs_model', 'logs');
		$this->load->model('auto_email_model', 'auto_email');
		$this->load->database('default');
	}
	// --------------------------------------------------------------------
	
	/**
	 * index
	 *
	 * @access	public
	 */
	function index()
	{
		redirect('auto_email/listing');
	}
	// --------------------------------------------------------------------
	
	/**
	 * listing
	 *
	 * @access	public
	 */
	function listing($eventid=false)
	{
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		
		// if (!$this->session->userdata('cei')) show_404();
		if($eventid!=''){
		$event_id = $eventid;
		}else{
		$event_id = $this->session->userdata('cei');
		}
		
		// prepare data for the template
		$data['page_title'] = 'Auto Email ASR';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
 		$data['auto_email'] = $this->auto_email->get_email($event_id);
				
		// get the event info
		$data['event'] = $this->events->get($event_id);
		
		$this->load->view('auto_email_list', $data);
	}
 
 
	/**
	 * add
	 *
	 * @access	public
	 */
	function add($event_id)
	{
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event'));
		if (!$this->session->userdata('cei')) show_404();
		$event_id = $this->session->userdata('cei');
		
		// prepare data for the template
		$data['page_title'] = 'Add Email Address';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
			
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event'));
			
		$config = array(
			array(
				'field'   => 'email_address',
				'label'   => 'Email Address',
				'rules'   => 'trim|required|strip_tags|callback__validateEmailsTo'
			),
			array(
				'field'   => 'email_address_cc',
				'label'   => 'CC Email Address',
				'rules'   => 'callback__validateEmailsCC'
			),
			array(
				'field'   => 'email_address_bcc',
				'label'   => 'BCC Email Address',
				'rules'   => 'trim|strip_tags|callback__validateEmailsBCC'
			)
			
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
	
		
		if ($this->form_validation->run() == FALSE)
		{
		
		
			// get the event info
			$data['event'] = $this->events->get($event_id);
			
			 
			// display the page
			
			$this->load->view('auto_email_add', $data);
		}
		else
		{
		
			$this->auto_email->add($event_id);
			$this->session->set_flashdata('message', assemble_message('Email Address has been successfully added'));
			redirect('auto_email/listing/');
		}
	}
	
		/**
	 * add
	 *
	 * @access	public
	 */
	function edit_email($auto_email_id,$eventid=false)
	{
		// if (!$this->session->userdata('cei')) show_404();
		$this->users->check_session(array('Admin','Super Admin','Admin2','Finance'));
		if($eventid!=''){
			$event_id= $eventid;
			$data['event_id'] = $eventid;
		}else{
			$event_id= $this->session->userdata('cei');
			$data['event_id'] = $event_id;
		}
		
		// prepare data for the template
		$data['page_title'] = 'Edit Email Address';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
			
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Finance'));
			
		$config = array(
			array(
				'field'   => 'email_address',
				'label'   => 'Email Address',
				'rules'   => 'trim|required|strip_tags|callback__validateEmailsTo'
			),
			array(
				'field'   => 'email_address_cc',
				'label'   => 'CC Email Address',
				'rules'   => 'callback__validateEmailsCC'
			),
			array(
				'field'   => 'email_address_bcc',
				'label'   => 'BCC Email Address',
				'rules'   => 'trim|strip_tags|callback__validateEmailsBCC'
			)
			
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
	
		
		if ($this->form_validation->run() == FALSE)
		{
		
		
			// get the event info
			$data['event'] = $this->events->get($event_id);
			$data['auto_email'] = $this->auto_email->getByID($auto_email_id);
			
			// if($eventid!=''){
			// $data['event_id'] = $eventid;
			// }else{
				// $data['event_id'] = $event_id;
			// }
			// display the page
			
			$this->load->view('auto_email_edit', $data);
		}
		else
		{
		
			$this->auto_email->update_email($auto_email_id);
			$this->session->set_flashdata('message', assemble_message('Email Address has been successfully modified'));
			redirect('auto_email/listing/'.$event_id);
		}
	}
		
 	/**
	 * add exclusive promo
	 *
	 * @access	public
	 */
	/* function promo_exclusive_for()
	{
		if (!$this->session->userdata('cei')) show_404();
		$event_id = $this->session->userdata('cei');
		
		// prepare data for the template
		$data['page_title'] = 'Add Promo Code';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
			
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event'));
			
		$config = array(
			array(
				'field'   => 'promo_code_name',
				'label'   => 'Name',
				'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[255]'
			),
			array(
				'field'   => 'promo_code_code',
				'label'   => 'Promo Code',
				'rules'   => 'trim|required|strip_tags'
			),
			array(
				'field'   => 'promo_code_qty',
				'label'   => 'Quantity',
				'rules'   => 'trim|required|strip_tags|numeric|max_length[2]'
			),
			array(
				'field'   => 'ticket_type',
				'label'   => 'Ticket Type',
				'rules'   => 'trim|strip_tags'
			),
			array(
				'field'   => 'promo_code_prices[]',
				'label'   => 'Prices',
				'rules'   => 'trim|required|strip_tags'
			),			
			
			array(
				'field'   => 'date_from',
				'label'   => 'Date From',
				'rules'   => 'trim|required|strip_tags|callback__date_check'
			),	
			
			array(
				'field'   => 'date_to',
				'label'   => 'Date To',
				'rules'   => 'trim|required|strip_tags|callback__date_check'
			),
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
	
		
		if ($this->form_validation->run() == FALSE)
		{
		
		
			// get the event info
			$data['event'] = $this->events->get($event_id);
			
			// get event sections
			$data['prices'] = $this->prices->get_prices_dropdown_for_promo($event_id);
			 
			// get event sections
			$data['ticket_types'] = $this->ticket_types->get_ticket_types_dropdown_promo($data['event']->event_ticket_types);
			 
			// display the page
			
			$this->load->view('promo_codes_add', $data);
		}
		else
		{
		$group_ids = $this->promocodes->get_last_group_id();
		foreach($group_ids as $gid){
			$group = $gid->promocode->group_id;
		}
		
		if(!isset($group_id)){
			echo $group_id = 1;
		}else{
			echo $group_id +=1;
		}
			$this->promo_codes->add($event_id,$group_id);
			$this->session->set_flashdata('message', assemble_message('Promo Code has been successfully added'));
			redirect('promo_codes/listing/');
		}
	} */
	/**
	 * edit
	 *
	 * @access	public
	 */
/* 	function editByID($promo_code_id = false)
	{
	
		if (!$promo_code_id) show_404();
		if (!$this->session->userdata('cei')) show_404();
		$event_id = $this->session->userdata('cei');
		
		// prepare data for the template
		$data['page_title'] = 'Edit Promo Code';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event'));
			
		$config = array(

			array(
				'field'   => 'promo_code_name',
				'label'   => 'Name',
				'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[255]'
			),
			array(
				'field'   => 'promo_code_code',
				'label'   => 'Promo Code',
				'rules'   => 'trim|required|strip_tags'
			),
			array(
				'field'   => 'promo_code_qty',
				'label'   => 'Quantity',
				'rules'   => 'trim|required|strip_tags|numeric|max_length[2]'
			),
			array(
				'field'   => 'ticket_type[]',
				'label'   => 'Ticket Type',
				'rules'   => 'trim|strip_tags'
			),
			array(
				'field'   => 'promo_code_prices[]',
				'label'   => 'Sections',
				'rules'   => 'trim|required|strip_tags'
			),
			array(
				'field'   => 'date_from',
				'label'   => 'Date From',
				'rules'   => 'trim|required|strip_tags|callback__date_check'
			),	
			
			array(
				'field'   => 'date_to',
				'label'   => 'Date To',
				'rules'   => 'trim|required|strip_tags|callback__date_check'
			),
		);
		
		$this->form_validation->set_rules($config); 

		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
	
		
		if ($this->form_validation->run() == FALSE)
		{
				
			// get the event info
			$data['event'] = $this->events->get($event_id);
			
			// get event sections
			$data['prices'] = $this->prices->get_prices_dropdown_for_promo($event_id);
			
			// get user's data
			$data['promo_code'] = $this->promocodes->get($promo_code_id);
				 
			// get event sections
			$data['ticket_types'] = $this->ticket_types->get_ticket_types_dropdown_promo($data['event']->event_ticket_types);
			 
			// display the page
			$this->load->view('promo_codes_edit', $data);
		}
		else
		{
			$this->promo_codes->edit($promo_code_id);
			$this->session->set_flashdata('message', assemble_message('Promo Code has been successfully modified'));
			redirect('promo_codes/listing/');
		}
	}	 */
	
	// --------------------------------------------------------------------
	
	/**
	 * delete
	 *
	 * @access	public
	 */
	function delete($auto_email_id = false)
	{
		if (!$auto_email_id) show_404();
		
		// log this
		$this->logs->add('Delete Promo Code');
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event'));
		
		$this->auto_email->delete($auto_email_id);
		$this->session->set_flashdata('message', assemble_message('Email has been successfully deleted'));
		redirect('auto_email/listing/');
	}	
	
	function _validateEmailsTo($str = false) 
	{
		$emails_to = $this->input->post('email_address');
		if ( !preg_match ("/^[a-zA-Z0-9@.,-_]+$/",$emails_to)) {
   // $errors[] = "Name must only contain letters!";

			$this->form_validation->set_message('_validateEmailsTo', "space, enter and ' is not allowed.");
			return FALSE;
		}
		else
		{
			return TRUE; 
		}
	}
	
		function _validateEmailsCC($str = false) 
	{
		$emails_cc = $this->input->post('email_address_cc');
		if ($emails_cc != '' && !preg_match ("/^[a-zA-Z0-9@.,-_]+$/",$emails_cc)) {
   // $errors[] = "Name must only contain letters!";

			$this->form_validation->set_message('_validateEmailsCC', "space/enter/' is not allowed.");
			return FALSE;
		}
		else
		{
			return TRUE; 
		}
	}
	
		function _validateEmailsBCC($str = false) 
	{
		$emails_bcc = $this->input->post('email_address_bcc');
		if ($emails_bcc !='' && !preg_match ("/^[a-zA-Z0-9@.,-_]+$/",$emails_bcc)) {
   // $errors[] = "Name must only contain letters!";

			$this->form_validation->set_message('_validateEmailsBCC', "space, enter and ' is not allowed.");
			return FALSE;
		}
		else
		{
			return TRUE; 
		}
	}


	
	
	function _date_check($str = false)
	{	
		$date_from = $this->input->post('date_from');
		$date_to = $this->input->post('date_to');
		 
		if ($date_to < $date_from)
		{
			$this->form_validation->set_message('_date_check', "Date to cannot be earlier than date from!");
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
	
	function getActiveEvents(){
		echo $this->auto_email->getAllActiveEventIDForASR();
		
	}
	
	function active()
	{
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event','Finance'));
		// echo 'dsasda';
		// die();
		// prepare data for the template
		$data['page_title'] = 'Events';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		if ($this->session->userdata('logged_in')) {
			// log this
			$this->logs->add($data['page_title']);
		}

		$searchkey = array();		
		$searchflds = qw('event_title');//array('event_title','event_title','name','ticket_transaction_id');
		foreach ( $searchflds as $fld)
		{
			$searchkey[ $fld ] = $this->input->post($fld);
			$data[$fld]= $this->input->post($fld);
		}
		
		// get all events
		$data['events'] = $this->auto_email->get_active_events($searchkey);
		
		// print_r($data['events']);
		
		$this->session->set_userdata('breadcrumbs', array());
		$this->load->view('active_events_for_ASR', $data);
	}
	
	
	function email_asr($event_id){
		
		
		
		$data['event_id'] = $event_id;
		$data['date_today'] = date("Y-m-d");
				 
		// display the page
		// ob_start();
		$this->load->view('email_asr', $data);
		// file_put_contents('yourpage.html', ob_get_contents());
	}
	
	function test_email(){
		$this->load->view('phpmail');
		$mail = new PHPMailer();
		
		$mail->IsSMTP(); // enable SMTP
		// $mail->IsMail(); // enable SMTP
		$mail->SMTPDebug = 1; // debugging: 1 = errors and messages, 2 = messages only
		$mail->SMTPAuth = true; // authentication enabled
		// $mail->SMTPSecure = 'ssl'; // secure transfer enabled REQUIRED for Gmail
		// $mail->Host = "smtp.gmail.com";
		// $mail->Host = "mail.smlifestyleentertainment.ph";
		$mail->Host = "email-smtp.us-east-1.amazonaws.com";
		// $mail->Port = 465; // or 587
		// $mail->Port = 25; // or 587
		$mail->Port = 587;
		$mail->IsHTML(true);
		$mail->Username = "AKIARGTGZ65D6J5HOKO4";
		$mail->Password = "BJC/dfboTMbljY67fCQwMaQ+SSJ5zp0UMsbmKU32lVEa";
		
		// $mail->Username = "";
		// $mail->Password = "";
		$mail->SetFrom("smtickets.noreply@smtickets.com");
		
		// $file_to_attach ='application/views/ASR_reports/asr_'.$event_id.'_'.date("Y-m-d").'.html';

		// $filename = 'asr_'.$event_id.'_'.date("Y-m-d").'.html';

		

		// $mail->AddAttachment( $file_to_attach , $filename );

		$mail->Subject = "Advance Sales Report ";
		$mail->Body = "<p align='justify' style='color:#787878;font-size:9pt;font-family:Calibri;font-weight:normal;font-style:normal'>CONFIDENTIALITY NOTICE: This message and its contents are confidential and are subject to restrictions contained in this <a href='http://sminvestments.com/disclaimer'>link</a>. If you received this in error, please do not read or take action in reliance on it. Instead, please inform the sender and then delete it immediately.</p>";
		// echo $aemail->to_email_address;
		// die();str_replace(' ', '', $aemail->to_email_address)

		$mail->AddAddress("bayodjohnny@gmail.com");
		$mail->AddBCC("");
		$mail->AddCC("johnny.bayod@mobilegroupinc.com");
		$mail->Send();
		/* if(!$mail->Send()) {
		$this->session->set_flashdata('message', assemble_message('An Error has occured'));
		redirect('auto_email/active/');
		// echo "Mailer Error: " . $mail->ErrorInfo;
		// $failed_email += 1;
		// echo "Mailer Error: " . $mail->ErrorInfo."<br>";
		
		} else {
			$this->session->set_flashdata('message', assemble_message('ASR has been successfully sent'));
			redirect('auto_email/active/');
			// $success_email += 1;
			// echo "Message sent<br>";
		} */
		
		$this->session->set_flashdata('message', assemble_message('ASR has been successfully sent'));
		redirect('auto_email/active/');
		
	}
	
	function gen_report($event_id){
		file_put_contents("application/views/ASR_reports/asr_".$event_id."_".date("Y-m-d").".html", file_get_contents(base_url()."auto_email/email_asr/".$event_id));
	}
	
	function auto_email_ASR_by_event_id($event_id){

		$this->load->view('phpmail');
		// echo 'dsadas';
// die();	
	
		// foreach($generate_reports as $greport2){
		
		$this->gen_report($event_id);
		$auto_emails = $this->auto_email->getActiveEventForASR($event_id);
		// die();
		if($auto_emails<1){
			$this->session->set_flashdata('message', assemble_message('No email address'));
			redirect('auto_email/active/');
		}
		
		// die();
		foreach($auto_emails as $aemail){
		
		$mail = new PHPMailer();
		
		$mail->IsSMTP(); // enable SMTP
		// $mail->IsMail(); // enable SMTP
		$mail->SMTPDebug = 1; // debugging: 1 = errors and messages, 2 = messages only
		$mail->SMTPAuth = true; // authentication enabled
		// $mail->SMTPSecure = 'ssl'; // secure transfer enabled REQUIRED for Gmail
		// $mail->Host = "smtp.gmail.com";
		// $mail->Host = "mail.smlifestyleentertainment.ph";
		$mail->Host = "email-smtp.us-east-1.amazonaws.com";
		// $mail->Port = 465; // or 587
		// $mail->Port = 25; // or 587
		$mail->Port = 587;
		$mail->IsHTML(true);
		$mail->Username = "AKIARGTGZ65D6J5HOKO4";
		$mail->Password = "BJC/dfboTMbljY67fCQwMaQ+SSJ5zp0UMsbmKU32lVEa";
		
		// $mail->Username = "";
		// $mail->Password = "";
		$mail->SetFrom("smtickets.noreply@smtickets.com");
		
		$file_to_attach ='application/views/ASR_reports/asr_'.$event_id.'_'.date("Y-m-d").'.html';

		$filename = 'asr_'.$event_id.'_'.date("Y-m-d").'.html';

		

		$mail->AddAttachment( $file_to_attach , $filename );

		$mail->Subject = "Advance Sales Report ".$aemail->event_title." ".date("Y-m-d");
		$mail->Body = "<p align='justify' style='color:#787878;font-size:9pt;font-family:Calibri;font-weight:normal;font-style:normal'>CONFIDENTIALITY NOTICE: This message and its contents are confidential and are subject to restrictions contained in this <a href='http://sminvestments.com/disclaimer'>link</a>. If you received this in error, please do not read or take action in reliance on it. Instead, please inform the sender and then delete it immediately.</p>";
		// echo $aemail->to_email_address;
		// die();str_replace(' ', '', $aemail->to_email_address)
		
			$toemail_ads = explode(",",str_replace(' ', '', $aemail->to_email_address));
			$toemails = count($toemail_ads)-1;
			for($ctr=0;$ctr<=$toemails;$ctr++){
				$mail->AddAddress($toemail_ads[$ctr]);
			} 
		

		if($aemail->cc_email_address!=','){
			$ccemail_ads = explode(",",str_replace(' ', '', $aemail->cc_email_address));
			$ccemails = count($ccemail_ads)-1;
			for($ctr=0;$ctr<=$ccemails;$ctr++){
					$mail->AddCC($ccemail_ads[$ctr]);
			}
		}
		
		if($aemail->bcc_email_address!=','){
			$bccemail_ads = explode(",",str_replace(' ', '', $aemail->bcc_email_address));
			$bccemails = count($bccemail_ads)-1;
			for($ctr=0;$ctr<=$bccemails;$ctr++){
			$mail->AddBCC($bccemail_ads[$ctr]);
			}	
		} 


	
	/* if(!$mail->Send()) {
		$this->session->set_flashdata('message', assemble_message('An Error has occured'));
		redirect('auto_email/active/');
		// echo "Mailer Error: " . $mail->ErrorInfo;
		// $failed_email += 1;
		// echo "Mailer Error: " . $mail->ErrorInfo."<br>";
		
	} else {
		$this->session->set_flashdata('message', assemble_message('ASR has been successfully sent'));
		redirect('auto_email/active/');
		// $success_email += 1;
		// echo "Message sent<br>";
	} */
	// error_reporting(E_ERROR);
	$mail->Send();
	$this->session->set_flashdata('message', assemble_message('ASR has been successfully sent'));
		redirect('auto_email/active/');
		// error_reporting(E_ERROR);
	// $this->session->set_flashdata('message', assemble_message('ASR has been successfully sent'));
		// redirect('auto_email/active/');
	// $this->auto_email->sent_success();
	
	}

	/* echo "Success Emails: ".$success_email.'<br>';
	echo "Failed Emails: ".$failed_email; */
	// die();
			// }
		}
	
	
	function auto_email_asr(){


	$this->load->view('phpmail');
	$generate_reports_all = $this->auto_email->getActiveEventIDForASR(0, 'all','-','-');
	// die();
	// echo count($generate_reports_all);


	$mid = ceil(count($generate_reports_all)/20);
		// echo '<pre>';
		// print_r($generate_reports_all);
		// die();
	
	
	$fcstart = 19;


	$fcend = 19;
	for($ctr=0;$ctr<$mid;$ctr++){
	$fcstart *= $ctr;
	$fcend *= ($ctr+1);
	$generate_reports = $this->auto_email->getActiveEventIDForASR(0, 'all',$fcstart,$fcend);
	
	$success_email = 0;
	$failed_email = 0;
	

	foreach($generate_reports as $greport){
		
		$this->gen_report($greport->event_id);
		
	}
	
		foreach($generate_reports as $greport2){
		
		$this->gen_report($greport->event_id);
		$auto_emails = $this->auto_email->getActiveEventForASR($greport2->event_id);
		
		foreach($auto_emails as $aemail){	
		$mail = new PHPMailer();
		
		$mail->IsSMTP(); // enable SMTP
		// $mail->IsMail(); // enable SMTP
		$mail->SMTPDebug = 1; // debugging: 1 = errors and messages, 2 = messages only
		$mail->IsSMTP(); // enable SMTP
		// $mail->IsMail(); // enable SMTP
		$mail->SMTPDebug = 1; // debugging: 1 = errors and messages, 2 = messages only
		// $mail->SMTPAuth = true; // authentication enabled
		// $mail->SMTPSecure = 'ssl'; // secure transfer enabled REQUIRED for Gmail
		// $mail->Host = "smtp.gmail.com";
		$mail->Host = "mail.smlifestyleentertainment.ph";
		// $mail->Port = 465; // or 587
		$mail->Port = 25; // or 587
		$mail->IsHTML(true);
		// $mail->Username = "smtickets.noreply@gmail.com";
		// $mail->Password = "smtickets12345";
		
		$mail->Username = "";
		$mail->Password = "";
		$mail->SetFrom("smtickets.noreply@smtickets.com");
		
		$file_to_attach ='application/views/ASR_reports/asr_'.$aemail->event_id.'_'.date("Y-m-d").'.html';

		$filename = 'asr_'.$aemail->event_id.'_'.date("Y-m-d").'.html';

		

		$mail->AddAttachment( $file_to_attach , $filename );

		$mail->Subject = "Advance Sales Report ".$aemail->event_title." ".date("Y-m-d");
		$mail->Body = "<p align='justify' style='color:#787878;font-size:9pt;font-family:Calibri;font-weight:normal;font-style:normal'>CONFIDENTIALITY NOTICE: This message and its contents are confidential and are subject to restrictions contained in this <a href='http://sminvestments.com/disclaimer'>link</a>. If you received this in error, please do not read or take action in reliance on it. Instead, please inform the sender and then delete it immediately.</p>";
		// echo $aemail->to_email_address;
		// die();str_replace(' ', '', $aemail->to_email_address)
		$toemail_ads = explode(",",str_replace(' ', '', $aemail->to_email_address));
		$ccemail_ads = explode(",",str_replace(' ', '', $aemail->cc_email_address));
		$bccemail_ads = explode(",",str_replace(' ', '', $aemail->bcc_email_address));
		$toemails = count($toemail_ads) - 2;
		$ccemails = count($ccemail_ads) - 2;
		$bccemails = count($bccemail_ads) - 2;
	// die();
	for($ctr=0;$ctr<=$toemails;$ctr++){
		$mail->AddAddress($toemail_ads[$ctr]);
	}
	for($ctr=0;$ctr<=$ccemails;$ctr++){
			$mail->AddCC($ccemail_ads[$ctr]);
	}	
	for($ctr=0;$ctr<=$ccemails;$ctr++){
			$mail->AddBCC($bccemail_ads[$ctr]);
	}	
	
/* 	$mail->AddAddress('johnny.bayod@mobilegroupinc.com');
	$mail->AddCC('smtickets.noreply@mobilegroupinc.com');
	$mail->AddBCC('smtickets.noreply2@mobilegroupinc.com'); */
	
	if(!$mail->Send()) {
		$failed_email += 1;
		echo "Mailer Error: " . $mail->ErrorInfo."<br>";
	} else {
		$success_email += 1;
		echo "Message sent<br>";
	}
	}
		
	

		
	
	
	
	/* echo "Success Emails: ".$success_email.'<br>';
	echo "Failed Emails: ".$failed_email; */
	// die();
			}
		}
	}
	
	
	
	function auto_email_asr_dreamplay(){


	$this->load->view('phpmail');


	$generate_reports_all = $this->auto_email->getActiveEventIDForASR(1, 'all','-','-');
	// die();
	// echo count($generate_reports_all);
	$mid = ceil(count($generate_reports_all)/20);
		// echo '<pre>';
		// print_r($generate_reports_all);
		//die();
	
	
	$fcstart = 19;
	$fcend = 19;
	for($ctr=0;$ctr<$mid;$ctr++){
	$fcstart *= $ctr;
	$fcend *= ($ctr+1);
	$generate_reports = $this->auto_email->getActiveEventIDForASR(1, 'all',$fcstart,$fcend);
	


	$success_email = 0;
	$failed_email = 0;
	

	foreach($generate_reports as $greport){
		
		$this->gen_report($greport->event_id);
		
	}
	
		foreach($generate_reports as $greport2){
		
		$this->gen_report($greport->event_id);
		$auto_emails = $this->auto_email->getActiveEventForASR($greport2->event_id);
		
		foreach($auto_emails as $aemail){	
		$mail = new PHPMailer();
		
		$mail->IsSMTP(); // enable SMTP
		// $mail->IsMail(); // enable SMTP
		$mail->SMTPDebug = 1; // debugging: 1 = errors and messages, 2 = messages only
		$mail->IsSMTP(); // enable SMTP
		// $mail->IsMail(); // enable SMTP
		$mail->SMTPDebug = 1; // debugging: 1 = errors and messages, 2 = messages only
		// $mail->SMTPAuth = true; // authentication enabled
		// $mail->SMTPSecure = 'ssl'; // secure transfer enabled REQUIRED for Gmail
		// $mail->Host = "smtp.gmail.com";
		$mail->Host = "mail.smlifestyleentertainment.ph";
		// $mail->Port = 465; // or 587
		$mail->Port = 25; // or 587
		$mail->IsHTML(true);
		// $mail->Username = "smtickets.noreply@gmail.com";
		// $mail->Password = "smtickets12345";
		
		$mail->Username = "";
		$mail->Password = "";
		$mail->SetFrom("smtickets.noreply@smtickets.com");
		
		$file_to_attach ='application/views/ASR_reports/asr_'.$aemail->event_id.'_'.date("Y-m-d").'.html';

		$filename = 'asr_'.$aemail->event_id.'_'.date("Y-m-d").'.html';

		

		$mail->AddAttachment( $file_to_attach , $filename );

		$mail->Subject = "Advance Sales Report ".$aemail->event_title." ".date("Y-m-d");
		$mail->Body = "<p align='justify' style='color:#787878;font-size:9pt;font-family:Calibri;font-weight:normal;font-style:normal'>CONFIDENTIALITY NOTICE: This message and its contents are confidential and are subject to restrictions contained in this <a href='http://sminvestments.com/disclaimer'>link</a>. If you received this in error, please do not read or take action in reliance on it. Instead, please inform the sender and then delete it immediately.</p>";
		// echo $aemail->to_email_address;
		// die();str_replace(' ', '', $aemail->to_email_address)
		$toemail_ads = explode(",",str_replace(' ', '', $aemail->to_email_address));
		$ccemail_ads = explode(",",str_replace(' ', '', $aemail->cc_email_address));
		$bccemail_ads = explode(",",str_replace(' ', '', $aemail->bcc_email_address));
		$toemails = count($toemail_ads) - 2;
		$ccemails = count($ccemail_ads) - 2;
		$bccemails = count($bccemail_ads) - 2;
	// die();
	for($ctr=0;$ctr<=$toemails;$ctr++){
		$mail->AddAddress($toemail_ads[$ctr]);
	}
	for($ctr=0;$ctr<=$ccemails;$ctr++){
			$mail->AddCC($ccemail_ads[$ctr]);
	}	
	for($ctr=0;$ctr<=$ccemails;$ctr++){
			$mail->AddBCC($bccemail_ads[$ctr]);
	}	
	
/* 	$mail->AddAddress('johnny.bayod@mobilegroupinc.com');
	$mail->AddCC('smtickets.noreply@mobilegroupinc.com');
	$mail->AddBCC('smtickets.noreply2@mobilegroupinc.com'); */
	
	if(!$mail->Send()) {
		$failed_email += 1;
		echo "Mailer Error: " . $mail->ErrorInfo."<br>";
	} else {
		$success_email += 1;
		echo "Message sent<br>";
	}
	}
		
	
	/* echo "Success Emails: ".$success_email.'<br>';
	echo "Failed Emails: ".$failed_email; */
	// die();
			}
		}
	}
	
}
/* End of file prices.php */
/* Location: ./application/controllers/prices.php */	

