<?php
class Admin extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->model('logs_model', 'logs');
		$this->load->model('admin_model', 'admin');
		$this->load->model('users_model', 'users');

		// cannot restrict to certain access group since printing is via 3rd party application
		$this->load->database('default');
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
	}
	
	function index()
	{
		// $this->load->view('welcome_message');
	}

    function mark_paid_done($trans_id = 0)
    {
		if ($trans_id > 0) {
			// mark the transaction and tickets as Done
			$this->admin->mark_paid_transaction_done($trans_id);
			$this->logs->add('Marked Done ' . $trans_id);
			
			$message = 'Marked Paid Transaction ID #' . $trans_id . ' as Done. Please review status of your transaction.';
			$this->session->set_flashdata('message', assemble_message($message));
			
		}
		
		$referrer = (isset($_SERVER["HTTP_REFERER"])) ? $_SERVER["HTTP_REFERER"] : '';
		
		if (empty($referrer)) { 
			redirect('');
		}
		else {
			redirect($referrer);
		}
	}


	function ResetPrintWithStatus($status_from = "paid_online" , $trans_id = 0) {
		$this->logs->add('Reset Print Online Ticket ' . $trans_id);
		$status_allowed = array("paid_online","done");
		if (($trans_id > 0) && (in_array($status_from, $status_allowed))) {
			// continue
		} else {
			die("Cannot process your request. Invalid access.");
		}
		
		$status_to = 'paid_online';

		$sql_1 = "
			UPDATE sm_barcode smb
				SET smb.sm_transaction_id = (1000000000 + $trans_id)
				WHERE smb.sm_transaction_id = $trans_id ;
		";
		$sql_2 = "
			UPDATE transactions t
				SET t.transaction_status = '$status_to'
				WHERE t.transaction_id = $trans_id
					AND t.transaction_user_id = 1
					AND t.transaction_branch_id = 90
					AND t.transaction_status = '$status_from'
			;
		";
		$sql_3 = "
			UPDATE tickets tix
				SET tix.ticket_status = '$status_to'
					, tix.ticket_branch_id = 90
					, tix.ticket_user_id = 1
					, tix.ticket_terminal_id = 1
				WHERE tix.ticket_transaction_id = $trans_id
					AND tix.ticket_status = '$status_from'
			;
		";
		
		echo "Processing Request.";
		$boolResetSuccess = $this->db->simple_query($sql_1);
		if ($boolResetSuccess) {
			echo ".";
			$boolResetSuccess &= $this->db->simple_query($sql_2);
		}
		if ($boolResetSuccess) {
			echo ".";
			$boolResetSuccess &= $this->db->simple_query($sql_3);
		}
		echo "<BR>";
		if ($boolResetSuccess) {
			echo "Application of reset to reprint trans ID # $trans_id should be successful. Please check transaction details to verify. ";
		} else {
			echo "Reset was not fully successful. You can double-check transaction details to verify. Please inform MGI. <BR>";
		}

		
	}

	function GenerateBarcode($event_id = 0) {
		$this->load->helper('html');
		$this->db->select("smb.sm_trigger");
		$this->db->where("sm_event_id = '680'");
		$query = $this->db->get("sm_barcode smb");

		$event_id = 693;

		$sql = "
SELECT date(tix.ticket_date_entered) as dt, (hour(tix.ticket_date_entered)%2) hs, smb.sm_transaction_id, smb.sm_trigger, smb.sm_ticket_id, tix.ticket_type_id, tix.ticket_status, smb.sm_deactivated, tix.ticket_event_id
FROM sm_barcode smb
	left join tickets tix
		on tix.ticket_id = smb.sm_ticket_id
	where smb.sm_event_id IN ($event_id)
		and smb.sm_trigger IS NOT NULL

group by dt, hs , smb.sm_deactivated, tix.ticket_status, tix.ticket_type_id
order by smb.sm_transaction_id desc
";
$query = $this->db->query($sql);
		echo "<table cellspacing=5 cellpadding=5 border=0 width=100%>";
		$i = 0;
		$c = 0;
		foreach ($query->result() as $row) {
			$c++;
			if ($i == 2) {
				$i = 0;
			}

			if ($i == 0) {
			echo "<tr>";
			}
			if ($i < 2) {
			echo "<th>";
			echo $c;
			echo "</th>";
			echo "<td>";
			echo img("resources/phpqrcode/on-the-fly.php?data=" . $row->sm_trigger);
			echo img("resources/barcode/ek_barcode.php?text=" . $row->sm_trigger);
			echo "</td>";
			echo "<td>";
			echo $row->sm_ticket_id;
			echo "/";
			echo $row->ticket_status;
			echo "/sc2=";
			echo $row->ticket_type_id;
			echo "/dc-";
			echo $row->sm_deactivated;
			echo "/e-";
			echo $row->ticket_event_id;
			echo "</td>";
			}
			if ($i == 1) {
			echo "</tr>";
			}
			// echo "<BR>";

			$i++;
		}
		echo "</table>";
		
	}

	function paidonlinevoucher($type = false, $transaction_id = false)
	{
		$this->load->model('transactions_model', 'transactions');
		$this->load->model('tickets_model', 'tickets');
		$this->load->model('events_model', 'events');
		$this->load->model('prices_model', 'prices');
		$this->load->model('payments_model', 'payments');
		$this->load->model('ticket_layouts_model', 'ticket_layouts');
		$this->load->model('extension_model', 'extension');

		// check the customer session
		//$this->sessions->session_check(array('tid'));
		// if (!$type) show_404();
		// if (!$transaction_id) show_404();
		if (!$type) { die("error type") ; }
		if (!$transaction_id) { die("error t") ; }
		
		$voucher_type = ($type == 'all') ? 'all' : 'one';
		// $transaction_id = ($transaction_id) ? $transaction_id : $this->session->userdata('tid');

		
  	    // check ownership
		// $this->transactions->check_access($transaction_id);
		// instead of ownership, check if valid ip since this must come from admin
		
		$data['voucher_type'] = $voucher_type;
		$data['transaction'] = $this->transactions->get($transaction_id);
		$data['tickets'] = $this->tickets->get_paid_online_tickets($transaction_id);

		$data['ticket_terms'] = $file = file_get_contents(base_url() . '/resources/terms/ticket_terms.txt', true);
		
		if (count($data['tickets']) > 0)
		{
			$data['price'] = $this->prices->get($data['tickets'][0]->ticket_price_id);
			$data['event'] = $this->events->get($data['tickets'][0]->ticket_event_id);
			$payments = $this->payments->get_payments($transaction_id);

			$data['payment_type'] = (count($payments) > 0) ? $payments[0]->payment_type_name : 'Unknown Payment Type';
			
			$total_payment = 0;
			foreach($payments as $payment)
				$total_payment += $payment->payment_amount;
				
			$data['total_amount'] = $total_payment;
			$data['ticket_layout'] = $this->ticket_layouts->get($data['tickets'][0]->ticket_event_id);
			$data['bcode'] = $this->extension->get_transaction_bcode($transaction_id);
			
			// display the page
			$this->load->view('transaction_tickets', $data);
		}
		else
		{
			echo 'Ticket not found';
		}
	}

	function get_barcode_by_trans($transID = false){
		
		if($transID){
			$this->db->select('transaction_barcode');
			$this->db->where('transaction_id', $transID);
			$result = $this->db->get('transactions')->row();
			
			if($result){
			echo 'Barcode: ' . $result->transaction_barcode;
			
			}else{
			
			echo 'Not Paid Online. Please check transactionstatus';
			}	
	
		}
	}

	function tag($event_id =false,$section_id =false, $ticket_id =false, $trans_id = false, $code =false){
		
		if(!$event_id) die('No Event ID');
		if(!$section_id) die('No Section ID');
		if(!$ticket_id) die('No Ticket ID');
		if(!$trans_id) die('No Trans ID');
		if(!$code) die('No CODE');
			
		
		
		//CHECK FOR DUPLICATES
		$this->db->where('queue_ticket_id', $ticket_id);
		$this->db->or_where('queue_number', $code);
		$query = $this->db->get('queue');
		
		if($query->num_rows() > 0) die('Ticket ID or Code is already used');
		 
		 
		//INSERT TO QUEUE TABLE
		$data = array(
        'queue_ticket_id' => $ticket_id,
        'queue_transaction_id' => $trans_id,
        'queue_event_id' => $event_id,
        'queue_section_id' => $section_id,
        'queue_number' => $code,
        // 'queue_claim' => 0
		);

		$this->db->insert('queue', $data);
		echo 'Success!';
		
	}
	
	function asr_all($event_id = 0){
		if($event_id > 0){
			$sql = "SELECT 
			e.event_title,pr.price_id ,pr.price_name, pr.price_price, COUNT(*) AS sold , 
			  sum(CASE WHEN tt.ticket_type_discount_type = 'Amount' THEN pr.price_price - ticket_type_discount ELSE pr.price_price - (pr.price_price * (ticket_type_discount/100)) END) as amount 
			FROM tickets t 
			INNER JOIN prices pr ON pr.price_id = t.ticket_price_id
			INNER JOIN ticket_types tt ON tt.ticket_type_id = t.ticket_type_id
			INNER JOIN events e ON e.event_id = t.ticket_event_id
			WHERE t.ticket_event_id = ?
			AND t.ticket_status IN ('done','paid_online')
			AND tt.ticket_type_group = 0
			GROUP BY t.ticket_price_id
			ORDER BY pr.price_price desc";
			
			$query =  $this->db->query($sql, array($event_id));
			$result = $query->result();
			echo '<br>' . $result[0]->event_title;
			echo '<br><br><table width="30%" border=1 style="border-collapse:collapse">';
			echo '<tr>';
			echo '<th>Section</th>';
			echo '<th>Price</th>';
			echo '<th>Sold</th>';
			echo '<th>Amount</th>';
			echo '</tr>';
			$t_sold = 0;
			$t_amount = 0;
			foreach($result as $x){
				echo '<tr>';
					echo "<td>$x->price_name</td>";
					echo "<td style='text-align:right'>$x->price_price</td>";
					echo "<td style='text-align:right'>$x->sold</td>";
					echo "<td style='text-align:right'>$x->amount</td>";
				echo '</tr>';
				
				$t_sold += $x->sold;
				$t_amount += $x->amount;
			}
			echo '<tr>';
				echo "<td colspan=2>Total</td>";
				echo "<td style='text-align:right'>$t_sold</td>";
				echo "<td style='text-align:right'>" .number_format($t_amount,2)."</td>";
					
				echo '</tr>';
			echo '</table>';
		}else{
			echo 'Invalid Event';
		}
	}

 	function refund_reset($transid = false){
		
		if($transid){
		
		$this->logs->add('Marked Done ' . $transid); 
		$this->db->where('queue_refund_transaction_id', $transid);
		$this->db->limit(1); 
		$this->db->delete('queue_refund');
		
		if($this->db->affected_rows() > 0){
			echo 'Transaction ' . $transid . ' has been reset successfuly';
		}
		}else{
			echo 'Invalid trans ID';
		}
	}
	
	function get_trans_by_barcode($barcode = false){
	
		if($barcode){
		$this->db->select('transaction_id');
		$this->db->where('transaction_barcode', $barcode);
		$this->db->limit(1);
		$result = $this->db->get('transactions')->row();
		
		if($result){
		echo 'Transaction ID: ' . $result->transaction_id;
		
		}else{
		
		echo 'No Transid ID.Please check barcode';
		}
		
		}else{
			
			echo 'Barcode required';
		}
	
	}

	function process_payment()
	{
		$url = 'https://aws-api.smtickets.com/prodAPI/v1/transaction/payment_done';
		
		if(isset($_POST['referencenumber']) && isset($_POST['amount']) && isset($_POST['paycode'])){
			 
			$this->logs->add('Process Payment -' . $_POST['referencenumber']);

		
			$data = array(
				'referencenumber' => $_POST['referencenumber'],
				'paycode' => $_POST['paycode'],
				'amount' => $_POST['amount']
			);

			 
			$options = array(
				'http' => array(
					'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
					'method'  => 'POST',
					'content' => http_build_query($data)
				),
			);

			$context  = stream_context_create($options);
			$result = @file_get_contents($url, false, $context);
			
			
			echo $result;
			
		}else{
			$this->load->view('process_payment');
		}
			
	}
			
	function overide_payment()
	{
		$url = 'https://aws-api.smtickets.com/tmAPI/transaction/payment_done_2';
		
		if(isset($_POST['referencenumber'])){
			 $ref =  explode("-", $_POST['referencenumber']);
  
			if($ref[1] == ''){
				die('Reference number is required');
			}
			 
			if($_POST['reservationnumber'] == ''){
				die('Reservation number is required');
			}
			 
			if($_POST['amount'] == ''){
				die('Amount is required');
			}
			
			
			//update ticket details w/ res 
			$this->db->where_in('ticket_transaction_id', [$ref[1] , $_POST['reservationnumber']]);
			$q = $this->db->get('tickets');
			if($q->num_rows() > 0){
				$result = $q->result(); 
				$e = [];
				$reservations = [];
				$unselected = [];
				foreach($result as $x){
					if($x->ticket_status == 'reserved'){  $reservations[] = $x; }
					if($x->ticket_status == 'unselected'){ $unselected[] = $x; }
					
					$e[] = $x->ticket_event_id;
				}
				if(count($reservations) !=  count($unselected)) { die('Please check reservation qty.');}
				
				if(count(array_unique($e)) > 1){ die('Please check reservation event.');}
			 
				for ($x = 0; $x < count($unselected); $x++) {
					
					
					$fields = array(
						'ticket_section_id'		=>$reservations[$x]->ticket_section_id,
						'ticket_price_id'		=>$reservations[$x]->ticket_price_id,
						'ticket_system_row'		=>$reservations[$x]->ticket_system_row,
						'ticket_system_col'		=>$reservations[$x]->ticket_system_col,
						'ticket_row'			=>$reservations[$x]->ticket_row,
						'ticket_seat'			=>$reservations[$x]->ticket_seat,
					);
				
					// update db
					$this->db->where('ticket_id', $unselected[$x]->ticket_id);
					$this->db->where('ticket_status', 'unselected');
					$this->db->limit(1); 
					$this->db->update('tickets', $fields);
					
					$this->logs->add('Override -' .$ref[1] . '-' . $_POST['reservationnumber']);
					 
				} 
				// echo '<pre>';
				// print_r($reservations);
				
			}
			
			
			 
			$data = array(
				'cardnumber' => $_POST['cardnumber'],
				'referencenumber' => $_POST['referencenumber'],
				'paycode' => $_POST['paycode'],
				'amount' => $_POST['amount'],
				'others' => ''
			);

			 
			$options = array(
				'http' => array(
					'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
					'method'  => 'POST',
					'content' => http_build_query($data)
				),
			);

			$context  = stream_context_create($options);
			$result = @file_get_contents($url, false, $context);
			
			
			
			echo $result;
			
		}else{
			$this->load->view('override_payment');
		}
	}
	
	
}
?>

