% Copyright Homayoon Beigi 2025

T = 0:0.01:20;

%U = zeros(size(T))'; % impulse input
%U(1)=1;

%U = ones(size(T))'; % step input (u = 1 for all positive time)

U = 0.1*sin(5*T + 1)';

%sys_tf = tf([2 1], [1 2 3]) % example transfer function
sys_tf = tf([1 3], [1 7 14 8]) % stable
%sys_tf = tf([1 3], [1 0 1]) % marginally stable
%sys_tf = tf([1 3], [1 1 1 8]) % unstable
[Y, Tsim] = lsim(sys_tf, U, T);
TempV=[U(:,1);Y(:,1)];
plot(Tsim, U, 'Color', [0.5 0 0]);
hold on;
plot(Tsim, Y, 'b');
ylim([min(TempV) max(TempV)*1.1]);
title('Response vs Input with Zero Initial Conditions');
legend('Input', 'Output');
