// 根据某一个节点的过滤条件，获取其在一个森林的路径。
function getPathByKey(value, key, arr) {
  let temppath = [];
  try {
    function getNodePath(node){
      // 这里可以自定义push的内容，而不是整个node,而且这里node也包含了children
      temppath.push(node);
      //找到符合条件的节点，通过throw终止掉递归
      if (node[key] === value) {
        throw ("GOT IT!");
      }
      if (node.children && node.children.length > 0) {
        for (var i = 0; i < node.children.length; i++) {
          getNodePath(node.children[i]);
        }

        //当前节点的子节点遍历完依旧没找到，则删除路径中的该节点
        temppath.pop();
      }
      else {

        //找到叶子节点时，删除路径当中的该叶子节点
        temppath.pop();
      }
    }
    for (let i = 0; i < arr.length; i++) {
      getNodePath(arr[i]);
    }
  } catch (e) {
    return temppath;
  }
}
new Vue({
  el: '#vue-container',
  mounted () {
    this.getTaskList()
  },
  data () {
    return {
      query: {
        group_id: 0,
        children: true,
        name: '',
        state: '',
        hasTrigger: '',
      },
      tabSelectedIndex: '1',
      tabList: [
        {
          title: '任务列表',
          name: '1'
        }
      ],
      tabIndex: 2,
      tree: [],
      groups: [],
      breadcrumb: [{id: 0, label: '全部'}],
      groupCount: [0, 0, 0, 0, 0],
      showMenu: true,
      taskListLoading: false,
      taskListTotal: 0,
      taskDetailTotal: 0,
      task: {},
      taskDetailList: [],
      taskAllList: [],
      taskList: [],
      triggerDialogShow: false,
      trigger: {},
      triggerSwitch: true,
      triggerTaskId: 0,
      triggerAction: 'add',
      interval_types: [
        {value: 'interval', label: '每间隔'},
        {value: 'daily', label: '每天'},
        {value: 'weekly', label: '每周'},
        {value: 'runOnce', label: '仅一次'},
        {value: 'cron', label: 'cron表达式'}
      ],
      dayOfWeek: [
        {value: '2', label: '星期一'},
        {value: '3', label: '星期二'},
        {value: '4', label: '星期三'},
        {value: '5', label: '星期四'},
        {value: '6', label: '星期五'},
        {value: '7', label: '星期六'},
        {value: '1', label: '星期日'}
      ],
      day_interval: 'interval',
      timeRange: [new Date(new Date(new Date().toLocaleDateString()).getTime()), new Date(new Date(new Date().toLocaleDateString()).getTime()+24*60*60*1000-1)],
      editorContent: '',
      editFiled: '',
      editTaskId: '',
      editDataId: '',
      editContentShow: false,
      taskDialog: false,
      taskDialogTitle: '新建任务',
      taskDialogShowGroup: true,
      taskUploadId: 0,
      taskSchedulerList: [],
      selectedId: '0',
    }
  },
  methods: {
    makeUrl (params) {
	  let url = `${server_url}?${params}&type=json`
	  if (server_url === '')
	  {
		  url = 'http://' + window.location.host + `/api?${params}&type=json`
	  }
      if (user !== '') {
        url += `&user=${user}&pwd=${pwd}`
      } else {
		url += `&user=${this.getUrlParam('user')}&pwd=${this.getUrlParam('pwd')}`
	  }
      return url
    },
	getUrlParam (name) {
	    var reg = new RegExp("(^|&)" + name + "=([^&]*)(&|$)", "i");
	    var r = window.location.search.substr(1).match(reg);
	    if (r != null) 
	    	return decodeURIComponent(r[2]); 
	    return null;
	},
    taskDialogShow (type, id = 0) {
      if (type === 'add') {
        this.taskDialogTitle = '新建任务'
        this.taskDialogShowGroup = true
      } else {
        this.taskDialogTitle = '更新任务'
        this.taskDialogShowGroup = false
      }
      this.taskUploadId = id
      this.taskDialog = true
    },
    submitFile () {
      let group = $("#group").val()
      if(this.taskDialogShowGroup && $("#group").val() == ""){
        this.$message.error('请选择分组，如果没有分组请先创建分组')
        return false;
      }
      if($("#rulefile").val() == ""){
        this.$message.error('请选择上传的规则文件')
        return false;
      }
      let that = this
      let url = this.makeUrl(`model=job&action=update&jobid=${this.taskUploadId}`)
      if (this.taskDialogShowGroup) {
        url = this.makeUrl(`model=job&action=create&siteid=${group}`)
      }
      $("#uploadrulefile").ajaxSubmit({
        type: 'post',
        url: url,
        success: function (data) {
          if (data.Status == "1") {
            that.taskDialog = false
            that.$message.success('规则上传成功')
            if(that.taskDialogShowGroup) {
              window.location.reload()
            }
          } else {
            that.$message.error(data.Tips)
          }
        },
      })
    },
    initList () {
      this.breadcrumb = [{id: 0, label: '全部'}]
      this.taskAllList = []
      this.query = {
        group_id: 0,
        children: true,
        name: '',
        state: '',
        hasTrigger: ''
      }
      this.getTaskList()
    },
    getTaskList () {
      axios(this.makeUrl(`model=job&action=list`))
        .then(function (response) {
          if (response.data.Status != '1') {
            if (response.data.Tips === '请求Url中不包含user或pwd') {
              this.$message.error('服务端已开启用户验证，不可匿名访问，请填写setting.js中的用户名、密码后刷新页面')
              return
            }
            this.$message.error(response.data.Tips)
            return
          }
          this.taskAllList = response.data.Data.map(item => {
            item.spider = item.SpiderContent === 1
            item .publish = item.OutContent === 1
            return item
          })
          this.taskListTotal = this.taskAllList.length
          this.taskListPage()
          this.getGroupList()
        }.bind(this)).catch(function (error) {
        console.log(error);
      })
    },
    getSchedulerList () {
      axios(this.makeUrl(`model=job&action=list`))
        .then(function (response) {
          if (response.data.Status != '1') {
            this.$message.error('获取计划任务列表失败')
            return
          }
          this.taskSchedulerList = response.data.Data
        }.bind(this)).catch(function (error) {
        console.log(error);
      })
    },
    groupFilter(id) {
      this.query.group_id = id
    },
    taskListPage (page = 1, size = 10) {
      let start = (page - 1) * size
      let list = JSON.parse(JSON.stringify(this.taskAllList))
      if (this.query.state !== '') {
        list = list.filter(item => item.JobStatus === parseInt(this.query.state))
      }
      if (this.query.hasTrigger !== '') {
        if (this.query.hasTrigger === '1') {
          list = list.filter(item => item.Type !== undefined)
        } else {
          list = list.filter(item => item.Type === undefined)
        }
      }
      if (this.query.name !== '') {
        list = list.filter(item => {
          return item.JobName.toLowerCase().indexOf(this.query.name.toLowerCase()) !== -1
        })
      }
      this.breadcrumb = getPathByKey(this.query.group_id, 'id', JSON.parse(JSON.stringify(this.tree)))
      if (this.breadcrumb === undefined) {
        this.breadcrumb = [{id: 0, label: '全部'}]
      }
      if (this.query.group_id) {
        // let ids = this.breadcrumb.map(item => {
        //   return item.id
        // })
        // if (ids.length > 1) {
        //   ids.splice(0, 1)
        // }
        let ids = [this.query.group_id]
        if (this.query.children) {
          ids = ids.concat(this.getChildren(JSON.parse(JSON.stringify(this.groups)), this.query.group_id).map(item => {return item.id}))
        }
        list = list.filter(item => {
          return ids.includes(item.SiteId)
        })
        console.log(ids)
      }
      this.groupCount = this.groupCount.map((item, index) => {
        item = list.filter(obj => obj.JobStatus === index).length
        return item
      })
      this.taskListTotal = list.length
      this.taskList = list.splice(start, size)
      this.taskList.map(item => {
        this.getCount(item.JobId)
      })
      console.log(this.taskList)
    },
    controlTask (row, operation) {
      axios(this.makeUrl(`model=job&action=${operation}&jobid=${row.JobId}`))
        .then(function (response) {
          let operationZh = ''
          switch(operation)
          {
            case 'start':
              operationZh = '开始';
              row.JobStatus = 1
              break;
            case 'pause':
              operationZh = '暂停';
              row.JobStatus = 2
              break;
            default:
              operationZh = '停止';
              row.JobStatus = 4
              break;
          }
          if (response.data.Status != '1') {
            this.$message.error(`${response.data.Tips}`)
            return
          }
		  let index = this.taskAllList.findIndex(item => item.JobId === row.JobId)
		  if (index !== -1)
		  {
			this.taskAllList[index].JobStatus = row.JobStatus
		  }
          this.$message.success(`${operationZh}任务成功！`)
          return
        }.bind(this)).catch(function (error) {
        console.log(error);
      })
    },
    getGroupList () {
      axios(this.makeUrl(`model=site&action=list`))
        .then(function (response) {
          if (response.data.Status != '1') {
            this.$message.error('获取任务分组列表失败')
            return
          }
          let ret = response.data.Data.map(item => {
            return {id: parseInt(item.SiteId), label: item.SiteName, pid: parseInt(item.ParentId), count: 0}
          })
          ret = ret.map(obj => {
            let ids = [obj.id]
            ids = ids.concat(this.getChildren(JSON.parse(JSON.stringify(ret)), obj.id).map(item => {return item.id}))
            list = this.taskAllList.filter(item => {
              return ids.includes(item.SiteId)
            })
            obj.count = list.length
            return obj
          })
          this.groups = JSON.parse(JSON.stringify(ret))
          // console.log(this.groups)
          this.tree = []
          if (ret.length) {
            this.tree = [{
              id: 0,
              label: '全部',
              count: this.taskAllList.length,
              children: this.createTree(ret)
            }]
          }
        }.bind(this)).catch(function (error) {
        console.log(error);
      })
    },
    createTree (list , key = 'pid') {
      list = JSON.parse(JSON.stringify(list))
      let tree = list.filter(function(parent) {
        let branchArr = list.filter(
          function(child) {
            return parent.id == child[key];
          });
        if (branchArr.length > 0) {
          parent.children = branchArr;
        }
        return parent[key] == "";
      });
      return tree;
    },
    getChildren (groups, id = 0) {
      let ret = []
      groups.map(item => {
        if (parseInt(item.pid) === id) {
          ret.push(item)
          if (this.getChildren(groups, item.id) !== undefined) {
            ret = ret.concat(this.getChildren(groups, item.id))
          }
        }
      })
      return ret
    },
    getCount(id) {
      axios.get(this.makeUrl(`model=data&action=count&opreator=0&jobid=${id}`))
        .then(function (response) {
          if (response.data.Status != '1') {
            return
          }
          let index = this.taskList.findIndex(item => item.JobId === id)
          if (index !== -1) {
            this.$set(this.taskList[index], 'dataTotal', response.data.Count)
            this.$set(this.taskAllList[this.taskAllList.findIndex(item => item.JobId === id)], 'dataTotal', response.data.Count)
            this.taskDetailTotal = response.data.Count > 0 ? response.data.Count : 0
          }
        }.bind(this)).catch(function (error) {
          console.log(error);
        });
      axios.get(this.makeUrl(`model=data&action=count&opreator=1&jobid=${id}`))
        .then(function (response) {
          if (response.data.Status != '1') {
            return
          }
          let index = this.taskList.findIndex(item => item.JobId === id)
          if (index !== -1) {
            this.$set(this.taskList[index], 'dataSpider', response.data.Count)
            this.$set(this.taskAllList[this.taskAllList.findIndex(item => item.JobId === id)], 'dataSpider', response.data.Count)
          }
        }.bind(this)).catch(function (error) {
        console.log(error);
      });
      axios.get(this.makeUrl(`model=data&action=count&opreator=2&jobid=${id}`))
        .then(function (response) {
          if (response.data.Status != '1') {
            return
          }
          let index = this.taskList.findIndex(item => item.JobId === id)
          if (index !== -1) {
            this.$set(this.taskList[index], 'dataUnSpider', response.data.Count)
            this.$set(this.taskAllList[this.taskAllList.findIndex(item => item.JobId === id)], 'dataUnSpider', response.data.Count)
          }
        }.bind(this)).catch(function (error) {
        console.log(error);
      });
      axios.get(this.makeUrl(`model=data&action=count&opreator=3&jobid=${id}`))
        .then(function (response) {
          if (response.data.Status != '1') {
            return
          }
          let index = this.taskList.findIndex(item => item.JobId === id)
          if (index !== -1) {
            this.$set(this.taskList[index], 'dataPublish', response.data.Count)
            this.$set(this.taskAllList[this.taskAllList.findIndex(item => item.JobId === id)], 'dataPublish', response.data.Count)
          }
        }.bind(this)).catch(function (error) {
        console.log(error);
      });
      axios.get(this.makeUrl(`model=data&action=count&opreator=4&jobid=${id}`))
        .then(function (response) {
          if (response.data.Status != '1') {
            return
          }
          let index = this.taskList.findIndex(item => item.JobId === id)
          if (index !== -1) {
            this.$set(this.taskList[index], 'dataUnPublish', response.data.Count)
            this.$set(this.taskAllList[this.taskAllList.findIndex(item => item.JobId === id)], 'dataUnPublish', response.data.Count)
          }
        }.bind(this)).catch(function (error) {
        console.log(error);
      });
    },
    getTaskDetail (id, page, size) {
      axios.get(this.makeUrl(`model=data&action=view&pn=${page}&rn=${size}&jobid=${id}`))
        .then(function (response) {
          if (response.data.Status != '1') {
            return
          }
          this.taskDetailList = response.data.Data
        }.bind(this)).catch(function (error) {
        console.log(error);
      });
    },
    handleAddGroup () {
      this.$prompt('请输入分组名称', '新建分组', {
        confirmButtonText: '确定',
        cancelButtonText: '取消',
        inputPattern: '',
        inputErrorMessage: ''
      }).then(({ value }) => {
        axios.get(this.makeUrl(`model=site&action=create&sitename=${value}&parentid=${this.query.group_id}`))
          .then(function (response) {
            if (response.data.Status != '1') {
              this.$message.error('分组添加失败')
              return
            }
            this.initList()
            this.$message.success('分组添加成功')
            return
          }.bind(this)).catch(function (error) {
          console.log(error);
        });
      }).catch(() => {});
    },
    handleUpdateGroup () {
      if (this.query.group_id === 0) {
        this.$message.error('根分组不可编辑')
        return true
      }
      let name = this.groups.find(item => item.id === this.query.group_id)['label']
      this.$prompt('请输入分组名称', '编辑分组', {
        confirmButtonText: '确定',
        cancelButtonText: '取消',
        inputPlaceholder: name,
        inputPattern: '',
        inputErrorMessage: ''
      }).then(({ value }) => {
        let data = {
          // parentID: this.query.group_id,
          siteName: value,
          // siteMemo: ''
        }
        axios.post(this.makeUrl(`model=site&action=update&siteid=${this.query.group_id}`), JSON.parse(JSON.stringify(data)))
          .then(function (response) {
            console.log(response.data)
            if (response.data.Status != '1') {
              this.$message.error('分组名称修改失败！')
              return
            }
            this.initList()
            this.$message.success('分组名称修改成功')
          }.bind(this)).catch(function (error) {
          console.log(error)
        })
      }).catch(() => {});
    },
    handleDelGroup () {
      if (this.query.group_id === 0) {
        this.$message.error('根分组不可删除')
        return true
      }
      let ids = [this.query.group_id]
      ids = ids.concat(this.getChildren(JSON.parse(JSON.stringify(this.groups)), this.query.group_id).map(item => {return item.id}))
      let taskIds = this.taskAllList.filter(item => {
        return ids.includes(item.SiteId)
      }).map(item => {return item.JobId})
      let count = this.groups.find(item => item.id === this.query.group_id)['count']
      this.$confirm(`该分组下有 ${count} 个任务，任务删除后不可恢复，是否确定删除该分组?`, '提示', {
        confirmButtonText: '确定',
        cancelButtonText: '取消',
        type: 'warning'
      }).then(() => {
        axios.get(this.makeUrl(`model=site&action=delete&site_ids=${ids.join(',')}&job_ids=${taskIds.join(',')}`))
          .then(function (response) {
            if (response.data.Status != '1') {
              this.message.error('分组删除失败')
              return
            }
            this.initList()
            this.$message.success('分组删除成功')
            return
          }.bind(this)).catch(function (error) {
          console.log(error);
        });
      }).catch(() => {});
    },
    handleChangePage (val) {
      this.taskListPage(val)
    },
    handleChangeDetailPage(val) {
      this.getTaskDetail(this.task.JobId, val - 1, 10)
    },
    handleNodeClick (data, node) {
      this.query.group_id = data.id
      this.selectedId = data.id
      // this.taskListPage()
      // console.log(this.breadcrumb)
      // console.log(node)
    },
    toggleMenu () {
      this.showMenu = !this.showMenu
    },
    addTab(id, name, row) {
      this.getCount(id)
      this.task = JSON.parse(JSON.stringify(row))
      this.editTaskId = id
      this.getTaskDetail(id, 0, 10)
      let tab = this.tabList.find(item => item.name === id)
      if (tab === undefined) {
        this.tabList.push({
          title: name +'数据列表',
          name: id,
        })
      }
      this.tabSelectedIndex = id
    },
    removeTab(targetName) {
      let tabs = this.tabList;
      let activeName = this.tabSelectedIndex;
      if (activeName === targetName) {
        tabs.forEach((tab, index) => {
          if (tab.name === targetName) {
            let nextTab = tabs[index + 1] || tabs[index - 1];
            if (nextTab) {
              activeName = nextTab.name;
            }
          }
        });
      }
      this.tabSelectedIndex = activeName;
      this.tabList = tabs.filter(tab => tab.name !== targetName);
    },
    clickTab (targetName) {
      if (this.tabSelectedIndex === parseInt(targetName.name)) return
      if (targetName.name !== '1') {
        this.getTaskDetail(targetName.name, 0, 10)
        this.getCount(targetName.name)
        return
      }
      let temp = JSON.parse(JSON.stringify(this.taskList))
      this.taskList = []
      this.taskList = temp
    },
    changeTaskCheckbox (row, type) {
      axios.get(this.makeUrl(`model=job&action=changestatus&jobid=${row.JobId}&${type}=${row.publish ? 1 : 0}`))
        .then(function (response) {
          if (response.data.Status != '1') {
            row.publish = !row.publish
            return
          }
        }.bind(this)).catch(function (error) {
        console.log(error);
      });
    },
    deleteTask (id) {
      this.$confirm('此操作将永久删除该任务, 是否继续?', '提示', {
        confirmButtonText: '确定',
        cancelButtonText: '取消',
        type: 'warning'
      }).then(() => {
        axios.get(this.makeUrl(`model=job&action=delete&jobid=${id}`))
          .then(function (response) {
            if (response.data.Status != '1') {
              this.$message.error('任务删除失败！')
              return
            }
          }.bind(this)).catch(function (error) {
          console.log(error);
        });
        let index = this.taskAllList.findIndex(item => item.JobId === id)
        if (index !== -1) {
          this.taskAllList.splice(index, 1)
        }
        this.taskListPage()
        this.$message.success('删除成功！')
      }).catch(() => {})
    },
    openTriggerDialog(row, op = 'add') {
      this.triggerAction = op
      if (op === 'add') {
        this.trigger = {
          'trigger_type': 'interval',
          'repeat_interval': 50,
          'typeof_interval': 'Hour',
          'only_once_time': new Date(),
          'start_time': new Date(new Date(new Date().toLocaleDateString()).getTime()),
          'end_time': new Date(new Date(new Date().toLocaleDateString()).getTime()+24*60*60*1000-1),
          'begin_date': new Date(),
          'intervalof_day': 2,
          'daysof_week': [],
          'is_repeat_task': 1,
          'repeat_count': 2,
          'cron_expression': '',
          'cron_desc': ''
        }
      } else {
        let data = row.ScheduleDetail
        this.triggerSwitch = data.Enalbe
        this.trigger = {
          'trigger_type': data.Type,
          'repeat_interval': data.Interval,
          'typeof_interval': data.typeOfInterval,
          'only_once_time': new Date(),
          'start_time': new Date(),
          'end_time': new Date(),
          'begin_date': new Date(),
          'intervalof_day': data.IntervalOfDay,
          'daysof_week': data.DaysOfWeek,
          'is_repeat_task': 1,
          'repeat_count': 2,
          'cron_expression': data.Cron,
          'cron_desc': ''
        }
        // try {
        //   this.timeRange = [new Date(data.StartTime), new Date(data.EndTime)]
        // } catch (error) {
        //   console.log("初始化timeRange出错")
        // }
        switch (data.Type)
        {
          case 'interval':
            data.EndTime && (this.trigger.end_time = moment(data.EndTime, 'YYYY-MM-DD HH:mm:ss'))
            data.StartTime && (this.trigger.start_time = moment(data.StartTime, 'YYYY-MM-DD HH:mm:ss'))
            break
          case 'daily':
            data.StartTime && (this.trigger.begin_date = moment(data.StartTime, 'YYYY-MM-DD HH:mm:ss'))
            data.StartTime && (this.trigger.start_time = moment(data.StartTime, 'YYYY-MM-DD HH:mm:ss'))
            break
          case 'weekly':
            data.StartTime && (this.trigger.start_time = moment(data.StartTime, 'YYYY-MM-DD HH:mm:ss'))
            break
          case  'runOnce':
            data.StartTime && (this.trigger.begin_date = moment(data.StartTime, 'YYYY-MM-DD HH:mm:ss'))
            data.StartTime && (this.trigger.only_once_time = moment(data.StartTime, 'YYYY-MM-DD HH:mm:ss'))
            break
          default :
            break
        }
      }
      this.triggerTaskId = row.JobId
      this.triggerDialogShow = true
    },
    submitTrigger () {
      let temp = JSON.parse(JSON.stringify(this.trigger))
      console.log(temp)
      let data = {}
      data.EndTime = null
      data.StartTime = null
      switch (temp.trigger_type)
      {
        case 'interval':
          data.EndTime = moment(temp.end_time).format('YYYY-MM-DD HH:mm:ss')
          data.StartTime = moment(temp.start_time).format('YYYY-MM-DD HH:mm:ss')
          break
        case 'daily':
          data.StartTime = `${moment(temp.begin_date).format('YYYY-MM-DD')} ${moment(temp.start_time).format('HH:mm:ss')}`
          break
        case 'weekly':
          data.StartTime = moment(temp.start_time).format('YYYY-MM-DD HH:mm:ss')
          break
        case  'runOnce':
          data.StartTime = `${moment(temp.begin_date).format('YYYY-MM-DD')} ${moment(temp.only_once_time).format('HH:mm:ss')}`
          break
        default :
          break
      }
      data.Cron = temp.cron_expression
      data.DaysOfWeek = temp.daysof_week
      data.Enalbe = this.triggerSwitch
      data.Interval = temp.repeat_interval
      data.IntervalOfDay = temp.intervalof_day
      data.Type = temp.trigger_type
      data.typeOfInterval = temp.typeof_interval
      if (this.triggerAction === 'add') {
        axios.post(this.makeUrl(`model=schedulernew&action=create&jobid=${this.triggerTaskId}`), JSON.parse(JSON.stringify(data)))
          .then(function (response) {
            console.log(response.data)
            if (response.data.Status != '1') {
              this.$message.error('计划任务添加失败！')
              return
            }
            this.$message.success('计划任务添加成功')
            this.triggerDialogShow = false
            this.initList()
          }.bind(this)).catch(function (error) {
          console.log(error)
        })
      } else {
        axios.post(this.makeUrl(`model=schedulernew&action=update&jobid=${this.triggerTaskId}`), JSON.parse(JSON.stringify(data)))
          .then(function (response) {
            console.log(response.data)
            if (response.data.Status != '1') {
              this.$message.error('计划任务修改失败！')
              return
            }
            this.$message.success('计划任务修改成功')
            this.triggerDialogShow = false
            this.initList()
          }.bind(this)).catch(function (error) {
          console.log(error)
        })
      }
    },
    updateContent (val) {
      this.editorContent = val
    },
    submitEditorContent () {
      axios.get(this.makeUrl(`model=data&appname=LocoySpider&jobid=${this.editTaskId}&action=update&labelname=${this.editFiled}&content=${this.editorContent}&dataid=${this.editDataId}`))
        .then(function (response) {
          if (response.data.Status != '1') {
            this.$message.error('修改内容保存失败！')
            return
          }
        }.bind(this)).catch(function (error) {
        console.log(error);
      });
      this.$message.success('修改内容保存成功')
      this.editContentShow = false
    },
    editContent (row, column, cell, event) {
      if (column.label === 'ID') return
      this.editFiled = column.label
      this.editDataId = row['ID']
      this.editorContent = row[column.label]
      this.editContentShow = true
    }
  },
  watch: {
    timeRange: function () {
      this.trigger.start_time = this.timeRange[0]
      this.trigger.end_time = this.timeRange[1]
    },
    'trigger.intervalof_day': function () {
      if (this.trigger.intervalof_day === 0 && this.day_interval !== 'everyday') {
        setTimeout(() => {
          this.day_interval = 'everyday'
        }, 100)
      }
    },
    'trigger': {
      handler: function () {
        // console.log(JSON.stringify(this.trigger))
      },
      deep: true
    },
    query: {
      handler: function() {
        this.taskListPage()
      },
      deep: true
    }
  }
})
// 定义一个名为 button-counter 的新组件
Vue.component('button-counter', {
  data: function () {
    return {
      count: 0
    }
  },
  template: `<button v-on:click="count++">You clicked me {{ count }} times.</button>`
})
// Vue.use(VueHtml5Editor, {
//   showModuleName: true,
//   image: {
//     sizeLimit: 512 * 1024,
//     compress: true,
//     width: 500,
//     height: 500,
//     quality: 80
//   }
// })
// new Vue({ el: '#vue-container' })
