/**
 * @file	scciif.h
 * @brief	SCCI ANZX NX̐錾уC^[tFCX̒`܂
 */

#pragma once

#include "../externalchip.h"

class Scci2SoundChip;
class Scci2SoundInterfaceManager;

/**
 * @brief SCCI ANZX NX
 */
class CScci2If
{
public:
	CScci2If();
	~CScci2If();
	bool Initialize();
	void Deinitialize();
	void Reset();
	IExternalChip* GetInterface(IExternalChip::ChipType nChipType, UINT nClock);

private:
	HMODULE m_hModule;					/*!< W[ */
	Scci2SoundInterfaceManager* m_pManager;	/*!< }l[W */

	/**
	 * @brief `bv NX
	 */
	class Chip : public IExternalChip
	{
	public:
		Chip(CScci2If* pScciIf, Scci2SoundChip* pSoundChip);
		virtual ~Chip();
		operator Scci2SoundChip*();
		virtual ChipType GetChipType();
		virtual void Reset();
		virtual void WriteRegister(UINT nAddr, UINT8 cData);
		virtual INTPTR Message(UINT nMessage, INTPTR nParameter = 0);

	private:
		CScci2If* m_pScciIf;			/*!< eCX^X */
		Scci2SoundChip* m_pSoundChip;	/*!< `bv CX^X */
	};

	void Detach(Chip* pChip);
	friend class Chip;
};
