/**
 * @file	scciif.cpp
 * @brief	SCCI ANZX NX̓̒`s܂
 */

#include "compiler.h"
#include "scci2if.h"
#include "scci2.h"

/**
 * RXgN^
 */
CScci2If::CScci2If()
	: m_hModule(NULL)
	, m_pManager(NULL)
{
}

/**
 * fXgN^
 */
CScci2If::~CScci2If()
{
	Deinitialize();
}

/**
 * 
 * @retval true 
 * @retval false s
 */
bool CScci2If::Initialize()
{
	if (m_hModule)
	{
		return false;
	}

	do
	{
		m_hModule = ::LoadLibrary(TEXT("SCCI2.DLL"));
		if (m_hModule == NULL)
		{
			break;
		}

		/* TEhC^[tF[X}l[W[擾p֐AhX擾 */
		SCCIFUNC fnGetSoundInterfaceManager = reinterpret_cast<SCCIFUNC>(::GetProcAddress(m_hModule, "getSoundInterfaceManager"));
		if (fnGetSoundInterfaceManager == NULL)
		{
			break;
		}

		/* TEhC^[tF[X}l[W[擾 */
		m_pManager = (*fnGetSoundInterfaceManager)();
		if (m_pManager == NULL)
		{
			break;
		}

		/* TEhC^[tF[X}l[W[CX^X */
		/* KŏɎsĂ */
		if (!m_pManager->initializeInstance())
		{
			break;
		}

		/* Zbgs */
		Reset();
		return true;
	} while (false /*CONSTCOND*/);

	Deinitialize();
	return false;
}

/**
 * 
 */
void CScci2If::Deinitialize()
{
	if (m_pManager)
	{
		/* ꊇJꍇi`bvꊇJ̏ꍇj */
		m_pManager->releaseAllSoundChip();

		/* TEhC^[tF[X}l[W[CX^XJ */
		/* FreeLibrarysOɕKĂяoĂ */
		m_pManager->releaseInstance();

		m_pManager = NULL;
	}

	if (m_hModule)
	{
		::FreeLibrary(m_hModule);
		m_hModule = NULL;
	}
}

/**
 * Zbg
 */
void CScci2If::Reset()
{
	if (m_pManager)
	{
		/* Zbgs */
		m_pManager->reset();
	}
}

/**
 * C^[tFCX擾
 * @param[in] nChipType ^Cv
 * @param[in] nClock NbN
 * @return CX^X
 */
IExternalChip* CScci2If::GetInterface(IExternalChip::ChipType nChipType, UINT nClock)
{
	const bool bInitialized = Initialize();

	do
	{
		if (m_pManager == NULL)
		{
			break;
		}

		SC2_CHIP_TYPE iSoundChipType = SC2_TYPE_NONE;
		switch (nChipType)
		{
			case IExternalChip::kAY8910:
				iSoundChipType = SC2_TYPE_AY8910;
				break;

			case IExternalChip::kYM2203:
				iSoundChipType = SC2_TYPE_YM2203;
				break;

			case IExternalChip::kYM2608:
				iSoundChipType = SC2_TYPE_YM2608;
				break;

			case IExternalChip::kYM3438:
				iSoundChipType = SC2_TYPE_YM2612;
				break;

			case IExternalChip::kYMF288:
				iSoundChipType = SC2_TYPE_YMF288;
				break;

			case IExternalChip::kYM3812:
				iSoundChipType = SC2_TYPE_YM3812;
				break;

			case IExternalChip::kYMF262:
				iSoundChipType = SC2_TYPE_YMF262;
				break;

			case IExternalChip::kY8950:
				iSoundChipType = SC2_TYPE_Y8950;
				break;

			case IExternalChip::kYM2151:
				iSoundChipType = SC2_TYPE_YM2151;
				break;

			default:
				break;
		}

		Scci2SoundChip* pSoundChip = m_pManager->getSoundChip(iSoundChipType, nClock);
		if (pSoundChip != NULL)
		{
			/* TEh`bv擾ł */
			return new Chip(this, pSoundChip);
		}
	} while (false /*CONSTCOND*/);

	if (bInitialized)
	{
//		Deinitialize();
	}
	return NULL;
}

/**
 * 
 * @param[in] pChip `bv
 */
void CScci2If::Detach(CScci2If::Chip* pChip)
{
	/* `bv̊Ji`bvPʂŊJ̏ꍇj */
	if (m_pManager)
	{
		m_pManager->releaseSoundChip(*pChip);
	}
}

/* ---- `bv */

/**
 * RXgN^
 * @param[in] pScciIf eCX^X
 * @param[in] pSoundChip `bv CX^X
 */
CScci2If::Chip::Chip(CScci2If* pScciIf, Scci2SoundChip* pSoundChip)
	: m_pScciIf(pScciIf)
	, m_pSoundChip(pSoundChip)
{
}

/**
 * fXgN^
 */
CScci2If::Chip::~Chip()
{
	m_pScciIf->Detach(this);
}

/**
 * Iy[^
 */
CScci2If::Chip::operator Scci2SoundChip*()
{
	return m_pSoundChip;
}

/**
 * Get chip type
 * @return The type of the chip
 */
IExternalChip::ChipType CScci2If::Chip::GetChipType()
{
	int iSoundChip = m_pSoundChip->getSoundChipType();

	const SCCI2_SOUND_CHIP_INFO* pInfo = m_pSoundChip->getSoundChipInfo();
	if (pInfo)
	{
		iSoundChip = pInfo->iSoundChip;
	}

	switch (iSoundChip)
	{
		case SC2_TYPE_AY8910:
			return IExternalChip::kAY8910;

		case SC2_TYPE_YM2203:
			return IExternalChip::kYM2203;

		case SC2_TYPE_YM2608:
			return IExternalChip::kYM2608;

		case SC2_TYPE_YM2612:
			return IExternalChip::kYM3438;

		case SC2_TYPE_YM3812:
			return IExternalChip::kYM3812;

		case SC2_TYPE_YMF262:
			return IExternalChip::kYMF262;

		case SC2_TYPE_YMF288:
			return IExternalChip::kYMF288;

		case SC2_TYPE_Y8950:
			return IExternalChip::kY8950;

		case SC2_TYPE_YM2151:
			return IExternalChip::kYM2151;

		default:
			break;
	}
	return IExternalChip::kNone;
}

/**
 * Zbg
 */
void CScci2If::Chip::Reset()
{
}

/**
 * WX^
 * @param[in] nAddr AhX
 * @param[in] cData f[^
 */
void CScci2If::Chip::WriteRegister(UINT nAddr, UINT8 cData)
{
	m_pSoundChip->setRegister(nAddr, cData);
}

/**
 * bZ[W
 * @param[in] nMessage bZ[W
 * @param[in] nParameter p[^
 * @return Ug
 */
INTPTR CScci2If::Chip::Message(UINT nMessage, INTPTR nParameter)
{
	return 0;
}
