/**
 * @file	cmdparser.h
 * @brief	GXP[vV[PXȂǂ̃R}hp[X܂
 */

/*
 * Copyright (c) 2026 SimK
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

#include <vector>

// R}h`p}N@R}hꍇPRINTCMD_DEFINE\̓char cmd̒₷
// R}h񃊃e
#define PRINTCMD_DEFINE_FIXEDLEN(cmdstr, datalength, proc)				{cmdstr, sizeof(cmdstr)-1, PRINTCMD_TYPE_FIXEDLEN, datalength, 0, 0, 0, proc, false}
#define PRINTCMD_DEFINE_LENFIELD(cmdstr, fieldlen, elementsize, proc)	{cmdstr, sizeof(cmdstr)-1, PRINTCMD_TYPE_LENFIELD, 0, fieldlen, elementsize, 0, proc, false}
#define PRINTCMD_DEFINE_TERMINATOR(cmdstr, terminator_char, proc)		{cmdstr, sizeof(cmdstr)-1, PRINTCMD_TYPE_TERMINATOR, 0, 0, 0, terminator_char, proc, false}
#define PRINTCMD_DEFINE_FIXEDLEN_V(cmdstr, datalength, proc)			{cmdstr, sizeof(cmdstr)-1, PRINTCMD_TYPE_FIXEDLEN, datalength, 0, 0, 0, proc, true}
#define PRINTCMD_DEFINE_LENFIELD_V(cmdstr, fieldlen, elementsize, proc)	{cmdstr, sizeof(cmdstr)-1, PRINTCMD_TYPE_LENFIELD, 0, fieldlen, elementsize, 0, proc, true}

// R}h1byte
#define PRINTCMD1_DEFINE_FIXEDLEN(cmd, datalength, proc)				{{cmd, '\0'}, 1, PRINTCMD_TYPE_FIXEDLEN, datalength, 0, 0, 0, proc, false}
#define PRINTCMD1_DEFINE_LENFIELD(cmd, fieldlen, elementsize, proc)		{{cmd, '\0'}, 1, PRINTCMD_TYPE_LENFIELD, 0, fieldlen, elementsize, 0, proc, false}
#define PRINTCMD1_DEFINE_TERMINATOR(cmd, terminator_char, proc)			{{cmd, '\0'}, 1, PRINTCMD_TYPE_TERMINATOR, 0, 0, 0, terminator_char, proc, false}
#define PRINTCMD1_DEFINE_FIXEDLEN_V(cmd, datalength, proc)				{{cmd, '\0'}, 1, PRINTCMD_TYPE_FIXEDLEN, datalength, 0, 0, 0, proc, true}
#define PRINTCMD1_DEFINE_LENFIELD_V(cmd, fieldlen, elementsize, proc)	{{cmd, '\0'}, 1, PRINTCMD_TYPE_LENFIELD, 0, fieldlen, elementsize, 0, proc, true}

// R}h2byte
#define PRINTCMD2_DEFINE_FIXEDLEN(cmd1, cmd2, datalength, proc)					{{cmd1, cmd2, '\0'}, 2, PRINTCMD_TYPE_FIXEDLEN, datalength, 0, 0, 0, proc, false}
#define PRINTCMD2_DEFINE_LENFIELD(cmd1, cmd2, fieldlen, elementsize, proc)		{{cmd1, cmd2, '\0'}, 2, PRINTCMD_TYPE_LENFIELD, 0, fieldlen, elementsize, 0, proc, false}
#define PRINTCMD2_DEFINE_TERMINATOR(cmd1, cmd2, terminator_char, proc)			{{cmd1, cmd2, '\0'}, 2, PRINTCMD_TYPE_TERMINATOR, 0, 0, 0, terminator_char, proc, false}
#define PRINTCMD2_DEFINE_FIXEDLEN_V(cmd1, cmd2, datalength, proc)				{{cmd1, cmd2, '\0'}, 2, PRINTCMD_TYPE_FIXEDLEN, datalength, 0, 0, 0, proc, true}
#define PRINTCMD2_DEFINE_LENFIELD_V(cmd1, cmd2, fieldlen, elementsize, proc)	{{cmd1, cmd2, '\0'}, 2, PRINTCMD_TYPE_LENFIELD, 0, fieldlen, elementsize, 0, proc, true}

// R}h3byte
#define PRINTCMD3_DEFINE_FIXEDLEN(cmd1, cmd2, cmd3, datalength, proc)				{{cmd1, cmd2, cmd3, '\0'}, 3, PRINTCMD_TYPE_FIXEDLEN, datalength, 0, 0, 0, proc, false}
#define PRINTCMD3_DEFINE_LENFIELD(cmd1, cmd2, cmd3, fieldlen, elementsize, proc)	{{cmd1, cmd2, cmd3, '\0'}, 3, PRINTCMD_TYPE_LENFIELD, 0, fieldlen, elementsize, 0, proc, false}
#define PRINTCMD3_DEFINE_TERMINATOR(cmd1, cmd2, cmd3, terminator_char, proc)		{{cmd1, cmd2, cmd3, '\0'}, 3, PRINTCMD_TYPE_TERMINATOR, 0, 0, 0, terminator_char, proc, false}
#define PRINTCMD3_DEFINE_FIXEDLEN_V(cmd1, cmd2, cmd3, datalength, proc)				{{cmd1, cmd2, cmd3, '\0'}, 3, PRINTCMD_TYPE_FIXEDLEN, datalength, 0, 0, 0, proc, true}
#define PRINTCMD3_DEFINE_LENFIELD_V(cmd1, cmd2, cmd3, fieldlen, elementsize, proc)	{{cmd1, cmd2, cmd3, '\0'}, 3, PRINTCMD_TYPE_LENFIELD, 0, fieldlen, elementsize, 0, proc, true}

// R}h4byte
#define PRINTCMD4_DEFINE_FIXEDLEN(cmd1, cmd2, cmd3, cmd4, datalength, proc)					{{cmd1, cmd2, cmd3, cmd4, '\0'}, 4, PRINTCMD_TYPE_FIXEDLEN, datalength, 0, 0, 0, proc, false}
#define PRINTCMD4_DEFINE_LENFIELD(cmd1, cmd2, cmd3, cmd4, fieldlen, elementsize, proc)		{{cmd1, cmd2, cmd3, cmd4, '\0'}, 4, PRINTCMD_TYPE_LENFIELD, 0, fieldlen, elementsize, 0, proc, false}
#define PRINTCMD4_DEFINE_TERMINATOR(cmd1, cmd2, cmd3, cmd4, terminator_char, proc)			{{cmd1, cmd2, cmd3, cmd4, '\0'}, 4, PRINTCMD_TYPE_TERMINATOR, 0, 0, 0, terminator_char, proc, false}
#define PRINTCMD4_DEFINE_FIXEDLEN_V(cmd1, cmd2, cmd3, cmd4, datalength, proc)				{{cmd1, cmd2, cmd3, cmd4, '\0'}, 4, PRINTCMD_TYPE_FIXEDLEN, datalength, 0, 0, 0, proc, true}
#define PRINTCMD4_DEFINE_LENFIELD_V(cmd1, cmd2, cmd3, cmd4, fieldlen, elementsize, proc)	{{cmd1, cmd2, cmd3, cmd4, '\0'}, 4, PRINTCMD_TYPE_LENFIELD, 0, fieldlen, elementsize, 0, proc, true}

typedef enum {
	PRINTCMD_TYPE_FIXEDLEN = 0,
	PRINTCMD_TYPE_LENFIELD = 1,
	PRINTCMD_TYPE_TERMINATOR = 2,
} PRINTCMD_TYPE;

typedef enum {
	PRINTCMD_CALLBACK_RESULT_CONTINUE = 0,
	PRINTCMD_CALLBACK_RESULT_COMPLETE = 1,
	PRINTCMD_CALLBACK_RESULT_INVALID = 2
} PRINTCMD_CALLBACK_RESULT;

typedef struct {
	UINT8 cmd[5]; // R}h@oCgꍇ͐ɗ̂珇ɏ@nullI[
	int cmdlen;
	PRINTCMD_TYPE type;

	// Œ蒷@
	UINT32 fixedlen_datalength; // R}hf[^

	// ϒ
	UINT32 lenfield_length; // vf\񕔕̒
	UINT32 lenfield_elementsize; // vf1̃TCY

	// I[
	UINT8 terminator_char; // I[

	// CӃf[^
	void *userdata;

	// Xe[^XɂĒς
	bool varlength;
} PRINTCMD_DEFINE;

typedef struct {
	PRINTCMD_DEFINE *cmd;
	std::vector<UINT8> data;
} PRINTCMD_DATA;

/**
 * @brief PrinterCommandParser
 */
class PrinterCommandParser
{
public:
	/// <summary>
	/// RXgN^
	/// </summary>
	/// <param name="commandTable">R}h̒`e[u</param>
	/// <param name="commandTableLength">R}h̒`e[u̒</param>
	/// <param name="unknownCommandCallback">`ÕR}hƂ̏֐i݂͌̃R}hf[^Śj@null̏ꍇ͏펞R}h(PRINTCMD_CALLBACK_RESULT_INVALID)</param>
	/// <param name="variableLengthCallback">ԂɂĒςR}h̒ǉԂ֐@null̏ꍇ͒ǉi=̒j ̒lɂ͂łȂ</param>
	/// <param name="callbackParam">`ÕR}hƂ̏֐ɓnCӂ̃|C^</param>
	PrinterCommandParser(const PRINTCMD_DEFINE *commandTable, int commandTableLength, PRINTCMD_CALLBACK_RESULT (*unknownCommandCallback)(void* param, const std::vector<UINT8>& curBuffer), UINT32 (*variableLengthCallback)(void* param, const PRINTCMD_DEFINE& cmddef, const std::vector<UINT8>& curBuffer), void* callbackParam);
	/// <summary>
	/// fXgN^
	/// </summary>
	~PrinterCommandParser();

	/// <summary>
	/// f[^Push܂
	/// </summary>
	/// <param name="data">Vf[^</param>
	/// <returns>R}hSɉ߂ăXgɒǉꂽtrueԂ</returns>
	bool PushByte(UINT8 data);

	/// <summary>
	/// p[XꂽR}h̃Xg擾܂BZbgꍇclearĂOKB
	/// </summary>
	/// <returns>p[XꂽR}h̃Xg</returns>
	std::vector<PRINTCMD_DATA>& GetParsedCommandList();
	
private:
	PrinterCommandParser(const PrinterCommandParser&); // Rs[RXgN^֎~
	PrinterCommandParser& operator=(const PrinterCommandParser&); // Rs[֎~

	/// <summary>
	/// R}hXgɌ݂̃obt@ǉ
	/// </summary>
	void AddToCommandList();

    std::vector<UINT8> m_buffer;
    std::vector<PRINTCMD_DEFINE> m_commandTable;
    std::vector<PRINTCMD_DATA> m_parsedCommandList;
	PRINTCMD_CALLBACK_RESULT (*m_unknownCommandCallback)(void* param, const std::vector<UINT8>& curBuffer); 
	UINT32(*m_variableLengthCallback)(void* param, const PRINTCMD_DEFINE& cmddef, const std::vector<UINT8>& curBuffer);
	void* m_callbackParam;

	PRINTCMD_DEFINE *m_cmddef;
	bool m_dataRemainValid;
	int m_dataRemain;
	bool m_terminatorValid;
	UINT8 m_terminator;
	int m_cmdlen;
	bool m_addLengthChecked;
};
