/**
 * @file	cmpipe.cpp
 * @brief	OtpCv VA NX̓̒`s܂
 */

#include "compiler.h"
#include "cmpipe.h"

#if defined(SUPPORT_NAMED_PIPE)

/**
 * CX^X쐬
 * @param[in] nPort |[gԍ
 * @param[in] pipename pCv̖O
 * @param[in] servername T[o[̖O
 * @return CX^X
 */
CComPipe* CComPipe::CreateInstance(LPCTSTR pipename, LPCTSTR servername)
{
	CComPipe* pSerial = new CComPipe;
	if (!pSerial->Initialize(pipename, servername))
	{
		delete pSerial;
		pSerial = NULL;
	}
	return pSerial;
}

/**
 * RXgN^
 */
CComPipe::CComPipe()
	: CComBase(COMCONNECT_SERIAL)
	, m_hSerial(INVALID_HANDLE_VALUE)
	, m_isserver(false)
	, m_lastdata(0)
	, m_lastdatafail(0)
{
}

/**
 * fXgN^
 */
CComPipe::~CComPipe()
{
	if (m_hSerial != INVALID_HANDLE_VALUE)
	{
		if(m_isserver){
			DisconnectNamedPipe(m_hSerial);
		}
		::CloseHandle(m_hSerial);
		m_hSerial = INVALID_HANDLE_VALUE;
	}
}

/**
 * 
 * @param[in] nPort |[gԍ
 * @param[in] pipename pCv̖O
 * @param[in] servername T[o[̖O
 * @retval true 
 * @retval false s
 */
bool CComPipe::Initialize(LPCTSTR pipename, LPCTSTR servername)
{
	TCHAR szName[MAX_PATH];
	if(pipename==NULL || _tcslen(pipename) == 0){
		// No pipe name
		return false;
	}
	if(_tcslen(pipename) + (servername!=NULL ? _tcslen(servername) : 0) > MAX_PATH - 16){
		// too long pipe name
		return false;
	}
	if(_tcschr(pipename, '\\') != NULL || (servername!=NULL && _tcschr(servername, '\\') != NULL)){
		// cannot use \ in pipe name
		return false;
	}
	if(servername && _tcslen(servername)!=0){
		wsprintf(szName, TEXT("\\\\%s\\pipe\\%s"), servername, pipename);
	}else{
		wsprintf(szName, TEXT("\\\\.\\pipe\\%s"), pipename);
	}

	if(m_hSerial != INVALID_HANDLE_VALUE){
		if(m_isserver){
			DisconnectNamedPipe(m_hSerial);
		}
		::CloseHandle(m_hSerial);
		m_hSerial = INVALID_HANDLE_VALUE;
	}

	// NCAgڑgC
	m_hSerial = CreateFile(szName, GENERIC_READ | GENERIC_WRITE, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	if (m_hSerial == INVALID_HANDLE_VALUE) {
		// T[o[ōăgC
		m_hSerial = CreateNamedPipe(szName, PIPE_ACCESS_DUPLEX, PIPE_TYPE_BYTE|PIPE_NOWAIT, 1, 1024, 1024, 500, NULL);
		if (m_hSerial == INVALID_HANDLE_VALUE) {
			return false;
		}
		m_isserver = true;
		//ConnectNamedPipe(m_hSerial, NULL); // With a nonblocking-wait handle, the connect operation returns zero immediately, and the GetLastError function returns ERROR_PIPE_LISTENING. Ƃ̂ƂȂ̂ŏ펞0
	}

	_tcscpy(m_pipename, pipename);
	_tcscpy(m_pipeserv, servername);

	return true;
}

/**
 * ǂݍ
 * @param[out] pData obt@
 * @return TCY
 */
UINT CComPipe::Read(UINT8* pData)
{
	DWORD dwReadSize;
	if (m_hSerial == INVALID_HANDLE_VALUE) {
		return 0;
	}
	if (PeekNamedPipe(m_hSerial, NULL, 0, NULL, &dwReadSize, NULL)){
		if(dwReadSize > 0){
			if (::ReadFile(m_hSerial, pData, 1, &dwReadSize, NULL))
			{
				return 1;
			}
		}
	}else{
		DWORD err = GetLastError();
		if(m_isserver){
			if(err==ERROR_BROKEN_PIPE){
				DisconnectNamedPipe(m_hSerial);
				ConnectNamedPipe(m_hSerial, NULL);
			}
		}else{
			if(err==ERROR_PIPE_NOT_CONNECTED){
				Initialize(m_pipename, m_pipeserv);
			}
		}
	}
	return 0;
}

/**
 * 
 * @param[out] cData f[^
 * @return TCY
 */
UINT CComPipe::Write(UINT8 cData)
{
	UINT ret;
	DWORD dwWrittenSize;
	if (m_hSerial == INVALID_HANDLE_VALUE) {
		m_lastdatafail = 1;
		return 0;
	}
	ret = (::WriteFile(m_hSerial, &cData, 1, &dwWrittenSize, NULL)) ? 1 : 0;
	if(dwWrittenSize==0) {
		DWORD err = GetLastError();
		if(m_isserver){
			if(err==ERROR_BROKEN_PIPE){
				return 0;
			}
		}else{
			if(err==ERROR_PIPE_NOT_CONNECTED){
				return 0;
			}
		}
		if(m_lastdatafail && GetTickCount() - m_lastdatatime > 1000){
			m_lastdatafail = 0;
			m_lastdata = 0;
			m_lastdatatime = 0;
			return 1; // obt@f[^肻ɂȂȂ炠߂ib1byte(8bit)͗΂ɂ蓾Ȃj
		}
		m_lastdatafail = 1;
		m_lastdata = cData;
		m_lastdatatime = GetTickCount();
		return 0;
	}else{
		m_lastdatafail = 0;
		m_lastdata = 0;
		m_lastdatatime = 0;
	}
	return ret;
}

/**
 * ݃gC
 * @return TCY
 */
UINT CComPipe::WriteRetry()
{
	UINT ret;
	DWORD dwWrittenSize;
	if(m_lastdatafail){
		if (m_hSerial == INVALID_HANDLE_VALUE) {
			return 0;
		}
		ret = (::WriteFile(m_hSerial, &m_lastdata, 1, &dwWrittenSize, NULL)) ? 1 : 0;
		if(dwWrittenSize==0) {
			DWORD err = GetLastError();
			if(m_isserver){
				if(err==ERROR_BROKEN_PIPE){
					return 1; // 펞
				}
			}else{
				if(err==ERROR_PIPE_NOT_CONNECTED){
					return 1; // 펞
				}
			}
			if(m_lastdatafail && GetTickCount() - m_lastdatatime > 1000){
				m_lastdatafail = 0;
				m_lastdata = 0;
				m_lastdatatime = 0;
				return 1; // obt@f[^肻ɂȂȂ炠߂ib1byte(8bit)͗΂ɂ蓾Ȃj
			}
			return 0;
		}
		m_lastdatafail = 0;
		m_lastdata = 0;
		m_lastdatatime = 0;
		return ret;
	}
	return 1;
}

/**
 * Ō݂̏Ă邩`FbN
 * @return TCY
 */
UINT CComPipe::LastWriteSuccess()
{
	if(m_lastdatafail && GetTickCount() - m_lastdatatime > 3000){
		return 1; // 3bԃobt@f[^肻ɂȂȂ炠߂
	}
	if(m_lastdatafail){
		return 0;
	}
	return 1;
}

/**
 * Xe[^X𓾂
 * bit 7: ~CI (RI, RING)
 * bit 6: ~CS (CTS)
 * bit 5: ~CD (DCD, RLSD)
 * bit 4: reserved
 * bit 3: reserved
 * bit 2: reserved
 * bit 1: reserved
 * bit 0: ~DSR (DR)
 * @return Xe[^X
 */
UINT8 CComPipe::GetStat()
{
	UINT8 ret = 0xa0;
	DWORD dwReadSize;
	if (m_hSerial == INVALID_HANDLE_VALUE) {
		ret = 0xe1;
	}else if (!PeekNamedPipe(m_hSerial, NULL, 0, NULL, &dwReadSize, NULL)){
		DWORD err = GetLastError();
		if(err==ERROR_BAD_PIPE){
			ret = 0xe1;
		}else{
			if(m_isserver){
				if(err==ERROR_BROKEN_PIPE){
					ret = 0xe1;
				}
			}else{
				if(err==ERROR_PIPE_NOT_CONNECTED){
					ret = 0xe1;
				}
			}
		}
	}
	return ret;
}

/**
 * bZ[W
 * @param[in] nMessage bZ[W
 * @param[in] nParam p^
 * @return Ug R[h
 */
INTPTR CComPipe::Message(UINT nMessage, INTPTR nParam)
{
	switch (nMessage)
	{
		case COMMSG_PURGE:
			{
				m_lastdatafail = 0;
				m_lastdata = 0;
				m_lastdatatime = 0;
			}
			break;

		default:
			break;
	}
	return 0;
}

#endif
