tokage.data = {};

// 間違えてグローバルのsavやramに代入してたので今後は再発防止徹底

// 【引数】number : 1～tokage.SAVEDATA_NUM
tokage.data.save = function(sav, number)
{
	// １回でもセーブされたフラグ（ロード可）
	sav.saved = true;
	
	// 本文欄を保存する
	sav.textArea = $(tokage.TEXT_AREA).html();
	
	// 名前欄を保存する
	sav.nameArea = $(tokage.NAME_AREA).html();
	
	// 日時を更新する
	var date = new Date();
	console.log(date);
	sav.summary.dateTime = tokage.data.dateFormat(date);
	console.log(sav.summary.dateTime);
	
	// スクリーンショットを保存する
	sav.summary.screenShot.storage = 
		document.getElementById("tokage_canvas").toDataURL("image/jpeg", 1.0);
	
	window.localStorage.setItem("save" + (number - 1), JSON.stringify(sav));
	console.log(sav);
};

// 【引数】number : 1～tokage.SAVEDATA_NUM
tokage.data.load = function(number)
{
	var sav_text;
	sav_text = window.localStorage.getItem("save" + (number - 1));
	if (sav_text == null)
	{
		return tokage.data.newData();
	}
	else
	{
		return JSON.parse(sav_text);
	}
};

tokage.data.newData = function()
{
	var sav = 
	{
		lang : "ja",
		saved : false, // １回でも保存されたらtrue。falseの時はロードできない。
		summary : 
		{
			screenShot : { storage : "" },
			dateTime : tokage.data.dateFormat(null),
			chapter : ""
		},
		script : "", // todo: storageのほうがいいか？ 理由：空データロード時に困る(現状savedを使って弾いている)
		pointer : 0,
		textArea : "",
		nameArea : "",
		stopTagName : null,
		actCharaName : null,
		layers : 
		{
			"base" : // (M)
			{
				left : 0, // (M)
				top : 0, // (M)
				flip : false, // (M)
				transed : false, // (M)
				fore :  // (M)
				{
					storage : null // (M)
				},
				back : // (M)
				{
					storage : null // (M)
				}
			}
			/*,"0" : // (O)
			{\
				left : 0,
				top : 0,
				flip : false,
				fore :
				{
					storage : "./data/fgimage/example1_face1.png"
				},
				back :
				{
					storage : null
				}
				name : "example1", // (O)
				face : "face1" // (O)
			},
			"1" : // (O)
			{
				left : 0,
				top : 0,
				flip : false
				fore : 
				{
					storage : "./data/fgimage/example2.png"
				},
				back :
				{
					storage : null
				}
			}*/
		},
		charas : // (M)
		{
			/*"name01" :  // (O)
			{
				jname : "例の人", // (M)
				faces : // (M)
				{
					"default" : // (M)
					{
						storage : "./data/fgimage/example1.png" // (M)
					},
					"face01" : // (O)
					{
						storage : "./data/fgimage/example1_smile.png" // (M)
					}
				}
			}*/
		},
		f : { sys : { messageWindowVisible : true } } // sysはシステムが代入してくれる変数。ram的なものもある
	};
	
	// 真っ黒1px
	sav.summary.screenShot.storage = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAACXBIWXMAADXTAAA10wEMIUN3AAAAG3RFWHRTb2Z0d2FyZQBDZWxzeXMgU3R1ZGlvIFRvb2zBp+F8AAAADUlEQVQI12NkYGD4DwABCQEB0tSvjgAAAABJRU5ErkJggg==";
	
	return sav;
};

// savを元にramを生成する
// 本文を復元する
// ・ramに含まれる画像オブジェクトのロードも行う
// ・lタグで止まってる場合はレイヤーの表示も行う
tokage.data.generateRam = function(sav)
{
	var ram =
	{
		// foreAlpha : 1.0,
		transTime : 0, // Source of ForeAlpha and BackAlpha
		searchingLabel : null,
		destinationLevel : 0,
		skipMode : false,
		noWait : false, 
		state : 0,
		tagName : "",
		paramName : "",
		param : "",
		params : {},
		doubleQuote : false,
		stopping : true, // stopTagNameだけでは不十分なため
		escapeSequence : false,
		loadingCount : 0, // これが0になるまで描画できない
		layers : 
		{
			"base" : // (M)
			{
				fore : // (M)
				{
					img : null // (M)
				},
				back : // (M)
				{
					img : null // (M)
				}
			}
			/*,"0" : // (O)
			{
				fore : // (M)
				{
					img : null, // (M)
				},
				back : // (M)
				{
					img : null // (M)
				}
			}*/
		}
	};

	// console.log(sav);
	// console.log(ram);
	
	$.each
	(
		sav.layers, function(key, value)
		{
			// "0" : null のようなペアが入ってくるため弾く
			if (value == null) return;
			
			// (ram)
			if (ram.layers[key] == null) // value == null
			{
				ram.layers[key] = { fore : { img : null }, back : { img : null } };
			}
			
			var load = function(page)
			{
				if (value[page] == null) { console.log("ERROD: 不整合"); return; }
				if (value[page].storage == null) return;
				ram.loadingCount++;
				ram.layers[key][page].img = new Image();
				ram.layers[key][page].img.src = value[page].storage;
				ram.layers[key][page].img.onload = function()
				{
					ram.loadingCount--;
					if (ram.loadingCount == 0)
					{
						// Canvasを描画する
						tokage.canvas.draw(ram, sav);
					}
				};
			};
			
			load("fore");
			load("back");
		}
	);
	
	// 本文欄を復元する
	$(tokage.TEXT_AREA).html(sav.textArea);
	
	// 名前欄を復元する
	$(tokage.NAME_AREA).html(sav.nameArea);
	
	// クリックレイヤーを表示・非表示
	$(tokage.NEXT_DIV).css("display", "none");
	if (sav.stopTagName === "l") { $(tokage.NEXT_DIV).css("display", "block"); }
	
	return ram;
};

tokage.data.dateFormat = function(date)
{
	if (date == null) return "空のデータ";
	
	var fmt00 = function(val) { return ("00" + val).slice(-2); };
	var fmt0000 = function(val) { return ("0000" + val).slice(-4); };
	var youbi = ["日", "月", "火", "水", "木", "金", "土"];
	
	var year = fmt0000(date.getFullYear());
	var month = fmt00(date.getMonth() + 1);
	var day = fmt00(date.getDate());
	var youbi = youbi[date.getDay()];
	var hours = fmt00(date.getHours());
	var minutes = fmt00(date.getMinutes());
	var seconds = fmt00(date.getSeconds());

	var ret =  "<span class='weak'>" + year + "/</span>" + month + "/" + day + "(" + youbi + ") " + hours + ":" + minutes + "<span class='weak'>:" + seconds + "</span>";
	return ret;
};

tokage.data.findLayer = function(sav, name)
{
	// for (var i = tokage.LAYERS; i >= 1; i--)
	for (var i = 1; i <= tokage.LAYERS; i++)
	{
		var layer = sav.layers["" + i];
		if (layer != null && layer.name === name) return "" + i;
	}
	return null;
};

tokage.data.findEmptyLayer = function(sav)
{
	for (var i = 1; i <= tokage.LAYERS; i++)
	{
		var layer = sav.layers["" + i];
		if (layer == null) return "" + i;
	}
	return null;
};

