tokage.canvas = {};

tokage.canvas.draw = function(ram, sav)
{
	var can = document.getElementById(tokage.CANVAS_TAG);
	var ctx = can.getContext("2d");

	var drawLayer = function(l)
	{
		if (l == null || l === "") return;
		
		var ramlayer = ram.layers[l];
		if (ramlayer == null) return;
		
		ctx.save();
		
		var left = sav.layers[l].left;
		var top = sav.layers[l].top;
		var flip = sav.layers[l].flip;
		
		var isback = (ramlayer.back != null && ramlayer.back.img != null);
		var isfore = (ramlayer.fore != null && ramlayer.fore.img != null);
		
		// アクティブじゃないキャラクターを半透明にするための係数
		var alpha2 = 1.0;
		
		// nameがnullでなく(nullの場合はキャラクターじゃない)
		// かつアクティブなキャラクターと名前が同じの場合
		if (sav.layers[l].name != null && sav.layers[l].name !== sav.actCharaName) alpha2 = 0.75;
		
		if (isback)
		{
			var img = ramlayer.back.img;
			var width = img.width;
			var height = img.height;
			
			// flipの処理
			if (flip == true)
			{
				ctx.translate( (left + width / 2), 0 );
				ctx.scale( -1, 1 );
				ctx.translate( -(left + width / 2), 0 );
			}
			
			ctx.globalAlpha = tokage.canvas.getBackAlpha(ram.transTime);
			
			// フェードしないレイヤーは常に不透明
			if (sav.layers[l].transed) ctx.globalAlpha = 1.0;
			
			// baseのbackは常に不透明
			if (l === "base") ctx.globalAlpha = 1.0;
			
			ctx.globalAlpha *= alpha2;
			ctx.drawImage(img, left, top);
			
		}
		if (isfore)
		{
			var img = ramlayer.fore.img;
			var width = img.width;
			var height = img.height;
			
			// flipの処理
			if (flip == true)
			{
				ctx.translate( (left + width / 2), 0 );
				ctx.scale( -1, 1 );
				ctx.translate( -(left + width / 2), 0 );
			}
			
			ctx.globalAlpha = tokage.canvas.getForeAlpha(ram.transTime);
			
			// console.log(ctx.globalAlpha);
		
			// フェードしないレイヤーは常に不透明
			if (sav.layers[l].transed) ctx.globalAlpha = 1.0;
			
			ctx.globalAlpha *= alpha2;
			ctx.drawImage(img, left, top);
			
			// 文字列で渡してたのが原因だったからこのログは全く正常に見える
			// console.log("left: " + left + ", top: " + top);
		}
		ctx.restore();
	};
	
	// baseを描画
	drawLayer("base");
	
	// 1～tokage.LAYERSを描画
	for (var i = 1; i <= tokage.LAYERS; i++)
	{
		drawLayer("" + i);
	}
};

// todo: この名前空間でよいか？
tokage.canvas.backToFore = function(ram, sav)
{
	// この関数はtrans終了時に呼び出される
	
	var backToForeLayer = function(l)
	{
		if (sav.layers[l] == null) return;
		
		// フェード要求の場合のみ移動する
		if (!sav.layers[l].transed)
		{
			sav.layers[l].transed = true; // フェードしない
			
			ram.layers[l].fore = $.extend(true, { }, ram.layers[l].back); // ディープコピー
			ram.layers[l].back.img = null;
		
			sav.layers[l].fore = $.extend(true, { }, sav.layers[l].back); // ディープコピー
			sav.layers[l].back.storage = null;
			
			// [/image]による削除の場合
			if (sav.layers[l].back.storage == null && sav.layers[l].fore.storage == null)
			{
				ram.layers[l] = null;
				sav.layers[l] = null;
			}
		}
	};
	
	// baseを移動
	backToForeLayer("base");
	
	// 1～tokage.LAYERSも移動
	for (var i = 1; i <= tokage.LAYERS; i++)
	{
		backToForeLayer("" + i); // ここを+iじゃなくて+1にして苦しんでたアホな子はいね～がぁ
	}
	
	ram.transTime = 0;
};

tokage.canvas.getForeAlpha = function(transTime)
{
	if (transTime <= 0.5) return 1;
	return -2.0 * transTime + 2;
};

tokage.canvas.getBackAlpha = function(transTime)
{
	if (transTime > 0.5) return 1;
	return 2.0 * transTime;
};