#pragma once
#include "d3d9.h"

interface Direct3DDevice9ExWrapper : public IDirect3DDevice9Ex
{
public:
	Direct3DDevice9ExWrapper(IDirect3DDevice9Ex **ppReturnedDeviceInterface, D3DPRESENT_PARAMETERS *pPresentParam, IDirect3D9Ex *pIDirect3D9Ex);
	virtual ~Direct3DDevice9ExWrapper();

	// callback interface
	IDirect3DDevice9Ex* m_Direct3DDevice9Ex;
	IDirect3D9Ex* m_Direct3D9Ex;

	UINT m_Stride;

	// original interface
	STDMETHOD(QueryInterface)(REFIID riid, void** ppvObj);
	STDMETHOD_(ULONG, AddRef)();
	STDMETHOD_(ULONG, Release)();
	STDMETHOD(TestCooperativeLevel)();
	STDMETHOD_(UINT, GetAvailableTextureMem)();
	STDMETHOD(EvictManagedResources)();
	STDMETHOD(GetDirect3D)(IDirect3D9** ppD3D9);
	STDMETHOD(GetDeviceCaps)(D3DCAPS9* pCaps);
	STDMETHOD(GetDisplayMode)(UINT iSwapChain, D3DDISPLAYMODE* pMode);
	STDMETHOD(GetCreationParameters)(D3DDEVICE_CREATION_PARAMETERS *pParameters);
	STDMETHOD(SetCursorProperties)(UINT XHotSpot, UINT YHotSpot, IDirect3DSurface9* pCursorBitmap);
	STDMETHOD_(void, SetCursorPosition)(int X, int Y, DWORD Flags);
	STDMETHOD_(BOOL, ShowCursor)(BOOL bShow);
	STDMETHOD(CreateAdditionalSwapChain)(D3DPRESENT_PARAMETERS* pPresentationParameters, IDirect3DSwapChain9** pSwapChain);
	STDMETHOD(GetSwapChain)(UINT iSwapChain, IDirect3DSwapChain9** pSwapChain);
	STDMETHOD_(UINT, GetNumberOfSwapChains)();
	STDMETHOD(Reset)(D3DPRESENT_PARAMETERS* pPresentationParameters);
	STDMETHOD(Present)(CONST RECT* pSourceRect, CONST RECT* pDestRect, HWND hDestWindowOverride, CONST RGNDATA* pDirtyRegion);
	STDMETHOD(GetBackBuffer)(UINT iSwapChain, UINT iBackBuffer, D3DBACKBUFFER_TYPE Type, IDirect3DSurface9** ppBackBuffer);
	STDMETHOD(GetRasterStatus)(UINT iSwapChain, D3DRASTER_STATUS* pRasterStatus);
	STDMETHOD(SetDialogBoxMode)(BOOL bEnableDialogs);
	STDMETHOD_(void, SetGammaRamp)(UINT iSwapChain, DWORD Flags, CONST D3DGAMMARAMP* pRamp);
	STDMETHOD_(void, GetGammaRamp)(UINT iSwapChain, D3DGAMMARAMP* pRamp);
	STDMETHOD(CreateTexture)(UINT Width, UINT Height, UINT Levels, DWORD Usage, D3DFORMAT Format, D3DPOOL Pool, IDirect3DTexture9** ppTexture, HANDLE* pSharedHandle);
	STDMETHOD(CreateVolumeTexture)(UINT Width, UINT Height, UINT Depth, UINT Levels, DWORD Usage, D3DFORMAT Format, D3DPOOL Pool, IDirect3DVolumeTexture9** ppVolumeTexture, HANDLE* pSharedHandle);
	STDMETHOD(CreateCubeTexture)(UINT EdgeLength, UINT Levels, DWORD Usage, D3DFORMAT Format, D3DPOOL Pool, IDirect3DCubeTexture9** ppCubeTexture, HANDLE* pSharedHandle);
	STDMETHOD(CreateVertexBuffer)(UINT Length, DWORD Usage, DWORD FVF, D3DPOOL Pool, IDirect3DVertexBuffer9** ppVertexBuffer, HANDLE* pSharedHandle);
	STDMETHOD(CreateIndexBuffer)(UINT Length, DWORD Usage, D3DFORMAT Format, D3DPOOL Pool, IDirect3DIndexBuffer9** ppIndexBuffer, HANDLE* pSharedHandle);
	STDMETHOD(CreateRenderTarget)(UINT Width, UINT Height, D3DFORMAT Format, D3DMULTISAMPLE_TYPE MultiSample, DWORD MultisampleQuality, BOOL Lockable, IDirect3DSurface9** ppSurface, HANDLE* pSharedHandle);
	STDMETHOD(CreateDepthStencilSurface)(UINT Width, UINT Height, D3DFORMAT Format, D3DMULTISAMPLE_TYPE MultiSample, DWORD MultisampleQuality, BOOL Discard, IDirect3DSurface9** ppSurface, HANDLE* pSharedHandle);
	STDMETHOD(UpdateSurface)(IDirect3DSurface9* pSourceSurface, CONST RECT* pSourceRect, IDirect3DSurface9* pDestinationSurface, CONST POINT* pDestPoint);
	STDMETHOD(UpdateTexture)(IDirect3DBaseTexture9* pSourceTexture, IDirect3DBaseTexture9* pDestinationTexture);
	STDMETHOD(GetRenderTargetData)(IDirect3DSurface9* pRenderTarget, IDirect3DSurface9* pDestSurface);
	STDMETHOD(GetFrontBufferData)(UINT iSwapChain, IDirect3DSurface9* pDestSurface);
	STDMETHOD(StretchRect)(IDirect3DSurface9* pSourceSurface, CONST RECT* pSourceRect, IDirect3DSurface9* pDestSurface, CONST RECT* pDestRect, D3DTEXTUREFILTERTYPE Filter);
	STDMETHOD(ColorFill)(IDirect3DSurface9* pSurface, CONST RECT* pRect, D3DCOLOR color);
	STDMETHOD(CreateOffscreenPlainSurface)(UINT Width, UINT Height, D3DFORMAT Format, D3DPOOL Pool, IDirect3DSurface9** ppSurface, HANDLE* pSharedHandle);
	STDMETHOD(SetRenderTarget)(DWORD RenderTargetIndex, IDirect3DSurface9* pRenderTarget);
	STDMETHOD(GetRenderTarget)(DWORD RenderTargetIndex, IDirect3DSurface9** ppRenderTarget);
	STDMETHOD(SetDepthStencilSurface)(IDirect3DSurface9* pNewZStencil);
	STDMETHOD(GetDepthStencilSurface)(IDirect3DSurface9** ppZStencilSurface);
	STDMETHOD(BeginScene)();
	STDMETHOD(EndScene)();
	STDMETHOD(Clear)(DWORD Count, CONST D3DRECT* pRects, DWORD Flags, D3DCOLOR Color, float Z, DWORD Stencil);
	STDMETHOD(SetTransform)(D3DTRANSFORMSTATETYPE State, CONST D3DMATRIX* pMatrix);
	STDMETHOD(GetTransform)(D3DTRANSFORMSTATETYPE State, D3DMATRIX* pMatrix);
	STDMETHOD(MultiplyTransform)(D3DTRANSFORMSTATETYPE, CONST D3DMATRIX*);
	STDMETHOD(SetViewport)(CONST D3DVIEWPORT9* pViewport);
	STDMETHOD(GetViewport)(D3DVIEWPORT9* pViewport);
	STDMETHOD(SetMaterial)(CONST D3DMATERIAL9* pMaterial);
	STDMETHOD(GetMaterial)(D3DMATERIAL9* pMaterial);
	STDMETHOD(SetLight)(DWORD Index, CONST D3DLIGHT9*);
	STDMETHOD(GetLight)(DWORD Index, D3DLIGHT9*);
	STDMETHOD(LightEnable)(DWORD Index, BOOL Enable);
	STDMETHOD(GetLightEnable)(DWORD Index, BOOL* pEnable);
	STDMETHOD(SetClipPlane)(DWORD Index, CONST float* pPlane);
	STDMETHOD(GetClipPlane)(DWORD Index, float* pPlane);
	STDMETHOD(SetRenderState)(D3DRENDERSTATETYPE State, DWORD Value);
	STDMETHOD(GetRenderState)(D3DRENDERSTATETYPE State, DWORD* pValue);
	STDMETHOD(CreateStateBlock)(D3DSTATEBLOCKTYPE Type, IDirect3DStateBlock9** ppSB);
	STDMETHOD(BeginStateBlock)();
	STDMETHOD(EndStateBlock)(IDirect3DStateBlock9** ppSB);
	STDMETHOD(SetClipStatus)(CONST D3DCLIPSTATUS9* pClipStatus);
	STDMETHOD(GetClipStatus)(D3DCLIPSTATUS9* pClipStatus);
	STDMETHOD(GetTexture)(DWORD Stage, IDirect3DBaseTexture9** ppTexture);
	STDMETHOD(SetTexture)(DWORD Stage, IDirect3DBaseTexture9* pTexture);
	STDMETHOD(GetTextureStageState)(DWORD Stage, D3DTEXTURESTAGESTATETYPE Type, DWORD* pValue);
	STDMETHOD(SetTextureStageState)(DWORD Stage, D3DTEXTURESTAGESTATETYPE Type, DWORD Value);
	STDMETHOD(GetSamplerState)(DWORD Sampler, D3DSAMPLERSTATETYPE Type, DWORD* pValue);
	STDMETHOD(SetSamplerState)(DWORD Sampler, D3DSAMPLERSTATETYPE Type, DWORD Value);
	STDMETHOD(ValidateDevice)(DWORD* pNumPasses);
	STDMETHOD(SetPaletteEntries)(UINT PaletteNumber, CONST PALETTEENTRY* pEntries);
	STDMETHOD(GetPaletteEntries)(UINT PaletteNumber, PALETTEENTRY* pEntries);
	STDMETHOD(SetCurrentTexturePalette)(UINT PaletteNumber);
	STDMETHOD(GetCurrentTexturePalette)(UINT *PaletteNumber);
	STDMETHOD(SetScissorRect)(CONST RECT* pRect);
	STDMETHOD(GetScissorRect)(RECT* pRect);
	STDMETHOD(SetSoftwareVertexProcessing)(BOOL bSoftware);
	STDMETHOD_(BOOL, GetSoftwareVertexProcessing)();
	STDMETHOD(SetNPatchMode)(float nSegments);
	STDMETHOD_(float, GetNPatchMode)();
	STDMETHOD(DrawPrimitive)(D3DPRIMITIVETYPE PrimitiveType, UINT StartVertex, UINT PrimitiveCount);
	STDMETHOD(DrawIndexedPrimitive)(D3DPRIMITIVETYPE, INT BaseVertexIndex, UINT MinVertexIndex, UINT NumVertices, UINT startIndex, UINT primCount);
	STDMETHOD(DrawPrimitiveUP)(D3DPRIMITIVETYPE PrimitiveType, UINT PrimitiveCount, CONST void* pVertexStreamZeroData, UINT VertexStreamZeroStride);
	STDMETHOD(DrawIndexedPrimitiveUP)(D3DPRIMITIVETYPE PrimitiveType, UINT MinVertexIndex, UINT NumVertices, UINT PrimitiveCount, CONST void* pIndexData, D3DFORMAT IndexDataFormat, CONST void* pVertexStreamZeroData, UINT VertexStreamZeroStride);
	STDMETHOD(ProcessVertices)(UINT SrcStartIndex, UINT DestIndex, UINT VertexCount, IDirect3DVertexBuffer9* pDestBuffer, IDirect3DVertexDeclaration9* pVertexDecl, DWORD Flags);
	STDMETHOD(CreateVertexDeclaration)(CONST D3DVERTEXELEMENT9* pVertexElements, IDirect3DVertexDeclaration9** ppDecl);
	STDMETHOD(SetVertexDeclaration)(IDirect3DVertexDeclaration9* pDecl);
	STDMETHOD(GetVertexDeclaration)(IDirect3DVertexDeclaration9** ppDecl);
	STDMETHOD(SetFVF)(DWORD FVF);
	STDMETHOD(GetFVF)(DWORD* pFVF);
	STDMETHOD(CreateVertexShader)(CONST DWORD* pFunction, IDirect3DVertexShader9** ppShader);
	STDMETHOD(SetVertexShader)(IDirect3DVertexShader9* pShader);
	STDMETHOD(GetVertexShader)(IDirect3DVertexShader9** ppShader);
	STDMETHOD(SetVertexShaderConstantF)(UINT StartRegister, CONST float* pConstantData, UINT Vector4fCount);
	STDMETHOD(GetVertexShaderConstantF)(UINT StartRegister, float* pConstantData, UINT Vector4fCount);
	STDMETHOD(SetVertexShaderConstantI)(UINT StartRegister, CONST int* pConstantData, UINT Vector4iCount);
	STDMETHOD(GetVertexShaderConstantI)(UINT StartRegister, int* pConstantData, UINT Vector4iCount);
	STDMETHOD(SetVertexShaderConstantB)(UINT StartRegister, CONST BOOL* pConstantData, UINT  BoolCount);
	STDMETHOD(GetVertexShaderConstantB)(UINT StartRegister, BOOL* pConstantData, UINT BoolCount);
	STDMETHOD(SetStreamSource)(UINT StreamNumber, IDirect3DVertexBuffer9* pStreamData, UINT OffsetInBytes, UINT Stride);
	STDMETHOD(GetStreamSource)(UINT StreamNumber, IDirect3DVertexBuffer9** ppStreamData, UINT* pOffsetInBytes, UINT* pStride);
	STDMETHOD(SetStreamSourceFreq)(UINT StreamNumber, UINT Setting);
	STDMETHOD(GetStreamSourceFreq)(UINT StreamNumber, UINT* pSetting);
	STDMETHOD(SetIndices)(IDirect3DIndexBuffer9* pIndexData);
	STDMETHOD(GetIndices)(IDirect3DIndexBuffer9** ppIndexData);
	STDMETHOD(CreatePixelShader)(CONST DWORD* pFunction, IDirect3DPixelShader9** ppShader);
	STDMETHOD(SetPixelShader)(IDirect3DPixelShader9* pShader);
	STDMETHOD(GetPixelShader)(IDirect3DPixelShader9** ppShader);
	STDMETHOD(SetPixelShaderConstantF)(UINT StartRegister, CONST float* pConstantData, UINT Vector4fCount);
	STDMETHOD(GetPixelShaderConstantF)(UINT StartRegister, float* pConstantData, UINT Vector4fCount);
	STDMETHOD(SetPixelShaderConstantI)(UINT StartRegister, CONST int* pConstantData, UINT Vector4iCount);
	STDMETHOD(GetPixelShaderConstantI)(UINT StartRegister, int* pConstantData, UINT Vector4iCount);
	STDMETHOD(SetPixelShaderConstantB)(UINT StartRegister, CONST BOOL* pConstantData, UINT  BoolCount);
	STDMETHOD(GetPixelShaderConstantB)(UINT StartRegister, BOOL* pConstantData, UINT BoolCount);
	STDMETHOD(DrawRectPatch)(UINT Handle, CONST float* pNumSegs, CONST D3DRECTPATCH_INFO* pRectPatchInfo);
	STDMETHOD(DrawTriPatch)(UINT Handle, CONST float* pNumSegs, CONST D3DTRIPATCH_INFO* pTriPatchInfo);
	STDMETHOD(DeletePatch)(UINT Handle);
	STDMETHOD(CreateQuery)(D3DQUERYTYPE Type, IDirect3DQuery9** ppQuery);
	STDMETHOD(SetConvolutionMonoKernel)( UINT width, UINT height, float* rows, float* columns);
	STDMETHOD(ComposeRects)( IDirect3DSurface9* pSrc, IDirect3DSurface9* pDst, IDirect3DVertexBuffer9* pSrcRectDescs, UINT NumRects, IDirect3DVertexBuffer9* pDstRectDescs, D3DCOMPOSERECTSOP Operation, int Xoffset, int Yoffset);
	STDMETHOD(PresentEx)( CONST RECT* pSourceRect, CONST RECT* pDestRect, HWND hDestWindowOverride, CONST RGNDATA* pDirtyRegion, DWORD dwFlags);
	STDMETHOD(GetGPUThreadPriority)( INT* pPriority);
	STDMETHOD(SetGPUThreadPriority)( INT Priority);
	STDMETHOD(WaitForVBlank)( UINT iSwapChain);
	STDMETHOD(CheckResourceResidency)( IDirect3DResource9** pResourceArray, UINT32 NumResources);
	STDMETHOD(SetMaximumFrameLatency)( UINT MaxLatency);
	STDMETHOD(GetMaximumFrameLatency)( UINT* pMaxLatency);
	STDMETHOD(CheckDeviceState)( HWND hDestinationWindow);
	STDMETHOD(CreateRenderTargetEx)( UINT Width, UINT Height, D3DFORMAT Format, D3DMULTISAMPLE_TYPE MultiSample, DWORD MultisampleQuality, BOOL Lockable, IDirect3DSurface9** ppSurface, HANDLE* pSharedHandle, DWORD Usage);
	STDMETHOD(CreateOffscreenPlainSurfaceEx)( UINT Width, UINT Height, D3DFORMAT Format, D3DPOOL Pool, IDirect3DSurface9** ppSurface, HANDLE* pSharedHandle, DWORD Usage);
	STDMETHOD(CreateDepthStencilSurfaceEx)( UINT Width, UINT Height, D3DFORMAT Format, D3DMULTISAMPLE_TYPE MultiSample, DWORD MultisampleQuality, BOOL Discard, IDirect3DSurface9** ppSurface, HANDLE* pSharedHandle, DWORD Usage);
	STDMETHOD(ResetEx)( D3DPRESENT_PARAMETERS* pPresentationParameters, D3DDISPLAYMODEEX *pFullscreenDisplayMode);
	STDMETHOD(GetDisplayModeEx)( UINT iSwapChain, D3DDISPLAYMODEEX* pMode, D3DDISPLAYROTATION* pRotation);
};