var theme = {};

theme.themes = [ {
      label : 'Default CSS',
      id : 'custom'
  }, {
    label : 'Board CSS',
    id : 'custom-force'
  }, {
      label : 'Yotsuba B',
      id : 'global'
  }, {
      label : 'Yotsuba P',
      id : 'yotsuba_p'
  }, {
      label : 'Yotsuba',
      id : 'yotsuba'
  }, {
      label : 'Miku',
      id : 'miku'
  }, {
      label : 'Yukkuri',
      id : 'yukkuri'
  }, {
      label : 'Hispita',
      id : 'hispita'
  }, {
      label : 'Warosu',
      id : 'warosu'
  }, {
      label : 'Vivian',
      id : 'vivian'
  }, {
      label : 'Tomorrow',
      id : 'tomorrow'
  }, {
      label : 'Lain',
      id : 'lain'
  }, {
      label : 'Royal',
      id : 'royal'
  }, {
      label : 'Hispaperro',
      id : 'hispaperro'
  }, {
      label : 'HispaSexy',
      id : 'hispasexy'
  }, {
      label : 'Avellana',
      id : 'avellana'
  }, {
      label : 'Evita',
      id : 'evita'
  }, {
      label : 'Redchanit',
      id : 'redchanit'
  }, {
/*
      label : 'Sonic 3 & Knuckles',
      id : 'sonic3'
  }, {
      label : 'Final Fantasy',
      id : 'finalfantasy'
  }, {
      label : 'Facepalm',
      id : 'facepalm'
  }, {
      label : 'Moepheus',
      id : 'moepheus'
  }, {
*/
      label : 'MoeOS8',
      id : 'moeos'
  }, {
      label : 'Windows 95',
      id : 'win95'
  }, {
      label : 'Penumbra',
      id : 'penumbra'
  }, {
      label : 'Penumbra (Clear)',
      id : 'penumbra_clear'
  }
];

theme.themeLink = undefined;
theme.globalTheme = undefined;
theme.customCssHref = "";

theme.addThemeSelector = function() {

  var themesBefore = document.getElementById('themesBefore');

  if (!themesBefore) {
    return
  }

  var referenceNode = themesBefore.previousSibling.previousSibling;
 
  themesBefore.parentNode.insertBefore(document.createTextNode(' '),
      referenceNode);
 
  var divider = document.createElement('span');
  divider.innerText = '/';
  themesBefore.parentNode.insertBefore(divider, referenceNode);
 
  themesBefore.parentNode.insertBefore(document.createTextNode(' '),
      referenceNode);
 
  var themeSelector = document.createElement('select');
  themeSelector.id = 'themeSelector';
 
  /*
  var vanillaOption = document.createElement('option');
  vanillaOption.innerText = 'Default';
  themeSelector.appendChild(vanillaOption);
  */
 
  theme.themes.forEach((theme) => {
 
    var themeOption = document.createElement('option');
    themeOption.innerText = theme.label;
 
    if (theme.id === localStorage.selectedTheme) {
      themeOption.selected = true;
    }
 
    themeSelector.appendChild(themeOption);
 
  })
 
  var changeTheme = function(e) {
 
    var selectedTheme = theme.themes[e.target.selectedIndex];
 
    if (selectedTheme.id === localStorage.selectedTheme) {
      return;
    }
 
    localStorage.selectedTheme = selectedTheme.id;
 
    theme.load();
 
  };

  themeSelector.onchange = changeTheme;
 
  themesBefore.parentNode.insertBefore(themeSelector, referenceNode);
 
  themesBefore.parentNode.insertBefore(document.createTextNode(' '),
      referenceNode);

  var secondSelector = themeSelector.cloneNode(true);
  secondSelector.onchange = changeTheme;
  secondSelector.selectedIndex = themeSelector.selectedIndex;

  var sideMenu = document.getElementById("sidebar-menu");
  if (sideMenu) 
    // sideMenu.append(secondSelector);
    sideMenu.insertBefore(secondSelector, sideMenu.children[0].nextSibling);

};

theme.load = function(init) {

  var currentTheme = localStorage.selectedTheme;

  var force = false;
  if (currentTheme === 'custom-force') {
    currentTheme = 'custom';
    force = true;
  }

  //loading a custom theme
  if (currentTheme === 'custom') {
    // document.body.className = 'theme_board'; //shouldn't be necessary anymore

    //If an accompanying base CSS to the globalTheme exists, load that instead of whatever custom.css exists
    if (!force && theme.globalThemeBase !== undefined) {
      //remove custom.css href
      theme.themeLink.href = '';
      document.head.insertBefore(theme.globalThemeBase, document.getElementById("nullSyntax"));
    }
    else {
      theme.themeLink.href = theme.customCssHref;
    }

    if (!force && theme.globalTheme !== undefined) {
      document.head.insertBefore(theme.globalTheme, document.getElementById("nullSyntax"));
    }

    if (force) {
      theme.globalTheme?.remove();
      theme.globalThemeBase?.remove();
    }
  //loading a non-custom theme
  } else {
    // document.body.className = 'theme_' + currentTheme;
    theme.themeLink.href = '/.static/css/' + currentTheme + '.css';
    if (theme.globalTheme !== undefined) {
      theme.globalTheme.remove();
    }
  }
};

document.addEventListener("DOMContentLoaded", function() {
  var ending = '/custom.css';

  const globalTheme = document.getElementsByClassName("globalTheme")[0];

  if (globalTheme !== undefined) {
    theme.globalTheme = globalTheme;
    theme.globalThemeBase = document.getElementsByClassName("globalThemeBase")[0];
  }

  //if there's a `link` element with "custom.css", then remember it
  var loadedCss = document.getElementsByTagName('link');
  for (var i in Array.from(loadedCss)) {
    var cssHref = loadedCss[i].href;

      if (cssHref !== undefined && cssHref.indexOf(ending) === 
    cssHref.length - ending.length) {
        theme.customCssHref = cssHref;
        loadedCss[i].remove();
        break;
      }
  }
  
  theme.addThemeSelector();
  prepareTheme();
});

var prepareTheme = function() {
// Load selected or custom theme while loading
theme.themeLink = document.createElement("link")
theme.themeLink.type = "text/css";
theme.themeLink.rel = "stylesheet";
theme.themeLink.id = "themeLink";
document.head.insertBefore(theme.themeLink, document.getElementById("nullSyntax"));

var currentTheme = localStorage.selectedTheme;
localStorage.selectedTheme = currentTheme === undefined ?
        theme.themes[0].id : currentTheme;

theme.load(true);
}

prepareTheme();
