screen dungeon_level:

    layer "master"
    $ toDungeonNextLevel = getNextLevelDungeon(dungeonLevel,player1Stats["level"]+player2Stats["level"])

    if dungeonLevel < 5:
        image "board/dungeon_3_lv.png":
            xalign .18
            yalign -0.17
            rotate -2

        image "ui/level_token_" + str(dungeonLevel) + ".png":
            zoom 1.25
            xalign .28
            yalign -.01

        if toDungeonNextLevel == 3:
            image "ui/dungeon_arrow.png":
                xalign .170 yalign .08
        elif toDungeonNextLevel == 2:
            image "ui/dungeon_arrow.png":
                xalign .215 yalign .08
        elif toDungeonNextLevel == 1:
            image "ui/dungeon_arrow.png":
                xalign .260 yalign .07
        elif toDungeonNextLevel == 0:
            image "ui/dungeon_arrow.png":
                xalign .305 yalign .07

    elif dungeonLevel < 8:
        image "board/dungeon_4_lv.png":
            xalign .18
            yalign -0.17
            rotate -2

        image "ui/level_token_" + str(dungeonLevel) + ".png":
            zoom 1.25
            xalign .28
            yalign -.01

        if toDungeonNextLevel == 4:
            image "ui/dungeon_arrow.png":
                xalign .15 yalign .05
        elif toDungeonNextLevel == 3:
            image "ui/dungeon_arrow.png":
                xalign .15 yalign .05
        elif toDungeonNextLevel == 2:
            image "ui/dungeon_arrow.png":
                xalign .15 yalign .05
        elif toDungeonNextLevel == 1:
            image "ui/dungeon_arrow.png":
                xalign .15 yalign .05
        elif toDungeonNextLevel == 0:
            image "ui/dungeon_arrow.png":
                xalign .15 yalign .05
    else:
        image "board/dungeon_2_lv.png":
            xalign .18
            yalign -0.17
            rotate -2

        image "ui/level_token_" + str(dungeonLevel) + ".png":
            zoom 1.25
            xalign .28
            yalign -.01

        if toDungeonNextLevel == 5:
            image "ui/dungeon_arrow.png":
                xalign .15 yalign .05
        elif toDungeonNextLevel == 4:
            image "ui/dungeon_arrow.png":
                xalign .15 yalign .05
        elif toDungeonNextLevel == 3:
            image "ui/dungeon_arrow.png":
                xalign .15 yalign .05
        elif toDungeonNextLevel == 2:
            image "ui/dungeon_arrow.png":
                xalign .15 yalign .05
        elif toDungeonNextLevel == 1:
            image "ui/dungeon_arrow.png":
                xalign .15 yalign .05
        elif toDungeonNextLevel == 0:
            image "ui/dungeon_arrow.png":
                xalign .15 yalign .05

screen clickable_icons:

    use lore_sheets
    use rules_book
    use settings

screen lore_sheets:
    # CHARACTERS SHEETS
    imagebutton:
        xalign 0.0
        yalign 0.0
        idle "board/sheet_hide.png"
        hover "board/sheet_show.png"
        action ShowMenu("lore", player = playerTurn)

screen rules_book:
    # RULES BOOKS
    imagebutton:
        xalign 0.0
        yalign 0.45
        idle "board/rules_hide.png"
        hover "board/rules_show.png"
        action ShowMenu("rules")

screen settings:
    # SETTINGS
    imagebutton at Transform (rotate=14):
        xalign 0.93
        yalign -0.22
        idle im.FactorScale("board/settings.png", .95)
        hover im.FactorScale("board/settings.png", 1)
        # idle "board/settings_hide.png"
        # hover "board/settings_show.png"
        action ShowMenu('preferences')

screen arrow():

    add DynamicDisplayable(rotateArrow)

screen player_1_turn:

    $ randomSide = str(renpy.random.randint(1,6))

    drag:
        drag_name "DiceP1"
        xpos 960 ypos 540
        anchor(0.5,0.5)
        idle_child "ui/p1dice" + randomSide + ".png"
        hover_child "ui/p1dice" + randomSide + ".png"
        selected_hover_child im.FactorScale("ui/p1dice" + randomSide + ".png",1.3)
        drag_raise True
        dragged dragged_func
        clicked clicked_func

    key ["K_SPACE", "K_RETURN"] action Function(clicked_func)


screen player_2_turn:

    $ randomSide = str(renpy.random.randint(1,6))

    drag:
        drag_name "DiceP2"
        xpos 960 ypos 540
        anchor(0.5,0.5)
        idle_child "ui/p2dice" + randomSide + ".png"
        hover_child "ui/p2dice" + randomSide + ".png"
        selected_hover_child im.FactorScale("ui/p2dice" + randomSide + ".png",1.3)
        drag_raise True
        dragged dragged_func
        clicked clicked_func
        
    key ["K_SPACE", "K_RETURN"] action Function(clicked_func)

screen character_selection():

    imagebutton:
        at transform:
            rotate 5.0
        xalign -0.15
        yalign .5
        idle im.FactorScale("characters/card_findrel.png", 1.0)
        hover im.FactorScale("characters/card_findrel.png", 1.005)
        action [SetVariable("playerCharacter", 1), Return()] 

    # transform layla_pop:
    #     xalign 1.8 yalign -1.0 rotate 0
    #     linear .55 xalign 1.1 yalign .55 rotate -7

    imagebutton:
        at transform:
            rotate -4.0
        xalign 1.15
        yalign .55
        idle im.FactorScale("characters/card_layla.png", 1.0)
        hover im.FactorScale("characters/card_layla.png", 1.005)
        action [SetVariable("playerCharacter", 2), Return()] 

screen character_card(character):

    hbox at cardPosition:
        spacing -100
        image "characters/card_" + character + "_small.png"
        imagebutton:
            ypos -30 
            idle im.FactorScale("ui/token_zoom.png",.4)
            hover im.FactorScale("ui/token_zoom_hover.png", .4)
            action Function(zoomCharacterCard, character)

screen meet_up_cards(state):

    if state == "findrel tops":
        hbox at meetup_findrel_top:
            spacing -100
            image "characters/card_findrel_small.png"
            imagebutton:
                ypos -30 
                idle im.FactorScale("ui/token_zoom.png",.4)
                hover im.FactorScale("ui/token_zoom_hover.png", .4)
                action Function(zoomCharacterCard, "findrel")

        hbox at meetup_layla_bottom:
            spacing -100
            image "characters/card_layla_small.png"
            imagebutton:
                ypos -30 
                idle im.FactorScale("ui/token_zoom.png",.4)
                hover im.FactorScale("ui/token_zoom_hover.png", .4)
                action Function(zoomCharacterCard, "layla")

    elif state == "layla tops":
        hbox at meetup_findrel_bottom:
            spacing -100
            image "characters/card_findrel_small.png"
            imagebutton:
                ypos -30 
                idle im.FactorScale("ui/token_zoom.png",.4)
                hover im.FactorScale("ui/token_zoom_hover.png", .4)
                action Function(zoomCharacterCard, "findrel")

        hbox at meetup_layla_top:
            spacing -100
            image "characters/card_layla_small.png"
            imagebutton:
                ypos -30 
                idle im.FactorScale("ui/token_zoom.png",.4)
                hover im.FactorScale("ui/token_zoom_hover.png", .4)
                action Function(zoomCharacterCard, "layla")
    else:
        hbox at findrel_pop:
            spacing -100
            image "characters/card_findrel_small.png"
            imagebutton:
                ypos -30 
                idle im.FactorScale("ui/token_zoom.png",.4)
                hover im.FactorScale("ui/token_zoom_hover.png", .4)
                action Function(zoomCharacterCard, "findrel")

        hbox at layla_pop:
            spacing -100
            image "characters/card_layla_small.png"
            imagebutton:
                ypos -30 
                idle im.FactorScale("ui/token_zoom.png",.4)
                hover im.FactorScale("ui/token_zoom_hover.png", .4)
                action Function(zoomCharacterCard, "layla")

    # elif state == "intro": # Only used at the start of the game
    #     image "characters/card_findrel_small.png" at findrel_pop
    #     image "characters/card_layla_small.png" at layla_pop



screen tutorial(tutorialScreenNb):

    $ tutorialArray = getTutorialArray(tutorialScreenNb)

    modal True

    frame:
        xalign .5
        yalign .5
        xpadding 25 
        ypadding 25 
        vbox:
            spacing 20
            xalign .5
            for i in tutorialArray:
                text i:
                    xalign .5

    if tutorialScreenNb < 10:
        dismiss action [Show("tutorial", tutorialScreenNb = tutorialScreenNb+1)]
    else:
        dismiss action Return()

# label dungeonLevellingUp:

#     python:

#     return

label card_zoom:

    call screen card_zoom(zoomedCardPath)
    return

screen card_zoom(path):

    image "table"

    # $ zoomLevel = 0.70

    drag:
        drag_name "zoomedCard"
        xalign .5 yalign .4
        drag_offscreen True
        idle_child im.FactorScale(path, zoomLevel)
        hover_child im.FactorScale(path, zoomLevel)
        # hover_child im.FactorScale("encounters/card_" + enemy + "_" + sex + "_big.png", zoomLevel)

    if isInGallery:
        imagebutton:
            xalign .98
            yalign .05
            idle im.FactorScale("ui/token_close.png",.75)
            hover im.FactorScale("ui/token_close.png", .8)        
            action Hide()
    else:
        imagebutton:
            xalign .98
            yalign .05
            idle im.FactorScale("ui/token_close.png",.75)
            hover im.FactorScale("ui/token_close.png", .8)        
            action Return()

    imagebutton:
        xalign .98
        yalign .35
        idle im.FactorScale("ui/token_zoom.png",.75)
        hover im.FactorScale("ui/token_zoom.png", .8)        
        insensitive im.FactorScale(im.Grayscale("ui/token_zoom.png"),.85)
        action [(SensitiveIf(zoomLevel<1)), SetVariable("zoomLevel", zoomLevel+0.10)]

    imagebutton:
        xalign .98
        yalign .65
        idle im.FactorScale("ui/token_unzoom.png",.75)
        hover im.FactorScale("ui/token_unzoom.png", .8)
        insensitive im.FactorScale(im.Grayscale("ui/token_unzoom.png"),.85)
        action [(SensitiveIf(zoomLevel>0.4)), SetVariable("zoomLevel", zoomLevel-0.10)]