

screen characters_sheets:
    use findrel_sheet
    use layla_sheet


screen findrel_sheet:

    image "board/findrel_sheet.png":
        if playerTurn == 1:
            xalign .05
            yalign 1.05
        else:
            xalign .05
            yalign 1.20

    image "level_token_" + str(player1Stats["level"]):
        zoom 1.25
        xalign .25
        if playerTurn == 1:
            yalign .85
        else:
            yalign .96


    hbox:
        xalign .35
        if playerTurn == 1:
            yalign .8
        else:
            yalign .91
        spacing -30
        for i in range(player1Stats["max_mana"]):
            if player1Stats["mana"] > i:
                image "miniManaEmptyToFull" at flipToken:
                    if i % 2 == 0:
                        ypos -5
                        zoom 1.2
                    else:
                        ypos 5
                        zoom 1.2
            else:
                image "miniManaFullToEmpty" at flipToken:   
                    if i % 2 == 0:
                        ypos -5
                        zoom 1.2
                    else:
                        ypos 5
                        zoom 1.2

    grid 6 2:
        xalign .35
        if playerTurn == 1:
            yalign .895
        else:
            yalign 1.01
        spacing -30
        for i in range(player1Stats["gold"]):
            image "images/ui/mini_gold.png":
                if i % 2 == 0:
                    ypos -5
                    zoom 1.2
                else:
                    ypos 5
                    zoom 1.2


    # if playerTurn == 2 or (playerTurn == 1 and isShopping == False):
    use inventory_findrel

screen layla_sheet:
    image "board/layla_sheet.png":
        if playerTurn == 2:
            xalign .80
            yalign 1.05
        else:
            xalign .80
            yalign 1.20

    image "ui/level_token_" + str(player2Stats["level"]) + ".png":
        zoom 1.25
        xalign .685
        if playerTurn == 2:
            yalign .85
        else:
            yalign .96

    hbox:
        xalign .825
        if playerTurn == 2:
            yalign .8
        else:
            yalign .91
        spacing -30
        for i in range(player2Stats["max_mana"]):
            if player2Stats["mana"] > i:
                image "miniManaEmptyToFull" at flipToken:
                    if i % 2 == 0:
                        ypos -5
                        zoom 1.2
                    else:
                        ypos 5
                        zoom 1.2
            else:
                image "miniManaFullToEmpty" at flipToken:   
                    if i % 2 == 0:
                        ypos -5
                        zoom 1.2
                    else:
                        ypos 5
                        zoom 1.2


    grid 6 2:
        xalign .835
        if playerTurn == 2:
            yalign .895
        else:
            yalign 1.01
        spacing -30
        for i in range(player2Stats["gold"]):
            image "images/ui/mini_gold.png":
                if i % 2 == 0:
                    ypos -5
                    zoom 1.2
                else:
                    ypos 5
                    zoom 1.2


    # if playerTurn == 1 or (playerTurn == 2 and isShopping == False):
    use inventory_layla

screen inventory_findrel:

    hbox:
        xanchor 0.5
        spacing -250
        if playerTurn == 1:
            yalign 1.325
            xpos 460
        elif playerTurn == 2:
            yalign 1.375
            xpos 260
            

        for index, i in enumerate(player1Items):
            $ angle = getInventoryCardAngle(index+1, len(player1Items))
            imagebutton at itemCardDeck(angle):
                idle im.FactorScale("items/card_item_"+ player1Items[index].icon + ".png",.425)
                hover im.FactorScale("items/card_item_"+ player1Items[index].icon + ".png",.435)
                action(Function(clickItemCard, item=i))

screen inventory_layla:

    hbox:
        xanchor 0.5
        spacing -250
        if playerTurn == 2:
            yalign 1.325
            xpos 1260
        elif playerTurn == 1:
            yalign 1.375
            xpos 1060 

        for index, i in enumerate(player2Items):
            $ angle = getInventoryCardAngle(index+1, len(player2Items))
            imagebutton at itemCardDeck(angle):
                idle im.FactorScale("items/card_item_"+ player2Items[index].icon + ".png",.425)
                hover im.FactorScale("items/card_item_"+ player2Items[index].icon + ".png",.435)
                action(Function(clickItemCard, item=i))

screen gauges:

    use top_gauge
    use bottom_gauge

screen top_gauge:

    image "ui/gauge_top.png":
        xalign 1.0
        yalign 0.0

    hbox:
        spacing -100
        xpos 1760
        ypos 492 - (player1Stats["top"]*2)
        image "ui/p1_arrow.png":
            yalign .5
        text str(player1Stats["top"]):
            style "gauge_points"
            ypos 10 xpos -7

    hbox:
        spacing -100
        xpos 1850
        ypos 492 - (player2Stats["top"]*2)
        image "ui/p2_arrow.png":
            xzoom -1.0
            yalign .5
        text str(player2Stats["top"]):
            style "gauge_points"
            ypos 10 xpos 7

screen bottom_gauge:

    image "ui/gauge_bottom.png":
        xalign 1.0
        yalign 1.0

    hbox:
        spacing -100
        image "ui/p1_arrow.png":
            yalign .5
        text str(player1Stats["bottom"]):
            style "gauge_points"
            ypos 10 xpos -7
        xpos 1760
        ypos 565 + (player1Stats["bottom"]*2)

    hbox:
        spacing -100
        xpos 1850 
        ypos 565 + (player2Stats["bottom"]*2)
        image "ui/p2_arrow.png":
            xzoom -1.0
            yalign .5
        text str(player2Stats["bottom"]):
            style "gauge_points"
            ypos 10 xpos 7

screen stock_sheets:

    frame at Transform(xalign=0.95, yalign=0.5, rotate=8):
        style "lore_note_frame"
        padding (10,10)
        xsize 225
        ysize 300
    
        image "mirror" at Transform(rotate=270):
            xpos 60 ypos -85
        text "In Mirror" :
            style "stock_text"
            xpos 10 ypos 14
        
        hbox:
            spacing 5
            xpos 16 ypos 80
            text str(topPool):
                style "stock_points"
                yalign .5
            image "tokenTop":
                yalign .5
                zoom 1.2

        hbox:
            spacing 5
            xpos 95 ypos 140
            image "mini_gold":
                yalign .5
            text str(goldPool):
                style "stock_points"
                yalign .5

        hbox:
            spacing 5
            xpos 21 ypos 200
            text str(bottomPool):
                style "stock_points"
                yalign .5
            image "tokenBottom":
                yalign .5
                zoom 1.2

label description_collar:
    hide screen choice
    show card_item_collar at cardPosition
    "A {b}Collar{/b}. It grants you 10 {image=tokenBottom} Bottom points."
    return

label description_rope:
    show card_item_rope at cardPosition
    "A {b}Rope{/b}. It grants you 10 {image=tokenTop} Top points."
    return

label description_aphrodisiac:
    show card_item_aphrodisiac at cardPosition
    "A vial of {b}Aphrodisiac{/b}. It grants you 5 {image=tokenTop} Top points and 5 {image=tokenBottom} points."
    return

label description_emblem:
    show card_item_emblem at cardPosition
    "This is an{b}Emblem{/b}. When it's equipped, you get stronger by one {image=level_1} level."
    return

label description_glowing_gem:
    show card_item_glowing_gem at cardPosition
    "This is a{b}Glowing gem{/b}. It raises your maximum {image=miniMana} Mana by 1."
    return

label description_gag:
    hide window
    show card_item_gag at cardPosition
    "This is a {b}Gag{/b}.  It grants you 20 {image=tokenBottom} Bottom points."
    return

label description_leash:
    show card_item_leash at cardPosition
    "This is a {b}Leash{/b}. It grants you 20 {image=tokenTop} Top points."
    return

label description_lube:
    show card_item_lube at cardPosition
    "A vial of {b}Lube{/b}. It grants you 10 {image=tokenTop} Top points and 10 {image=tokenBottom} points."
    return

label description_ring_of_fortune:
    show card_item_ring_of_fortune at cardPosition
    "A {b}Ring of Fortune{/b}. As long as it's in your hand, you get one {image=miniGold} Gold when starting your turn."
    return

label description_quickstep_boots:
    show card_item_quickstep_boots at cardPosition
    "Those are {b}Quickstep boots{/b}. As long as they're in your hand, you get 1 additional move after throwing the dice."
    return
