﻿init python:
    class Circle:
        def __init__(self, nb, xpos, ypos, circleType, circleAppearance, tier):
            self.nb = nb
            self.xpos = xpos
            self.ypos = ypos
            self.circleType = circleType
            self.circleAppearance = circleAppearance
            self.tier = tier

    class Item:
        def __init__(self, name, effect, icon, value):
            self.name = name
            self.effect = effect
            self.icon = icon
            self.value = value

    class Event:
        def __init__(self, eventId, description, choicesList):
            self.eventId = eventId
            self.description = description
            self.choicesList = choicesList

    class Encounter:
        def __init__(self, name, text, imgPath, choiceTexts, requiredPts, requiredLv, pointsReward, goldReward):
            self.name = name
            self.text = text
            self.imgPath = imgPath
            self.choiceTexts = choiceTexts
            self.requiredPts = requiredPts
            self.requiredLv = requiredLv
            self.pointsReward = pointsReward
            self.goldReward = goldReward

    class EventChoice:
        def __init__(self, choiceId, choiceText, choiceEffects, choiceDesc, choiceAfterText):
            self.choiceId = choiceId
            self.choiceText = choiceText
            self.choiceEffects = choiceEffects
            self.choiceDesc = choiceDesc
            self.choiceAfterText = choiceAfterText

    class ChoiceEffect:
        def __init__(self, stat, modifier, value):
            self.stat = stat
            self.modifier = modifier
            self.value = value

    class OpponentAi:
        def __init__(self, character, stats, items, goalPicked, difficulty):
            self.character = character
            self.stats = stats
            self.items = items
            self.goalPicked = goalPicked
            self.difficulty = difficulty

    class LockPostIt:
        def __init__(self, text, isUnlocked, color, rotate, size, pos):
            self.text = text
            self.isUnlocked = isUnlocked
            self.color = color
            self.rotate = rotate
            self.size = size
            self.pos = pos

default playMode = "versusAI"

default player1Items = []
default player2Items = []
default itemsInGame = []

default dungeonLevel = 0

define config.layers = ['pop-up', 'master', 'transient', 'screens', 'overlay']

    # renpy.show("circles/unknown.png", at_list=[Transform(xpos=200,ypos=500)])
# show image "circles/unknown.png" at Transform(xpos=200,ypos=500)

# image wizard_full = im.FactorScale("characters/wizard_full.png", 1.4)
# image warrior_full = im.FactorScale("characters/warrior_full.png", 1.4)

image player1 = "images/characters/p1.png"
image player2 = "images/characters/p2.png"

image card_findrel = "images/characters/card_findrel.png"
image card_layla = "images/characters/card_layla.png"

# image table = "board/table_background2.png"
image board = "board/board.png"
# image stock_sheets = "ui/stocks_sheet.png"
image table = gui.main_menu_background


image unknown = "images/circles/unknown.png"
image unknownBig = "images/circles/unknown_big.png"

image encounter = "images/circles/encounter.png"
image encounterBig = "images/circles/encounter_big.png"

image event = "images/circles/event.png"
image eventBig = "images/circles/event_big.png"

image gold = "images/circles/gold.png"
image goldBig = "images/circles/gold_big.png"

image item = "images/circles/item.png"
image itemBig = "images/circles/item_big.png"

image shop = "images/circles/shop.png"
image shopBig = "images/circles/shop_big.png"

image mirror = "images/circles/mirror.png"
image mirrorBig = "images/circles/mirror_big.png"

image start = "images/circles/start.png"
image startBig = "images/circles/start_big.png"
image startSmall = im.FactorScale("images/circles/start.png", .4)


image bg black = "#000000"

image card_goblin_m_top = "scenes/goblin_m_top.png"
image card_goblin_m_bottom = "scenes/goblin_m_bottom.png"
image card_goblin_f_top = "scenes/goblin_f_top.png"
image card_goblin_f_bottom = "scenes/goblin_f_bottom.png"

image card_gold_1 = "ui/card_coin_1.png"
image card_gold_2 = "ui/card_coin_2.png"

image card_item_rope = "items/card_item_rope.png"
image card_item_collar = "items/card_item_collar.png"
image card_item_aphrodisiac = "items/card_item_aphrodisiac.png"
image card_item_glowing_gem = "items/card_item_glowing_gem.png"
image card_item_emblem = "items/card_item_emblem.png"

image token_level_1 = "ui/level_token_1.png"
image token_level_2 = "ui/level_token_2.png"
image token_level_3 = "ui/level_token_3.png"
image token_level_4 = "ui/level_token_4.png"
image token_level_5 = "ui/level_token_5.png"
image token_level_6 = "ui/level_token_6.png"
image token_level_7 = "ui/level_token_7.png"
image token_level_8 = "ui/level_token_8.png"
image token_level_9 = "ui/level_token_9.png"
image token_level_10 = "ui/level_token_10.png"

image steam_logo = im.FactorScale("ui/steam_logo.png",.5)

default player1Stats = {
    "level": 1,
    "top": 0,
    "bottom" : 0,
    "gold": 1,
    "max_mana": 5,
    "mana": 1,
}

default player2Stats = {
    "level": 1,
    "top": 0,
    "bottom" : 0,
    "gold": 1,
    "max_mana": 5,
    "mana": 1,
}

default playerTurn = 0

default player1Passives = []
default player2Passives = []

default statChangeDisplay = {
    "player": 0,
    "stat": "",
    "number": 0,
}

define dungeonRooms = [
    "encounter", "encounter", "encounter", "encounter", "encounter", "encounter", # 6
    "event", "event", "event", "event", "event", # 5
    "gold", "gold", "gold", "gold", # 4
    "shop", "shop", "gold", #3 One of these turns into a shop when Dungeon lv.1
    "item", "item", #2
    "event", #1 Turns into a mirror when Dungeon lv.1
]

define eventsList = [
    
    [ # Tier 1
        "event_the_merchant",
        "event_the_troll",
        "event_the_tavern",
        "event_the_training",
        "event_the_offering",
    ],
    [ # Tier 2
        "event_the_impotent",
        "event_the_pool",
        "event_the_adventurer",
        "event_the_gaol",
        "event_the_sorceress",
    ],
    [ # Tier 3
        "event_the_e",
        "event_the_f",
        "event_the_g",
        "event_the_h",
        "event_the_i",

    ],
    [ # Tier 4
        "event_the_j",
        "event_the_k",
        "event_the_l",
        "event_the_m",
        "event_the_n",
  
    ]
]

define itemsList = [
    [ # Tier 1
        "collar",
        "rope", 
        "aphrodisiac",
        "emblem",
        "glowing_gem",
    ],
    [ # Tier 2
        "gag",
        "leash",
        "lube",
        "ring_of_fortune",
        "quickstep_boots",
    ],
    [ # Tier 3
        "ropes",
        "clamps",
        "condom",
        "trader_hat",
        "enchanted_idol",
    ],
    [ # Tier 4
        "buttplug",
        "whip",
        "moon_pendant",
        "moon_pendant",
        "lucky_sigil",  
    ]
]

define  encountersList = [
    [ # Tier 1
        "goblin",
        "goblin",
        "kobold",
    ],
    [ # Tier 2
        "goblin",
        "kobold",
        "slime",
    ],
    [ # Tier 3
        "kobold",
        "slime",
        "goblin_horde"
    ],
    [ # Tier 4
        "slime",
        "goblin_horde",
        "succubus",
    ]
]

define goldList = [
    [ # Tier 1
        1,
        1,
        1,
        2
    ],
    [ # Tier 2
        1,
        2,
        2,
        2,
    ],
    [ # Tier 3
        1,
        2,
        2,
        3
    ],
    [ # Tier 4
        2,
        3,
        3,
        4
    ]
]




define charactersNames = ["", "{b}{color=#71b1d9}Findrel{/color}{/b}", "{b}{color=#d99971}Layla{/color}{/b}"]

# define findrel_full = Character(None, image="findrel_full", kind=bubble,properties="bottom_left", area=[480, 270, 640, 225])
# define layla_full = Character(None, image="layla_full", kind=bubble, properties="top_right", area=[480, 270, 640, 225])

default playerCharacter = 0

default extraTurn = False
default shopItemsPicked = False # Prevents the shop from generation new random selections after screen refresh

default xDice = 0
default yDice = 0

default arrow_angle = 0.0

default topPool = 0
default bottomPool = 0
default goldPool = 0

default chanceEncounterCounter = 0
default chanceEncounterTheme = ""

define eventThreshold = [75, 150, 300, 500]
default eventCounter = 0 

default currentRoom = ""
default eventEncounter = ""
default lastEvents = ["", ""]
default lastChoice = "" # keeps track of last choice made by player
default winner = ""

default itemChosen = ""
default isShopping = False
default isThrowing = False

default zoomLevel = 0.70
default zoomedCardPath = ""
default isInGallery = False

default isBraveHeartActive = False

default persistent.collection = {
    "charactersSexCards": [],
    "foesCards": [],
    "foesSexCardsFindrel": [],
    "foesSexCardsLayla": [],
    "itemsCards": [],
    "eventsCards": [],
}

default sfwMode = False
default persistent.selectedBackground = "A"

default difficulty = "normal"

default cheat_nextDice = 0

default hasDemoEnded = False

default leadingPlayer = 0

# define arrow_angle_offset = 130.0

image findrel_full = "characters/findrel_portrait.png"
image layla_full = "characters/layla_portrait.png"

image diceP1_1 = "ui/p1dice1.png"
image diceP1_2 = "ui/p1dice2.png"
image diceP1_3 = "ui/p1dice3.png"
image diceP1_4 = "ui/p1dice4.png"
image diceP1_5 = "ui/p1dice5.png"
image diceP1_6 = "ui/p1dice6.png"

image diceP2_1 = "ui/p2dice1.png"
image diceP2_2 = "ui/p2dice2.png"
image diceP2_3 = "ui/p2dice3.png"
image diceP2_4 = "ui/p2dice4.png"
image diceP2_5 = "ui/p2dice5.png"
image diceP2_6 = "ui/p2dice6.png"

image mini_diceP1_1 = im.FactorScale("ui/p1dice1.png",.275)
image mini_diceP1_2 = im.FactorScale("ui/p1dice2.png",.275)
image mini_diceP2_1 = im.FactorScale("ui/p2dice1.png",.275)

image event_merchant = "events/event_the_merchant.png"
image event_troll = "events/event_the_troll.png"
image event_tavern = "events/event_the_tavern.png"
image event_training = "events/event_the_training.png"
image event_offering = "events/event_the_offering.png"
image event_impotent = "events/event_the_impotent.png"

image event_merchant_small = "events/event_the_merchant_small.png"
image event_troll_small = "events/event_the_troll_small.png"
image event_tavern_small = "events/event_the_tavern_small.png"
image event_training_small = "events/event_the_training_small.png"
image event_offering_small = "events/event_the_offering_small.png"
image event_impotent_small = "events/event_the_impotent_small.png"

image skill_soul_steal = "ui/card_skill_soul_steal.png"
image skill_gust_of_wind =  "ui/card_skill_gust_of_wind.png"
image skill_brave_heart =  "ui/card_skill_brave_heart.png"
image skill_endurance =  "ui/card_skill_endurance.png"

image arrow = "ui/arrow.png"

image miniMana = im.FactorScale("images/ui/mini_mana.png", .8)
image miniManaEmpty = "images/ui/mini_mana_empty.png"
image miniGold = im.FactorScale("images/ui/mini_gold.png",.8)

image tokenTop = im.FactorScale("images/ui/token_top.png", .8)
image tokenBottom = im.FactorScale("images/ui/token_bottom.png", .8)

image tokenTopPlus = im.FactorScale("images/ui/token_top_plus.png", .8)
image tokenTopMinus = im.FactorScale("images/ui/token_top_minus.png", .8)
image tokenBottomPlus = im.FactorScale("images/ui/token_bottom_plus.png", .8)
image tokenBottomMinus = im.FactorScale("images/ui/token_bottom_minus.png", .8)
image goldPlus = im.FactorScale("images/ui/mini_gold_plus.png", .8)
image goldMinus = im.FactorScale("images/ui/mini_gold_minus.png", .8)
image manaPlus = im.FactorScale("images/ui/manaPlus.png", .8)
image manaMinus = im.FactorScale("images/ui/manaMinus.png", .8)
image levelPlus = im.FactorScale("images/ui/level_token_plus.png", .8)
image levelMinus = im.FactorScale("images/ui/level_token_minus.png", .8)

image topAbove10True = im.FactorScale("images/ui/top_above_10_true.png", .8)
image topAbove10False = im.FactorScale("images/ui/top_above_10_false.png", .8)
image topAbove25True = im.FactorScale("images/ui/top_above_25_true.png", .8)
image topAbove25False = im.FactorScale("images/ui/top_above_25_false.png", .8)
image topAbove50True = im.FactorScale("images/ui/top_above_50_true.png", .8)
image topAbove50False = im.FactorScale("images/ui/top_above_50_false.png", .8)

image bottomAbove10True = im.FactorScale("images/ui/bottom_above_10_true.png", .8)
image bottomAbove10False = im.FactorScale("images/ui/bottom_above_10_false.png", .8)
image bottomAbove25True = im.FactorScale("images/ui/bottom_above_25_true.png", .8)
image bottomAbove25False = im.FactorScale("images/ui/bottom_above_25_false.png", .8)
image bottomAbove50True = im.FactorScale("images/ui/bottom_above_50_true.png", .8)
image bottomAbove50False = im.FactorScale("images/ui/bottom_above_50_false.png", .8)

image levelAbove1True = im.FactorScale("images/ui/level_token_above_1_true.png", .8)
image levelAbove3True = im.FactorScale("images/ui/level_token_above_3_true.png", .8)
image levelAbove3False = im.FactorScale("images/ui/level_token_above_3_false.png", .8)
image levelAbove5True = im.FactorScale("images/ui/level_token_above_5_true.png", .8)
image levelAbove5False = im.FactorScale("images/ui/level_token_above_5_false.png", .8)



# image above10Top "ui/top_above_top_".png"

image warriorClass = im.FactorScale("images/ui/class_warrior.png", .75)
image wizardClass = im.FactorScale("images/ui/class_wizard.png", .75)

image mini_gold = "images/ui/mini_gold.png"


image level_1 = Transform("ui/level_token_1.png", zoom=0.8)
image level_2 = Transform("ui/level_token_2.png", zoom=0.8)
image level_3 = Transform("ui/level_token_3.png", zoom=0.8)
image level_4 = Transform("ui/level_token_4.png", zoom=0.8)
image p1_arrow = Transform("ui/p1_arrow.png")
image p2_arrow = Transform("ui/p2_arrow.png")

image black_screen = "#000000"

label start:

    show table

    if persistent.tutorial:
        menu:
            "Skip the prologue?"
            "Yes.":
                show table
                show board
                $ initCircles()
                $ refreshBoard(True)
                $ playerPosition = [0, 0, 0]
                show player1 at initialPosition
                show player2 at initialPosition
                jump skip_tutorial
            "No.":
                window hide

    show screen meet_up_cards("intro")
    pause .75
    "p2" "Fuck, you really did it. You {i}actually{/i} made cards out of Findrel and Layla."
    "p1" "It feels weird seeing our own Dungeons & Turn-ons characters like this..."
    "Isn't it? And I even made a whole board game for them. For you."
    "p2" "Are we supposed to roleplay or something?"
    "That's up to you."
    "First things first, let me set up the board."
    pause .25
    hide screen meet_up_cards with moveouttop
    pause .45
    show board at boardAppear
    pause .9

    "Here. That's the dungeon you'll be exploring."
    $ initCircles()

    $ refreshBoard(False)
    pause .25
    "And those are the room tokens, hidden for now."
    "Your characters start here, at the entrance."

    $ playerPosition = [0, 0, 0]

    show player1 at initialPosition
    pause .25
    show player2 at initialPosition
    pause .50
    "p2" "You even 3D printed figurines..."

label skip_prologue:
    

    # jump skip_tutorial

    # if persistent.tutorial:
    menu:
        "Of course. Now let me show you how the game's played."
        "Please do.":
            jump tutorial
        "Don't bother, we'll learn as we go \n {size=*0.65}{color=#d456d3}{b}Skip Tutorial":
            jump skip_tutorial

    jump tutorial

label skip_tutorial:

    # show screen side_ui
    # show stock_sheets at Transform(xalign=0.93, yalign=0.5)
    show screen stock_sheets
    show screen clickable_icons
    show screen characters_sheets
    show screen gauges
    show screen lore_sheets
    show screen dungeon_level
    

label character_selection:

    $ tutorial = False
    pause .15
    "Alright, who goes first?"

label character_selection_loop:

    call screen character_selection

    if playMode == "versusAI":

        if playerCharacter == 1:
            show screen character_card("findrel")
            $ playerTurn = 1
            "Findrel, the half-impostor mage! Ready for this special session?"
            "p1" "Ready as hell, I love playing as Findrel."

            menu:
                "He will only face female foes. Is that alright?"
                "Of course! \n {size=*0.65}{color=#72b1da}{space=10}{b}Play as Findrel":
                    pause .15
                    menu:
                        "p2" "Why bother? You know I'm going to win, right?"
                        "Keep telling yourself that, dear. \n {size=*0.65}{color=#d456d3}{space=10}{b}Normal mode":
                            $ difficulty = "normal"
                        "Not if I give my all, I assure you. \n {size=*0.65}{color=#7b7b7b}{space=10}{b}Hard mode - Not in demo" if False:
                            $ difficulty = "hard"
                    "That's enough banter, you two."

                "No, wait a minute...":
                    "Alright, I'll let you reconsider."
                    jump character_selection_loop

            "Now, one last thing before we start."
            menu:
                "How do you guys feel about sexual content? Should we cut it out?"
                "Isn't it why we're here? \n {size=*0.65}{color=#d456d3}{space=10}{b}Not Safe for Work (NSFW) Mode":
                    $ sfwMode = False
                "I'd be more comfortable that way. \n {size=*0.65}{color=#7b7b7b}{space=10}{b}Safe for Work (SFW) Mode - Not in demo" if False:
                    $ sfwMode = True

        elif playerCharacter == 2:
            show screen character_card("layla")
            $ playerTurn = 2
            "Layla, the arena-bred warrior! You like playing as her, do you?"
            "p2" "I'm having fun, especially when I get into character."

            menu:
                "She will only face male foes. Is that alright?"
                "Bring them on! \n {size=*0.65}{color=#d34c53}{space=10}{b}Play as Layla":
                    pause .15
                    menu:
                        "p1" "This is gonna be fun. Especially once I win."
                        "But you won't. \n {size=*0.65}{color=#d456d3}{space=10}{b}Normal mode":
                            $ difficulty = "normal"
                        "How can you win if I crush you? \n {size=*0.65}{color=#7b7b7b}{space=10}{b}Hard mode - Not in demo" if False:
                            $ difficulty = "hard"
                    "That's enough banter, you two."

                "No, wait a minute...":
                    "Alright, I'll let you reconsider."
                    jump character_selection_loop
    
            "Now, one last thing before we start."
            menu:
                "How do you guys feel about sexual imagery? Should we cut them out?"
                "Don't you dare. \n {size=*0.65}{color=#d456d3}{space=10}{b}Not Safe for Work (NSFW) Mode":
                    $ sfwMode = False
                "I'd rather we do. \n {size=*0.65}{color=#7b7b7b}{space=10}{b}Safe for Work (SFW) Mode - Not in demo" if False:
                    $ sfwMode = True

    elif playMode == "versusPlayer":

        $ playerTurn = playerCharacter

        "Now, one last thing before we start."
        menu:
            "Would you rather play with or without sexual imagery?"
            "With, please. \n {size=*0.65}{color=#d456d3}{space=10}{b}Not Safe for Work (NSFW) Mode":
                $ sfwMode = False
            "Without, please. \n {size=*0.65}{color=#7b7b7b}{space=10}{b}Safe for Work (SFW) Mode - Not in demo version" if False:
                $ sfwMode = True

    if sfwMode:
        "No sexy pictures, then. Understood."
    else:
        "You want sexy pictures, then. Understood."
    
    "Now let's play!"

    hide screen character_card with moveoutbottom

    $ soloPlayer = playerCharacter
    $ opponentAi = getOpponentAi()

    # if soloPlayer == 1:
    #     $ opp = Character("p2")
    # else:
    #     $ opp = Character("p1")

    $ playerTurn = soloPlayer
    $ addMana(playerTurn, 1)

    $ renpy.call_screen("player_" + str(playerTurn) + "_turn")

    # default dice = Drag(d = Image("ui/p1dice1.png", xysize = (250, 250)), drag_name = "dice", drag_raise = True, align = (0.5, 0.5))
    # default my_draggroup = DragGroup(dice)
    # default dice = Drag(d = "ui/p1dice1.png")

label demo_end:

    hide screen characters_sheets
    hide screen gauges
    hide screen clickable_icons
    hide screen stock_sheets
    hide screen lore_sheets
    "Well, that's all for today."
    "p1" "What? Already?"
    "p2" "I thought we had to reach 200 points?"
    "In the full game, yes. But you're playing a demo right now."
    "There'll soon be a lot more sex cards to discover, with new enemies and events. New items, too."
    "If you liked it and wish to support PopotoProductions, feel free to wishlist the game on Steam!"
    "p1" "What are you even talking about?"

    if isCollectionComplete():
        "Nothing. I know you've seen every card currently in the game, but how about a new game anyway?"
    else:
        "Nothing. How about a new game? I know for a fact you haven't seen every card currently in the game..."
    return

# label victory_findrel:

#     call screen player_1_victory

# label victory_layla:

#     call screen player_2_victory

# screen player_1_victory():

#     modal True

#     image "characters/wizard.jpg":
#         xalign .5
#         yalign .35

#     frame:
#         xalign .5
#         yalign .5
#         xpadding 25
#         ypadding 25
#         text "Findrel is victorious!"

#     dismiss action Jump("epilogue")

# screen player_2_victory():

#     modal True

#     image "characters/warrior.jpg":
#         xalign .5
#         yalign .35

#     frame:
#         xalign .5
#         yalign .5
#         xpadding 25
#         ypadding 25
#         text "Layla is victorious!"

#     dismiss action Jump("epilogue")

# label epilogue:

#     scene image "#000"
#     hide screen side_ui
#     hide screen score_ui
#     hide screen dungeonLevel
#     scene image "backgrounds/living_room.png" with fade

#     "Robin" "That was a wild ride!"
#     "WIP version is over, now there should be a scene between the two characters depending on the domination/submission dynamic between the two..."
#     pause