
label resolve_mirror:

    if playerTurn == 1:
        $ playerMana = player1Stats["mana"]
        $ playerTop = player1Stats["top"]
        $ playerBottom = player1Stats["bottom"]
    else:
        $ playerMana = player2Stats["mana"]
        $ playerTop = player2Stats["top"]
        $ playerBottom = player2Stats["bottom"]

    if playMode == "versusPlayer" or (playMode == "versusAI" and playerTurn == soloPlayer):

        "In the mirror, you see a glimpse of what could have been."
        "To put it bluntly, here you can grab points your opponent lost."

        menu:
            "For some mana, you can claim Gold, Top or Bottom points stored in the pool."

            "Get Top points" if topPool > 0 and playerTop >= topPool:

                $ halfPts = int(topPool/2)
                $ quarterPts = int(topPool/4)

                menu:
                    "There are currently [topPool] Top points in the pool."

                    "Get [topPool] Top pts for {image=miniMana}{image=miniMana}{image=miniMana}" if playerMana >= 3 and topPool > 0:
                        $ addTopPoints(playerTurn, topPool)
                        $ removeMana(playerTurn, 3)
                        $ topPool = 0
                        jump between_turn
                    "Get [halfPts] Top pts for {image=miniMana}{image=miniMana}" if playerMana >= 2 and halfPts > 0:
                        $ addTopPoints(playerTurn, halfPts)
                        $ removeMana(playerTurn, 2)
                        $ topPool -= halfPts
                        jump between_turn
                    "Get [quarterPts] Top pts for {image=miniMana}" if playerMana >= 1 and quarterPts > 0:
                        $ addTopPoints(playerTurn, quarterPts)
                        $ removeMana(playerTurn, 1)
                        $ topPool -= quarterPts
                        jump between_turn
                    "Forget it":
                        jump resolve_mirror

            "Get Gold" if goldPool > 0:

                $ fullPts = goldPool
                $ halfPts = int(goldPool/2)
                $ quarterPts = int(goldPool/4)

                menu:
                    "There are currently [goldPool] Gold in the pool."

                    "Get [fullPts] Gold for {image=miniMana}{image=miniMana}{image=miniMana}" if playerMana >= 3 and fullPts > 0:
                        $ goldPool -= fullPts
                        $ addGold(playerTurn, fullPts)
                        $ removeMana(playerTurn, 3)
                        jump between_turn
                    "Get [halfPts] Gold for {image=miniMana}{image=miniMana}" if playerMana >= 2 and halfPts > 0:
                        $ goldPool -= halfPts
                        $ addGold(playerTurn, halfPts)
                        $ removeMana(playerTurn, 2)
                        jump between_turn
                    "Get [quarterPts] Gold for {image=miniMana}" if playerMana >= 1 and quarterPts > 0:
                        $ goldPool -= quarterPts
                        $ addGold(playerTurn, quarterPts)
                        $ removeMana(playerTurn, 1)
                        jump between_turn
                    "Forget it":
                        jump resolve_mirror

            "Get Bottom points" if bottomPool > 0 and playerBottom >= bottomPool:    

                $ halfPts = int(bottomPool/2)
                $ quarterPts = int(bottomPool/4)

                menu:
                    "There are currently [bottomPool] Bottom points in the pool."

                    "Get [bottomPool] Bottom pts for {image=miniMana}{image=miniMana}{image=miniMana}" if playerMana >= 3 and bottomPool > 0:
                        $ addBottomPoints(playerTurn, bottomPool)
                        $ removeMana(playerTurn, 3)
                        $ bottomPool = 0
                        jump between_turn
                    "Get [halfPts] Bottom pts for {image=miniMana}{image=miniMana}" if playerMana >= 2 and halfPts > 0:
                        $ addBottomPoints(playerTurn, halfPts)
                        $ removeMana(playerTurn, 2)
                        $ bottomPool -= halfPts
                        jump between_turn
                    "Get [quarterPts] Bottom pts for {image=miniMana}" if playerMana >= 1 and quarterPts > 0:
                        $ addBottomPoints(playerTurn, quarterPts)
                        $ removeMana(playerTurn, 1)
                        $ bottomPool -= quarterPts
                        jump between_turn
                    "Forget it":
                        jump resolve_mirror

            "Go on your way":
                jump between_turn

    else:
        $ ai_resolveMirror()
        jump between_turn

screen resolve_mirror(content):

    if playerTurn == 1:
        $ icon = "miniMana"
    elif playerTurn == 2:
        $ icon = "warriorEnergy"

    frame:
        xpadding 20
        ypadding 20
        xalign .5 yalign .5
        vbox:
            xalign .5
            spacing 35
            text "Spend mana to absorb the some of the sexual essence contained in the pool."

            hbox:
                xalign .5
                spacing 80
                vbox:
                    spacing 35
                    text "Top : " + str(topPool):
                        xalign .5
                    grid 2 2:
                        spacing 20
                        xalign .5
                        vbox:
                            xalign .5
                            spacing 10
                            textbutton "5":
                                xalign .5
                                action [SensitiveIf(topPool>=5), Function(takeFromPool, stat = "top", ptsTaken = 5), Return()]
                            text "Free":
                                xalign .5

                        vbox:
                            xalign .5
                            spacing 10
                            textbutton "10":
                                xalign .5
                                action [SensitiveIf(topPool>=10), Function(takeFromPool, stat = "top", ptsTaken = 10), Return()]
                            text "{image=warriorEnergy}":
                                xalign .5

                        vbox:
                            xalign .5
                            spacing 10
                            textbutton "15":
                                xalign .5
                                action [SensitiveIf(topPool>=15), Function(takeFromPool, stat = "top", ptsTaken = 15), Return()]
                            text "{image=warriorEnergy}{image=warriorEnergy}":
                                xalign .5

                        vbox:
                            xalign .5
                            spacing 10
                            textbutton "20":
                                xalign .5
                                action [SensitiveIf(topPool>=20), Function(takeFromPool, stat = "top", ptsTaken = 20), Return()]
                            text "{image=warriorEnergy}{image=warriorEnergy}{image=warriorEnergy}":
                                xalign .5

                vbox:
                    spacing 35
                    text "Bottom : " + str(bottomPool):
                        xalign .5
                    grid 2 2:
                        spacing 20
                        xalign .5
                        vbox:
                            xalign .5
                            spacing 10
                            textbutton "5":
                                xalign .5
                                action [SensitiveIf(bottomPool>=5), Function(takeFromPool, stat = "bottom", ptsTaken = 5), Return()]
                            text "Free":
                                xalign .5

                        vbox:
                            xalign .5
                            spacing 10
                            textbutton "10":
                                xalign .5
                                action [SensitiveIf(bottomPool>=10), Function(takeFromPool, stat = "bottom", ptsTaken = 10), Return()]
                            text "{image=warriorEnergy}":
                                xalign .5

                        vbox:
                            xalign .5
                            spacing 10
                            textbutton "15":
                                xalign .5
                                action [SensitiveIf(bottomPool>=15), Function(takeFromPool, stat = "bottom", ptsTaken = 15), Return()]
                            text "{image=warriorEnergy}{image=warriorEnergy}":
                                xalign .5

                        vbox:
                            xalign .5
                            spacing 10
                            textbutton "20":
                                xalign .5
                                action [SensitiveIf(bottomPool>=20), Function(takeFromPool, stat = "bottom", ptsTaken = 20), Return()]
                            text "{image=warriorEnergy}{image=warriorEnergy}{image=warriorEnergy}":
                                xalign .5

            textbutton "OK":
                action [Return()]
                xalign .5

label resolve_start:

    "Good job landing back on the Start room. You gain an extra turn."
    $ extraTurn = True
    jump between_turn

label resolve_mirror_tutorial:

    if tutorialTurn == 8:
        $ playerMana = player1Stats["mana"]

        "This is where the \"pool\" of {image=tokenTop} Top and {image=tokenBottom} Bottom points gets useful."
        "Here you can draw from that reserve, on two conditions."
        "First, there must be at least 1 point in the pool."
        "And second, the amount you get can't be higher than what you currently have."
        "This means you can't exchange {image=miniMana} Mana for these 10 {image=tokenTop} Top points."
        "p2" "Not until I first get at least 10 {image=tokenTop} Top points on my own. Is that right?"
        "Exactly."
        "p1" "So that whole thing's pretty useless at this point."
        "It'll come in handy the longer the game lasts."

        menu:
            "For now, there's not much you can do."

            "Get Top points" if False:
                window hide

            "Get Gold" if False:
                window hide

            "Get Bottom points" if False:    
                window hide

            "Leave":
                $ tutorialTurn += 1
                jump between_turn

    elif tutorialTurn == 9:
        $ playerMana = player2Stats["mana"]
        "p1" "I should grab some of these {image=tokenTop} Top points, shouldn't I?"
        "Normally, you can't because your current {image=tokenTop} Top points are lower than what's in the Mirror."

        menu:
            "But hey, I'm teaching you the ropes so let's make an exception."

            "Get Top points":
                window hide

                $ halfPts = int(topPool/2)
                $ quarterPts = int(topPool/4)

                "Now, you can spend 3 {image=miniMana} Mana to get the whole sum."
                "You can also get half of that for 2 {image=miniMana} Mana, and a quarter for 1 {image=miniMana} Mana."
                "p1" "I'd better keep some spare {image=miniMana} Mana for whenever I get here, then."

                menu:
                    "Explanations are nearly over, so you can go ahead and get everything."

                    "Get [topPool] Top pts for {image=miniMana}{image=miniMana}{image=miniMana}" if playerMana >= 3 and topPool > 0:
                        $ addTopPoints(playerTurn, topPool)
                        $ removeMana(playerTurn, 3)
                        $ topPool = 0
                    "Get [halfPts] Top pts for {image=miniMana}{image=miniMana}" if False:
                        $ addTopPoints(playerTurn, halfPts)
                        $ removeMana(playerTurn, 2)
                        $ topPool -= halfPts
                    "Get [quarterPts] Top pts for {image=miniMana}" if False:
                        $ addTopPoints(playerTurn, quarterPts)
                        $ removeMana(playerTurn, 1)
                        $ topPool -= quarterPts
                    "Forget it" if False:
                        window hide

            "Get Bottom points" if False:    
                window hide

            "Go on your way" if False:
                window hide

        "p1" "Well, that was shockingly expensive."
        "The {image=miniMana} Mana cost stays the same no matter how many points there are in the Mirror."
        "So it's a much better deal when the pool is fuller."

        "By the way, this is the first time your characters get in the same room"
        "p2" "Does that trigger something?"
        "Yes, what I like to call the Hero Encounter."

        jump between_turn
