
label resolve_shop:

    "A merchant has set his shop inside the dungeon."

    $ shopSelection = getShopSelection(currentRoom)

    if shopSelection == []:
        "But he has no more items to sell, sorry!"
        $ isShopping = True
        if playMode == "versusPlayer" or (playMode == "versusAI" and playerTurn == soloPlayer):
            menu:
                "Do you wish to sell something, though?"
                "Leave":
                    $ isShopping = False
                    window hide
                    hide screen shop
                    pause .5
                    jump between_turn
        else:
            pause .15
            jump between_turn



    elif len(shopSelection) < 3:
        "It looks like his stock is wearing thin"

    if playMode == "versusPlayer" or (playMode == "versusAI" and playerTurn == soloPlayer):

        $ isShopping = True
        show screen shop(shopSelection)
        $ renpy.play("sounds/card1.mp3")
        pause .07
        $ renpy.play("sounds/card1.mp3")
        pause .07
        $ renpy.play("sounds/card1.mp3")

        menu:
            "Choose an item card to buy it, or pick an item from your deck to sell it."
            "Leave":
                $ isShopping = False
                window hide
                hide screen shop
                pause .5
                hide item
                pause .5
                jump between_turn
                
    else:
        $ playerItemsNb = len(player1Items) if playerTurn == 1 else len(player2Items)
        $ itemsBought = 0
        show screen buy(shopSelection)
        pause .95

        if playerItemsNb < 5:
            $ text = ai_resolveShop(shopSelection)
            if text != "":
                while text != "":
                    
                    $ text = ai_resolveShop(shopSelection)
                $ renpy.say("p1" if soloPlayer == 2 else "p2", "And that will be all, I think.")
            else:
                $ renpy.say("p1" if soloPlayer == 2 else "p2", "I'm not buying anything.")
        else:
            $ renpy.say("p1" if soloPlayer == 2 else "p2", "No shopping for me, I can't carry more items.")
                    

        window hide
        hide screen buy
        
        hide item
        pause .15
        jump between_turn

label buying_item:

    if playMode == "tutorial":
        if tutorial_askedToBuyEmblem == False:
            menu:
                "For now, just sell your Rope."
                "Leave" if False:
                    window hide
        else:
            if itemChosen.name != "Emblem":
                "You'll buy one later if you want. Get the Emblem instead."

    if playerTurn == 1:
        $ playerGold = player1Stats["gold"]
        $ playerItemsNb = len(player1Items)

    elif playerTurn == 2:
        $ playerGold = player2Stats["gold"]
        $ playerItemsNb = len(player2Items)

    if playerItemsNb < 5:

        if playerGold >= itemChosen.value:

            menu:
                "[itemChosen.name] costs [itemChosen.value] coins. Is this what you want?"
                "Buy [itemChosen.name]":
                    $ isShopping = False
                    $ buyItem(playerTurn, itemChosen)

                    $ checkCollection("item", itemChosen.icon, None, None)
                    if playMode == "tutorial":
                        jump tutorial_stock

                    $ isShopping = True
                    menu:
                        "Here you go. Anything else?"
                        "Leave":
                            $ isShopping = False
                            window hide
                            hide screen shop
                            pause .5
                            jump between_turn

                "No":
                    show screen shop(shopSelection)

                    menu:
                        "What will it be, then?"
                        "Leave":
                            $ isShopping = False
                            window hide
                            hide screen shop
                            pause .5
                            jump between_turn

        else:
            show screen shop(shopSelection)
            menu:
                "Sorry, but you don't have enough gold. Try selling an item."            
                "Leave":
                    $ isShopping = False
                    window hide
                    hide screen shop
                    pause .5
                    jump between_turn
    
    else:
        show screen shop(shopSelection)
        menu:
            "You carry too many items. You should consider selling one."        
            "Leave":
                $ isShopping = False
                window hide
                hide screen shop
                pause .5
                jump between_turn
        

label selling_item:

    hide screen shop
    # show screen selling_item_card(itemChosen.icon)
    show image "items/card_item_[itemChosen.icon].png" at sellingCardPosition as soldItem
    $ sellValue = int(itemChosen.value/2)

    menu:
        "Do you want to sell [itemChosen.name] for [sellValue] coins?"
        "Sell [itemChosen.name]":
            hide soldItem
            $ sellItem(playerTurn, itemChosen)
            if playMode == "tutorial":
                "Good! Now you've got three coins, and I'll even give you a fourth one."
                $ addGold(2,1)
                "p1" "Cheater."
                
                $ tutorial_askedToBuyEmblem = True
                show screen shop(shopSelection)
                menu:
                    "Why don't you buy that Emblem to gain a level?"

                    "Leave" if False:
                        hide window

            show screen shop(shopSelection)
            
            menu:
                "All done. Anything else?"
                "Leave":
                    $ isShopping = False
                    window hide
                    hide screen shop
                    pause .5
                    jump between_turn
        "No" if playMode != "tutorial":
            hide soldItem
            show screen shop(shopSelection)

            menu:
                "What will it be, then?"
                "Leave":
                    $ isShopping = False
                    window hide
                    hide screen shop
                    pause .5
                    hide item
                    pause .5
                    jump between_turn


screen shop(shopSelection):

    use buy(shopSelection)
    # if playerTurn == 1:
    #     use sell_findrel
    # elif playerTurn == 2:
    #     use sell_layla


screen buy(shopSelection):

    # hbox at shopAppear:
    #     spacing -300
    # for index, i in enumerate(shopSelection):

        if len(shopSelection) >= 1:
            imagebutton at shopAppear1:
                idle im.FactorScale("items/card_item_" + shopSelection[0].icon + ".png", 0.67)
                hover im.FactorScale("items/card_item_" + shopSelection[0].icon + ".png", 0.68)
                action [SensitiveIf(isShopping), SetVariable("itemChosen", shopSelection[0]), Jump("buying_item")]

        if len(shopSelection) >= 2:
            imagebutton at shopAppear2:
                idle im.FactorScale("items/card_item_" + shopSelection[1].icon + ".png", 0.67)
                hover im.FactorScale("items/card_item_" + shopSelection[1].icon + ".png", 0.68)
                action [SensitiveIf(isShopping), SetVariable("itemChosen", shopSelection[1]), Jump("buying_item")]

        if len(shopSelection) >= 3:
            imagebutton at shopAppear3:
                idle im.FactorScale("items/card_item_" + shopSelection[2].icon + ".png", 0.67)
                hover im.FactorScale("items/card_item_" + shopSelection[2].icon + ".png", 0.68)
                action [SensitiveIf(isShopping), SetVariable("itemChosen", shopSelection[2]), Jump("buying_item")]            

            # zoom .75
            # rotate (index-1)*10

screen sell_findrel():

    
    if len(player1Items) > 0:
        imagebutton:
            idle im.FactorScale("items/token_item_" + player1Items[0].icon + ".png", 0.2)
            hover im.FactorScale("items/token_item_" + player1Items[0].icon + ".png", 0.25)
            xalign 0.165
            if playerTurn == 1:
                yalign 0.94
            elif playerTurn == 2:
                yalign 1.06
            action [SetVariable("itemChosen", player1Items[0]), Jump("selling_item")]

    if len(player1Items) > 1:
        imagebutton:
            idle im.FactorScale("items/token_item_" + player1Items[1].icon + ".png", 0.2)
            hover im.FactorScale("items/token_item_" + player1Items[1].icon + ".png", 0.25)
            xalign 0.215
            if playerTurn == 1:
                yalign 0.94
            elif playerTurn == 2:
                yalign 1.06
            action [SetVariable("itemChosen", player1Items[1]), Jump("selling_item")]

    if len(player1Items) > 2:
        imagebutton:
            idle im.FactorScale("items/token_item_" + player1Items[2].icon + ".png", 0.2)
            hover im.FactorScale("items/token_item_" + player1Items[2].icon + ".png", 0.25)
            xalign 0.265
            if playerTurn == 1:
                yalign 0.94
            elif playerTurn == 2:
                yalign 1.06
            action [SetVariable("itemChosen", player1Items[2]), Jump("selling_item")]

    if len(player1Items) > 3:
        imagebutton:
            idle im.FactorScale("items/token_item_" + player1Items[3].icon + ".png", 0.2)
            hover im.FactorScale("items/token_item_" + player1Items[3].icon + ".png", 0.25)
            xalign 0.185
            if playerTurn == 1:
                yalign 1.027
            elif playerTurn == 2:
                yalign 1.167
            action [SetVariable("itemChosen", player1Items[3]), Jump("selling_item")]

    if len(player1Items) > 4:
        imagebutton:
            idle im.FactorScale("items/token_item_" + player1Items[4].icon + ".png", 0.2)
            hover im.FactorScale("items/token_item_" + player1Items[4].icon + ".png", 0.25)
            xalign 0.235
            if playerTurn == 1:
                yalign 1.027
            elif playerTurn == 2:
                yalign 1.167
            action [SetVariable("itemChosen", player1Items[4]), Jump("selling_item")]

screen sell_layla:

    if len(player2Items) > 0:
        imagebutton:
            idle im.FactorScale("items/token_item_" + player2Items[0].icon + ".png", 0.2)
            hover im.FactorScale("items/token_item_" + player2Items[0].icon + ".png", 0.25)
            xalign 0.626
            if playerTurn == 2:
                yalign 0.94
            elif playerTurn == 1:
                yalign 1.06
            action [SetVariable("itemChosen", player2Items[0]), Jump("selling_item")]


    if len(player2Items) > 1:
        imagebutton:
            idle im.FactorScale("items/token_item_" + player2Items[1].icon + ".png", 0.2)
            hover im.FactorScale("items/token_item_" + player2Items[1].icon + ".png", 0.25)
            xalign 0.676
            if playerTurn == 2:
                yalign 0.94
            elif playerTurn == 1:
                yalign 1.06
            action [SetVariable("itemChosen", player2Items[1]), Jump("selling_item")]

    if len(player2Items) > 2:
        imagebutton:
            idle im.FactorScale("items/token_item_" + player2Items[2].icon + ".png", 0.2)
            hover im.FactorScale("items/token_item_" + player2Items[2].icon + ".png", 0.25)
            xalign 0.726
            if playerTurn == 2:
                yalign 0.94
            elif playerTurn == 1:
                yalign 1.06
            action [SetVariable("itemChosen", player2Items[2]), Jump("selling_item")]

    if len(player2Items) > 3:
        imagebutton:
            idle im.FactorScale("items/token_item_" + player2Items[3].icon + ".png", 0.2)
            hover im.FactorScale("items/token_item_" + player2Items[3].icon + ".png", 0.25)
            xalign 0.649
            if playerTurn == 2:
                yalign 1.027
            elif playerTurn == 1:
                yalign 1.167
            action [SetVariable("itemChosen", player2Items[3]), Jump("selling_item")]

    if len(player2Items) > 4:
        imagebutton:
            idle im.FactorScale("items/token_item_" + player2Items[4].icon + ".png", 0.2)
            hover im.FactorScale("items/token_item_" + player2Items[4].icon + ".png", 0.25)
            xalign 0.697
            if playerTurn == 2:
                yalign 1.027
            elif playerTurn == 1:
                yalign 1.167
            action [SetVariable("itemChosen", player2Items[4]), Jump("selling_item")]


screen resolve_shop(content):

    if shopItemsPicked == False:
        
        $ shopItemsPicked = True

    if playerTurn == 1:
        $ playerGold = player1Stats["gold"]
        $ playerItems = player1Items

    elif playerTurn == 2:
        $ playerGold = player2Stats["gold"]
        $ playerItems = player2Items

    frame:
        xalign .5 yalign .5
        # ymaximum 300
        xmaximum 1000
        xpadding 30 ypadding 30

        vbox:
            xalign .5
            spacing 20

            if shopSelection != []:
                text "Welcome, customer! What will you buy?":
                    xalign .5
            else:
                text "Alas, I'm out of supplies! Will you sell something?":
                    xalign .5                

            hbox:
                xalign .5
                spacing 100

                for i in shopSelection:
                    vbox:
                        spacing 10
                        xmaximum 250
                        xminimum 250
                        textbutton "Buy":
                            xalign .5
                            action [SensitiveIf(playerGold>=i.value), Function(buyItem, player = playerTurn, item = i), Return()]
                        text i.name:
                            xalign .5

                        text str(i.value) + " coins":
                            xalign .5
                            size 28
                            if playerGold >= i.value:
                                color "#dfda31"
                            else:
                                color "#b93434"
                        image "items/" + i.icon + ".png":
                            xalign .5
                        text i.effect:
                            xalign .5
                            size 28
                            color "#008000"

            hbox:
                xalign .5
                spacing 60
                textbutton "Sell":
                    xalign .5 yalign .5
                    action [SensitiveIf(len(playerItems)>0), Hide("resolve_shop"), Show("sell_screen", playerItems = playerItems, content = content)]

                textbutton "Leave":
                    xalign .5 yalign .5
                    action Return()

# screen sell_screen(playerItems, content):

#     frame:
#         xalign .5 yalign .5
#         # ymaximum 650
#         # xmaximum 1000
#         xpadding 30 ypadding 30

#         vbox:
#             xalign .5
#             spacing 20
#             text "Selling, eh?":
#                 xalign .5

#             grid 4 2:
#                 xalign .5
#                 spacing 100

#                 for i in playerItems:
#                     vbox:
#                         spacing 10
#                         xmaximum 250
#                         xminimum 250
#                         textbutton "Sell":
#                             xalign .5
#                             action [Function(sellItem, player = playerTurn, item = i)]
#                         text i.name:
#                             xalign .5

#                         text str(int(i.value/2)) + " coins":
#                             xalign .5
#                             size 28
#                             color "#dfda31"

#                         image "items/" + i.icon + ".png":
#                             xalign .5
#                         text i.effect:
#                             xalign .5
#                             size 28
#                             color "#008000"


#             hbox:
#                 xalign .5
#                 spacing 60
#                 textbutton "Buy":
#                     xalign .5 yalign .5
#                     action [Hide(), Show("resolve_shop", content = content)]

#                 textbutton "Leave":
#                     xalign .5 yalign .5
#                     action [Hide(), Return()]


label resolve_shop_tutorial:

    $ tutorial_askedToBuyEmblem = False
    "This room is home to a merchant."
    $ shopSelection = [
        getItem("glowing_gem"),
        getItem("emblem"),
        getItem("collar"),
    ]
    # show image "items/card_item_glowing_gem.png" at shopAppear1, Transform(zoom=0.75)
    # show image "items/card_item_collar.png" at shopAppear2, Transform(zoom=0.75)
    # show image "items/card_item_emblem.png" at shopAppear3, Transform(zoom=0.75)

    show screen shop(shopSelection)

    "They'll be selling up to three random items of the current tier."
    "However, you can see he doesn't have the Rope in stock."
    "That's because you already have it on you. But not for long."
    # show screen sell_layla
    $ isShopping = True

    menu:
        "Go ahead, sell the Rope."
        "Leave" if False:
            window hide

# screen buy_tutorial(shopSelection):

#     # hbox at shopAppear:
#     #     spacing -300
#     # for index, i in enumerate(shopSelection):
#         imagebutton at Transform(xalign=0.00, yalign=0.45,rotate=-12):
#             idle im.FactorScale("items/card_item_" + shopSelection[0].icon + ".png", 0.75)
#             hover im.FactorScale("items/card_item_" + shopSelection[0].icon + ".png", 0.78)
#             action [SetVariable("itemChosen", shopSelection[0]), Jump("buying_item_tutorial")]

#         imagebutton at Transform(xalign=0.25, yalign=0.45,rotate=-0):
#             idle im.FactorScale("items/card_item_" + shopSelection[1].icon + ".png", 0.75)
#             hover im.FactorScale("items/card_item_" + shopSelection[1].icon + ".png", 0.78)
#             action [SetVariable("itemChosen", shopSelection[1]), Jump("buying_item_tutorial")]

#         imagebutton at Transform(xalign=0.50, yalign=0.45,rotate=12):
#             idle im.FactorScale("items/card_item_" + shopSelection[2].icon + ".png", 0.75)
#             hover im.FactorScale("items/card_item_" + shopSelection[2].icon + ".png", 0.78)
#             action [SetVariable("itemChosen", shopSelection[2]), Jump("buying_item_tutorial")]            

#             # zoom .75
#             # rotate (index-1)*10

# label buying_item_tutorial:

#     menu:
#         "[itemChosen.name] costs [itemChosen.value] coins. Is this what you want?"
#         "Buy [itemChosen.name]" if itemChosen.name == "Emblem":
#             $ buyItem(playerTurn, itemChosen)
#             $ isShopping = False
#             hide screen buy_tutorial
#             jump tutorial_stock


#         "No" if False:
#             show screen shop(shopSelection)

#             menu:
#                 "What will it be, then?"
#                 "Leave":
#                     $ isShopping = False
#                     window hide
#                     hide screen shop
#                     pause .5
#                     jump between_turn