screen rules():
    
    modal True
    add "table"

    textbutton _("Back") at Transform(rotate=-10):
        xpos 24 ypos -10
        style "menu_note_button"
        action Return()

    viewport:
        mousewheel True
        draggable True
        arrowkeys True
        pagekeys True
        xpos 200 ypos 0
        vbox:
            frame:
                style "paper_frame"
                padding(120,70)
                xsize 1550
                ysize 2450
                vbox:
                    style_prefix "rules"
                    spacing 25
                    vbox:
                        spacing 20
                        xalign .5
                        image "ui/title.png":
                            zoom .65
                            xalign .5
                        text "{color=#42769e}Rule{/color} {color=#c14c4f}Book{/color}":
                            font "MorrisRomanAlternate.ttf"
                            size 72
                            xalign .5
                    null height 10
                    text "The Goal":
                        style "rules_subtitle"
                    hbox:
                        spacing 80
                        xmaximum 1300
                        vbox:
                            spacing 15
                            text "Race against your opponent and be the first to reach either 200 {image=tokenTop} Top Points (for {b}Dominance{/b}) or 200 {image=tokenBottom} Bottom Points (for {b}Submission{/b}) to win the game.":
                                xmaximum 900
                            text "Neither Dominance or Submission matter from a gameplay perspective. Pick whatever path feels best for you but beware: you can't pursue both, and there can be neither two Tops nor two Bottoms...":
                                xmaximum 900
                            text "Reaching the heart icon on one of the gauges levels up triggers a scene, depending on the current dynamics.":
                                xmaximum 900
                            text "{i}This demo ends upon reaching the first level-up at {b}75{/b} Points. The full game will have different stages at 50, 100 and 150, ending with 200.{/i}":
                                xmaximum 900
                        hbox:
                            spacing 10
                            image "ui/gauge_bottom.png"
                            image "ui/gauge_top.png"
                    null height 10
                    text "The Characters":
                        style "rules_subtitle"
                    text "You must pick a character between {color=#42769e}{b}Findrel{/b}{/color} and {color=#c14c4f}{b}Layla{/b}{/color}. Both can be played as either Top or Bottom, which means several games are required to unlock all of their scenes."
                    text "While all the events are common to both, each has different texts and there are a few unique choices tied to their class. Note that Findrel will face {b}female foes{/b} and Layla will face {b}male foes{/b}."
                    text "Each of the two characters has a passive skill, as well as an active skill that can be triggered using {image=miniMana} Mana in specific situations."
                    hbox:
                        spacing 15
                        xfill True
                        # null width 5
                        vbox:
                            spacing 15
                            text "Findrel, the Wizard":
                                color "#42769e"
                                xalign .5
                                font "MorrisRomanAlternate.ttf"
                                size 45
                            text "Faces Female Foes ♀" xalign .5
                            hbox:
                                spacing 15
                                vbox:
                                    xmaximum 250
                                    yalign .5
                                    null height 25
                                    text "Mind drain":
                                        color "#42769e"
                                        bold True
                                        xalign 1.0
                                    text "Passive skill":
                                        xalign 1.0
                                        size 20
                                    text "Restore 1 Mana after {b}Fighting{/b} a foe.":
                                        text_align 1.0

                                    null height 25

                                    text "Gust of wind":
                                        color "#42769e"
                                        bold True
                                        xalign 1.0
                                    text "Active skill":
                                        xalign 1.0
                                        size 20
                                    text "Spend 1 or 2 Mana to move further":
                                        text_align 1.0
                                        
                                image "characters/card_findrel_small.png" zoom .75
                        vbox:
                            spacing 15
                            text "Layla, the Warrior":
                                color "#c14c4f"
                                xalign .5
                                font "MorrisRomanAlternate.ttf"
                                size 45
                            text "Faces Male Foes ♂" xalign .5
                            hbox:
                                spacing 15
                                image "characters/card_layla_small.png" zoom .75
                                vbox:
                                    xmaximum 250
                                    yalign .5
                                    null height 25
                                    text "Brave Heart":
                                        color "#c14c4f"
                                        bold True
                                    text "Passive skill":
                                        size 20
                                    text "Can face foes up to 2 levels stronger"

                                    null height 25

                                    text "Endurance":
                                        color "#c14c4f"
                                        bold True
                                    text "Active skill":
                                        size 20
                                    text "Spend mana after facing a foe to play again"
                            
            frame:
                style "paper_frame"
                padding(120,70)
                xsize 1550
                ysize 2450
                vbox:
                    xalign .5
                    style_prefix "rules"
                    spacing 25
                    vbox:
                        xalign .5
                        spacing 25
                        null height 20
                        text "The Player's Hand":
                            style "rules_subtitle"
                        text "Findrel and Layla are respectively displayed on the bottom left and bottom right sides of the screen, regardless of who you play as."
                        image "board/findrel_sheet.png" xalign .5

                        hbox:
                            vbox:
                                spacing 25
                                # CLASS
                                hbox:
                                    spacing 25
                                    image "ui/class_wizard.png":
                                        zoom 1.25
                                        yalign .5
                                    text "Class": 
                                        bold True
                                        yalign .5
                                    text "The class associated with your character. Some events present unique choices that are only available for either a Wizard or a Warrior.":
                                        yalign .5

                                # LEVEL
                                hbox:
                                    spacing 25
                                    image "ui/level_token_1.png":
                                        zoom 1.25
                                        yalign .5
                                    text "Level":
                                        bold True
                                        yalign .5
                                    text "Required to face stronger foes. It also defines how many points are distributed during a Hero Encounter. Your level increases every time you complete a lap around the board, as well as through certain events or items.":
                                        yalign .5
                                    
                                # MANA
                                hbox:
                                    spacing 25
                                    image "ui/mini_mana.png":
                                        zoom 1.25
                                        yalign .5
                                    text "Mana":
                                        bold True
                                        yalign .5
                                    text "Mana is spent to use your active skill, as well as in certain events. One mana point is restored at the start of each turn.":
                                        yalign .5

                                # MAX MANA
                                hbox:
                                    spacing 25
                                    image "ui/mini_mana_empty.png":
                                        zoom 1.25
                                        yalign .5
                                    text "Max Mana":
                                        bold True
                                        yalign .5
                                    text "The maximum amount of mana you can reach. It starts at 6 but can be raised or lowered through specific item and events.":
                                        yalign .5

                                # GOLD
                                hbox:
                                    spacing 25
                                    image "ui/mini_gold.png":
                                        zoom 1.25
                                        yalign .5
                                    text "Gold":
                                        bold True
                                        yalign .5
                                    text "Coins used at the shop or for certain events. They can be obtained through Gold rooms, events, selling items or fighting foes other than Goblins. Any additional coin beyond the 12 max limit is sent to the Mirror.":
                                        yalign .5

                                # ITEMS
                                hbox:
                                    hbox:
                                        spacing -85
                                        image "items/card_item_aphrodisiac_small.png":
                                            zoom .15
                                            yalign .5
                                            rotate -15
                                        image "items/card_item_gag_small.png":
                                            zoom .15
                                            yalign .5
                                            rotate 15
                                    text "Items":
                                        bold True
                                        yalign .5
                                    null width 25
                                    text "Items giving you various advantages. They can be bought or found in Items rooms, and can also be sold for gold or used in specific events. You can only hold a maximum of 5 items, and there can only be one sample of each.":
                                        yalign .5

                        null height 5
                        text "The Board":
                            style "rules_subtitle"
                        text "The board represents the dungeon. It is made of 22 rooms whose order is randomly generated at the start of each game. These rooms are hidden until a player steps in. You move around using {image=mini_diceP1_1}{image=mini_diceP2_1} Dice you drag and drop. Running a full lap around the board makes you earn a {image=level_1} level."
                        text "When both characters end their turns in the same room, this triggers a {b}Hero Encounter{/b} to widen the gap between them: the dominating character earns Top (and loses Bottom) while the submissive one earns Bottom (and loses Top). The amount of points earned and lost is equal to the character's level."
                        image "board/board.png":
                            xalign .5
                            zoom .60
                            ypos -15

            frame:
                style "paper_frame"
                padding(120,70)
                xsize 1550
                ysize 2450
                vbox:
                    xalign .5
                    style_prefix "rules"
                    spacing 25

                    text "The dungeon can also level up! The piece of board below represents its level gauge, which progresses every time a character gains a level."

                    hbox:
                        xalign .5
                        spacing 40
                        hbox:
                            spacing -105
                            image "board/dungeon_3_lv.png"
                            image "ui/level_token_1.png":
                                ypos 25
                            image "ui/dungeon_arrow.png":
                                ypos 80 xpos 15
                        hbox:
                            spacing -105
                            image "board/dungeon_4_lv.png"
                            image "ui/level_token_4.png":
                                ypos 25
                            image "ui/dungeon_arrow.png":
                                ypos 80 xpos -30
                        hbox:
                            spacing -105
                            image "board/dungeon_5_lv.png"
                            image "ui/level_token_7.png":
                                ypos 25
                            image "ui/dungeon_arrow.png":
                                ypos 80 xpos -60

                    text "Each time the dungeon's level rises, several rooms get hidden again and their {b}Tier{/b} increases, offering new events, stronger foes and better items."
                    text "There are four Tiers in total ({i}only two in this demo{/i}), and part of the first Tier is locked until the dungeon's first level up."

                    null height 20
                    text "The Rooms":
                        style "rules_subtitle"

                    vbox:
                        text "During your turn, you will step into one of these dungeon rooms. Although their order differ from one game to another, their number is always the same."
                        spacing 20
                        xalign .5
                        null height 5
                        grid 4 2:
                            xalign .5
                            spacing 10
                            hbox:
                                xsize 250
                                spacing 10
                                
                                image "circles/event.png"
                                vbox:
                                    yalign .5
                                    text "Event":
                                        bold True
                                        xalign .5
                                    text "(6)":
                                        xalign .5
                                        
                            hbox:
                                xsize 250
                                spacing 10
                                image "circles/encounter.png"
                                vbox:
                                    yalign .5
                                    text "Encounter":
                                        bold True
                                        xalign .5
                                    text "(5)":
                                        xalign .5
                            hbox:
                                xsize 250
                                spacing 10
                                image "circles/gold.png"
                                vbox:
                                    yalign .5
                                    text "Gold":
                                        bold True
                                        xalign .5
                                    text "(4)":
                                        xalign .5
                            hbox:
                                xsize 250
                                spacing 10
                                image "circles/shop.png"
                                vbox:
                                    yalign .5
                                    text "Shop":
                                        bold True
                                        xalign .5
                                    text "(3)":
                                        xalign .5

                            hbox:
                                xsize 250
                                spacing 10
                                image "circles/item.png"
                                vbox:
                                    yalign .5
                                    text "Item":
                                        bold True
                                        xalign .5
                                    text "(2)":
                                        xalign .5

                            hbox:
                                xsize 250
                                spacing 10
                                image "circles/start.png"
                                vbox:
                                    yalign .5
                                    text "Entrance":
                                        bold True
                                        xalign .5
                                    text "(1)":
                                        xalign .5
                            hbox:
                                xsize 250
                                spacing 10
                                image "circles/mirror.png"
                                vbox:
                                    yalign .5
                                    text "Mirror":
                                        bold True
                                        xalign .5
                                    text "(1)":
                                        xalign .5
                            hbox:
                                xsize 250
                                spacing 10
                                image "circles/unknown.png"
                                vbox:
                                    yalign .5
                                    text "Unknown":
                                        bold True
                                        xalign .5
                                    text "(?)":
                                        xalign .5
                        null height 5
                        text "While the dungeon is still Lv. 0, one of the three Shop rooms is replaced by a Gold room and the Mirror room is replaced by an Event room, which are more useful at the beginning of the game."
                        null height 10

                        hbox:
                            xalign 1.0
                            spacing 35
                            vbox:
                                spacing 25
                                yalign .5
                                xmaximum 700
                                image "circles/event.png" xalign 1.0
                                hbox:
                                    xalign 1.0
                                    spacing 30
                                    text "Event Rooms":
                                        align (1.0,.5)
                                        size 42
                                        font "MorrisRomanAlternate.ttf"
                                        color "#68aac9"
                                text "Events present choices that often result in stats, gold or level gains and losses. Every option's consequence is visible so as to let you choose knowingly.":
                                    text_align 1.0
                                text "Both characters face the same events, although their description and choices are worded differently. Some events however do have choices unique to a class, as Wizards and Warriors each have their own ways of solving problems.":
                                    text_align 1.0
                            image "events/event_the_troll.png" zoom .75

                        hbox:
                            spacing 35
                            image "encounters/card_goblin_f.png" zoom .75
                            vbox:
                                spacing 25
                                yalign .5
                                xmaximum 700
                                image "circles/encounter.png"
                                hbox:
                                    spacing 30
                                    text "Encounter Rooms":
                                        yalign .5
                                        size 42
                                        font "MorrisRomanAlternate.ttf"
                                        color "#db5a48"
                                text "Encounters have you face the dungeon's denizens. At low level, your only option is to {b}Escape{/b}, otherwise you can {b}Fight{/b} them to earn gold (except for Goblins)."
                                text "If your Top or Bottom points are high enough, you can also {b}Dominate{/b} or {b}Submit{/b} to them. You earn and lose points depending on the option you picked, which means you can't be both Dominant and Submissive."

            frame:
                style "paper_frame"
                padding(120,70)
                xsize 1550
                ysize 2650
                vbox:
                    xalign .5
                    style_prefix "rules"
                    spacing 25

                    hbox:
                        xalign 1.0
                        spacing 35
                        vbox:
                            spacing 25
                            yalign .5
                            xmaximum 700
                            image "circles/item.png" xalign 1.0
                            hbox:
                                xalign 1.0
                                spacing 30
                                text "Item Rooms":
                                    align (1.0,.5)
                                    size 42
                                    font "MorrisRomanAlternate.ttf"
                                    color "#d89551"
                            text "Items can be freely found in these rooms, provided you don't already carry the maximum limit of 5 items. In this case, you will be offered to discard one of your items before picking the new one.":
                                text_align 1.0
                            text "If every item of the current Tier is already in game, as there can only be one copy of each, these rooms will contain gold coin instead.":
                                text_align 1.0
                        image "items/card_item_leash.png" zoom .75

                    hbox:
                        spacing 25
                        vbox:
                            spacing 25
                            xmaximum 450
                            image "circles/gold.png":
                                xalign .5
                            text "Gold Rooms":
                                xalign .5
                                size 42
                                font "MorrisRomanAlternate.ttf"
                                color "#dcc24a"
                            text "You will find one or several coins in these rooms, depending on the room's {b}Tier{/b}.":
                                text_align .5

                        vbox:
                            spacing 25
                            xmaximum 450
                            image "circles/shop.png":
                                xalign .5
                            text "Shop Rooms":
                                xalign .5
                                size 42
                                font "MorrisRomanAlternate.ttf"
                                color "#7852c1"
                            text "A merchant will offer a selection of 3 items, if they are not already in either of the player's hand.":
                                text_align .5

                        vbox:
                            spacing 25
                            xmaximum 450
                            image "circles/start.png":
                                xalign .5
                            text "Entrance Room":
                                xalign .5
                                size 42
                                font "MorrisRomanAlternate.ttf"
                                color "#73bf7c"
                            text "Passing through the starting grants you a level, and ending your turn here allows you to play again.":
                                text_align .5
                
                    null height 20
                    hbox:
                        spacing 35
                        frame at Transform(xalign=0.95, yalign=0.5, rotate=8):
                            style "lore_note_frame"
                            padding (10,10)
                            xsize 225
                            ysize 330
                        
                            image "mirror" at Transform(rotate=270):
                                xpos 60 ypos -70
                            text "In Mirror" :
                                style "stock_text"
                                xpos 10 ypos 35
                            
                            hbox:
                                spacing 5
                                xpos 16 ypos 100
                                text "6":
                                    style "stock_points"
                                    yalign .5
                                image "tokenTop":
                                    yalign .5
                                    zoom 1.2

                            hbox:
                                spacing 5
                                xpos 95 ypos 160
                                image "mini_gold":
                                    yalign .5
                                text "3":
                                    style "stock_points"
                                    yalign .5

                            hbox:
                                spacing 5
                                xpos 21 ypos 220
                                text "0":
                                    style "stock_points"
                                    yalign .5
                                image "tokenBottom":
                                    yalign .5
                                    zoom 1.2
                        # null height 20
                        vbox:
                            spacing 25
                            yalign .5
                            xmaximum 700
                            # image "circles/mirror.png"
                            hbox:
                                spacing 30
                                text "Mirror Room":
                                    yalign .5
                                    size 42
                                    font "MorrisRomanAlternate.ttf"
                                    color "#5acabb"
                            text "The Mirror room allows a player to interact with other possibilies. In clearer words, it lets you spend Mana to collect Gold, Top or Bottom points stored in a pool."
                            text "Every time a player loses Top or Bottom points, the lost points are stored in this pool and can be {b}reclaimed by either player{/b}, if their corresponding stat is higher than the pool's content."
                            text "Gold is only stored in the Mirror pool if a player earns coins while they are already carrying the maximum amount (12)."


                    null height 5
                    text "The Game Master's Tips":
                        style "rules_subtitle"
                    null height 5
                    vbox:
                        xpos 150 spacing 20 xmaximum 1200
                        text "▪ If you are trying to play Dominant and your opponent has more Top points than you in early game, you can either try to catch up with them, or switch to Submissive instead."
                        text "▪ There can be only one of each item in the game at any given time: if an item is vital to your opponent, you can pick it up or buy it only so that they don't end up in their hand."
                        text "▪ Don't hoard your money! Every coin you get after reaching the maximum amount (12) will be stored in the Mirror, where it can be reclaimed by any player (especially your opponent!)"
                    null height 5

                    text "The Dev's Notes":
                        style "rules_subtitle"
                    null height 5
                    vbox:
                        xpos 150 spacing 20 xmaximum 1200
                        text "▪ There is a SFW (Safe for Work) mode option to enable in the Settings, for people who wish to disable erotic content. ({i}Not implemented in demo{/i})"
                        text "▪ You can change the background napkin anytime in the Settings."
                        text "▪ This game was brought to you by {b}PopotoProductions{/b}. Character designs and sex scenes by {b}Pululon{/b}, events images by {b}Elz{/b}, items and board tokens by {b}Michelle Beldam{/b} and music by {b}Muchkin{/b}."
                        text "▪ Thank you for playing this demo! Feel free to {b}{color=#136fa1}wishlist the game{/color}{/b} on Steam~"

                textbutton _("Click here! {image=steam_logo}") at Transform(rotate=-10):
                    xalign 1.325 yalign 1.07
                    padding (15,15)
                    # xpos 24 ypos -10
                    style "menu_note_button"
                    action OpenURL("https://store.steampowered.com/app/3973280/Tabletops__Bottoms/")
