## Lore screen ##########################################################

screen locking_post_it(player, locks):

    for i in locks:
        if not i.isUnlocked:
            frame at Transform(rotate=i.rotate):
                style i.color + "_post_it"
                xsize i.size[0]
                ysize i.size[1]
                pos i.pos
                vbox:
                    align (.5,.5)
                    text i.text:
                        xalign .5
                        if player == 1:
                            style "lore_note_text_findrel"
                        else:
                            style "lore_note_text_layla"
                    image "ui/lock_icon.png":
                        xalign .5
                    text "(Not in demo)":
                        style "lore_note_text_locked"

screen switch_character_sheet(player):

    # frame at Transform(rotate=240):
    #     style "paper_frame"
    #     xpos 1250
    #     ypos 200
    #     padding(120,70)
    frame at Transform(rotate=-14):
        style "paper_frame"
        xpos 1500
        ypos 200
        padding(120,70)
        vbox:
            spacing 30
            vbox:
                frame:
                    style_prefix "lore_header"
                    xsize 500
                    ysize 70
                    text "Character Name":
                        size 42
                frame:
                    style_prefix "lore_note"
                    xsize 500
                    ysize 95
                    if player == 1:
                        text "Findrel Leyruvian":
                            size 70
                    else:
                        text "Layla Kinstalker":
                            size 70
     
            if player == 1:
                imagebutton:
                    idle "characters/sheet_findrel.png"
                    xpos -30
                    # action Quit(confirm=True)
                    action ShowMenu("lore", player=1)
            else:
                imagebutton:
                    idle "characters/sheet_layla.png"
                    xpos -30
                    action ShowMenu("lore", player=2)

screen lore(player):

    $ locks = getLocks(player)

    tag menu
    add "table"

    textbutton _("Back") at Transform(rotate=-10):
        xpos 24 ypos -10
        style "menu_note_button"
        action Return()

    $ characterSheetInfo = getCharacterSheetInfo("Findrel" if player == 1 else "Layla")

    viewport:
        mousewheel True
        arrowkeys True
        pagekeys True
        xpos 200 ypos 0
        
        vbox:
            
            frame:
                # Layla Page 1
                style "paper_frame"
                # xmaximum 1350
                # ysize 2000
                # xalign .5
                padding(120,70)
                xsize 1550
                ysize 2000


                hbox:
                    spacing 80
                    # Left Side
                    vbox:
                        spacing 40
                        grid 2 2:
                            spacing 25
                            hbox:
                                # Race
                                frame:
                                    ysize 70 xsize 120
                                    style_prefix "lore_header"
                                    text _("Race")
                                    
                                frame:
                                    ysize 70 xsize 200
                                    style_prefix "lore_note"
                                    text characterSheetInfo["race"]

                            hbox:
                                # Age
                                frame:
                                    style_prefix "lore_header"
                                    text _("Age")
                                    ysize 70 xsize 120
                                frame:
                                    ysize 70 xsize 200
                                    style_prefix "lore_note"
                                    text characterSheetInfo["age"]

                            hbox:
                                # Class
                                frame:
                                    style_prefix "lore_header"
                                    text "Class"
                                    ysize 70 xsize 120
                                frame:
                                    ysize 70 xsize 200
                                    style_prefix "lore_note"
                                    text characterSheetInfo["class"]

                            hbox:
                                # Spec.
                                frame:
                                    style_prefix "lore_header"
                                    text "Spec."
                                    ysize 70 xsize 120
                                frame:
                                    ysize 70 xsize 200
                                    style_prefix "lore_note"
                                    text characterSheetInfo["spec"]

                        if sfwMode:
                            frame:
                                style "orange_post_it"
                                xsize 800 ysize 250

                        else:
                            hbox:
                                spacing 25
                                vbox:
                                    # Background.
                                    frame:
                                        style_prefix "lore_header"
                                        ysize 70 xsize 320
                                        text "Background"
                                    frame:
                                        style_prefix "lore_note"
                                        ysize 70 xsize 320
                                        text characterSheetInfo["background"]

                                
                                vbox:
                                    # Alignment.
                                    frame:
                                        style_prefix "lore_header"
                                        ysize 70 xsize 320
                                        text "Alignment"
                                    frame:
                                        style_prefix "lore_note"
                                        ysize 70 xsize 320
                                        text characterSheetInfo["alignment"]

                        hbox:
                            spacing 25
                            xalign .5
                            frame:
                                style "lore_note_frame"
                                xpadding 15
                                ypadding 15
                                vbox:
                                    spacing 15
                                    # Characteristics
                                    for i in ["STR", "DEX", "CON", "INT", "WIS", "CHR"]:
                                        hbox:
                                            frame:
                                                ysize 50 xsize 80
                                                style_prefix "lore_header"
                                                text "[i]"
                                            frame:
                                                ysize 50 xsize 100
                                                style_prefix "lore_note"
                                                text characterSheetInfo[i]
                            frame:
                                style "lore_note_frame"
                                xpadding 15
                                ypadding 15
                                vbox:
                                    spacing 12
                                    hbox:
                                        # Level
                                        frame:
                                            ysize 69 xsize 80
                                            style_prefix "lore_header"
                                            text "Level"
                                        frame:
                                            ysize 69 xsize 100
                                            style_prefix "lore_note"
                                            text characterSheetInfo["level"]:
                                                size 80
                                    vbox:
                                        # Health Points
                                        frame:
                                            style_prefix "lore_header"
                                            ysize 40 xsize 180
                                            text "Health Pts"
                                        frame:
                                            style_prefix "lore_note"
                                            ysize 50 xsize 180
                                            text characterSheetInfo["HP"]

                                    vbox:
                                        # Mana Points
                                        frame:
                                            style_prefix "lore_header"
                                            ysize 40 xsize 180
                                            text "Mana Pts"
                                        frame:
                                            style_prefix "lore_note"
                                            ysize 50 xsize 180
                                            text characterSheetInfo["MP"]

                                    vbox:
                                        # Stamina Points
                                        frame:
                                            style_prefix "lore_header"
                                            ysize 40 xsize 180
                                            text "Stamina Pts"
                                        frame:
                                            style_prefix "lore_note"
                                            ysize 50 xsize 180
                                            text characterSheetInfo["SP"]    

                        vbox:
                            frame:
                                style_prefix "lore_header"
                                ysize 60 xsize 665
                                text "Skills":
                                    size 42
                            frame:
                                ysize 490 xsize 665
                                style "lore_note_frame"

                                grid 3 4:
                                    align(.5,.5)
                                    spacing 15
                                    for i in ["Athletics", "Acrobatics", "Thievery", "Awareness", "Survival", "Nature", "Entertain", "Speech", "Knowledge", "Arcana", "Medecine", "Mechanics"]:
                                        vbox:
                                            # Skills
                                            frame:
                                                style_prefix "lore_header"
                                                ysize 40 xsize 200
                                                text "[i]"
                                            frame:
                                                style_prefix "lore_note"
                                                ysize 60 xsize 200
                                                text characterSheetInfo[i]


                        vbox:
                            frame:
                                style_prefix "lore_header"
                                ysize 60 xsize 665
                                text "Sex Skills":
                                    size 42
                            frame:
                                ysize 280 xsize 665
                                style "lore_note_frame"

                                grid 3 2:
                                    align(.5,.5)
                                    spacing 15
                                    for i in ["Seduction", "Hands", "Oral", "Vaginal", "Anal", "Penile"]:
                                        vbox:
                                            # Sex skills
                                            frame:
                                                style_prefix "lore_header"
                                                ysize 40 xsize 200
                                                text "[i]"
                                            frame:
                                                style_prefix "lore_note"
                                                ysize 60 xsize 200
                                                text characterSheetInfo[i]
                                    
                    vbox:
                        spacing 30
                        vbox:
                            frame:
                                style_prefix "lore_header"
                                xsize 500
                                ysize 70
                                text "Character Name":
                                    size 42
                            frame:
                                style_prefix "lore_note"
                                xsize 500
                                ysize 95
                                text characterSheetInfo["name"]:
                                    size 70
                            image characterSheetInfo["portrait"]:
                                xpos -30
                        vbox:
                            frame:
                                style_prefix "lore_header"
                                xsize 500
                                ysize 70
                                text "Traits":
                                    size 42
                            frame:
                                style_prefix "lore_note"
                                xsize 500
                                ysize 300
                                text characterSheetInfo["traits"]
   
                        vbox:
                            frame:
                                style_prefix "lore_header"
                                xsize 500
                                ysize 70
                                text "Equipment":
                                    size 42
                            frame:
                                style_prefix "lore_note"
                                xsize 500
                                ysize 500
                                text characterSheetInfo["equipment"]

                use locking_post_it(player, locks[0])
            
            frame:
                # Layla Page 2
                style "paper_frame"
                # xmaximum 1350
                # ysize 2000
                # xalign .5
                padding(120,70)
                xsize 1550
                ysize 2000

                vbox:
                    spacing 40
                    hbox:
                        spacing 80
                        vbox:
                            spacing 25
                            hbox:
                                spacing 25
                                hbox:
                                    # Home
                                    frame:
                                        ysize 70 xsize 120
                                        style_prefix "lore_header"
                                        text "Home"
                                        
                                    frame:
                                        ysize 70 xsize 200
                                        style_prefix "lore_note"
                                        text characterSheetInfo["home"]

                                hbox:
                                    # God
                                    frame:
                                        ysize 70 xsize 120
                                        style_prefix "lore_header"
                                        text "God"
                                        
                                    frame:
                                        ysize 70 xsize 200
                                        style_prefix "lore_note"
                                        text "Halforas"

                            hbox:
                                # Goal
                                frame:
                                    ysize 70 xsize 120
                                    style_prefix "lore_header"
                                    text "Goal"
                                    
                                frame:
                                    ysize 70 xsize 545
                                    style_prefix "lore_note"
                                    text characterSheetInfo["goal"]:
                                        size 40

                            hbox:
                                # Flaws
                                frame:
                                    ysize 70 xsize 120
                                    style_prefix "lore_header"
                                    text "Flaws"
                                    
                                frame:
                                    ysize 70 xsize 545
                                    style_prefix "lore_note"
                                    text characterSheetInfo["flaws"]:
                                        size 40
                        

                        vbox:
                            frame:
                                style_prefix "lore_header"
                                xsize 560
                                ysize 70
                                text "Secret":
                                    size 42
                            frame:
                                style_prefix "lore_note"
                                xsize 560
                                ysize 200
                                padding(20,20)
                                text characterSheetInfo["secret"]:
                                    size 36

                    vbox:
                        frame:
                            style_prefix "lore_header"
                            xsize 1305
                            ysize 70
                            text "Backstory":
                                size 42
                        frame:
                            style_prefix "lore_note"
                            xsize 1305
                            ysize 350
                            padding(20,20)
                            text characterSheetInfo["backstory"]:
                                size 32

                    hbox:
                        spacing 55
                        vbox:
                            frame:
                                style_prefix "lore_header"
                                xsize 550
                                ysize 70
                                text "Bonds":
                                    size 42
                            frame:
                                style_prefix "lore_note"
                                xsize 550
                                ysize 930
                                padding(20,20)
                                text characterSheetInfo["bonds"]:
                                    size 36
                                    yalign .05
                        frame:
                            xpadding 25 ypadding 25
                            style_prefix "lore_note"
                            vbox:
                                spacing 25
                                vbox:
                                    # Behaviour
                                    frame:
                                        ysize 50 xsize 650
                                        style_prefix "lore_header"
                                        text "Behaviour"
                                        
                                    frame:
                                        ysize 50 xsize 650
                                        style_prefix "lore_note"
                                        text characterSheetInfo["behaviour"]:
                                            size 40
                                vbox:
                                    # First time
                                    frame:
                                        ysize 50 xsize 650
                                        style_prefix "lore_header"
                                        text "First time"
                                        
                                    frame:
                                        ysize 200 xsize 650
                                        padding(20,20)
                                        style_prefix "lore_note"
                                        text characterSheetInfo["first time"]:
                                            size 32

                                vbox:
                                    # Preferences
                                    frame:
                                        ysize 50 xsize 650
                                        style_prefix "lore_header"
                                        text "Preferences"
                                        
                                    frame:
                                        ysize 50 xsize 650
                                        style_prefix "lore_note"
                                        text characterSheetInfo["preferences"]:
                                            size 40

                                vbox:
                                    # Kinks
                                    frame:
                                        ysize 50 xsize 650
                                        style_prefix "lore_header"
                                        text "Kinks"
                                        
                                    frame:
                                        ysize 50 xsize 650
                                        style_prefix "lore_note"
                                        text characterSheetInfo["kinks"]:
                                            size 40

                                vbox:
                                    # Weaknesses
                                    frame:
                                        ysize 50 xsize 650
                                        style_prefix "lore_header"
                                        text "Weaknesses"
                                        
                                    frame:
                                        ysize 50 xsize 650
                                        style_prefix "lore_note"
                                        text characterSheetInfo["weaknesses"]:
                                            size 40

                                vbox:
                                    # Insecurities
                                    frame:
                                        ysize 50 xsize 650
                                        style_prefix "lore_header"
                                        text "Insecurities"
                                        
                                    frame:
                                        ysize 50 xsize 650
                                        style_prefix "lore_note"
                                        text characterSheetInfo["insecurities"]:
                                            size 40

                                hbox:
                                    # Safe word
                                    frame:
                                        ysize 50 xsize 200
                                        style_prefix "lore_header"
                                        text "Safe word"
                                        
                                    frame:
                                        ysize 50 xsize 450
                                        style_prefix "lore_note"
                                        text characterSheetInfo["safe word"]:
                                            size 40

                use locking_post_it(player, locks[1])
            null height 150

    use switch_character_sheet(2 if player==1 else 1)