init python:


    # MOVEMENT

    def movePlayerToken(playerTurn, movement):

        playerToken = "player1" if playerTurn == 1 else "player2"

        # if playerTurn == 1:
        while movement > 0:
            playerPosition[playerTurn] += 1
            if playerPosition[playerTurn] > 21:
                playerPosition[playerTurn] = 0
                renpy.show(playerToken, at_list=[movingPlayerToken])
                addLevel(playerTurn, 1)
            else:
                renpy.show(playerToken, at_list=[movingPlayerToken])

            renpy.pause(0.10)
            renpy.play("sounds/tap" + str(renpy.random.randint(1,4)) + ".mp3")
            renpy.pause(0.15)
            movement -= 1

    def showCurrentCircle(circle):

        renpy.show(circle.circleAppearance + "Big", at_list=[appearingUp])

    def revealCircle(circle):

        renpy.show(circle.circleAppearance + "Big", at_list=[reveal_hideOld])
        renpy.pause(0.3)
        renpy.show(circle.circleType + "Big", at_list=[reveal_showNew])


    def hideCircle(circle):

        renpy.hide(circle.circleAppearance + "Big")

    def resolveCircle(circleAppearance, circleContent):

        globals()["currentRoom"] = circleContent
        
        if playMode != "tutorial":
            renpy.jump("resolve_" + circleAppearance)
        else:
            renpy.jump("resolve_" + circleAppearance + "_tutorial")

    # TUTORIALS

    def backToTutorial():

        if tutorialTurn == 1:
            renpy.jump("tutorial_gold")

        elif tutorialTurn == 2:
            renpy.jump("tutorial_encounter")

        elif tutorialTurn == 3:
            renpy.jump("tutorial_item")

        elif tutorialTurn == 4:
            renpy.jump("tutorial_event")

        elif tutorialTurn == 5:
            renpy.jump("tutorial_shop")

        elif tutorialTurn == 6:
            renpy.jump("tutorial_encounter_2")

        elif tutorialTurn == 7:
            renpy.jump("tutorial_encounter_2")

        elif tutorialTurn == 8:
            renpy.jump("tutorial_mirror")

        elif tutorialTurn == 9:
            renpy.jump("tutorial_mirror")

        elif tutorialTurn == 10:
            renpy.jump("tutorial_end")

    def tutorializeCircle(newType):

        circles[playerPosition[playerTurn]].circleType = newType

    # DUNGEON BOARD STATE

    def updateBoard(dungeonLevel):

        if dungeonLevel == 1:
            changeRooms([["event", "mirror"], ["gold","shop"]])

        elif dungeonLevel == 2:
            upgradeRooms(1, ["encounter", "encounter", "event", "event", "gold", "shop"])

        elif dungeonLevel == 3:
            upgradeRooms(1, ["encounter", "encounter", "event", "gold", "gold", "shop", "item"])

        elif dungeonLevel == 4:
            upgradeRooms(1, ["encounter", "encounter", "event", "event", "gold", "shop", "item"])

        elif dungeonLevel == 5:
            upgradeRooms(2, ["encounter", "encounter", "event", "event", "gold", "shop"])

        elif dungeonLevel == 6:
            upgradeRooms(2, ["encounter", "encounter", "event", "gold", "gold", "shop", "item"])

        elif dungeonLevel == 7:
            upgradeRooms(2, ["encounter", "encounter", "event", "event", "gold", "shop", "item"])

        elif dungeonLevel == 8:
            upgradeRooms(3, ["encounter", "encounter", "event", "event", "gold", "shop"])

        elif dungeonLevel == 9:
            upgradeRooms(3, ["encounter", "encounter", "event", "gold", "gold", "shop", "item"])

        elif dungeonLevel == 10:
            upgradeRooms(3, ["encounter", "encounter", "event", "event", "gold", "shop", "item"])

    def upgradeRooms(levelToUpgrade, selectionToUpgrade):

        while len(selectionToUpgrade)>0:
        # selectedRoom = renpy.numpy.random.choice(globals()["circles"], size=1)
            for j in renpy.random.sample(globals()["circles"],len(globals()["circles"])):
                if len(selectionToUpgrade)>0:
                    if j.circleType == selectionToUpgrade[0] and j.tier == levelToUpgrade-1:
                        j.circleType = selectionToUpgrade[0]
                        j.tier = levelToUpgrade
                        j.circleAppearance = "unknown"
                        del selectionToUpgrade[0]

        refreshBoard(True)

    def changeRooms(selectionToChange):

        # selectedRoom = renpy.numpy.random.choice(globals()["circles"], size=1)
        for i in selectionToChange:
            print(i[0])
            for j in renpy.random.sample(globals()["circles"],len(globals()["circles"])):
                print(j.circleType)
                if j.circleType == i[0]:
                    j.circleType = i[1]
                    j.circleAppearance = "unknown"
                    del i
                    break

        refreshBoard(True)

    def refreshBoard(isInstant):

        for i in circles:
            renpy.show(i.circleAppearance, at_list=[Transform(xpos=i.xpos + 0,ypos=i.ypos,xanchor=.5, yanchor=.5)], tag=str(i.nb))
            if not isInstant:
                randomDuration = renpy.random.randint(5, 15)
                renpy.pause(randomDuration/100)

    def seeBoard():
        renpy.scene()

    def getCurrentRoom():
        return circles[playerPosition[playerTurn]]

    def getCurrentMaxTier():
        if dungeonLevel < 2:
            return 0
        else:
            return 1

    # CHARACTERS DYNAMICS

    def whoIsLeading():
        FindrelMaxValue = player1Stats["top"] if player1Stats["top"] > player1Stats["bottom"] else player1Stats["bottom"]
        LaylaMaxValue = player2Stats["top"] if player2Stats["top"] > player2Stats["bottom"] else player2Stats["bottom"]
        
        if FindrelMaxValue > LaylaMaxValue:
            return 1
        elif LaylaMaxValue > FindrelMaxValue:
            return 2
        else:
            return 0

    def whoTopsMeeting(topPlayer, bottomPlayer):
        topPlayerLv = globals()["player" + str(topPlayer) + "Stats"]["level"]
        bottomPlayerLv = globals()["player" + str(bottomPlayer) + "Stats"]["level"]

        addTopPoints(topPlayer, topPlayerLv)
        removeBottomPoints(topPlayer, topPlayerLv)

        addBottomPoints(bottomPlayer, bottomPlayerLv)
        removeTopPoints(bottomPlayer, bottomPlayerLv)

    def playersMeetUp():
        globals()["chanceEncounterCounter"] += 1

        if chanceEncounterCounter == 1:
            globals()["chanceEncounterTheme"] = "first_encounter"
        else:
            globals()["chanceEncounterTheme"] = "other_encounter"

        renpy.call_in_new_context("chance_encounter")


    def isThresholdReached():

        if player1Stats["top"] >= eventThreshold[eventCounter]:
            renpy.call_in_new_context("event_" + str(eventCounter+1) + "_findrel")
        elif player2Stats["top"] >= eventThreshold[eventCounter]: 
            renpy.call_in_new_context("event_" + str(eventCounter+1) + "_layla")
        elif player1Stats["bottom"] >= eventThreshold[eventCounter]:
            renpy.call_in_new_context("event_" + str(eventCounter+1) + "_layla")
        elif player2Stats["bottom"] >= eventThreshold[eventCounter]: 
            renpy.call_in_new_context("event_" + str(eventCounter+1) + "_findrel")

    # OTHER MENUS

    def getRandomColor():

        colors = ["orange", "yellow", "red"]
        return renpy.random.choice(colors)

    def getGalleryPostItText(cardPath, cardCollection):

        if cardCollection == "charactersSexCards":
            texts = {
                "scenes/findrel1" : "Findrel Top x Layla Bottom",
                "scenes/layla1" : "Layla Top x Findrel Bottom ",
            }

        elif cardCollection == "foesCards":
            texts = {
                "encounters/card_goblin_f" : "Goblin F",
                "encounters/card_goblin_m" : "Goblin M",
                "encounters/card_kobold_f" : "Kobold F",
                "encounters/card_kobold_m" : "Kobold M",
                "encounters/card_slime_f" : "Slime F",
                "encounters/card_slime_m" : "Slime M",
            }

        elif cardCollection == "foesSexCardsFindrel":
            texts = {
                "scenes/goblin_f_top" : "Top Findrel x Goblin F",
                "scenes/goblin_f_bottom" : "Bottom Findrel x Goblin F",
                "scenes/kobold_f_top" : "Top Findrel x Kobold F",
                "scenes/kobold_f_bottom" : "Bottom Findrel x Kobold F",
            }

        elif cardCollection == "foesSexCardsLayla":
            texts = {
                "scenes/goblin_m_top" : "Top Layla x Goblin F",
                "scenes/goblin_m_bottom" : "Bottom Layla x Goblin F",
                "scenes/kobold_m_top" : "Top Layla x Kobold F",
                "scenes/kobold_m_bottom" : "Bottom Layla x Kobold F",
            }

        elif cardCollection == "eventsCards":
            texts = {
                "events/event_the_merchant" : "The Merchant",
                "events/event_the_troll" : "The Troll",
                "events/event_the_tavern" : "The Tavern",
                "events/event_the_training" : "The Training",
                "events/event_the_offering" : "The Offering",
                "events/event_the_pool" : "The Pool",
                "events/event_the_impotent" : "The Impotent",
                "events/event_the_gaol" : "The Gaol",
                "events/event_the_sorceress" : "The Sorceress",
                "events/event_the_adventurer" : "The Adventurer",
            }
        elif cardCollection == "itemsCards":
            texts = {
                "items/card_item_collar" : "Collar",
                "items/card_item_rope" : "Rope",
                "items/card_item_aphrodisiac" : "Aphrodisiac",
                "items/card_item_emblem" : "Emblem",
                "items/card_item_glowing_gem" : "Glowing gem",
                "items/card_item_gag" : "Gag",
                "items/card_item_leash" : "Leash",
                "items/card_item_lube" : "Lube",
                "items/card_item_ring_of_fortune" : "Ring of Fortune",
                "items/card_item_quickstep_boots" : "Quickstep Boots",
            }

        return texts[cardPath]

    def zoomCharacterCard(character):
        globals()["zoomedCardPath"] = "characters/card_" + character + "_big.png"
        renpy.call_in_new_context("card_zoom")

    def zoomEncounterCard():
        globals()["zoomedCardPath"] = "encounters/card_" + currentRoom + "_" + enemySex + "_big.png"
        renpy.call_in_new_context("card_zoom")

    def zoomItemCard():
        globals()["zoomedCardPath"] = "items/card_item_" + currentRoom + "_big.png"
        renpy.call_in_new_context("card_zoom")

    def zoomEventCard():
        globals()["zoomedCardPath"] = "events/" + currentRoom + "_big.png"
        renpy.call_in_new_context("card_zoom")

    def zoomSexCard():
        globals()["zoomedCardPath"] = "scenes/" + currentRoom + "_" + enemySex + "_" + lastChoice + "_big.png"
        renpy.call_in_new_context("card_zoom")

    def zoomThresholdCard(sceneId):
        globals()["zoomedCardPath"] = "scenes/" + sceneId + "_big.png"
        renpy.call_in_new_context("card_zoom")

    def zoomGalleryCard(imgPath):
        globals()["isInGallery"] = True
        globals()["zoomedCardPath"] = imgPath + "_big.png"
        # renpy.jump("card_zoom")
        # renpy.call_in_new_context("card_zoom")
        renpy.show_screen("card_zoom", zoomedCardPath)

    def getLocks(player):
        playerName = "Findrel" if player == 1 else "Layla"
        otherPlayerName = "Layla" if player == 1 else "Findrel"

        locks = [[],[]]

        locks[0].append(LockPostIt(
            "Play 20 turns as " + playerName,
            False, # TBA
            getRandomColor(),
            -30,
            (600,300),
            (55,-60),
        ))

        locks[0].append(LockPostIt(
            "Reach Lv.15 as " + playerName,
            False, # TBA
            getRandomColor(),
            5,
            (480,500),
            (10,780),
        ))

        locks[0].append(LockPostIt(
            "Face 30 foes as " + playerName,
            False, # TBA
            getRandomColor(),
            25,
            (350,330),
            (700,730),
        ))

        locks[0].append(LockPostIt(
            "Collect 25 items as " + playerName,
            False, # TBA
            getRandomColor(),
            -12,
            (250,500),
            (740,1180),
        ))

        locks[0].append(LockPostIt(
            "Seduce 10 foes as " + playerName,
            False, # TBA
            getRandomColor(),
            -3,
            (560,200),
            (50,1350),
        ))

        locks[1].append(LockPostIt(
            "Buy 15 items as " + playerName,
            False, # TBA
            getRandomColor(),
            -10,
            (230,300),
            (50,-15),
        ))

        locks[1].append(LockPostIt(
            "Sell 15 items as " + playerName,
            False, # TBA
            getRandomColor(),
            2,
            (260,285),
            (310,-30),
        ))

        locks[1].append(LockPostIt(
            "???",
            False, # TBA
            getRandomColor(),
            8,
            (460,220),
            (770,-75),
        ))

        locks[1].append(LockPostIt(
            "Win a game as a Bottom " + playerName,
            False, # TBA
            getRandomColor(),
            -1,
            (1250,220),
            (30,0),
        ))

        locks[1].append(LockPostIt(
            "Win a game as a Top " + playerName,
            False, # TBA
            getRandomColor(),
            1,
            (1250,220),
            (10,-180),
        ))

        locks[1].append(LockPostIt(
            "Encounter " + otherPlayerName + " 10 times",
            False, # TBA
            getRandomColor(),
            -9,
            (500,430),
            (-50,800),
        ))

        locks[1].append(LockPostIt(
            "Seduce a foe as " + playerName,
            False, # TBA
            getRandomColor(),
            6,
            (600,180),
            (650,750),
        ))

        locks[1].append(LockPostIt(
            "Dominate 30 foes as " + playerName,
            False, # TBA
            getRandomColor(),
            10,
            (350,300),
            (820,1400),
        ))

        locks[1].append(LockPostIt(
            "Submit to 30 foes as " + playerName,
            False, # TBA
            getRandomColor(),
            -22,
            (300,300),
            (650,1150),
        ))
    
        return locks
