init python:

    def getInventoryCardAngle(cardPosition, deckLength):

        if deckLength == 1:
            return 0

        elif deckLength == 2:
            if cardPosition == 1:
                return -10
            elif cardPosition == 2:
                return 10

        elif deckLength == 3:
            if cardPosition == 1:
                return -15
            elif cardPosition == 2:
                return 1
            elif cardPosition == 3:
                return 15

        elif deckLength == 4:
            if cardPosition == 1:
                return -15
            elif cardPosition == 2:
                return -5
            elif cardPosition == 3:
                return 5
            elif cardPosition == 4:
                return 15

        elif deckLength == 5:
            if cardPosition == 1:
                return -20
            elif cardPosition == 2:
                return -10
            elif cardPosition == 3:
                return 0
            elif cardPosition == 4:
                return 10
            elif cardPosition == 5:
                return 20

    def clickItemCard(item):

        if isShopping:
            globals()["itemChosen"] = item
            renpy.jump("selling_item")

        elif isThrowing:
            globals()["itemChosen"] = item
            renpy.jump("throwing_item")
            
        else:
            # renpy.hide_screen("choice")
            renpy.call_in_new_context("description_" + item.icon)

    # def getFullHand(player):
    #     globals()["player" + str(player) + "Items"].append(getItem("aphrodisiac"))
    #     globals()["player" + str(player) + "Items"].append(getItem("rope"))
    #     globals()["player" + str(player) + "Items"].append(getItem("collar"))
    #     globals()["player" + str(player) + "Items"].append(getItem("glowing_gem"))

    def checkItem(player, itemName):

        checkStatus = False

        for i in globals()["player" + str(player) + "Items"]:
            if i.name == itemName:
                return True

    def getAvailableItemsUpToCurrentTier(maxTier):

        availableItems = []
        tier = maxTier

        while tier >= 0:
            for i in itemsList[tier]:
                if i not in itemsInGame:
                    availableItems.append(i)
            tier -= 1

        return availableItems

    def getRandomItem(maxTier):

        availableItems = getAvailableItemsUpToCurrentTier(maxTier)
        selection = getItem(renpy.random.choice(availableItems))
        return selection


    def getItemText(itemId):

        text = {
            # Tier 1
            "collar" : "A nice collar. Would you put it on?",
            "rope" : "A rope could be useful in this sort of dungeon.",
            "aphrodisiac" : "A vial of aphrodisiac. Might come in handy...",
            "glowing_gem" : "This stone seems to be glowing.",
            "emblem" : "You pick up what seems to be a hero emblem.",
            # Tier 2
            "gag" : "A ball gag... Who knows when you might need one?",
            "leash" : "A leash to use on a certain someone.",
            "lube" : "Some lube to... ease things up.",
            "quickstep_boots" : "Magic boots to help move faster.",
            "ring_of_fortune" : "How lucky! This ring might get you richer."
        }
        return text[itemId]

    def addItem(player, item):

        renpy.show("card_item_" + item.icon, at_list=[itemToFindrel if playerTurn == 1 else itemToLayla], layer="overlay")
        if player == 1:
            globals()["player1Items"].append(item)
        elif player == 2:
            globals()["player2Items"].append(item)

        itemsInGame.append(item.icon)
        addItemEffect(player, item.name)

    def removeItem(player, item):

        renpy.show("card_item_" + item.icon, at_list=[itemFromFindrel if playerTurn == 1 else itemFromLayla], layer="overlay")
        if player == 1:
            globals()["player1Items"].remove(item)
        elif player == 2:
            globals()["player2Items"].remove(item)

        itemsInGame.remove(item.icon)
        removeItemEffect(player, item.name)

    def addItemEffect(player, itemName):

        # TIER 1

        if itemName == "Collar":
            addBottomPoints(player, 10)

        elif itemName == "Rope":
            addTopPoints(player, 10)

        elif itemName == "Aphrodisiac":
            addTopPoints(player, 5)
            addBottomPoints(player, 5)

        elif itemName == "Emblem":
            addLevel(player, 1)

        elif itemName == "Glowing gem":
            globals()["player" + str(player) + "Stats"]["max_mana"] +=  1
            # renpy.notify(charactersNames[player] +  " gains 1 max mana")

        # TIER 2 

        if itemName == "Gag":
            addBottomPoints(player, 20)

        elif itemName == "Leash":
            addTopPoints(player, 20)

        elif itemName == "Lube":
            addTopPoints(player, 10)
            addBottomPoints(player, 10)

        # TIER 3 


        # TIER 4



    def removeItemEffect(player, itemName):

        statChangeDisplay["player"] = player

        # TIER 1

        if itemName == "Collar":
            removeBottomPoints(player,10)

        elif itemName == "Rope":
            removeTopPoints(player,10)

        elif itemName == "Aphrodisiac":
            removeTopPoints(player,5)
            removeBottomPoints(player,5)

        elif itemName == "Emblem":
            removeLevel(player,1)

        elif itemName == "Glowing gem":
            globals()["player" + str(player) + "Stats"]["max_mana"] -=  1
            # renpy.notify(charactersNames[player] +  " loses 1 max mana")

        # TIER 2 

        if itemName == "Gag":
            removeBottomPoints(player,20)

        elif itemName == "Leash":
            removeTopPoints(player,20)

        elif itemName == "Lube":
            removeTopPoints(player,10)
            removeBottomPoints(player,10)

        # TIER 3 



        # TIER 4 


    def getShopSelection(shopTier):

        selection = []

        availableItems = getAvailableItems(shopTier, itemsInGame)
        if len(availableItems) == 0:
            return []

        elif len(availableItems) <= 3:
            selection = availableItems
            renpy.random.shuffle(availableItems)

        else:
            while (len(selection) < 3) or (len(availableItems) < 3 and len(selection) < len(availableItems)):
                random = renpy.random.randint(0, 4)
                print(itemsList[shopTier][random])
                if itemsList[shopTier][random] not in itemsInGame and itemsList[shopTier][random] not in selection:
                    selection.append(itemsList[shopTier][random])
                else:
                    while itemsList[shopTier][random] not in itemsInGame and itemsList[shopTier][random] not in selection:
                        random = renpy.random.randint(0, 4)
                        selection.append(itemsList([shopTier][random]))

        for index, i in enumerate(selection):
            selection[index] = getItem(i)

        return selection

        # return [
        #     getItem(selection[0]),
        #     getItem(selection[1]),
        #     getItem(selection[2])
        #     ]


    # def willItemSelectionLoop(tier, itemsInGame):
        
    #     nb = 0
    #     for i in itemsList[tier]:
    #         if i in itemsInGame:
    #             print(nb)
    #             nb += 1
    #     if nb == len(itemsList[tier]):
    #         return True
    #     else:
    #         return False
    
    def getAvailableItems(tier, itemsInGame):

        availableItems = []
        for i in itemsList[tier]:
            if i not in itemsInGame:
                availableItems.append(i)

        # if tier > 0 and len(availableItems) < 3:
        #     for i in itemsList[tier-1]:
        #         if i not in itemsInGame:
        #             availableItems.append(i)

        if dungeonLevel == 0:
            if "glowing_gem" in availableItems:
                availableItems.remove("glowing_gem")

        return availableItems

    def buyItem(player, item):

        removeGold(player, item.value)
        removeItemFromShop(item)
        renpy.pause(.55)
        addItem(player, item)

    def sellItem(player, item):
        
        addGold(player, int(item.value/2))
        removeItem(player, item)

    def removeItemFromShop(item):
        # renpy.notify("token_item_[item.icon].png")
        renpy.play("sounds/card1.mp3")
        renpy.show("card_item_"+ item.icon, at_list=[itemToFindrel if playerTurn == 1 else itemToLayla], layer="overlay")
        globals()["shopSelection"].remove(item)