init python:

    def getTopLeftMenuCard():

        selection = [
            "card_layla_small",
            "card_goblin_f_small",
            "card_kobold_f_small",
        ]
        return renpy.random. choice(selection)

    def getMiddleLeftMenuCard():

        selection = [
            "event_merchant_small",
            "event_troll_small",
            "event_tavern_small",
            "event_training_small",
            "event_offering_small",
            "event_impotent_small",
        ]
        return renpy.random. choice(selection)

    def getBottomLeftMenuCard():

        selection = [
            "goblin_f_bottom_small",
            "goblin_m_bottom_small",
            "kobold_f_bottom_small",
            "kobold_m_bottom_small",
        ]
        return renpy.random. choice(selection)

    def getTopRightMenuCard():

        selection = [
            "goblin_f_top_small",
            "goblin_m_top_small",
            "kobold_f_top_small",
            "kobold_m_top_small",
        ]
        return renpy.random. choice(selection)

    def getMiddleRightMenuCard():

        selection = [
            "card_item_aphrodisiac_small",
            "card_item_rope_small",
            "card_item_collar_small",
            "card_item_emblem_small",
            "card_item_glowing_gem_small",
            "card_item_gag_small",
            "card_item_leash_small",
            "card_item_lube_small",
            "card_item_quickstep_boots_small",
            "card_item_ring_of_fortune_small",
        ]
        return renpy.random. choice(selection)

    def getBottomRightMenuCard():

        selection = [
            "card_findrel_small",
            "card_goblin_m_small",
            "card_kobold_m_small",
        ]
        return renpy.random. choice(selection)

    def initCircles():

        currentDungeonRooms = globals()["dungeonRooms"]
        renpy.random.shuffle(currentDungeonRooms)

        globals()["circles"] = [
            Circle(0, 1225, 640, "start", "start", 0),
            Circle(1, 1055, 735, currentDungeonRooms[0], "unknown", 0),
            Circle(2, 890, 765, currentDungeonRooms[1], "unknown", 0), 
            Circle(3, 890, 585, currentDungeonRooms[2], "unknown", 0),
            Circle(4, 780, 490, currentDungeonRooms[3], "unknown", 0),
            Circle(5, 645, 685, currentDungeonRooms[4], "unknown", 0),
            Circle(6, 495, 780, currentDungeonRooms[5], "unknown", 0),
            Circle(7, 330, 775, currentDungeonRooms[6], "unknown", 0),
            Circle(8, 330, 565, currentDungeonRooms[7], "unknown", 0),
            Circle(9, 450, 410, currentDungeonRooms[8], "unknown", 0),
            Circle(10, 585, 480, currentDungeonRooms[9], "unknown", 0),
            Circle(11, 500, 235, currentDungeonRooms[10], "unknown", 0),
            Circle(12, 685, 225, currentDungeonRooms[11], "unknown", 0),
            Circle(13, 805, 345, currentDungeonRooms[12], "unknown", 0),
            Circle(14, 910, 205, currentDungeonRooms[13], "unknown", 0),
            Circle(15, 1050, 260, currentDungeonRooms[14], "unknown", 0),
            Circle(16, 1035, 470, currentDungeonRooms[15], "unknown", 0),
            Circle(17, 1255, 455, currentDungeonRooms[16], "unknown", 0),
            Circle(18, 1265, 240, currentDungeonRooms[17], "unknown", 0),
            Circle(19, 1445, 435, currentDungeonRooms[18], "unknown", 0),
            Circle(20, 1445, 645, currentDungeonRooms[19], "unknown", 0),
            Circle(21, 1350, 790, currentDungeonRooms[20], "unknown", 0),
        ]

    def getNextLevelDungeon(dungeonLevel, playersLevelsSum):

        # levelsSum = player1Stats("level") + player2Stats("level"))

        dungeonLevelThreshold = [
            5, # To Lv.1 >> 3
            8, # To Lv.2 >> 3
            11, # To Lv.3 >> 3
            14, # To Lv.4 >> 3
            17, # To Lv.5 >> 4
            21, # To Lv.6 >> 4
            25, # To Lv.7 >> 4
            30, # To Lv.8 >> 5
            35, # To Lv.9 >> 5
            40 # To Lv.10 >> 5
        ]


        return dungeonLevelThreshold[dungeonLevel] - playersLevelsSum

    def isDungeonLevellingUp():
        
        levelSum = player1Stats["level"] + player2Stats["level"]

        if getNextLevelDungeon(dungeonLevel, levelSum) == 0 and dungeonLevel < 4:
            
            renpy.show("level_" + str(dungeonLevel+1), at_list=[dungeon_level_up])
            renpy.pause(.65)
            globals()["dungeonLevel"] += 1
            updateBoard(dungeonLevel)
            renpy.say(None,"Dungeon got level [dungeonLevel]! Be ready to face new challenges...")

            if dungeonLevel == 4:
                renpy.say(None,"Oh, and it seems like its level {b}won't get higher in this version.{/b}")
                renpy.say(None,"Better make use of what you currently have then, right?")

        # updatedDungeonLevel = 1
    


    def getCircleContent(circle):

        if circle.circleAppearance == "event":

            event = ""
            while event == "" or event in lastEvents:
                if dungeonLevel == 0:
                    event = eventsList[circle.tier][renpy.random.randint(0, 3)]
                else:
                    event = eventsList[circle.tier][renpy.random.randint(0, 4)]
            return event

        elif circle.circleAppearance == "gold":

            if dungeonLevel == 0:
                random = renpy.random.randint(0, 2)
            else:
                random = renpy.random.randint(0, 3)
            return goldList[circle.tier][random]

        elif circle.circleAppearance == "item":
    
            availableItems = getAvailableItems(circle.tier, itemsInGame)

            if availableItems == []:
                if circle.tier in [0,1]:
                    return 1
                elif circle.tier in [2,3]:
                    return 2
            else:
                return renpy.random.choice(availableItems)

        elif circle.circleAppearance == "encounter":

            if dungeonLevel == 0:
                random = renpy.random.randint(0, 1)
            else:
                random = renpy.random.randint(0, 2)

            return encountersList[circle.tier][random]

        elif circle.circleAppearance == "shop":
            
            return getCurrentMaxTier()

        elif circle.circleAppearance == "mirror":
            return "mirror"

        elif circle.circleAppearance == "start":
            return "start"

    def getItem(content):

        # TIER 1

        if content == "collar":
            return Item("Collar", "Bottom +10", "collar", 3)

        elif content == "rope":
            return Item("Rope","Top +10", "rope", 3)

        elif content == "aphrodisiac":
            return Item("Aphrodisiac","Top +5 Bottom +5", "aphrodisiac", 3)

        elif content == "emblem":
            return Item("Emblem","Level +1", "emblem", 4)

        elif content == "glowing_gem":
            return Item("Glowing gem","Max Mana +1", "glowing_gem", 4)

        # TIER 2

        elif content == "gag":
            return Item("Gag","Bottom +15", "gag", 5)

        elif content == "leash":
            return Item("Leash","Top +15", "leash", 5)

        elif content == "lube":
            return Item("Lube","Top +8 Bottom +8", "lube", 5)

        elif content == "ring_of_fortune":
            return Item("Ring of Fortune","Earn 25 gold every turn", "ring_of_fortune", 6)

        elif content == "quickstep_boots":
            return Item("Quickstep Boots","Add 1 to your movement dice", "quickstep_boots", 5)


    def getEncounter(content):
        if content == "goblin":
            encounter = Encounter(
            "Goblin", "A Goblin stands in your way. How will you deal with this dire situation?",
            "goblin",
            [
                "Dominate the Goblin",
                "Submit to the Goblin",
                "Fight the Goblin",
                "Escape the Goblin"
            ],
            10, 1, # Required stats (pts, lv)
            2, 0 # Rewards (pts, gold)
        )
        elif content == "kobold":
            encounter = Encounter(
            "Kobold", "A Kobold stands in your way. How will you deal with this dire situation?",
            "kobold",
            [
                "Dominate the Kobold",
                "Submit to the Kobold",
                "Fight the Kobold",
                "Escape the Kobold"
            ],
            25, 3, # Required stats (pts, lv)
            5, 1 # Rewards (pts, gold)
        )
        elif content == "slime":
            encounter = Encounter(
            "Slime", "A Slime stands in your way. How will you deal with this dire situation?",
            "slime",
            [
                "Dominate the Slime",
                "Submit to the Slime",
                "Fight the Slime",
                "Escape the Slime"
            ],
            50, 5, # Required stats (pts, lv)
            8, 2 # Rewards (pts, gold)
        )

        return encounter

    def countRooms(roomType):

        nb = 0
        
        for i in circles:
            if i.circleType == roomType:
                nb += 1
        return nb

    def getAllThresholdScenes():
        return [
    "scenes/findrel1",
    "scenes/layla1",
    ]

    def getAllEncounterScenes(character):

        if character == "findrel":
            return [
                "scenes/goblin_f_bottom",
                "scenes/goblin_f_top",
                "scenes/kobold_f_bottom",
                "scenes/kobold_f_top"
            ]

        elif character == "layla":
            return [
                "scenes/goblin_m_bottom",
                "scenes/goblin_m_top",
                "scenes/kobold_m_bottom",
                "scenes/kobold_m_top",
            ]

    def getAllEncounters():
        return [
    "encounters/card_goblin_f",
    "encounters/card_goblin_m",
    "encounters/card_kobold_f",
    "encounters/card_kobold_m",
    "encounters/card_slime_f",
    "encounters/card_slime_m",

    ]

    def getAllItems():
        return [
    "items/card_item_aphrodisiac",
    "items/card_item_rope",
    "items/card_item_collar",
    "items/card_item_emblem",
    "items/card_item_glowing_gem",

    "items/card_item_lube",
    "items/card_item_leash",
    "items/card_item_gag",
    "items/card_item_quickstep_boots",
    "items/card_item_ring_of_fortune",
    ]

    def getAllEvents():
        return [

    "events/event_the_merchant",
    "events/event_the_tavern",
    "events/event_the_troll",
    "events/event_the_offering",
    "events/event_the_training",

    "events/event_the_impotent",
    "events/event_the_pool",
    "events/event_the_gaol",
    "events/event_the_adventurer",
    "events/event_the_sorceress",
    ]

    def clearCollection():
        persistent.collection = {
        "charactersSexCards": [],
        "foesSexCardsFindrel": [],
        "foesSexCardsLayla": [],
        "foesCards": [],
        "itemsCards": [],
        "eventsCards": [],
    }


    def cheat_completeCollection():

        for i in getAllEvents():
            persistent.collection["eventsCards"].append(i)

    def countCollection():

        return {
            "charactersSexCards": len(persistent.collection["charactersSexCards"]),
            "foesCards": len(persistent.collection["foesCards"]),
            "foesSexCardsFindrel": len(persistent.collection["foesSexCardsFindrel"]),
            "foesSexCardsLayla": len(persistent.collection["foesSexCardsLayla"]),
            "eventsCards": len(persistent.collection["eventsCards"]),
            "itemsCards": len(persistent.collection["itemsCards"]),
        }
        return str(counter)

    def isCollectionComplete():
        isCollectionComplete = True

        if len(persistent.collection["charactersSexCards"]) < 2:
            isCollectionComplete = False
        if len(persistent.collection["foesCards"]) < 6:
            isCollectionComplete = False
        if len(persistent.collection["foesSexCardsFindrel"]) < 4:
            isCollectionComplete = False
        if len(persistent.collection["eventsCards"]) < 8:
            isCollectionComplete = False
        if len(persistent.collection["itemsCards"]) < 10:
            isCollectionComplete = False
        
        return isCollectionComplete


    def isSpecificCollectionComplete(collection):

        maxNb = {
            "charactersSexCards" : 2,
            "foesCards" : 6,
            "foesSexCardsFindrel" : 4,
            "eventsCards" : 8,
            "itemsCards" : 10,
        }

        if len(persistent.collection[collection]) < maxNb[collection]:
            return False
        else:
            return True
        

    def checkCollection(cardType, arg1, arg2, arg3):

        
        if cardType == "encounter":

            if "encounters/card_" + arg1 + "_" + arg2 not in persistent.collection["foesCards"]:
                persistent.collection["foesCards"].append("encounters/card_" + arg1 + "_" + arg2)
                return False
            else:
                return True

        elif cardType == "event":
            if "events/" + arg1 not in persistent.collection["eventsCards"]:
                persistent.collection["eventsCards"].append("events/" + arg1)
                return False
            else:
                return True

        elif cardType == "item":
            if "items/card_item_" + arg1 not in persistent.collection["itemsCards"]:
                persistent.collection["itemsCards"].append("items/card_item_" + arg1)
                return False
            else:
                return True

        elif cardType == "sexFoeFindrel":
            
            if "scenes/" + arg1 + "_" + arg2 + "_" + arg3 not in persistent.collection["foesSexCardsFindrel"]:
                persistent.collection["foesSexCardsFindrel"].append("scenes/" + arg1 + "_" + arg2 + "_" + arg3)
                return False
            else:
                return True

        elif cardType == "sexFoeLayla":
            if "scenes/" + arg1 + "_" + arg2 + "_" + arg3 not in persistent.collection["foesSexCardsLayla"]:
                persistent.collection["foesSexCardsLayla"].append("scenes/" + arg1 + "_" + arg2 + "_" + arg3)
                return False
            else:
                return True

        elif cardType == "charactersSexCards":
            if "scenes/" + arg1 not in persistent.collection["charactersSexCards"]:
                persistent.collection["charactersSexCards"].append("scenes/" + arg1)
                return False
            else:
                return True


    def getCharacterSheetInfo(character):

        characterInfo = {}

        if character == "Layla":
            characterInfo["name"] = "Layla Kinstalker"
            characterInfo["portrait"] = "characters/sheet_layla.png"
            
            characterInfo["race"] = _("Human")
            characterInfo["age"] = _("29")
            characterInfo["class"] = _("Warrior")
            characterInfo["spec"] = _("Judicator")
            characterInfo["background"] = _("Arena Fighter")
            characterInfo["alignment"] = _("Lawful Neutral")

            characterInfo["STR"] = "19"
            characterInfo["DEX"] = "15"
            characterInfo["CON"] = "17"
            characterInfo["INT"] = "10"
            characterInfo["WIS"] = "8"
            characterInfo["CHR"] = "14"

            characterInfo["level"] = str(player2Stats["level"])
            characterInfo["HP"] = "34 / 34"
            characterInfo["MP"] = "11 / 11"
            characterInfo["SP"] = "45 / 45"

            characterInfo["Athletics"] = "19"
            characterInfo["Acrobatics"] = "17"
            characterInfo["Thievery"] = "7"
            characterInfo["Awareness"] = "9"
            characterInfo["Survival"] = "16"
            characterInfo["Nature"] = "12"
            characterInfo["Entertain"] = "7"
            characterInfo["Speech"] = "11"
            characterInfo["Knowledge"] = "11"
            characterInfo["Arcana"] = "6"
            characterInfo["Medecine"] = "8"
            characterInfo["Mechanics"] = "7"

            characterInfo["Seduction"] = "13"
            characterInfo["Hands"] = "16"
            characterInfo["Oral"] = "15"
            characterInfo["Vaginal"] = "18"
            characterInfo["Anal"] = "12"
            characterInfo["Penile"] = "x"

            characterInfo["traits"] = _("- ")
            characterInfo["equipment"] = _("- ")

            characterInfo["home"] = "Urgunfeldt"
            characterInfo["god"] = "Halforas"
            characterInfo["goal"] = _("")
            characterInfo["flaws"] = _("")
            characterInfo["secret"] = _("")
           
            characterInfo["backstory"] = _("")
            characterInfo["backstory"] += _("")
            characterInfo["backstory"] += _("")
            

            characterInfo["bonds"] = "{size=52}Findrel{/size}\n"
            characterInfo["bonds"] += _("")
            characterInfo["bonds"] += _("")

            if player2Stats["top"] > player2Stats["bottom"]:
                characterInfo["behaviour"] = _("Dominant")
            elif player2Stats["bottom"] > player2Stats["top"]:
                characterInfo["behaviour"] = _("Submissive")
            else: 
                characterInfo["behaviour"] = _("Undecided")

            characterInfo["first time"] = _("")
            characterInfo["preferences"] = _("")
            characterInfo["kinks"] = _("")
            characterInfo["weaknesses"] = _("")
            characterInfo["insecurities"] = _("")
            characterInfo["safe word"] = _("")

        if character == "Findrel":
            characterInfo["name"] = "Findrel"
            characterInfo["portrait"] = "characters/sheet_findrel.png"
            
            characterInfo["race"] = _("Elf")
            characterInfo["age"] = _("41")
            characterInfo["class"] = _("Mage")
            characterInfo["spec"] = _("x")
            characterInfo["background"] = _("x")
            characterInfo["alignment"] = _("Chaotic Neutral")

            characterInfo["STR"] = "9"
            characterInfo["DEX"] = "12"
            characterInfo["CON"] = "11"
            characterInfo["INT"] = "18"
            characterInfo["WIS"] = "18"
            characterInfo["CHR"] = "17"

            characterInfo["level"] = str(player1Stats["level"])
            characterInfo["HP"] = "34 / 34"
            characterInfo["MP"] = "11 / 11"
            characterInfo["SP"] = "45 / 45"

            characterInfo["Athletics"] = "12"
            characterInfo["Acrobatics"] = "11"
            characterInfo["Thievery"] = "11"
            characterInfo["Awareness"] = "14"
            characterInfo["Survival"] = "9"
            characterInfo["Nature"] = "10"
            characterInfo["Entertain"] = "16"
            characterInfo["Speech"] = "17"
            characterInfo["Knowledge"] = "17"
            characterInfo["Arcana"] = "19"
            characterInfo["Medecine"] = "11"
            characterInfo["Mechanics"] = "6"

            characterInfo["Seduction"] = "17"
            characterInfo["Hands"] = "12"
            characterInfo["Oral"] = "13"
            characterInfo["Vaginal"] = "x"
            characterInfo["Anal"] = "14"
            characterInfo["Penile"] = "16"

            characterInfo["traits"] = _("")
            characterInfo["equipment"] = _("")

            characterInfo["home"] = ""
            characterInfo["god"] = "Senruvim"
            characterInfo["goal"] = _("")
            characterInfo["flaws"] = _("")
            characterInfo["secret"] = _("")
           
            characterInfo["backstory"] = _("")
            characterInfo["backstory"] += _("")
            characterInfo["backstory"] += _("")
            

            characterInfo["bonds"] = "{size=52}Findrel{/size}\n"
            characterInfo["bonds"] += _("")
            characterInfo["bonds"] += _("")

            if player2Stats["top"] > player2Stats["bottom"]:
                characterInfo["behaviour"] = _("Dominant")
            elif player2Stats["bottom"] > player2Stats["top"]:
                characterInfo["behaviour"] = _("Submissive")
            else: 
                characterInfo["behaviour"] = _("Undecided")

            characterInfo["first time"] = _("")
            characterInfo["preferences"] = _("")
            characterInfo["kinks"] = _("")
            characterInfo["weaknesses"] = _("")
            characterInfo["insecurities"] = _("")
            characterInfo["safe word"] = _("")

        return characterInfo
            