init python:
    
    def getEventIntro(event, playerTurn):

        # --------------------
        # ----- TIER 1 -------
        # --------------------

        # ----THE MERCHANT----

        if event == "event_the_merchant":

            if playerTurn == 1: 
                # WIZARD
                return [
            "A merchant's honeyed words welcome you in this new room. {i}\"Greetings, customer!\"{/i}",
            "Beside him on a small stall are several scrolls, two of which might prove useful to you.", 
            "One holds a fire-breathing spell while the other is host to a potent protection spell.",
            ]

            elif playerTurn == 2:
                # WARRIOR
                return [
            "A merchant seems to have set up a small shop in this part of the dungeon.",
            "He welcomes you with a warm smile and warmer words still. {i}\"Greetings, customer!\"{/i}.",
            "Beside him are a selection of potions. Two of them catch your eye : a strength potion and a defense potion.",
            ]

        # -----THE TROLL -----

        elif event == "event_the_troll":

            if playerTurn == 1: 
                # WIZARD
                return [
            "The stairs to the next floor are blocked by a giant, snoring obstacle.",
            "An obstacle whose enormous chest slowly rises with each breath : a Troll, asleep on the stairs.",
            "You fear those spells of yours might not be enough to deal with such a foe.",
            ]

            elif playerTurn == 2:
                # WARRIOR
                return [
            "The next obstacle on your way is none other than a huge Troll resting on the stairs.",
            "You stop, but the clinking noise from your armor has already woken him from his slumber.",
            "\"{i}Who... goes there...?{/i}\" he yawns, eyes half open.",
            ]

        # ----THE TAVERN----

        elif event == "event_the_tavern":

            if playerTurn == 1: 
                # WIZARD
                return [
            "You stumble upon an improvised tavern filled with dozens of Goblins.",
            "Before you can ready a spell, one shouts : {i}\"Look! This one's lost his way!\"{/i}",
            "He gets closer. {i}\"Say, elf boy... Who would win a fight between the Gobfather and your God of Magic?\"{/i}",
            "You know Senruvim the Wise would crush their deity. But is this what they want to hear?",
            ]

            elif playerTurn == 2:
                # WARRIOR
                return [
            "You stumble an upon improvised tavern filled with dozens of Goblins.",
            "Before you can unsheathe your sword, one shouts : {i}\"Look! This one's lost her way!\"{/i}",
            "She gets closer. {i}\"Say, human girl... Who would win a fight between the Gobfather and your God of War?\"{/i}",
            "You know Halforas the Mighty would crush their deity. But is this what they want to hear?",
                ]

        # ----THE TRAINING ----

        elif event == "event_the_training":

            if playerTurn == 1: 
                # WIZARD
                return [
            "You meet an old Orc, fiercely sparring with a training mannequin.",
            "He turns his head in your direction and lays down his weapon before you can think of a spell.",
            "\"{i}Easy lad, this is but a training room. Speaking of which, I can instruct you for a few coins. What say you?{/i}\"",
            ]

            elif playerTurn == 2:
                # WARRIOR
                return [
            "You meet an old Orc, fiercely sparring with a training mannequin.",
            "He turns his head in your direction and lays down his weapon before you can take a offensive stance.",
            "\"{i}Easy lass, this is but a training room. Speaking of which, I can instruct you for a few coins. What say you?{/i}\"",
            ]

        # ---THE OFFERING ---

        elif event == "event_the_offering":

            if playerTurn == 1: 
                # WIZARD
                return [
            "Along the next corridor is an altar dedicated to Senruvim the Wise, master of elements. Your god.",
            "Between the magic runes, you can see a small tray made for offerings of coins. Will you honor the deity?",
            ]

            elif playerTurn == 2:
                # WARRIOR
                return [
            "Along the next corridor is an altar dedicated to Halforas the Mighty, bane of fiends. Your god.",
            "Under the hanging sword and shield, you can see a small tray made for offerings of coins. Will you honor the deity?",
            ]

        # --------------------
        # ----- TIER 2 -------
        # --------------------

        # --- THE IMPOTENT ---

        elif event == "event_the_impotent":

            if playerTurn == 1: 
                # WIZARD
                return [
            "You are approached by a half-naked Kobold who points to an adjacent room.",
            "\"{i}Can the good Elf help Kalgi?{/i}\", he pleads, \"{i}Kalgi has pretty mate ready for funsies, but there's problem... down there.{/i}\"",
            "He points at his groin. \"{i}Kalgi can't get \"ready\". Does good Elf have hardening potion? Kalgi will buy it!{/i}\"",
            ]

            elif playerTurn == 2:
                # WARRIOR
                return [
            "You are approached by a half-naked Kobold who points to an adjacent room.",
            "\"{i}Can the good Human help Kalgi?{/i}\", he pleads, \"{i}Kalgi has pretty mate ready for funsies, but there's problem... down there.{/i}\"",
            "He points at his groin. \"{i}Kalgi can't get \"ready\". Does good Human have hardening potion? Kalgi will buy it!{/i}\"",
            ]

        # ---- THE POOL ----

        elif event == "event_the_pool":

            if playerTurn == 1: 
                # WIZARD
                return [
            "Your steps lead you to a damp and cold room. In its center is a large pool at the bottom of which awaits a chest.",
            "Ice clings to its surface, and you can even see a frozen fish floating pathetically next to it.",
            "Surely this chest should hold fabulous riches, but even thinking of dipping your hands in the water is enough to make you shiver.",
            ]

            elif playerTurn == 2:
                # WARRIOR
                return [
            "Your steps lead you to a damp and cold room. In its center is a large pool at the bottom of which awaits a chest.",
            "Ice clings to its surface, and you can even see a frozen fish floating pathetically next to it.",
            "Surely this chest should hold fabulous riches, but even thinking of dipping your hands in the water is enough to make you shiver.",
            ]

        # -- THE ADVENTURER --

        elif event == "event_the_adventurer":

            if playerTurn == 1: 
                # WIZARD
                return [
            "You hear the sounds of a battle nearby. Rushing to the next room, you see an adventurer grappling with three Goblins. ",
            "Casting a spell in their direction is enough to have them run away, as they can no longer take advantage of their numbers.",
            "The adventurer bows. \"{i}I'm quite grateful, sir{/i}\", she says. \"{i}Such a timely intervention warrants a reward.\" Is there anything you wish for?{/i}"
            ]

            elif playerTurn == 2:
                # WARRIOR
                return [
            "You hear the sounds of a battle nearby. Rushing to the next room, you see an adventurer grappling with three Goblins. ",
            "Charging with your sword in their direction is enough to have them run away, as they can no longer take advantage of their numbers.",
            "The adventurer bows. \"{i}I'm quite grateful, lady{/i}\", he says. \"{i}Such a timely intervention warrants a reward.\" Is there anything you wish for?{/i}"
            ]

        # ---- THE GAOL ----

        elif event == "event_the_gaol":

            if playerTurn == 1: 
                # WIZARD
                return [
            "You pass through the dungeon's prison. All cells look empty... save for the last one, from which you hear sighs of pleasure.",
            "The sighs grow louder and clearer. Soon, you can see the shadows cast by its occupants.",
            "There is something strange lingering in the air, but you probably don't risk much taking a peek. Do you?"
            ]

            elif playerTurn == 2:
                # WARRIOR
                return [
            "You pass through the dungeon's prison. All cells look empty... save for the last one, from which you hear sighs of pleasure.",
            "The sighs grow louder and clearer. Soon, you can see the shadows cast by its occupants.",
            "There is something strange lingering in the air, but you probably don't risk much taking a peek. Do you?"
            ]

        # --- THE SORCERESS ---

        elif event == "event_the_sorceress":

            if playerTurn == 1: 
                # WIZARD
                return [
            "Following an odd scent, you find yourself in a small room occupied by a Kobold sorceress.",
            "Busy as she is stirring a cauldron, she barely acknowledges your presence. Until you finally come forth, that is.",
            "\"{i}This brew of mine requires Glowing gems{/i}\" she simply states. \"{i}I can buy one from you. Or harness its power for your sake. \"{/i}"
            ]

            elif playerTurn == 2:
                # WARRIOR
                return [
            "Following an odd scent, you find yourself in a small room occupied by a Kobold sorceress.",
            "Busy as she is stirring a cauldron, she barely acknowledges your presence. Until you finally come forth, that is.",
            "\"{i}This brew of mine requires Glowing gems{/i}\" she simply states. \"{i}I can buy one from you. Or harness its power for your sake. \"{/i}"
            ]

    def getEventChoices(event, playerTurn):

        # --------------------
        # ----- TIER 1 -------
        # --------------------

        # ----THE MERCHANT----

        if event == "event_the_merchant":

            if playerTurn == 1: 
                # WIZARD
                return [
            EventChoice("merchant_top",
            "Buy the fire-breathing scroll", 
                [
                    ChoiceEffect("top", "+", 5),
                    ChoiceEffect("gold", "-", 2),
                ],
                "{size=*0.65}"
                    "{color=34b962}"
                        "{image=tokenTopPlus}"
                        "{space=10}"
                    "{/color}"
                    "{color=#b93434}"
                        "{image=goldMinus}{image=goldMinus}-"
                    "{/color}"
                "{/size}",
            [
                "This scroll should make a fine addition to your offensive arsenal.",
                "Whenever you meet your next enemy, you will have no reason to hold back.",
            ]
            ),

            EventChoice("merchant_bottom",
            "Buy the protection scroll", 
                [
                    ChoiceEffect("bottom", "+", 5),
                    ChoiceEffect("gold", "-", 2),
                ],
                "{size=*0.65}"
                    "{color=34b962}"
                        "{image=tokenBottomPlus}"
                        "{space=10}"
                    "{/color}"
                    "{color=#b93434}"
                        "{image=goldMinus}{image=goldMinus}-"
                    "{/color}"
                "{/size}",
            [
                "The spell contained in this scroll might serve you well in a dire situation.",
                "You'd best be careful not to waste it on small fry.",
            ]),

            EventChoice("merchant_none",
            "Leave empty-handed", 
                [
                ],
                "",
            [
                "Your gold is almost as precious as your life. Best keep it in your pouch for this one time.",
            ]),
            ]

            elif playerTurn == 2: 
                # WARRIOR
                return [
            EventChoice("merchant_top",
            "Buy the strength potion", 
                [
                    ChoiceEffect("top", "+", 5),
                    ChoiceEffect("gold", "-", 2),
                ],
                "{size=*0.65}"
                    "{color=34b962}"
                        "{image=tokenTopPlus}"
                        "{space=10}"
                    "{/color}"
                    "{color=#b93434}"
                        "{image=goldMinus}{image=goldMinus}-"
                    "{/color}"
                "{/size}",
            [
                "Drinking this vial will grant you formidable power.",
                "In point of fact, even holding one in your inventory is enough to boost your confidence.",
            ]
            ),

            EventChoice("merchant_bottom",
            "Buy the defense potion", 
                [
                    ChoiceEffect("bottom", "+", 5),
                    ChoiceEffect("gold", "-", 2),
                ],
                "{size=*0.65}"
                    "{color=34b962}"
                        "{image=tokenBottomPlus}"
                        "{space=10}"
                    "{/color}"
                    "{color=#b93434}"
                        "{image=goldMinus}{image=goldMinus}-"
                    "{/color}"
                "{/size}",
            [
                "Turning your skin into steel might prove vital during the rest of your exploration.",
                "Of course, that is certainly not a reason to put yourself in risky situations.",
            ]),

            EventChoice("merchant_none",
            "Leave empty-handed", 
                [
                ],
                "",
            [
                "Your gold is almost as precious as your life. Best keep it in your pouch for this one time.",
            ]),
            ]

        # -----THE TROLL -----

        if event == "event_the_troll":

            if playerTurn == 1: 
                # WIZARD
                return [
            EventChoice("troll_top",
            "Cast a firework spell and take advantage of the confusion", 
                [
                    ChoiceEffect("top", "+", 3),
                    ChoiceEffect("bottom", "-", 2),
                ],
                "{size=*0.65}"+
                    "{color=34b962}"+
                        "{image=tokenTopPlus}"
                        "{space=10}"+
                    "{/color}"+
                    "{color=b93434}"+
                        "{image=tokenBottomMinus}"
                        "{space=10}"+
                    "{/color}"+
                "{/size}",
            [
                "The first of many fireworks explodes in the small corridor, startling the Troll who jumps on his feet. ",
                "Hidden in a cloud of smoke, you pass before he can make any sense of his surroundings.",
            ]
            ),

            EventChoice("troll_bottom",
            "Shrink yourself to squeeze through a small gap", 
                [
                    ChoiceEffect("bottom", "+", 3),
                    ChoiceEffect("top", "-", 2),
                ],
                "{size=*0.65}"
                    "{color=34b962}"
                        "{image=tokenBottomPlus}"
                        "{space=10}"
                    "{/color}"
                    "{color=b93434}"+
                        "{image=tokenTopMinus}"
                        "{space=10}"+
                    "{/color}"+
                "{/size}",
            [
                "There is a gap between his thigh and the wall, small enough for a tiny person to pass through.",
                "Using a shrinking spell, you find your way there in spite of the foul smell.",
            ]),
            ]

            elif playerTurn == 2: 
                # WARRIOR
                return [
            EventChoice("troll_top",
            "Pretend to be his superior and order him to let you pass", 
                [
                    ChoiceEffect("top", "+", 3),
                    ChoiceEffect("bottom", "-", 2),
                ],
                "{size=*0.65}"
                    "{color=34b962}"
                        "{image=tokenTopPlus}"
                        "{space=10}"
                    "{/color}"
                    "{color=b93434}"+
                        "{image=tokenBottomMinus}"
                        "{space=10}"+
                    "{/color}"+
                "{/size}",
            [
                "With an imperative tone, you shout : {i}\"Make way at once, you imbecile!\"{/i}",
                "The Troll is none the wiser and you hurry along before he fully wakes up.",
            ]
            ),

            EventChoice("troll_bottom",
            "Pretend to be a servant and ask him to let you pass", 
                [
                    ChoiceEffect("bottom", "+", 3),
                    ChoiceEffect("top", "-", 2),
                ],
                "{size=*0.65}"
                    "{color=34b962}"
                        "{image=tokenBottomPlus}"
                        "{space=10}"
                    "{/color}"
                    "{color=b93434}"+
                        "{image=tokenTopMinus}"
                        "{space=10}"+
                    "{/color}"+
                "{/size}",
            [
                "With a pleading tone, you implore: \"{i}Sir, I beg of you. I was summoned across these stairs\"{/i}.",
                "The Troll is none the wiser and you hurry along before he fully wakes up.",
            ]),
            ]

        # ----THE TAVERN----

        elif event == "event_the_tavern":

            if playerTurn == 1: 
                # WIZARD
                return [
            EventChoice("tavern_top",
            "Answer \"{i}SeLruvin the Wise{/i}\" with confidence", 
                [
                    ChoiceEffect("top", "+", 4),
                    ChoiceEffect("mana", "+", 1)
                ],
                "{size=*0.65}"
                    "{color=#34b962}"
                        "{image=tokenTopPlus}"
                        "{space=10}"
                        "{image=manaPlus}"
                    "{/color}"
                "{/size}",
            [
                "They laugh. \"{i}Ha! This one's brave. We'll make an exception and let you pass{/i}\".",
                "Mana surges within you. Senruvim seemed pleased with your answer.",
            ]
            ),

            EventChoice("tavern_bottom",
            "Lie and answer \"{i}The Gobfather{/i}\"", 
                [
                    ChoiceEffect("bottom", "+", 4),
                    ChoiceEffect("special", "turn", 1)
                ],
                "{size=*0.65}"
                    "{color=#34b962}"
                        "{image=tokenBottomPlus}"
                        "{space=10}"
                        "{b}Extra turn{/b}"
                    "{/color}"
                "{/size}",
            [
                "One of them cheers. \"{i}Smart answer, elf boy! Come and eat with us!{/i}\"",
                "Their food is surprisingly good. With a full stomach, you decide to press on.",
            ]),
            ]

            elif playerTurn == 2: 
                # WARRIOR
                return [
            EventChoice("tavern_top",
            "Answer \"{i}Halforas the Mighty{/i}\" with confidence", 
                [
                    ChoiceEffect("top", "+", 4),
                    ChoiceEffect("mana", "+", 1)
                ],
                "{size=*0.65}"
                    "{color=#34b962}"
                        "{image=tokenTopPlus}"
                        "{space=10}"
                        "{image=manaPlus}"
                    "{/color}"
                "{/size}",
            [
                "They laugh. \"{i}Ha! This one's brave. We'll make an exception and let you pass{/i}\".",
                "Energy surges within you. Halforas seemed pleased with your answer.",
            ]
            ),

            EventChoice("tavern_bottom",
            "Lie and answer \"{i}The Gobfather{/i}\"", 
                [
                    ChoiceEffect("bottom", "+", 4),
                    ChoiceEffect("special", "turn", 1)
                ],
                "{size=*0.65}"
                    "{color=#34b962}"
                        "{image=tokenBottomPlus}"
                        "{space=10}"
                        "{b}Extra turn{/b}"
                    "{/color}"
                "{/size}",
            [
                "One of them cheers. \"{i}Smart answer, human girl! Come and eat with us!{/i}\"",
                "Their food is surprisingly good. With a full stomach, you decide to press on.",
            ]),

            EventChoice("tavern_none",
            "Bet a drink on Halforas's might", 
                [
                    ChoiceEffect("bottom", "+", 3),
                    ChoiceEffect("top", "+", 3),
                    ChoiceEffect("special", "fight", "goblin"),
                ],
                "{size=*0.65}"
                    "{image=warriorClass}"
                    "{space=10}"
                    "{color=#34b962}"
                        "{image=tokenBottomPlus}"
                        "{space=10}"
                        "{image=tokenTopPlus}"
                        "{space=10}"
                    "{/color}"
                    "{color=#b93434}"
                        "{b}Fight{/b}"
                    "{/color}"
                "{/size}",
            [
                "The crowd cheers, impressed by your brashness.",
                "After a few seconds, a Goblin comes forward, eager as he is to put you to the test.",
            ]),
            ]


        # ----THE TRAINING ----

        elif event == "event_the_training":

            if playerTurn == 1: 
                # WIZARD
                return [
            EventChoice("training_gold",
            "Pay for a session", 
                [
                    ChoiceEffect("level", "+", 1),
                    ChoiceEffect("gold", "-", 2),
                ],
                "{size=*0.65}"
                    "{color=34b962}"
                        "{image=levelPlus}"
                        "{space=10}"
                    "{/color}"
                    "{color=#b93434}"
                        "{image=goldMinus}{image=goldMinus}"
                    "{/color}"
                "{/size}",
            [
                "You pay the Orc in advance. \"{i}Be wary. I'm a tough teacher{/i}\", he grins.",
                "That was a lie. The instructor happens to be a sweetheart.",
                "You two end up talking about fine alcohol throughout the training.",
            ]
            ),

            EventChoice("training_mana",
            "Train with your own spells", 
                [
                    ChoiceEffect("level", "+", 1),
                    ChoiceEffect("mana", "-", 2),
                ],
                "{size=*0.65}"
                    "{image=wizardClass}"
                    "{space=10}"
                    "{color=34b962}"
                        "{image=levelPlus}"
                        "{space=10}"
                    "{/color}"
                    "{color=#b93434}"
                        "{image=manaMinus}"
                        "{space=10}"
                    "{/color}"
                "{/size}",
            [
                "\"{i}Help yourself{/i}\", he shrugs. An old mannequin is there for you to train with.",
                "You spend a while blasting it with spells. The old Orc can't help but regularly advise you on your posture.",
            ]),

            EventChoice("training_none",
            "Go on your way", 
                [
                ],
                "",
            [
                "You thank the Orc for the offer and go on your way. He nods respectfully.",
            ]),
            ]

            elif playerTurn == 2: 
                # WARRIOR                
                return [
            EventChoice("training_gold",
            "Pay for a session", 
                [
                    ChoiceEffect("level", "+", 1),
                    ChoiceEffect("gold", "-", 2),                
                ],
                "{size=*0.65}"
                    "{color=34b962}"
                        "{image=levelPlus}"
                        "{space=10}"
                    "{/color}"
                    "{color=#b93434}"
                        "{image=goldMinus}{image=goldMinus}"
                    "{/color}"
                "{/size}",
            [
                "You pay the Orc in advance. \"{i}Be wary. I'm a tough teacher{/i}\", he grins.",
                "That was a lie. The instructor happens to be a sweetheart.",
                "You two end up talking about fine alcohol throughout the training.",
            ]
            ),

            EventChoice("training_none",
            "Go on your way", 
                [
                ],
                "",
            [
                "You thank the Orc for the offer and go on your way. He nods respectfully.",
            ]),
            ]

        # ---THE OFFERING ---

        elif event == "event_the_offering":

            if playerTurn == 1: 
                # WIZARD
                return [
            EventChoice("offering_two",
            "Offer two coins.", 
                [
                    ChoiceEffect("mana", "+", 2),
                    ChoiceEffect("gold", "-", 2),
                ],
                "{size=*0.65}"
                    "{color=34b962}"
                        "{image=manaPlus}{image=manaPlus}"
                        "{space=10}"
                    "{/color}"
                    "{color=#b93434}"
                        "{image=goldMinus}{image=goldMinus}"
                    "{/color}"
                "{/size}",
            [
                "You can certainly afford to lighten your pockets for the master of elements.",
                "A sudden burst of power flows through you. Your offering didn't go unnoticed!",
            ]
            ),

            EventChoice("offering_one",
            "Offer one coin", 
                [
                    ChoiceEffect("mana", "+", 1),
                    ChoiceEffect("gold", "-", 1),
                ],
                "{size=*0.65}"
                    "{color=34b962}"
                        "{image=manaPlus}"
                        "{space=10}"
                    "{/color}"
                    "{color=#b93434}"
                        "{image=goldMinus}"
                    "{/color}"
                "{/size}",
            [
                "Unable to spare more than a single coin, you drop it on the tray, hoping this appeases Senruvim.",
                "A faint burst of power flows through you. It seems this was enough, after all.",
            ]),

            EventChoice("offering_none",
            "Keep your gold", 
                [
                    ChoiceEffect("special", "max_mana", -1),
                ],
                "{size=*0.65}"+
                    "{color=#b93434}"+
                        "{b}Max mana-{/b}"+
                    "{/color}"+
                "{/size}",
            [
                "You have better uses in mind for that money. Surely Senruvim will understand, right?",
                "Alas, a violent headache strikes you right as you leave the altar.",
                "You feel drained, as if some of your power left somehow.",
            ]),
            ]

            elif playerTurn == 2: 
                # WARRIOR                
                return [
            EventChoice("offering_two",
            "Offer two coins", 
                [
                    ChoiceEffect("mana", "+", 2),
                    ChoiceEffect("gold", "-", 2),
                ],
                "{size=*0.65}"
                    "{color=34b962}"
                        "{image=manaPlus}{image=manaPlus}"
                        "{space=10}"
                    "{/color}"
                    "{color=#b93434}"
                        "{image=goldMinus}{image=goldMinus}"
                    "{/color}"
                "{/size}",
            [
                "You can certainly afford to lighten your pockets for the bane of fiends.",
                "A sudden burst of power flows through you. Your offering didn't go unnoticed!",
            ]
            ),

            EventChoice("offering_one",
            "Offer one coin", 
                [
                    ChoiceEffect("mana", "+", 1),
                    ChoiceEffect("gold", "-", 1),
                ],
                "{size=*0.65}"
                    "{color=34b962}"
                        "{image=manaPlus}"
                        "{space=10}"
                    "{/color}"
                    "{color=#b93434}"
                        "{image=goldMinus}"
                    "{/color}"
                "{/size}",
            [
                "Unable to spare more than a single coin, you drop it on the tray, hoping this appeases Halforas.",
                "A faint burst of power flows through you. It seems this was enough, after all.",
            ]),

            EventChoice("offering_none",
            "Keep your gold", 
                [
                    ChoiceEffect("special", "max_mana", -1),
                ],
                "{size=*0.65}"
                    "{color=#b93434}"
                        "{b}Max mana-{/b}"
                    "{/color}"
                "{/size}",
            [
                "You have better uses in mind for that money. Surely Halforas will understand, right?",
                "Alas, a violent headache strikes you right as you leave the altar.",
                "You feel drained, as if some of your power left somehow.",
            ]),
            ]

        # --------------------
        # ----- TIER 2 -------
        # --------------------

        # --- THE IMPOTENT ---

        elif event == "event_the_impotent":

            if playerTurn == 1: 
                # WIZARD
                return [
            EventChoice("impotent_sell",
            "Sell for twice its price", 
                [
                    ChoiceEffect("gold", "+", 2),
                    ChoiceEffect("special", "item", "aphrodisiac"),
                ],
                "{size=*0.65}"
                    "{color=34b962}"
                        "{image=goldPlus}{image=goldPlus}"
                        "{space=10}"
                    "{/color}"
                    "{color=#b93434}"
                        "{b}Aphrodisiac-{/b}"
                    "{/color}"
                "{/size}",
            [
                "You're always happy to assist a soul in need, especially for the promise of coin.",
                "The Kobold jumps around, visibly thrilled : \"{i}Yes! Yes! Kalgi will make this night to remember!{/i}\"",
                "He stops to hand you the gold. \"{i}Here, for goodest Elf{/i}\".",
            ]
            ),

            EventChoice("impotent_keep",
            "Don't sell.", 
                [
                ],
                "",
            [
                "As soon as he realizes you either don't carry a bottle or prefer to keep it, the Kobold sighs.",
                "\"{i}Sad. Kalgi will get \"ready\" the old way. Although it very painful.{/i}\"",
                "He then starts to repetitively hit his own crotch while you walk away, confused."
            ]),
            ]

            elif playerTurn == 2: 
                # WARRIOR                
                return [
            EventChoice("impotent_sell",
            "Sell for twice its price", 
                [
                    ChoiceEffect("gold", "+", 2),
                    ChoiceEffect("special", "item", "aphrodisiac"),
                ],
                "{size=*0.65}"
                    "{color=34b962}"
                        "{image=goldPlus}{image=goldPlus}"
                        "{space=10}"
                    "{/color}"
                    "{color=#b93434}"
                        "{b}Aphrodisiac-{/b}"
                    "{/color}"
                "{/size}",
            [
                "You're always happy to assist a soul in need, especially for the promise of coin.",
                "The Kobold jumps around, visibly thrilled : \"{i}Yes! Yes! Kalgi will make this night to remember!{/i}\"",
                "He stops to hand you the gold. \"{i}Here, for goodest Human{/i}\".",
            ]
            ),

            EventChoice("impotent_scam",
            "Intimidate to sell for more", 
                [
                    ChoiceEffect("gold", "+", 3),
                    ChoiceEffect("special", "item", "aphrodisiac"),
                    ChoiceEffect("special", "above_lv", 5),
                ],
                "{size=*0.65}"
                    "{image=warriorClass}"
                    "{space=10}"
                    "{color=34b962}"
                        "{image=goldPlus}{image=goldPlus}{image=goldPlus}"
                        "{space=10}"
                    "{/color}"
                    "{color=#b93434}"
                        "{b}Aphrodisiac-{/b}"
                    "{/color}"
                "{/size}",
            [
                "The Kobold glares at you. \"{i}Bad human takes advantage of distress of Kalgi!{/i}\"",
                "But as the Kobold prepares for a fight, so do you and even he can see he's no match for your sword.",
                "He finally caves in. \"{i}Fine. Bad Human take the coins and leave Kalgi to his funsies.{/i}\"",
            ]),

            EventChoice("impotent_keep",
            "Don't sell.", 
                [
                ],
                "",
            [
                "As soon as he realizes you either don't carry a bottle or prefer to keep it, the Kobold sighs.",
                "\"{i}Sad. Kalgi will get \"ready\" the old way. Although it very painful.{/i}\"",
                "He then starts to repetitively hit his own crotch while you walk away, confused."
            ]),
            ]

        # ---- THE POOL ----

        elif event == "event_the_pool":

            if playerTurn == 1: 
                # WIZARD
                return [
            EventChoice("pool_dive",
            "Dive to get the gold.", 
                [
                    ChoiceEffect("gold", "+", 3),
                    ChoiceEffect("top", "-", 3),
                    ChoiceEffect("bottom", "-", 3),
                ],
                "{size=*0.65}"
                    "{color=34b962}"
                        "{image=goldPlus}{image=goldPlus}{image=goldPlus}"
                        "{space=10}"
                    "{/color}"
                    "{color=#b93434}"
                        "{image=tokenTopMinus}"
                        "{space=10}"
                        "{image=tokenBottomMinus}"
                    "{/color}"
                "{/size}",
            [
                "Fortune sometimes requires a fair sacrifice. You hastily remove your wizard robe so as to not get it wet, and enter the pool.",
                "The cold stings you like a million needles, but you hang on. Thankfully, the chest is unlocked and soon reveals its riches.",
                "Gems, crowns... and three coins to be used right away in the dungeon! Alas, you'll need quite some time to warm up after this.",
            ]
            ),

            EventChoice("pool_spell",
            "Attract the gold with a spell.", 
                [
                    ChoiceEffect("gold", "+", 3),
                    ChoiceEffect("mana", "-", 2),
                ],
                "{size=*0.65}"
                    "{image=wizardClass}"
                    "{space=10}"
                    "{color=34b962}"
                        "{image=goldPlus}{image=goldPlus}{image=goldPlus}"
                        "{space=10}"
                    "{/color}"
                    "{color=#b93434}"
                        "{image=manaMinus}{image=manaMinus}"
                    "{/color}"
                "{/size}",
            [
                "There are many a spell you could cast. A fireball to heat the water? A cold resistance enchantment? No, you'd rather not get wet at all.",
                "Lifting your staff, you use your telekinesis to draw the chest out of the water and open it.",
                "Inside are a few gems, one crown or two, but most of all three coins you could use right away!"
            ]
            ),

            EventChoice("pool_none",
            "Ignore the gold", 
                [
                ],
                "",
            [
                "There is absolutely no way you are setting foot in this frozen pool. Surely this treasure can't be worth the cold you will inevitably catch."
            ]),
            ]

            elif playerTurn == 2: 
                # WARRIOR
                    return [
                EventChoice("pool_dive",
                "Dive to get the gold.", 
                    [
                        ChoiceEffect("gold", "+", 3),
                        ChoiceEffect("top", "-", 3),
                        ChoiceEffect("bottom", "-", 3),
                    ],
                    "{size=*0.65}"
                        "{color=34b962}"
                            "{image=goldPlus}{image=goldPlus}{image=goldPlus}"
                            "{space=10}"
                        "{/color}"
                        "{color=#b93434}"
                            "{image=tokenTopMinus}"
                            "{space=10}"
                            "{image=tokenBottomMinus}"
                        "{/color}"
                    "{/size}",
                [
                    "Fortune sometimes requires sacrifices. You are fairly certain you can lift up the chest without setting foot inside, but that still means plunging your arms deep.",
                    "The cold is nigh unbearable, but you manage to get a hold of the chest and get it out of the water in one pull. You take a look inside.",
                    "Gems, crowns... and three coins to be used right away in the dungeon! Alas, you'll need quite some time to warm up after this."
                ]
                ),

                EventChoice("pool_none",
                "Ignore the gold", 
                    [
                    ],
                    "",
                [
                    "There is absolutely no way you are setting foot in this frozen pool. Surely this treasure can't be worth the cold you will inevitably catch.",
                ]),
                ]

        # -- THE ADVENTURER --

        elif event == "event_the_adventurer":

            if playerTurn == 1: 
                # WIZARD
                return [
            EventChoice("adventurer_kiss",
            "Ask for a kiss.", 
                [
                    ChoiceEffect("top", "+", 4),
                    ChoiceEffect("bottom", "+", 4),
                ],
                "{size=*0.65}"
                    "{color=34b962}"
                        "{image=tokenTopPlus}"
                        "{space=10}"
                        "{image=tokenBottomPlus}"
                        "{space=10}"
                    "{/color}"
                "{/size}",
            [
                "The adventurer smiles one more. \"Ah, yes. I'd say you deserve that much.\" She pushes her lips against yours, and quite eargerly at that.",
                "Her kiss tastes of hibiscus. You can't help but slip a hand under her cloak to touch her chest.",
                "She chuckles and steps back. \"{i}Well then, this was quite pleasant. Until we meet again, perhaps?{/i}\""
            ]
            ),

            EventChoice("adventurer_item",
            "Ask for an item.", 
                [
                    ChoiceEffect("special", "item", "+random"),
                ],
                "{size=*0.65}"
                    "{color=34b962}"
                        "Random item"
                        "{space=10}"
                    "{/color}"
                "{/size}",
            [
                "The adventurer looks surprised. It seems like this wasn't what she had in mind. Still, she takes something out of her bag.",
                "\"{i}Would this be to your liking, sir wizard? I'm afraid I have naught else to offer{/i}\".",
            ]
            ),

            EventChoice("adventurer_gold",
            "Ask for gold", 
                [
                    ChoiceEffect("gold", "+", 2),
                ],
                "{size=*0.65}"
                    "{color=34b962}"
                        "{image=goldPlus}{image=goldPlus}"
                        "{space=10}"
                    "{/color}"
                "{/size}",
            [
                "The adventurer almost looks disappointed as she goes to fetch a sachel.",
                "\"{i}Here{/i}\", she says handing you its content. \"{i}No good deed goes unrewarded.{/i}\"",
            ]),
            ]

            elif playerTurn == 2: 
                # WARRIOR
                return [
            EventChoice("adventurer_kiss",
            "Ask for a kiss.", 
                [
                    ChoiceEffect("top", "+", 4),
                    ChoiceEffect("bottom", "+", 4),
                ],
                "{size=*0.65}"
                    "{color=34b962}"
                        "{image=tokenTopPlus}"
                        "{space=10}"
                        "{image=tokenBottomPlus}"
                        "{space=10}"
                    "{/color}"
                "{/size}",
            [
                "The adventurer smiles one more. \"Ah, yes. I'd say you deserve that much.\" He pushes his lips against yours, and quite eargerly at that.",
                "His kiss tastes of hibiscus. You can't help but slip a hand under his cloak to touch his chest.",
                "He chuckles and steps back. \"{i}Well then, this was quite pleasant. Until we meet again, perhaps?{/i}\"",
            ]
            ),

            EventChoice("adventurer_item",
            "Ask for an item.", 
                [
                    ChoiceEffect("special", "item", "+random"),
                ],
                "{size=*0.65}"
                    "{color=34b962}"
                        "Random item"
                        "{space=10}"
                    "{/color}"
                "{/size}",
            [
                "The adventurer looks surprised. It seems like this wasn't what he had in mind. Still, he takes something out of his bag.",
                "\"{i}Would this be to your liking, lady warrior? I'm afraid I have naught else to offer{/i}\".",
            ]
            ),

            EventChoice("adventurer_gold",
            "Ask for gold", 
                [
                    ChoiceEffect("gold", "+", 2),
                ],
                "{size=*0.65}"
                    "{color=34b962}"
                        "{image=goldPlus}{image=goldPlus}"
                        "{space=10}"
                    "{/color}"
                "{/size}",
            [
                "The adventurer almost looks disappointed as he goes to fetch a sachel.",
                "\"{i}Here{/i}\", he says handing you its content. \"{i}No good deed goes unrewarded.{/i}\"",
            ]),
        ]

        # ---- THE GAOL ----

        elif event == "event_the_gaol":

            if playerTurn == 1: 
                # WIZARD
                return [
            EventChoice("gaol_peek",
            "Peek in the cell.", 
                [
                    ChoiceEffect("top", "+", 4),
                    ChoiceEffect("bottom", "+", 4),
                    ChoiceEffect("level", "-", 1),
                ],
                "{size=*0.65}"
                    "{color=34b962}"
                        "{image=tokenTopPlus}"
                        "{space=10}"
                        "{image=tokenBottomPlus}"
                        "{space=10}"
                    "{/color}"
                    "{color=#b93434}"
                        "{image=levelMinus}"
                    "{/color}"
                "{/size}",
            [
            "It's much darker than you expected but you can see the silhouette of a horned figure. The shadow cast on the wall didn't have horns, did it?",
            "Her partner moans in pleasure and she raises her head, locking eyes with you. Her mouth draws a wicked smile.",
            "You feel a compelling urge to masturbate but are strong enough to resist and flee. Still, you feel like this sight alone drained your will."
            ]
            ),

            EventChoice("gaol_none",
            "Don't peek.", 
                [
                ],
                "",
            [
            "There is nothing you'd like more than to take a glance inside the cell, to a point where it feels awfully strange.",
            "As a mage, you know some twisted magic is at work here. A magic whose puppet you do not wish to become.",
            "Leaving the sighs and moans behind, you escape the prison without as much as a look past you."
            ]
            ),
            ]

            elif playerTurn == 2: 
                # WARRIOR
                return [

            EventChoice("gaol_peek",
            "Peek in the cell.", 
                [
                    ChoiceEffect("top", "+", 4),
                    ChoiceEffect("bottom", "+", 4),
                    ChoiceEffect("level", "-", 1),
                ],
                "{size=*0.65}"
                    "{color=34b962}"
                        "{image=tokenTopPlus}"
                        "{space=10}"
                        "{image=tokenBottomPlus}"
                        "{space=10}"
                    "{/color}"
                    "{color=#b93434}"
                        "{image=levelMinus}"
                    "{/color}"
                "{/size}",
            [
            "It's much darker than you expected but you can see the silhouette of a horned figure. The shadow cast on the wall didn't have horns, did it?",
            "His partner moans in pleasure and he raises her head, locking eyes with you. His mouth draws a wicked smile.",
            "You feel a compelling urge to masturbate but are strong enough to resist and flee. Still, you feel like this sight alone drained your will."
            ]
            ),

            EventChoice("gaol_none",
            "Don't peek", 
                [
                ],
                "",
            [
            "There is nothing you'd like more than to take a glance inside the cell, to a point where it feels awfully strange.",
            "As a warrior, you've learnt to trust your instincts and it's currently ringing every alarm bells it can in your head.",
            "Leaving the sighs and moans behind, you escape the prison without as much as a look past you."
            ]),
        ]

        # --- THE SORCERESS ---

        elif event == "event_the_sorceress":


            if playerTurn == 1: 
                # WIZARD
                return [

            EventChoice("sorceress_mana",
            "Ask for the gem's power", 
                [
                    ChoiceEffect("max_mana", "+", 1),
                    ChoiceEffect("special", "item", "glowing_gem"),
                ],
                "{size=*0.65}"
                    "{color=34b962}"
                        "{b}Max mana+{/b}"
                        "{space=10}"
                    "{/color}"
                    "{color=#b93434}"
                        "{b}Glowing gem-{/b}"
                    "{/color}"
                "{/size}",
                        [
            "Was this a smile you faintly saw? The Kobold takes the gem out of your hand and starts casting a spell.",
            "As a wizard yourself, you pay a close attention to the words she mutters and it does sound like she is expurging the magic out of it.",
            "A split second later, you feel a surge flowing through you. And it looks like she does too. \"{i}I took my share of it. Naturally.\"{/i}"
            ]),

            EventChoice("sorceress_gold",
            "Ask for gold", 
                [
                    ChoiceEffect("gold", "+", 4),
                    ChoiceEffect("special", "item", "glowing_gem"),
                ],
                "{size=*0.65}"
                    "{color=34b962}"
                        "{image=goldPlus}{image=goldPlus}{image=goldPlus}{image=goldPlus}"
                        "{space=10}"
                    "{/color}"
                    "{color=#b93434}"
                        "{b}Glowing gem-{/b}"
                    "{/color}"
                "{/size}",
            [
            "\"{i}A fine specimen{/i}\", the Kobold observes. \"{i}A fine specimen worth four coins. You agree, yes?{/i}\"",
            "You were expecting to haggle, but this might be the highest price someone ought to pay for this item.",
            "Besides, the gem already found its way into her hand and your purse somehow seems heavier than before."
            ]
            ),

            EventChoice("sorceress_keep",
            "Leave.", 
                [
                ],
                "",
            [
            "Whether you don't possess the gem or simply don't want to part with it, the Kobold cares very little.",
            "\"{i}Then I have no interest in you. Begone and leave me to my craft, Elf.\"{/i}"
            ]),
            ]

            elif playerTurn == 2: 
                # WARRIOR                
                                return [

            EventChoice("sorceress_mana",
            "Ask for the gem's power", 
                [
                    ChoiceEffect("max_mana", "+", 1),
                    ChoiceEffect("special", "item", "glowing_gem"),
                ],
                "{size=*0.65}"
                    "{color=34b962}"
                        "{b}Max mana+{/b}"
                        "{space=10}"
                    "{/color}"
                    "{color=#b93434}"
                        "{b}Glowing gem-{/b}"
                    "{/color}"
                "{/size}",
            [
            "Was this a smile you faintly saw? The Kobold takes the gem out of your hand and starts casting a spell.",
            "As a warrior, you know next to nothing about magic, but you are ready to strike at the first sign of treachery.",
            "A split second later, you feel a surge flowing through you. And it looks like she does too. \"{i}I took my share of it. Naturally.\"{/i}"
            ]),

            EventChoice("sorceress_gold",
            "Ask for gold", 
                [
                    ChoiceEffect("gold", "+", 4),
                    ChoiceEffect("special", "item", "glowing_gem"),
                ],
                "{size=*0.65}"
                    "{color=34b962}"
                        "{image=goldPlus}{image=goldPlus}{image=goldPlus}{image=goldPlus}"
                        "{space=10}"
                    "{/color}"
                    "{color=#b93434}"
                        "{b}Glowing gem-{/b}"
                    "{/color}"
                "{/size}",
            [
            "\"{i}A fine specimen{/i}\", the Kobold observes. \"{i}A fine specimen worth four coins. You agree, yes?{/i}\"",
            "You were expecting to haggle, but this might be the highest price someone ought to pay for this item.",
            "Besides, the gem already found its way into her hand and your purse somehow seems heavier than before."
            ]
            ),

            EventChoice("sorceress_keep",
            "Leave.", 
                [
                ],
                "",
            [
            "Whether you don't possess the gem or simply don't want to part with it, the Kobold cares very little.",
            "\"{i}Then I have no interest in you. Begone and leave me to my craft, Human.\"{/i}"
            ]),
            ]


    def isChoiceValid(choice, playerMana, playerGold, playerLv, playerItems):
        value = True
        for i in choice.choiceEffects:

            if i.stat == "special":
                items = []
                if i.modifier == "item":
                    
                    if i.value == "+random": # If no more item to give, choice is locked
                        if len(getAvailableItemsUpToCurrentTier(1)) == 0:
                            value = False
                    else:
                        for j in playerItems:
                            items.append(j.icon)
                        if i.value not in items:
                            value = False

                if i.modifier == "above_lv":
                    if playerLv < i.value:
                        value = False

            elif i.modifier == "-":
                if (i.stat == "mana" and playerMana < i.value) or (i.stat == "gold" and playerGold <i.value):
                    value = False
        return value

    def resolveChoiceEffects(choiceEffects, player):

        for i in choiceEffects:
        # if len(choiceEffects) > 0:
            if i.stat == "top":
                if i.modifier == "+":
                    addTopPoints(player, i.value)
                elif i.modifier == "-":
                    removeTopPoints(player, i.value)

            elif i.stat == "bottom":
                if i.modifier == "+":
                    addBottomPoints(player, i.value)
                elif i.modifier == "-":
                    removeBottomPoints(player, i.value)

            elif i.stat == "mana":
                if i.modifier == "+":
                    addMana(player, i.value)
                elif i.modifier == "-":
                    removeMana(player, i.value)

            elif i.stat == "gold":
                renpy.notify("test")
                if i.modifier == "+":
                    addGold(player, i.value)
                elif i.modifier == "-":
                    removeGold(player, i.value)

            elif i.stat == "level":
                if i.modifier == "+":
                    addLevel(player, i.value)
                elif i.modifier == "-":
                    removeLevel(player, i.value)
                
            elif i.stat == "special":
                if i.modifier == "turn":
                    globals()["extraTurn"] = True
                elif i.modifier == "fight":
                    globals()["eventEncounter"] = i.value
                    renpy.jump("resolve_encounter")
                elif i.modifier == "max_mana":
                    globals()["player" + str(player) + "Stats"]["max_mana"] += i.value
                elif i.modifier == "item":
                    if i.value == "+random": # Offering random item
                        addItem(player, getRandomItem(1))
                    else: # Removing specific item
                        for j in globals()["player" + str(player) + "Items"]:
                            if j.icon == i.value:
                                removeItem(player, j)
            renpy.pause(.15)
                # addGold(player, gold)