init python:

    def getOpponentAi():
        character = 2 if soloPlayer == 1 else 1
        stats = player2Stats if character == 2 else player1Stats
        items = player2Items if character == 2 else player1Items
        return OpponentAi(character, stats, items, "undecided", "normal")


    def updateAiBehaviour():
        playerTop = globals()["player" + str(soloPlayer) + "Stats"]["top"]
        playerBottom = globals()["player" + str(soloPlayer) + "Stats"]["bottom"]

        if opponentAi.stats["top"] > opponentAi.stats["bottom"]:
            if playerTop >=  (opponentAi.stats["top"]*1.5):
                opponentAi.goalPicked = "bottom"
            else:
                opponentAi.goalPicked = "top"

        elif opponentAi.stats["bottom"] > opponentAi.stats["top"]:
            if playerBottom >= (opponentAi.stats["bottom"]*1.5):
                opponentAi.goalPicked = "top"
            else:
                opponentAi.goalPicked = "bottom"

        else:
            if playerTop > playerBottom:
                opponentAi.goalPicked = "bottom"
            elif playerBottom > playerTop:
                opponentAi.goalPicked = "top"
            else:
                opponentAi.goalPicked = "undecided"
        

    def updateAiStats(turnPhase):
        if turnPhase == "new turn":
            opponentAi.stats = player1Stats if opponentAi.character == 1 else player2Stats
        elif turnPhase == "end of turn":
            if opponentAi.character == 1:
                globals()["player1Stats"] = opponentAi.stats
            else:
                globals()["player2Stats"] = opponentAi.stats


    def ai_gustOfWind(movement, mana):
        if mana > 5:
            renpy.say("p1", "I'll use two Mana to move two rooms further.")
            skill_GustOfWind(2)
        elif mana == 5:
            if movement <= 3:
                renpy.say("p1", "I'll use two Mana to move two rooms further.")
                skill_GustOfWind(2)
            else:
                renpy.say("p1", "I'll use one Mana to move one room further.")
                skill_GustOfWind(1)
        elif mana == 4:
            if movement <= 2:
                renpy.say("p1", "I'll use two Mana to move two rooms further.")
                skill_GustOfWind(2)
            else:
                renpy.say("p1", "I'll use one Mana to move one room further.")
                skill_GustOfWind(1)
        elif mana == 3 and movement <= 2:
                renpy.say("p1", "I'll use one Mana to move one room further.")
                skill_GustOfWind(1)

        elif mana == 2 and movement == 1:
            renpy.say("p1", "I'll use one Mana to move one room further.")
            skill_GustOfWind(1)
        else:
            renpy.say("p1", "I won't use any Mana to move further")

    def ai_endurance(lastChoice):
        if lastChoice == "fight":
            if opponentAi.stats["mana"] >= 2:
                skill_Endurance(2)
                renpy.say("p2", "And I'll use two Mana to get an extra turn")
            else:
                renpy.say("p2", "Shit, not enough Mana for an extra turn...")
        else:
            if opponentAi.stats["mana"] >= 3:
                skill_Endurance(3)
                renpy.say("p2", "And I'll use three Mana to get an extra turn")
            else:
                renpy.say("p2", "Shit, not enough Mana for an extra turn...")

    def ai_resolveEvent(event, playerTurn):
        choicesList = getEventChoices(event, playerTurn)

        if event == "event_the_merchant":
            if opponentAi.stats["gold"] < 2:
                # Can't buy
                return [choicesList[2], "I don't have enough gold, so no."]
            elif opponentAi.goalPicked == "undecided":
                # Doesn't bother
                return [choicesList[2], "I'm not really interested."]
            elif opponentAi.goalPicked == "top": 
                # Bought Top potion
                return [choicesList[0], "Sure, I'll take the Top potion."]
            elif opponentAi.goalPicked == "bottom": 
                # Bought Bottom potion
                return [choicesList[1], "Sure, I'll take the Bottom potion."]

        elif event == "event_the_troll":
            randomNb = renpy.random.randint(1,2)
            if opponentAi.goalPicked == "top" or (opponentAi.goalPicked == "undecided" and randomNb == 1): 
                # Use force to pass
                return [choicesList[0], "I'll take the most aggressive option."]
            elif opponentAi.goalPicked == "bottom" or (opponentAi.goalPicked == "undecided" and randomNb == 2): 
                # Use subtlety to pass
                return [choicesList[1], "I'll take the most subtle option."]

        elif event == "event_the_tavern":
            if playerTurn == 2 and (opponentAi.stats["top"] >= 10 or opponentAi.stats["bottom"] >= 10):
                    # Bet a pint on Halforas
                    return [choicesList[2], "I'bet a pint on Halforas."]
            else:
                randomNb = renpy.random.randint(1,2)
                if opponentAi.goalPicked == "top" or (opponentAi.goalPicked == "undecided" and randomNb == 1): 
                    # Disagree with the Goblins
                    return [choicesList[0], "I'd rather praise my own God."]
                elif opponentAi.goalPicked == "bottom" or (opponentAi.goalPicked == "undecided" and randomNb == 2): 
                    # Agree with the Goblins
                    return [choicesList[1], "I'll play safe and agree with the Goblins."]

        elif event == "event_the_training":
            soloPlayerLevel = player1Stats["level"] if opponentAi.character == 2 else player2Stats["level"]
            if playerTurn == 1 and ((opponentAi.stats["mana"] > 3) or (opponentAi.stats["mana"] > 2 and opponentAi.stats["level"] < soloPlayerLevel)): 
                    # Trained for mana
                    return [choicesList[1], "Sure, I have mana to spare."]
            elif opponentAi.stats["gold"] > 3 or (opponentAi.stats["gold"] > 2 and opponentAi.stats["level"] < soloPlayerLevel): 
                # Trained for gold
                return [choicesList[0], "Sure, I have gold to spare."]
            else:
                if playerTurn == 1:
                    # Didn't train (Wizard)
                    return [choicesList[2], "No, I'd rather not."]
                else:
                    # Didn't train (Warrior)
                    return [choicesList[1], "No, I'd rather not."]

        elif event == "event_the_offering":
            if opponentAi.stats["gold"] >= 2 and opponentAi.stats["mana"]<3:
                # Gave 2 coins
                return [choicesList[0], "Let's go, I have coin to spare."]
            if opponentAi.stats["gold"] >= 1:
                # Gave 1 coins
                return [choicesList[1], "I'll only give one coin."]
            else:
                # Didn't offer anything
                return [choicesList[2], "Shit, I can't afford this right now."]

        elif event == "event_the_impotent":
            if opponentAi.character == 1:
                if checkItem(1, "Aphrodisiac"):
                    # Don't sell
                    return [choicesList[1], "Because I have one doesn't mean I'll sell it."]
                else:
                    # Can't sell
                    return [choicesList[1], "I don't even have one to begin with..."]
            else:
                if checkItem(2, "Aphrodisiac"):
                    # Don't sell
                    return [choicesList[2], "Because I have one doesn't mean I'll sell it."]
                else:
                    # Can't sell
                    return [choicesList[2], "I don't even have one to begin with..."]

        elif event == "event_the_pool":
            if opponentAi.character == 1:
                if opponentAi.stats["mana"] > 4:
                    # Use a spell to get the gold
                    return [choicesList[1], "I'll use a spell to fetch all that gold."]
                elif opponentAi.stats["mana"] > 1:
                    if opponentAi.stats["gold"] < 3:
                        # Use a spell to get the gold
                        return [choicesList[1], "I'll use a spell to fetch all that gold."]
                    else:
                        # Don't bother
                        return [choicesList[2], "I don't think that's worth the trouble."]
                else: 
                    if opponentAi.stats["gold"] < 3:
                        # Dive to get the gold
                        return [choicesList[0], "Who cares about some water? I'll get the gold."]
                    else: # Don't bother
                        return [choicesList[2], "I don't think that's worth the trouble."]

            else:
                if opponentAi.stats["gold"] < 3:
                    # Dive to get the gold
                    return [choicesList[0], "Who cares about some water? I'll get the gold."]
                else: # Don't bother
                    return [choicesList[1], "I don't think that's worth the trouble."]

        elif event == "event_the_adventurer":
            if len(opponentAi.items) < 3:
                # Ask for an item
                return [choicesList[1], "I'd rather ask for an item."]
            elif opponentAi.stats["gold"] < 3:
                # Ask for gold
                return [choicesList[2], "I'll ask for gold."]
            else:
                # Ask for a kiss
                return [choicesList[0], "I'm more interested in a kiss..."]

        elif event == "event_the_gaol":
            soloPlayerLevel = player1Stats["level"] if opponentAi.character == 2 else player2Stats["level"]
            if opponentAi.stats["level"] > 5:
                # Peek in the cell
                return [choicesList[0], "Alright, I'll have a quick look..."]
            else:
                # Keep your cool
                return [choicesList[1], "No, I'd better stay focused."]

        elif event == "event_the_sorceress":
            if checkItem(opponentAi.character, "Glowing gem", ):
                if opponentAi.stats["max_mana"] < 7:
                    # Ask for the gem's power
                    return [choicesList[0], "I definitely want some more mana"]
                elif opponentAi.stats["gold"] < 9:
                    # Ask for gold
                    return [choicesList[1], "I'd rather have gold"]
                else:
                    # Not selling
                    return [choicesList[2], "Sorry lady, I'm keeping my gem."]
            else:
                # Can't sell
                return [choicesList[2], "Sorry lady, I  don't have your gem."]

    def ai_resolveEncounter(encounter):
        if opponentAi.goalPicked == "undecided":
            if opponentAi.stats["level"] >= encounter.requiredLv:
                return "fight"
            else:
                return "escape"

        elif opponentAi.goalPicked == "top":
            if opponentAi.stats["top"] >= encounter.requiredPts:
                return "top"
            elif opponentAi.stats["level"] >= encounter.requiredLv:
                return "fight"
            else:
                return "escape"

        elif opponentAi.goalPicked == "bottom":
            if opponentAi.stats["bottom"] >= encounter.requiredPts:
                return "bottom"
            elif opponentAi.stats["level"] >= encounter.requiredLv:
                return "fight"
            else:
                return "escape"

    def ai_resolveItem(foundItem):

        if len(opponentAi.items) < 6:
            if foundItem in ["rope", "leash"] and opponentAi.goalPicked == "bottom":
                renpy.say("p1" if soloPlayer == 2 else "p2", "I don't need this.")
                return False
            elif foundItem in ["collar", "gag"] and opponentAi.goalPicked == "top":
                renpy.say("p1" if soloPlayer == 2 else "p2", "I don't need this.")
                return False
            elif foundItem == "glowing_gem" and opponentAi.stats["max_mana"] > 6:
                renpy.say("p1" if soloPlayer == 2 else "p2", "I don't need this.")
                return False
            else:
                renpy.say("p1" if soloPlayer == 2 else "p2", "I'll take it.")
                return True
        else:
            renpy.say("p1" if soloPlayer == 2 else "p2", "I'm already full.")
            return False

    def ai_resolveShop(shopSelection):

        buyDecision = [0, 0, 0] 

        # Set "priority" for each item in shop according to stats and behaviour 

        for index, i in enumerate(shopSelection):
            if i.name in ["Rope"]:
                if opponentAi.goalPicked == "top":
                    buyDecision[index] = 3
                else:
                    buyDecision[index] = 0

            elif i.name in ["Collar"]:
                if opponentAi.goalPicked == "bottom":
                    buyDecision[index] = 3
                else:
                    buyDecision[index] = 0

            elif i.name in ["Aphrodisiac"]:
                if opponentAi.goalPicked == "undecided":
                    buyDecision[index] = 3
                else:
                    buyDecision[index] = 2   

            elif i.name == "Emblem":
                soloPlayerLevel = player1Stats["level"] if opponentAi.character == 2 else player2Stats["level"]
                if opponentAi.stats["level"] < soloPlayerLevel:
                    buyDecision[index] = 2
                else:
                    buyDecision[index] = 1

            elif i.name == "Glowing gem":
                if opponentAi.character == 1:
                    buyDecision[index] = 2
                else:
                    buyDecision[index] = 1

            elif i.name == "Leash":
                if opponentAi.goalPicked == "top":
                    buyDecision[index] = 7
                else:
                    buyDecision[index] = 0

            elif i.name == "Gag":
                if opponentAi.goalPicked == "bottom":
                    buyDecision[index] = 7
                else:
                    buyDecision[index] = 0

            elif i.name == "Lube":
                soloPlayerTop = player1Stats["top"] if opponentAi.character == 2 else player2Stats["top"]
                soloPlayerBottom = player1Stats["bottom"] if opponentAi.character == 2 else player2Stats["bottom"]
                if opponentAi.goalPicked == "undecided":
                    buyDecision[index] = 7
                elif opponentAi.goalPicked == "top" and opponentAi.stats["top"] < soloPlayerBottom:
                    buyDecision[index] = 5
                elif opponentAi.goalPicked == "bottom" and opponentAi.stats["bottom"] < soloPlayerTop:
                    buyDecision[index] = 5
                else:
                    buyDecision[index] = 3

            elif i.name == "Ring of Fortune":
                if opponentAi.stats["gold"] > 10:
                    buyDecision[index] = 3
                elif opponentAi.stats["gold"] > 7:
                    buyDecision[index] = 4
                else:
                    buyDecision[index] = 5

            elif i.name == "Quickstep Boots":
                if opponentAi.character == 2:
                    buyDecision[index] = 5
                else:
                    buyDecision[index] = 3

        # Change priorities according to prices and current money

        itemChoice = ""
        maxBuyDecision = 0
        text = ""

        for index, i in enumerate(shopSelection):

            if i.value > opponentAi.stats["gold"]:
                buyDecision[index] = 0

            buyDecision[index] -= i.value/2
            
            if buyDecision[index] > maxBuyDecision:
                itemChoice = i
                maxBuyDecision = buyDecision[index]
                text = i.name
                renpy.say("p1" if soloPlayer == 2 else "p2", text + ".")
        if itemChoice != "":
            globals()["itemsBought"] += 1
            buyItem(opponentAi.character, itemChoice)

        return text

    def ai_resolveMirror():
        
        if opponentAi.goalPicked == "top" and opponentAi.stats["top"] > topPool and opponentAi.stats["mana"] > 0 and topPool > 3:
            renpy.say("p1" if playerTurn == 1 else "p2", _("I'll get some Top points from the mirror."))
            renpy.say(None, _("There's [topPool] Top points in the mirror. How many do you want?"))

            halfPts = int(topPool/2)
            quarterPts = int(topPool/4)

            if topPool > 10:
                if opponentAi.stats["mana"] >= 3:
                    renpy.say("p1" if playerTurn == 1 else "p2", _("I'll spend 3 mana to get all of it."))
                    renpy.say(None, _("Alright. [topPool] Top points for you then."))
                    addTopPoints(playerTurn, topPool)
                    globals()["topPool"] = 0
                elif opponentAi.stats["mana"] >= 2:
                    renpy.say("p1" if playerTurn == 1 else "p2", _("I'll spend 2 mana to get half of it."))
                    renpy.say(None, _("Alright. " + str(halfPts) + "  Top points for you then."))
                    addTopPoints(playerTurn, halfPts)
                    globals()["topPool"] -= halfPts
                else:
                    renpy.say("p1" if playerTurn == 1 else "p2", _("I'll spend 1 mana to get a quarter of it."))
                    renpy.say(None, _("Alright. " + str(quarterPts) + " Top points for you then."))
                    addTopPoints(playerTurn, quarterPts)
                    globals()["topPool"] -= quarterPts


            elif topPool > 5:
                if opponentAi.stats["mana"] >= 4:
                    renpy.say("p1" if playerTurn == 1 else "p2", _("I'll spend 3 mana to get all of it."))
                    renpy.say(None, _("Alright. [topPool] Top points for you then."))
                    addTopPoints(playerTurn, topPool)
                    globals()["topPool"] = 0
                elif opponentAi.stats["mana"] >= 3:
                    renpy.say("p1" if playerTurn == 1 else "p2", _("I'll spend 2 mana to get half of it."))
                    renpy.say(None, _("Alright. " + str(halfPts) + " Top points for you then."))
                    addTopPoints(playerTurn, halfPts)
                    globals()["topPool"] -= halfPts
                else:
                    renpy.say("p1" if playerTurn == 1 else "p2", _("I'll spend 1 mana to get a quarter of it."))
                    renpy.say(None, _("Alright. " + str(quarterPts) + " Top points for you then."))
                    addTopPoints(playerTurn, quarterPts)
                    globals()["topPool"] -= quarterPts


            else:
                if opponentAi.stats["mana"] >= 5:
                    renpy.say("p1" if playerTurn == 1 else "p2", _("I'll spend 3 mana to get all of it."))
                    renpy.say(None, _("Alright. [topPool]Top points for you then."))
                    addTopPoints(playerTurn, topPool)
                    globals()["topPool"] = 0
                elif opponentAi.stats["mana"] >= 4:
                    renpy.say("p1" if playerTurn == 1 else "p2", _("I'll spend 2 mana to get half of it."))
                    renpy.say(None, _("Alright. " + str(halfPts) + "  Top points for you then."))
                    addTopPoints(playerTurn, halfPts)
                    globals()["topPool"] -= halfPts
                else:
                    renpy.say("p1" if playerTurn == 1 else "p2", _("I'll spend 1 mana to get a quarter of it."))
                    renpy.say(None, _("Alright. " + str(quarterPts) + " Top points for you then."))
                    addTopPoints(playerTurn, quarterPts)
                    globals()["topPool"] -= quarterPts

        elif opponentAi.goalPicked == "bottom" and opponentAi.stats["bottom"] > bottomPool and opponentAi.stats["mana"] > 0 and bottomPool > 3:

            renpy.say("p1" if playerTurn == 1 else "p2", _("I'll get some Bottom points from the mirror."))
            renpy.say(None, _("There's [bottomPool] Bottom points in the mirror. How many do you want?"))

            halfPts = int(bottomPool/2)
            quarterPts = int(bottomPool/4)

            if bottomPool > 10:
                if opponentAi.stats["mana"] >= 3:
                    renpy.say("p1" if playerTurn == 1 else "p2", _("I'll spend 3 mana to get all of it."))
                    renpy.say(None, _("Alright. [bottomPool] Bottom points for you then."))
                    addBottomPoints(playerTurn, bottomPool)
                    globals()["bottomPool"] = 0
                elif opponentAi.stats["mana"] >= 2:
                    renpy.say("p1" if playerTurn == 1 else "p2", _("I'll spend 2 mana to get half of it."))
                    renpy.say(None, _("Alright. " + str(halfPts) + " Bottom points for you then."))
                    addBottomPoints(playerTurn, halfPts)
                    globals()["bottomPool"] -= halfPts
                else:
                    renpy.say("p1" if playerTurn == 1 else "p2", _("I'll spend 1 mana to get a quarter of it."))
                    renpy.say(None, _("Alright. " + str(quarterPts) + " Bottom points for you then."))
                    addBottomPoints(playerTurn, quarterPts)
                    globals()["bottomPool"] -= quarterPts


            elif bottomPool > 5:
                if opponentAi.stats["mana"] >= 4:
                    renpy.say("p1" if playerTurn == 1 else "p2", _("I'll spend 3 mana to get all of it."))
                    renpy.say(None, _("Alright. [bottomPool] Bottom points for you then."))
                    addBottomPoints(playerTurn, bottomPool)
                    globals()["bottomPool"] = 0
                elif opponentAi.stats["mana"] >= 3:
                    renpy.say("p1" if playerTurn == 1 else "p2", _("I'll spend 2 mana to get half of it."))
                    renpy.say(None, _("Alright. " + str(halfPts) + "  Bottom points for you then."))
                    addBottomPoints(playerTurn, halfPts)
                    globals()["bottomPool"] -= halfPts
                else:
                    renpy.say("p1" if playerTurn == 1 else "p2", _("I'll spend 1 mana to get a quarter of it."))
                    renpy.say(None, _("Alright. " + str(quarterPts) + " Bottom points for you then."))
                    addBottomPoints(playerTurn, quarterPts)
                    globals()["bottomPool"] -= quarterPts


            else:
                if opponentAi.stats["mana"] >= 5:
                    renpy.say("p1" if playerTurn == 1 else "p2", _("I'll spend 3 mana to get all of it."))
                    renpy.say(None, _("Alright. [bottomPool] Bottom points for you then."))
                    addBottomPoints(playerTurn, bottomPool)
                    globals()["bottomPool"] = 0
                elif opponentAi.stats["mana"] >= 4:
                    renpy.say("p1" if playerTurn == 1 else "p2", _("I'll spend 2 mana to get half of it."))
                    renpy.say(None, _("Alright. " + str(halfPts) + "  Bottom points for you then."))
                    addBottomPoints(playerTurn, halfPts)
                    globals()["bottomPool"] -= halfPts
                else:
                    renpy.say("p1" if playerTurn == 1 else "p2", _("I'll spend 1 mana to get a quarter of it."))
                    renpy.say(None, _("Alright. " + str(quarterPts) + " Bottom points for you then."))
                    addBottomPoints(playerTurn, quarterPts)
                    globals()["bottomPool"] -= quarterPts


        else:
            renpy.say("p1" if playerTurn == 1 else "p2", _("I'm not interested, for now."))
            return ""
