﻿

define a = Character("Ace", color = "#f91e1e")
define p = Character("[persistent.player_name]", color = "#ffea74")

image kitchen = "images/bgs/kitchen.png"
# Declare variables
init python:
    if not hasattr(persistent, "player_name") or persistent.player_name is None:
        persistent.player_name = ""
    if not hasattr(persistent, "player_gender") or persistent.player_gender is None:
        persistent.player_gender = ""
    if not hasattr(persistent, "player_skin") or persistent.player_skin is None:
        persistent.player_skin = ""
    if not hasattr(persistent, "chapters_just_unlocked") or persistent.chapters_just_unlocked is None:
        persistent.chapters_just_unlocked = False
    if not hasattr(persistent, "meeting_unlocked") or persistent.meeting_unlocked is None:
        persistent.meeting_unlocked = False

$ persistent.meeting_unlocked = False
transform shakechar:
    ease .05 yoffset 20
    ease .05 yoffset -20
    ease .03 yoffset 12
    ease .03 yoffset -12
    ease .01 yoffset 4
    ease .01 yoffset -4
    ease .01 yoffset 0


# The game starts here.
label start:
    call screen playerselect
    scene bg_room 
    hide screen playerselect

# Selection screen
screen playerselect():

    tag playerselect  # Ensures it replaces any other shown screen

    # Background
    add "images/pselect/bg.png"

    # Name input background (image)
    imagebutton:
        idle "images/pselect/namebox-idle.png"
        hover "images/pselect/namebox-hover.png"
        align (468, 253, 981, 93)
        focus_mask True
        action NullAction()  # No action needed, input is separate

    # Input field on top of image
    input:
        xpos 478
        ypos 273
        xsize 960
        ysize 50
        length 20
        value VariableInputValue("persistent.player_name")
        color "#000"
        size 60
        allow "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz '-"

    # Gender selection
    imagebutton:
        idle "images/pselect/male.png"
        hover "images/pselect/male-hover.png"
        selected_idle "images/pselect/male-hover-selected.png"
        selected_hover "images/pselect/male-hover-selected.png"
        action SetVariable("persistent.player_gender", "male")
        selected (persistent.player_gender == "male")
        align(377, 476, 416, 134)
        focus_mask True

    imagebutton:
        idle "images/pselect/female.png"
        hover "images/pselect/female-hover.png"
        selected_idle "images/pselect/female-hover-selected.png"
        selected_hover "images/pselect/female-hover-selected.png"
        action SetVariable("persistent.player_gender", "female")
        selected (persistent.player_gender == "female")
        align(1106, 475, 416, 136)
        focus_mask True 

    # Skin color selection
    imagebutton:
        idle "images/pselect/white.png"
        hover "images/pselect/white-hover.png"
        selected_idle "images/pselect/white-hover-selected.png"
        selected_hover "images/pselect/white-hover-selected.png"
        action SetVariable("persistent.player_skin", "white")
        selected (persistent.player_skin =="white")
        align(679, 891)
        focus_mask True

    imagebutton:
        idle "images/pselect/mixed.png"
        hover "images/pselect/mixed-hover.png"
        selected_idle "images/pselect/mixed-hover-selected.png"
        selected_hover"images/pselect/mixed-hover-selected.png"
        action SetVariable("persistent.player_skin", "mixed")
        selected (persistent.player_skin =="mixed")
        align(1106, 898)
        focus_mask True

    imagebutton:
        idle "images/pselect/black1.png"
        hover "images/pselect/black-hover.png"
        selected_idle "images/pselect/black-hover-selected.png"
        selected_hover "images/pselect/black-hover-selected.png"
        action SetVariable("persistent.player_skin", "black")
        selected (persistent.player_skin == "black")
        align(1538, 900)
        focus_mask True

    # Confirm button (optional)
    textbutton "Confirm":
        xpos 885
        ypos 950
        action [Hide("playerselect"), Return()]
        sensitive (persistent.player_name and persistent.player_gender and persistent.player_skin)

label meeting:
    scene kitchen
play music "audio/soundeffects/ocean.ogg" volume 0.1
play sound "audio/soundeffects/footsteps.ogg"
"You walked into the kitchen of the Going Merry and met eyes with the newest visitor; Portgas D. Ace."
"Apparently this guy is related to Luffy... Could it really be his brother? He was so much more respectful than the captain."
"Perhaps Ace got all the good genes?"
show smug
with dissolve
pause 0.1
play sound "ace/happy/hey.ogg" 
a "Are you gonna keep staring at me or are you actually gonna talk to me?"
p "E-Eh?"
"You hadn't even realized you'd been staring at him... But who could blame you?"
"This guy walks around shirtless with the most defined abs you've ever seen... And those freckles? Gorgeous."
p "Sorry, I just... Can't believe you're actually Luffy's brother, haha!"
hide smug 
show happy2
play sound "ace/happy/hahahhaa.ogg"
a "Yeah? I get that a lot."
a "My brother can be a handful... Even when we were younger he was a pain, haha!"
p "No, no! He's not a pain!"
hide happy2
show smug 
play sound "ace/mad/dontthinkso.ogg"
a "Aww, no need to lie to me. I've only been here for 5 minutes and I can already hear the chaos on the deck."
"You both pause as the faint sound of Luffy and Nami shouting reaches your ears."
p "Haha... I guess you're right."
"Ace grinned at your laughter, trying to hold back his own."
hide smug
show relaxed 
a "Yeah, well... Either way, thank you for joining his crew! Be sure to take care of him for me."
p "Of course I will!"
hide relaxed
show happy
"Ace beams at your response, his smile practically lights up the room.."
play sound "ace/happy/hehehooflustered.ogg"
hide relaxed
show happy2 
a "Great, thanks so much [persistent.player_name]!"
p "Ah? You know my name?"
"Ace tilts his head to the side confused for a moment before leaning forward in a bow."
play sound "ace/happy/hm.ogg"
hide happy2
show surprised at shakechar 
play sound "ace/mad/ummmm.ogg"
a "Oh, right! Sorry, I just heard it in conversation... That {i}is{/i}  your name, right...?"
p "Yeah, it is! No need to apologize, it just caught me off guard."
"Ace lifts up his head with an awkward smile."
a "Yeah, I bet."
hide surprised
show sad 
play sound "ace/happy/phew.ogg"
a "But still... I'm glad I got it right, it'd be embarassing if I didn't..."
"Ace rubs the back of his neck awkwardly with a forced laugh."
p "Well even if you did, it would've been fine. I would've just corrected you. Not a big deal."
hide sad
show happy2 
a "Oh good! I'm glad to hear it!"
hide happy2 
show wink 
a "Y'know I'm happy my brother has such kind crewmates like you on board. Not to mention a cutie with a nice name."
"He winks at you with a soft chuckle."
p "You-!?"
hide wink
show happy2
play sound "ace/happy/happylaugh.ogg"
a "Hahaha!! I didn't expect such a shocked reaction!"
p "You can't just call someone cute out of nowhere!"
hide happy2
show smug-blush 
a "Ah, I can't? What a pity... Guess I'll have to call you beautiful instead?"
play sound "ace/mad/sadaww.ogg"
p "Hey!!"
"You feel your face flush as he lets out a genuine laugh that rumbles the walls."
play sound "ace/happy/outofbreathlaugh.ogg"
a "You're really easy to tease, you know that?"

menu:
        "Flirt back":
            jump flirtback

        "Get flustered":
            jump flustered

label flirtback:
    p "You're not the only one who can do the teasing, pretty boy!"
    hide smug-blush 
    show happy 
    play sound "ace/happy/woww.ogg"
    a "Oh yeah? You think I'm pretty?"
    hide happy
    show smug 
    a "Wanna tell me more?"
    hide happy
    show wink-blush 
    with dissolve 
    "He winks at you again."
    jump post_tease

label flustered:
    p "I...! I am not! You're just..."
    hide smug-blush
    show happy2 
    play sound "ace/happy/hahahhaa.ogg"
    "Ace laughs again and you can't help but smile with him."
    p "Knock it off! Im serious! Quit laughing!"
    play sound "ace/happy/tryingtoholdinlaugh.ogg"
    hide happy2
    show happy 
    a "You're laughing too, yknow!"
    play sound "ace/happy/heheheyeah.ogg"
    hide happy 
    show wink-blush 
    a "But fine, fine. I'll stop telling you how absolutely gorgeous you are..."
    jump post_tease

label post_tease:
"UGH! THIS GUY...!"
hide wink-blush 
show smug 
a "You've got such a funny look on your face right now."
a "You're not used to being flirted with, are you?"
p "Not really. I mean... Sanji flirts with me sometimes, but he flirts with anyone."
hide smug
show happy2 
a "Hmm, yeah? You think he'd wanna flirt with me too?"
p "You wish! Besides, I'm the one you're flirting with right now..."
play sound "ace/happy/hehehooflustered.ogg"
a "Oh, wow! Getting possessive now, are we?"
hide happy2 
show surprised-blush at shakechar 
p "As if! You're reading into it too much."
a "Oh, I must be..."
"Ace chuckles again as you snatch his hat from him and place it on your own head with a sly grin."
scene prologue1 with dissolve 
a "Hmmm, suits you."
p "I was expecting a bigger reaction from you..."
a "Aw, are you dissapointed?"
p "Oh be quiet! But... Do you really mean that? You're not lying are you?"
show prologue2 with dissolve 
play sound "ace/mad/noway!.ogg"
a "You should know that lying doesn't run in the family, we're terrible at it."
"You remembered all the times Luffy has tried to lie to you and the others but failed miserably."
"He does not have a poker face, like, at all..."
show prologue3 with dissolve 
a "And besides... Why would I lie to a beauty like you?"
p "Ugh, you're worse than Sanji!"
"You playfully smack his arm and he pretends to be hurt, clutching his bicep."
play sound "soundeffects/slap.mp3"
show prologue4 with vpunch 
play sound "ace/mad/OUCH.ogg"
a "Oh jeez! You're gonna leave a bruise if you keep hitting me like that!"
p "Yeah, you better watch out!"
"You flex your muscles while smiling playfully at him; Ace gives your muscles a glance before pretending to cower."
a "Oh noooo... Don't hit meeee~"
play sound "ace/mad/sadgrunt.ogg"
p "You could at least {i}try{/i} to act scared."
play sound "ace/mad/ummmm.ogg"
a "I was! You saying I'm not a good actor?"
p "Guess acting doesn't run in the family either."
a "Oh, you wound me..."
"Ace winks at you before standing up from the table, he grabs his hat back from you and puts it back on."
scene kitchen 
show smug
a "Oh, by the way... You're not by chance familiar with The Cowboy Hat Rule, are you?"

menu:
    "I'm familiar with it.":
        jump hatruleyes

    "I'm not.":
        jump hatruleno

label hatruleyes:
p "Yeah, I'm familiar with it."
hide smug
show surprised-blush at shakechar 
"Ace's face wavers slightly, his confidence slipping for a moment."
play sound "ace/whimpers/ohhhhheywhat.ogg"
a "O-Oh, are you now? So you know what it means, huh?"
p "Now look who's getting all embarassed."
hide suprised-blush
show embarrassed 
a "Hey..."
"Ace pouted before putting another sly grin on his face."
hide embarassed
show smug
a "Well, you better keep your end of the deal for wearing my hat..."
p "Oh, I intend to."
hide smug
show smug-blush  
play sound "ace/whimpers/woah.ogg"
"Ace's face goes red at his cheeks and you laugh lightly, amused at how flustered he gets when you flirt back."
a "Great, well...I'll look forward to it. See ya then!"
"Ace walks out of the room with a confident saunter, leaving you alone in the kitchen."
"What should I do next? Perhaps looking into {color=#e09d66}{i}Chapters{/i}{/color}  will help..?"
$ persistent.meeting_unlocked = True
$ chapters_just_unlocked = True
show screen chapterselect
return 

label hatruleno:
p "I'm not familiar with it... What is it?"
a "You don't know it, huh?"
hide smug
show smug-blush 
"Ace's face blushes lightly as he looks away."
play sound "ace/moans/moan.ogg"
a "Hmm... Lets just say if you wear the hat... You gotta ride {i}something.{/i}"
"Your face turns completely red at his words and you stammer in response."
p "W-What!? No way, that can't be a real thing!"
p "You've gotta be lying to me..."
hide smug-blush 
show happy2 
a "Hey, didn't I tell you I don't lie?"
p "Then you're just trying to get a rise out of me, aren't you?"
hide happy2
show smug 
play sound "ace/mad/ummmm.ogg"
a "Hmm, maybe... Is it working?"
"Ace chuckles before his face turned soft and genuine."
hide smug
show sad 
a "Seriously though, I'm only messing with you. You don't have to follow that dumb rule if you don't want to."
hide sad
show relaxed 
play audio "ace/whimpers/whine.ogg"
a "Just wanted to tease you a little."
p "I didn't say I didn't want to..."
hide relaxed
show surprised-blush at shakechar 
play sound "ace/moans/suprisedwhat.ogg"
"Ace's eyes widened and he slips back into that confident grin, leaning in."
hide surprised-blush
show smug-blush 
a "Oh yeah?"
p "Y-yeah...?"
"How can a simple phrase make you feel so submissive...? It doesn't help that he's so close now."
a "Hmm, tell you what... You think on that and let me know, alright?"
p "I will..."
a "Hope to see you soon, cutie~"
"Of course he had to have the final word."
stop music fadeout 1.0
"...Guess I'd better think on it. Perhaps looking into {color=#e09d66}{i}Chapters{/i}{/color}  will help..?"
$ persistent.meeting_unlocked = True
$ chapters_just_unlocked = True
return 

transform unlock_appear:
    alpha 0.0
    linear 0.5 alpha 1.0
    easein 0.3 yoffset 0
    on show:
        yoffset 50

label chapterselect: 
    screen chapterselect():
        tag chapterselect
        add "pselect/chapterselectbg.png"
    
        imagebutton: #return button
            idle "images/pselect/chapterreturn.png"
            hover "images/pselect/chapterreturnhover.png"
            action [Hide("chapterselect"), Show("main_menu")]
            focus_mask True

        imagebutton: #chap1
            idle "images/pselect/chapter1.png"
            hover "images/pselect/chapter1hover.png"
            action Start("chapter1")
            align(382, 202)
            focus_mask True
        imagebutton: #chap2
            idle "images/pselect/chapter2.png"
            hover "images/pselect/chapter2hover.png"
            action Jump("notready")
            align(756, 200)
            focus_mask True
        imagebutton: #chap3
            idle "images/pselect/chapter3.png"
            hover "images/pselect/chapter3hover.png"
            action Jump("notready")
            align(1131, 198)
            focus_mask True
        imagebutton: #chap4
            idle "images/pselect/chapter4.png"
            hover "images/pselect/chapter4hover.png"
            action Jump("notready")
            align(1191, 56)
            focus_mask True
        imagebutton: #chap5
            idle "images/pselect/chapter5.png"
            hover "images/pselect/chapter5hover.png"
            action Jump("notready")
            align(1882, 200)
            focus_mask True

label notready:
    call screen notready
    show screen chapterselect
    return 

screen notready():
    add "images/pselect/notready.png"
    imagebutton: #return button
        idle "images/pselect/notreadyreturn.png"
        hover "images/pselect/notreadyreturnhover.png"
        action [Hide("notready"), Show("chapterselect")]
        align (1166, 780)
        focus_mask True 



return 
