<?php
    defined( 'ABSPATH' ) or die();

    if ( is_home() ) {
        $page_title = __('Home', 'energium');
    } elseif ( class_exists('WooCommerce') && is_product() ) {
        $page_title = sprintf(stripslashes(energium_get_theme_mod('woo_single_product_title')), get_the_title());
    } elseif ( class_exists('WooCommerce') && is_product_category()  ) {
        $page_title = sprintf(stripslashes(energium_get_theme_mod('woo_product_categories_title')), single_term_title('', false));
    } elseif ( class_exists('WooCommerce') && is_product_tag() ) {
        $page_title = sprintf(stripslashes(energium_get_theme_mod('woo_product_tags_title')), single_term_title('', false));
    } elseif ( class_exists('WooCommerce') && is_search() ) {
        $page_title = sprintf(__('Search Results By "%s"', 'energium'), get_search_query());
    } elseif (is_archive()) {
        if ( class_exists('WooCommerce') && is_woocommerce() ) {
            $page_title = get_the_title();
        } elseif ( !empty(get_queried_object()) && get_queried_object()->name == 'energium_portfolio') {
            $page_title = sprintf(esc_html(energium_get_theme_mod('portfolio_archive_page_title')), post_type_archive_title('', false));
        } elseif ( !empty(get_queried_object()) && get_queried_object()->name == 'energium_project') {
            $page_title = sprintf(esc_html(energium_get_theme_mod('project_archive_page_title')), post_type_archive_title('', false));
        } elseif ( !empty(get_queried_object()) && get_queried_object()->name == 'energium_case_study') {
            $page_title = sprintf(esc_html(energium_get_theme_mod('case_studies_archive_page_title')), post_type_archive_title('', false));
        } elseif ( !empty(get_queried_object()) && get_queried_object()->name == 'energium_team_member') {
            $page_title = sprintf(esc_html(energium_get_theme_mod('team_archive_page_title')), post_type_archive_title('', false));
        } elseif ( !empty(get_queried_object()) && get_queried_object()->name == 'energium_vacancy') {
            $page_title = sprintf(esc_html(energium_get_theme_mod('vacancy_archive_page_title')), post_type_archive_title('', false));
        } elseif ( !empty(get_queried_object()) && get_queried_object()->name == 'energium_service') {
            $page_title = sprintf(esc_html(energium_get_theme_mod('service_archive_page_title')), post_type_archive_title('', false));
        } else {
            $page_title = get_the_archive_title();
        }
    } elseif (is_search()) {
        $page_title = sprintf(__('Search Results By "%s"', 'energium'), get_search_query());
    } elseif (is_singular('energium_portfolio')) {
        $page_title = sprintf(stripslashes(energium_get_theme_mod('portfolio_single_page_title')), get_the_title());
    } elseif (is_singular('energium_project')) {
        $page_title = sprintf(stripslashes(energium_get_theme_mod('project_single_page_title')), get_the_title());
    } elseif (is_singular('energium_case_study')) {
        $page_title = sprintf(stripslashes(energium_get_theme_mod('case_studies_single_page_title')), get_the_title());
    } elseif (is_singular('energium_team_member')) {
        $page_title = sprintf(stripslashes(energium_get_theme_mod('team_single_page_title')), get_the_title());
    } elseif (is_singular('energium_vacancy')) {
        $page_title = sprintf(stripslashes(energium_get_theme_mod('vacancy_single_page_title')), get_the_title());
    } elseif (is_singular('energium_service')) {
        $page_title = sprintf(stripslashes(energium_get_theme_mod('service_single_page_title')), get_the_title());
    } elseif (is_single()) {
        $page_title = sprintf(stripslashes(energium_get_theme_mod('post_page_title')), get_the_title());
    } else {
        $page_title = get_the_title();
    }

    $page_title_heading_customize   = energium_get_prefered_option('page_title_heading_customize');
    $page_title_heading_icon_status = energium_get_prefered_option('page_title_heading_icon_status');
    $page_title_icon_image          = '';
    if ( $page_title_heading_customize == 'on' && $page_title_heading_icon_status == 'on' ) {
        $page_title_icon_image = energium_get_prepared_img_url('page_title_heading_icon_image', 'page_title_heading_icon_status');
    }
?>

<!-- Page Title -->
<div class="page-title-container">
    <div class="page-title-bg"></div>
    <div class="page-title-row">
        <div class="page-title-wrapper">
            <div class="page-title-box">
                <?php
                    if ( !empty($page_title_icon_image) ) {
                        echo '<img class="page-title-box-icon" src="' . esc_url($page_title_icon_image) . '" alt="' . esc_attr__('Page title icon', 'energium') . '" />';
                    }
                ?>
                <h1 class="page-title"><?php echo wp_kses($page_title, 'post'); ?></h1>
            </div>
        </div>
    </div>
    <div class="page-title-line line-1"></div>
    <div class="page-title-line line-2"></div>
    <div class="page-title-line line-3"></div>
    <div class="section-decoration page-title-decoration">
        <div class="decoration">
            <div class="decoration-inner-1">
                <div class="decoration-inner-2">
                    <div class="decoration-inner-3"></div>
                </div>
            </div>
        </div>
    </div>
</div>