<?php
    defined( 'ABSPATH' ) or die();
?>
    <div class="mobile-header-menu-container">
        <div class="mobile-header-row">

            <!-- Icons Block -->
            <div class="header-icons-container">
                <?php

                if (
                    energium_get_prefered_option('header_search_status') == 'on' ||
                    (
                        energium_get_prefered_option('side_panel_status') == 'on' &&
                        is_active_sidebar('sidebar-side')
                    ) ||
                    (
                        class_exists('WooCommerce') && energium_get_prefered_option('header_minicart_status') == 'on'
                    ) ||
                    energium_get_prefered_option('header_login_status') == 'on'
                ) {
                    echo '<div class="header-icons-container">';

                        // Login/Logout
                        if ( energium_get_prefered_option('header_login_status') == 'on' ) {
                            if ( class_exists('WooCommerce') ) {
                                echo '<div class="header-icon login-logout">';
                                if (is_user_logged_in()) {
                                    echo '<a href="' . wp_logout_url(home_url()) . '" title="' . esc_attr__('Logout', 'energium') . '" class="link-logout"></a>';
                                } else {
                                    echo '<a href="' . get_permalink(get_option('woocommerce_myaccount_page_id')) . '" title="' . esc_attr__('Login/Register', 'energium') . '" class="link-login"></a>';
                                };
                                echo '</div>';
                            } else {
                                echo '<div class="header-icon login-logout">';
                                if (is_user_logged_in()) {
                                    echo '<a href="' . wp_logout_url(home_url()) . '" title="' . esc_attr__('Logout', 'energium') . '" class="link-logout"></a>';
                                } else {
                                    echo '<a href="' . wp_login_url(get_permalink()) . '" title="' . esc_attr__('Login/Register', 'energium') . '" class="link-login"></a>';
                                };
                                echo '</div>';
                            }
                        }

                        // Mini Cart Link
                        if ( class_exists('WooCommerce') && energium_get_prefered_option('header_minicart_status') == 'on' ) {
                            echo '<div class="header-icon mini-cart">';
                                echo '<a href="' . esc_url(wc_get_cart_url()) . '" class="mini-cart-trigger">';
                                    echo '<i class="mini-cart-count">';
                                        if ( WC()->cart->cart_contents_count > 0 ) {
                                            echo '<span>' . WC()->cart->cart_contents_count . '</span>';
                                        }
                                    echo '</i>';
                                echo '</a>';
                            echo '</div>';
                        }

                        // Search Icon Trigger
                        if ( energium_get_prefered_option('header_search_status') == 'on' ) {
                            echo '<div class="header-icon search-trigger">';
                                echo '<span class="search-trigger-icon"></span>';
                            echo '</div>';
                        }

                        // Side Panel Trigger
                        if ( energium_get_prefered_option('side_panel_status') == 'on' && is_active_sidebar('sidebar-side') ) {
                            echo '<div class="header-icon dropdown-trigger">';
                                echo '<div class="dropdown-trigger-item"><svg xmlns="http://www.w3.org/2000/svg" version="1.1" viewBox="0 0 19.50568 19.5"><path class="cls-1" d="m 0.75,4.25 c 0,-2.62 0,-3.5 3.5,-3.5 3.5,0 3.5,0.88 3.5,3.5 0,2.62 0,3.5 -3.5,3.5 -3.5,0 -3.5,-0.87 -3.5,-3.5 z" /><path class="cls-2" d="m 11.75,4.25 c 0,-2.62 0,-3.5 3.5,-3.5 3.5,0 3.5,0.88 3.5,3.5 0,2.62 0,3.5 -3.5,3.5 -3.5,0 -3.5,-0.87 -3.5,-3.5 z" /><path class="cls-1" d="m 0.75,15.25 c 0,-2.62 0,-3.5 3.5,-3.5 3.5,0 3.5,0.88 3.5,3.5 0,2.62 0,3.5 -3.5,3.5 -3.5,0 -3.5,-0.87 -3.5,-3.5 z" /><path class="cls-1" d="m 11.75,15.25 c 0,-2.62 0,-3.5 3.5,-3.5 3.5,0 3.5,0.88 3.5,3.5 0,2.62 0,3.5 -3.5,3.5 -3.5,0 -3.5,-0.87 -3.5,-3.5 z" /></svg></div>';
                            echo '</div>';
                        }

                    echo '</div>';
                }

                // Close Button
                echo '<div class="menu-close">';
                    echo '<span class="menu-close-icon"></span>';
                echo '</div>';

                ?>
            </div>

        </div>
        <!-- Menu Block -->
        <?php
            if ( energium_get_prefered_option('header_menu_status') == 'on' ) {
                if ( !empty(energium_get_prefered_option('header_menu_select')) && energium_get_prefered_option('header_menu_select') != 'default' ) {
                    wp_nav_menu(
                        array(
                            'menu'          => energium_get_prefered_option('header_menu_select'),
                            'menu_class'    => 'main-menu',
                            'depth'         => 0,
                            'container'     => '',
                            'fallback_cb'   => '',
                            'items_wrap'    => '<nav><ul id="%1$s" class="%2$s">%3$s</ul></nav>'
                        )
                    );
                } else {
                    $menu_locations = get_nav_menu_locations();
                    if ( isset($menu_locations['main']) && $menu_locations['main'] !== 0 ) {
                        wp_nav_menu(
                            array(
                                'theme_location'    => 'main',
                                'menu_class'        => 'main-menu',
                                'depth'             => 0,
                                'container'         => '',
                                'fallback_cb'       => '',
                                'items_wrap'        => '<nav><ul id="%1$s" class="%2$s">%3$s</ul></nav>'
                            )
                        );
                    }
                }
            }
        ?>

        <?php
        if (
            energium_get_prefered_option('top_bar_status') == 'on' &&
            (
                energium_get_prefered_option('top_bar_contacts_email_status') == 'on' ||
                energium_get_prefered_option('top_bar_contacts_phone_status') == 'on' ||
                energium_get_prefered_option('top_bar_contacts_address_status') == 'on'
            )
        ) {
            echo '<div class="header-mobile-contacts">';
                if ( !empty(energium_get_prefered_option('top_bar_contacts_address')) && energium_get_prefered_option('top_bar_contacts_address_status') == 'on' ) {
                    $address_label  = energium_get_prepared_option('top_bar_contacts_address_label', '', 'top_bar_contacts_address_status');
                    echo '<div class="contact-item contact-item-address">';
                        if ( !empty($address_label) ) {
                            echo '<div class="contact-item-label">' . wp_kses($address_label, 'post') . '</div>';
                        }
                        echo '<div class="contact-item-value">' . esc_html(energium_get_prefered_option('top_bar_contacts_address')) . '</div>';
                    echo '</div>';
                }
                if ( !empty(energium_get_prefered_option('top_bar_contacts_phone')) && energium_get_prefered_option('top_bar_contacts_phone_status') == 'on' ) {
                    $phone_label    = energium_get_prepared_option('top_bar_contacts_phone_label', '', 'top_bar_contacts_phone_status');
                    echo '<div class="contact-item contact-item-phone">';
                        if ( !empty($phone_label) ) {
                            echo '<div class="contact-item-label">' . wp_kses($phone_label, 'post') . '</div>';
                        }
                        echo '<a href="tel:' . energium_clear_phone(energium_get_prefered_option('top_bar_contacts_phone')) . '" class="contact-item-value">';
                            echo esc_html(energium_get_prefered_option('top_bar_contacts_phone'));
                        echo '</a>';
                    echo '</div>';
                }
                if ( !empty(energium_get_prefered_option('top_bar_contacts_email')) && energium_get_prefered_option('top_bar_contacts_email_status') == 'on' ) {
                    $email_label    = energium_get_prepared_option('top_bar_contacts_email_label', '', 'top_bar_contacts_email_status');
                    echo '<div class="contact-item contact-item-email">';
                        if ( !empty($email_label) ) {
                            echo '<div class="contact-item-label">' . wp_kses($email_label, 'post') . '</div>';
                        }
                        echo '<a href="mailto:' . esc_attr(energium_get_prefered_option('top_bar_contacts_email')) . '" class="contact-item-value">';
                            echo esc_html(energium_get_prefered_option('top_bar_contacts_email'));
                        echo '</a>';
                    echo '</div>';
                }
            echo '</div>';
        }
        ?>

        <?php
        if (
            energium_get_prefered_option('top_bar_status') == 'on' &&
            energium_get_prefered_option('top_bar_socials_status') == 'on'
        ) {
            echo '<div class="header-mobile-socials">';
                echo energium_socials_output('mobile-menu-socials wrapper-socials');
            echo '</div>';
        }
        ?>

        <?php
        if (
            energium_get_prefered_option('header_callback_status') == 'on' &&
            (
                !empty(energium_get_prefered_option('header_callback_text')) ||
                !empty(energium_get_prefered_option('header_callback_title'))
            )
        ) {
            echo '<div class="callback">';
                if ( !empty(energium_get_prefered_option('header_callback_title')) ) {
                    echo '<div class="callback-title">';
                        echo esc_html(energium_get_prefered_option('header_callback_title'));
                    echo '</div>';
                }
                if ( !empty(energium_get_prefered_option('header_callback_text')) ) {
                    echo '<div class="callback-text">';
                        echo esc_html(energium_get_prefered_option('header_callback_text'));
                    echo '</div>';
                }
            echo '</div>';
        }
        ?>

        <?php
        if (
            energium_get_prefered_option('header_button_status') == 'on' &&
            !empty(energium_get_prefered_option('header_button_text'))
        ) {
            echo '<div class="header-mobile-button">';
                echo '<a class="energium-button" href="' . ( !empty(energium_get_prefered_option('header_button_url')) ? esc_url(energium_get_prefered_option('header_button_url')) : esc_js('javascript:void(0);')) . '">';
                    echo esc_html(energium_get_prefered_option('header_button_text'));
                echo '</a>';
            echo '</div>';
        }
        ?>

    </div>