<?php
    defined( 'ABSPATH' ) or die();
?>

<?php if (
        energium_get_prefered_option('footer_sidebar_status') == 'on' &&
        !empty(energium_get_prepared_option('footer_sidebar_select', '', 'footer_sidebar_status')) &&
        is_active_sidebar(energium_get_prepared_option('footer_sidebar_select', '', 'footer_sidebar_status'))
    ) { ?>

        <!-- Footer Widgets -->
        <div class="footer-section">
            <div class="footer-row">
                <div class="footer-widgets">
                    <?php dynamic_sidebar(energium_get_prepared_option('footer_sidebar_select', '', 'footer_sidebar_status')); ?>
                </div>
            </div>
        </div>

<?php } ?>

<?php if (
        energium_get_prefered_option('footer_copyright_status') == 'on' ||
        energium_get_prefered_option('footer_additional_menu_status') == 'on' ||
        energium_get_prefered_option('footer_menu_status') == 'on'
) { ?>
    <!-- Footer Info -->
        <div class="footer-section">
            <div class="footer-row">
                <div class="footer-columns-row">
                    <?php

                        // Footer Menu
                        if ( energium_get_prefered_option('footer_menu_status') == 'on' ) {
                            if ( !empty(energium_get_prefered_option('footer_menu_select')) && energium_get_prefered_option('footer_menu_select') != 'default' ) {
                                wp_nav_menu(
                                    array(
                                        'menu'              => energium_get_prefered_option('footer_menu_select'),
                                        'menu_class'        => 'footer-menu',
                                        'depth'             => 1,
                                        'container'         => 'div',
                                        'container_class'   => 'footer-column footer-menu-container',
                                        'fallback_cb'       => '',
                                        'items_wrap'        => '<nav><ul id="%1$s" class="%2$s">%3$s</ul></nav>'
                                    )
                                );
                            } else {
                                wp_nav_menu(
                                    array(
                                        'theme_location'    => 'footer_menu',
                                        'menu_class'        => 'footer-menu',
                                        'depth'             => 1,
                                        'container'         => 'div',
                                        'container_class'   => 'footer-column footer-menu-container',
                                        'fallback_cb'       => '',
                                        'items_wrap'        => '<nav><ul id="%1$s" class="%2$s">%3$s</ul></nav>'
                                    )
                                );
                            };
                        }

                        // Copyrights
                        if (
                            energium_get_prefered_option('footer_copyright_status') == 'on' &&
                            !empty(energium_get_prefered_option('footer_copyright_text'))
                        ) {
                            echo '<div class="footer-column footer-copyrights-container">';
                                echo do_shortcode(esc_html(energium_get_prefered_option('footer_copyright_text')));
                            echo '</div>';
                        }

                        // Footer Additional Menu
                        if ( energium_get_prefered_option('footer_additional_menu_status') == 'on' ) {
                            if ( !empty(energium_get_prefered_option('footer_additional_menu_select')) && energium_get_prefered_option('footer_additional_menu_select') != 'default' ) {
                                wp_nav_menu(
                                    array(
                                        'menu'              => energium_get_prefered_option('footer_additional_menu_select'),
                                        'menu_class'        => 'footer-additional-menu',
                                        'depth'             => 1,
                                        'container'         => 'div',
                                        'container_class'   => 'footer-column footer-additional-menu-container',
                                        'fallback_cb'       => '',
                                        'items_wrap'        => '<nav><ul id="%1$s" class="%2$s">%3$s</ul></nav>'
                                    )
                                );
                            } else {
                                wp_nav_menu(
                                    array(
                                        'theme_location'    => 'footer_add_menu',
                                        'menu_class'        => 'footer-additional-menu',
                                        'depth'             => 1,
                                        'container'         => 'div',
                                        'container_class'   => 'footer-column footer-additional-menu-container',
                                        'fallback_cb'       => '',
                                        'items_wrap'        => '<nav><ul id="%1$s" class="%2$s">%3$s</ul></nav>'
                                    )
                                );
                            }
                        }
                    ?>
                </div>
            </div>
        </div>
<?php } ?>