<?php
/**
 * The template for displaying single project item page
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package WordPress
 * @subpackage Energium
 * @since Energium 1.0
 */

the_post();
get_header();

$content_classes = 'content-wrapper';
$content_classes .= ' content-wrapper-sidebar-position-none';

$project_location               = energium_get_post_option('project_location');
$project_lead_time              = energium_get_post_option('project_lead_time');
$project_technical_description  = energium_get_post_option('project_technical_description');

$project_result_title           = energium_get_post_option('project_result_title');
$project_result_description     = energium_get_post_option('project_result_description');
$project_result_details         = energium_get_post_option('project_result_details');
$project_final_result_title     = energium_get_post_option('project_final_result_title');
$project_final_result_value     = energium_get_post_option('project_final_result_value');
$project_contact_button         = energium_get_post_option('project_contact_button');
$project_warranty               = energium_get_post_option('project_warranty');
$project_quality                = energium_get_post_option('project_quality');
?>

    <div class="<?php echo esc_attr($content_classes); ?>">

        <!-- Content Container -->
        <div class="content">

            <div id="project-<?php the_ID(); ?>" class="single-project">

                <div class="project-post-content">
                    <?php
                        echo '<h2 class="project-post-title">' . esc_html__('Information of the project', 'energium') . '</h2>';

                        if ( !empty($project_location) || !empty($project_lead_time) ) {
                            echo '<div class="project-post-meta">';
                                if ( !empty($project_location) ) {
                                    echo '<div class="project-post-meta-item project-location">' . esc_html($project_location) . '</div>';
                                }
                                if ( !empty($project_lead_time) ) {
                                    echo '<div class="project-post-meta-item project-lead-time">' . esc_html($project_lead_time) . '</div>';
                                }
                            echo '</div>';
                        }

                        the_content();

                        if ( !empty($project_technical_description) ) {
                            echo '<div class="project-technical-description-wrapper">';
                                echo '<h3>' . esc_html__('Technical description', 'energium') . '</h3>';
                                echo '<div class="project-technical-description-list">';
                                    foreach ( $project_technical_description as $item ) {
                                        echo '<div class="technical-description">';
                                            echo (isset($item[0]) && !empty($item[0]) ? '<div class="technical-description-label">' . esc_html($item[0]) . '</div>' : '');
                                            echo (isset($item[1]) && !empty($item[1]) ? '<div class="technical-description-value">' . esc_html($item[1]) . '</div>' : '');
                                        echo '</div>';
                                    }
                                echo '</div>';
                            echo '</div>';
                        }

                        if ( !empty(energium_media_gallery_output('project_gallery')) ) {
                            echo '<div class="project-post-gallery">';
                                echo energium_project_gallery_output('project_gallery');
                            echo '</div>';
                        }
                    ?>

                </div>


                <?php
                    if (
                        !empty($project_warranty) ||
                        !empty($project_quality) ||
                        !empty($project_result_title) ||
                        !empty($project_result_description) ||
                        !empty($project_result_details) ||
                        !empty($project_final_result_title) ||
                        !empty($project_final_result_value) ||
                        !empty($project_contact_button)
                    ) {
                        echo '<div class="project-results-wrapper">';
                            if (
                                !empty($project_result_title) ||
                                !empty($project_result_description) ||
                                !empty($project_result_details) ||
                                !empty($project_final_result_title) ||
                                !empty($project_final_result_value) ||
                                !empty($project_contact_button)
                            ) {
                                echo '<div class="project-results">';
                                    echo ( !empty($project_result_title) ? '<h4>' . esc_html($project_result_title) . '</h4>' : '' );
                                    echo ( !empty($project_result_description) ? '<div class="project-result-text">' . wp_kses($project_result_description, 'post') . '</div>' : '' );
                                    if ( !empty($project_result_details) ) {
                                        echo '<div class="project-results-details-list">';
                                            foreach ( $project_result_details as $item ) {
                                                echo '<div class="project-results-detail">';
                                                    echo (isset($item[0]) && !empty($item[0]) ? '<div class="project-results-detail-label">' . esc_html($item[0]) . '</div>' : '');
                                                    echo (isset($item[1]) && !empty($item[1]) ? '<div class="project-results-detail-value">' . esc_html($item[1]) . '</div>' : '');
                                                echo '</div>';
                                            }
                                        echo '</div>';
                                    }
                                    if ( !empty($project_final_result_title) || !empty($project_final_result_value) ) {
                                        echo '<div class="project-final-result-wrapper">';
                                            if ( !empty($project_final_result_title) ) {
                                                echo '<div class="project-final-result-title">' . esc_html($project_final_result_title) . '</div>';
                                            }
                                            if ( !empty($project_final_result_value) ) {
                                                echo '<div class="project-final-result-value">' . esc_html($project_final_result_value) . '</div>';
                                            }
                                        echo '</div>';
                                    }
                                    if ( !empty($project_contact_button) ) {
                                        echo '<div class="project-post-button">';
                                            echo '<a href="' . esc_url( $project_contact_button[0] ) . '" class="energium-button">' . esc_html( $project_contact_button[1] ) . '</a>';
                                        echo '</div>';
                                    }
                                echo '</div>';
                            }
                            if ( !empty($project_warranty) || !empty($project_quality) ) {
                                echo '<div class="project-additional">';
                                    if ( !empty($project_warranty) ) {
                                        echo '<div class="project-additional-item project-warranty">' . esc_html($project_warranty) . '</div>';
                                    }
                                    if ( !empty($project_quality) ) {
                                        echo '<div class="project-additional-item project-quality">' . esc_html($project_quality) . '</div>';
                                    }
                                echo '</div>';
                            }
                        echo '</div>';
                    }
                ?>

            </div>

        </div>

    </div>

<?php
get_footer();