<?php
/**
 * The template for displaying single portfolio item page
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package WordPress
 * @subpackage Energium
 * @since Energium 1.0
 */

the_post();
get_header();

$sidebar_args = energium_get_sidebar_args();
$sidebar_position = $sidebar_args['sidebar_position'];

$content_classes = 'content-wrapper';
$content_classes .= ' content-wrapper-sidebar-position-' . esc_attr($sidebar_position);

$portfolio_contact_button = energium_get_post_option('portfolio_contact_button');
?>

    <div class="<?php echo esc_attr($content_classes); ?>">

        <!-- Content Container -->
        <div class="content">

            <div id="portfolio-<?php the_ID(); ?>" class="single-portfolio">

                <?php
                    if ( !empty(energium_media_gallery_output('portfolio_gallery')) ) {
                        echo '<div class="portfolio-post-gallery">';
                            echo energium_media_gallery_output('portfolio_gallery');
                        echo '</div>';
                    }
                ?>

                <div class="portfolio-post-content">
                    <?php
                        if ( !empty(get_the_title()) ) {
                            echo '<h2 class="portfolio-post-title">' . get_the_title() . '</h2>';
                        }
                    ?>

                    <?php the_content(); ?>

                    <?php
                        if ( !empty($portfolio_contact_button) ) {
                            echo '<div class="portfolio-post-button">';
                                echo '<a href="' . esc_url( $portfolio_contact_button[0] ) . '" class="energium-button">' . esc_html( $portfolio_contact_button[1] ) . '</a>';
                            echo '</div>';
                        }
                    ?>
                </div>
            </div>

            <?php
                $args = array(
                    'prev_label'            => esc_html__('Prev Gallery', 'energium'),
                    'next_label'            => esc_html__('Next Gallery', 'energium'),
                    'taxonomy_name'         => 'energium_portfolio_category',
                    'taxonomy_separator'    => ' / '
                );
                echo energium_post_navigation($args);
            ?>

        </div>

        <!-- Sidebar Container -->
        <?php get_sidebar(); ?>

    </div>

<?php
get_footer();