"use strict";

function side_panel_open() {
    jQuery('.dropdown-trigger').on('click', function() {
        jQuery('.slide-sidebar-wrapper, .body-overlay').addClass('active');
    });
    jQuery('.slide-sidebar-close, .body-overlay').on('click', function() {
        jQuery('.slide-sidebar-wrapper, .body-overlay').removeClass('active');
    });
}

function extra_panel_open() {
    jQuery('.extra-trigger').on('click', function() {
        jQuery('.slide-extra-wrapper, .body-overlay').addClass('active');
    });
    jQuery('.slide-extra-close, .body-overlay').on('click', function() {
        jQuery('.slide-extra-wrapper, .body-overlay').removeClass('active');
    });
}

function search_panel_open() {
    jQuery('.search-trigger').on('click', function() {
        jQuery('.site-search, .body-overlay').addClass('active');
        jQuery('.site-search .search-form .search-form-field').focus();
    });
    jQuery('.site-search-close, .body-overlay').on('click', function() {
        jQuery('.site-search, .body-overlay, .mobile-header-menu-container').removeClass('active');
    });
}

function switch_form_columns() {
    jQuery('.tab-columns-switcher').on('click', function() {
        jQuery('.tab-column', jQuery(this).parents('.tab-columns')).toggleClass('hidden');
    });
}

function sticky_menu_active (){
    if ( jQuery('.sticky-header-on').length ) {
        jQuery('.sticky-header-on').each(function(){
            let obj = jQuery(this);
            let el_offset = obj.offset().top;
            let el_height = jQuery('.sticky-wrapper', obj).innerHeight();
            let el_ready = el_offset + el_height;
            let el_not_active = el_offset + el_height + 300;
            el_offset = el_offset + el_height + 200;

            obj.height(el_height);

            jQuery(window).scroll(function(){
                var st = jQuery(this).scrollTop();
                if (st <= el_ready) {
                    obj.removeClass('sticky-ready');
                } else {
                    obj.addClass('sticky-ready');
                }
                if (st <= el_not_active) {
                    obj.removeClass('sticky-active');
                }
                if (st <= el_offset) {
                    obj.removeClass('sticky-active');
                } else {
                    obj.addClass('sticky-active');
                }
            });
        });
    }
}

function mobile_menu_open() {
    jQuery('.menu-trigger').on('click', function() {
        jQuery('.mobile-header-menu-container, .body-overlay').addClass('active');
    });
    jQuery('.menu-close, .body-overlay').on('click', function() {
        jQuery('.mobile-header-menu-container, .body-overlay').removeClass('active');
    });
}

function simple_sidebar_open() {
    jQuery('.simple-sidebar-trigger').on('click', function() {
        if (jQuery(window).width() < 992) {
            jQuery('.simple-sidebar, .body-overlay').addClass('active');
        }
    });
    jQuery('.shop-hidden-sidebar-close, .body-overlay').on('click', function() {
        jQuery('.simple-sidebar, .body-overlay').removeClass('active');
    });
}

function widget_list_hierarchy_init (){
    widget_archives_hierarchy_controller ( '.widget ul li', 'ul.children', 'parent-archive', 'widget-archive-trigger' );
    widget_archives_hierarchy_controller ( '.widget_nav_menu .menu li', 'ul.sub-menu', 'parent-archive', 'widget-menu-trigger' );
}

function widget_archives_hierarchy_controller ( list_item_selector, sublist_item_selector, parent_class, trigger_class ){
    jQuery( list_item_selector ).has( sublist_item_selector ).each( function (){
        jQuery( this ).addClass( parent_class );
        jQuery(this).append( "<span class='" + trigger_class + "'></span>" );
    });
    jQuery( list_item_selector + ">" + sublist_item_selector ).css( "display", "none" );
    jQuery( list_item_selector + ">.item-wrapper>" + sublist_item_selector ).css( "display", "none" );
    jQuery( document ).on( "click", "." + trigger_class, function (){
        var el = jQuery(this);
        var sublist = el.siblings( sublist_item_selector );
        var sublist_alt = el.siblings('.item-wrapper').children( sublist_item_selector );
        if ( !sublist.length && !sublist_alt.length ) return;
        sublist = sublist.first();
        sublist_alt = sublist_alt.first();
        el.toggleClass('active');
        sublist.slideToggle( 300 );
        sublist_alt.slideToggle( 300 );
    });
}

function fix_responsive_iframe () {
    jQuery('.video-embed > div').each(function() {
        jQuery(this).unwrap('.video-embed');
    });
}

function elements_slider_init () {
    jQuery('.elementor-element .owl-carousel, .content-inner > .archive-listing .owl-carousel').each( function() {
        let slider              =  jQuery(this),
            slider_options      = slider.data('slider-options'),
            itemsMobile         = 1,
            itemsTablet         = 1,
            itemsDesktop        = 1,
            itemsFool           = 1,
            dotsContainer       = slider_options['dotsContainer'],
            dotsContainerMobile = '',
            progress            = slider_options['progress'],
            slideCount          = jQuery('.slider-item', slider).length;

        if ( slider_options['dotsContainerMobile'] ) {
            dotsContainerMobile = slider_options['dotsContainerMobile'];
        } else {
            dotsContainerMobile = slider_options['dotsContainer'];
        }

        switch (slider_options['items']) {
            case 2:
                itemsMobile     = 1;
                itemsTablet     = 2;
                itemsDesktop    = 2;
                itemsFool       = 2;
                break;
            case 3:
                itemsMobile     = 1;
                itemsTablet     = 2;
                itemsDesktop    = 3;
                itemsFool       = 3;
                break;
            case 4:
                itemsMobile     = 1;
                itemsTablet     = 2;
                itemsDesktop    = 3;
                itemsFool       = 4;
                break;
            case 5:
                itemsMobile     = 1;
                itemsTablet     = 2;
                itemsDesktop    = 3;
                itemsFool       = 5;
                break;
            case 6:
                itemsMobile     = 1;
                itemsTablet     = 3;
                itemsDesktop    = 5;
                itemsFool       = 6;
                break;
            default:
                break;
        }
        slider_options['navText'] = ['', ''];
        slider_options['responsive'] = {
            0:  {
                items:          itemsMobile,
                dotsContainer:  dotsContainerMobile,
                dots:           (slideCount > itemsMobile) ? slider_options['dots'] : false
            },
            768:  {
                items:          itemsTablet,
                dotsContainer:  dotsContainerMobile,
                dots:           (slideCount > itemsTablet) ? slider_options['dots'] : false
            },
            992:  {
                items:          itemsDesktop,
                dotsContainer:  dotsContainer,
                dots:           (slideCount > itemsDesktop) ? slider_options['dots'] : false
            },
            1281:  {
                items: itemsFool,
                dotsContainer: dotsContainer,
                dots:           (slideCount > itemsFool) ? slider_options['dots'] : false
            }
        };
        slider.owlCarousel(slider_options);
        if ( progress ) {
            slider.on('changed.owl.carousel', function(event) {
                if (progress) {
                    let progress_wrapper = slider.parents('.elementor-widget-container'),
                        progress_current = jQuery('.slider-progress-current', progress_wrapper),
                        progress_all     = jQuery('.slider-progress-all', progress_wrapper),
                        progress_line    = jQuery('.progress', progress_wrapper);
                    progress_all.text(event.page.count < 10 ? '0' + event.page.count : event.page.count);
                    progress_current.text((event.page.index + 1) < 10 ? '0' + (event.page.index + 1) : (event.page.index + 1));
                    let progress_val = Math.round(((event.page.index + 1) / event.page.count) * 100);
                    progress_line.css('width', progress_val + '%');
                }
            });
        }
    });
}

function project_slider_init () {
    jQuery('.project-post-gallery .owl-carousel').each( function() {
        jQuery(this).owlCarousel({
            items:          1,
            nav:            false,
            navText:        ['',''],
            dots:           true,
            autoplay:       false,
            loop:           true,
            dotsContainer:  false,
            autoHeight:     false
        });
    });
}

// Isotope init
function isotope_init() {
    if ( jQuery('.isotope').length > 0 ) {
        jQuery('.isotope-trigger').isotope({
            itemSelector:   '.isotope-item',
            gutter:         0
        });
    }
}

function help_item_acardeon() {
    jQuery('.help-item').each( function() {
        jQuery('.help-item-title', this).on('click', function() {
            jQuery(this).siblings('.help-item-content').slideToggle(300).parents('.help-item').toggleClass('active');
        });
    });
}

function background_image_parallax(object, multiplier){
    if ( object.length > 0 ) {
        multiplier = typeof multiplier !== 'undefined' ? multiplier : 0.5;
        multiplier = 1 - multiplier;
        var doc = jQuery(document);
        object.css({
            'background-attatchment': 'fixed'
        });
        jQuery(window).scroll(function () {
            if (jQuery(window).width() >= 992) {
                var from_top = doc.scrollTop() - object.offset().top,
                    bg_css = 'center ' + (multiplier * from_top) + 'px';
                object.css({
                    'background-position': bg_css
                });
            } else {
                object.css({
                    'background-position': ''
                });
            }
        });
    }
}

function check_custom_field(element) {
    if ( element.val() !== '' && !element.is(':hidden') ) {
        element.parents('.energium-form-field').addClass('not-empty');
    } else {
        element.parents('.energium-form-field').removeClass('not-empty');
    }
}

function wrap_multycolumns_wpform_fields() {
    jQuery('.wpforms-field .wpforms-field-row .wpforms-field-row-block input').each(function(){
        jQuery(this).wrap('<div class="energium-form-field"></div>').before('<div class="energium-label-wrapper"><div class="energium-form-field-border-top"></div></div>').after('<div' +
            ' class="energium-form-field-border-bottom"></div>');
    });
}

// Tilt
function tilt_effect() {
    jQuery('.tilt-effect').tilt({
        maxTilt:        23,
        perspective:    2e3,
        easing:         "cubic-bezier(.22,.61,.36,1)"
    });
}

// Scroll to Top
function scroll_to_top_init() {
    var scrollTop = jQuery(window).scrollTop();
    if (scrollTop > 600) {
        jQuery('.footer-scroll-top').addClass('active');
    } else {
        jQuery('.footer-scroll-top').removeClass('active');
    }
}

// Page Title Animation
function page_title_animate() {
    if ( jQuery('.page-loader-container').length ) {
        jQuery('body').on('pageloader_start_hidden', function () {
            if (jQuery('.section-decoration.page-title-decoration').length) {
                jQuery('.section-decoration.page-title-decoration').addClass('animated');
            }
        });
    } else {
        jQuery(window).on('load', function () {
            if (jQuery('.section-decoration.page-title-decoration').length) {
                jQuery('.section-decoration.page-title-decoration').addClass('animated');
            }
        });
    }
}

// Mobile Menu
function mobile_menu(){
    jQuery('.mobile-header-menu-container .main-menu').find('.menu-item').each(function(i, el){
        if( jQuery(el).find('.sub-menu').length != 0 && jQuery(el).find('.sub-menu-trigger').length == 0 ){
            jQuery(el).append('<span class="sub-menu-trigger"></span>');
        }
    });

    jQuery('.sub-menu-trigger').off();
    jQuery('.sub-menu-trigger').on('click', function() {
        if( jQuery(this).parent().hasClass('active') ){
            jQuery(this).prev().slideUp();
            jQuery(this).parent().removeClass('active');
        } else {
            var currentParents = jQuery(this).parents('.menu-item');
            jQuery('.sub-menu-trigger').parent().not(currentParents).removeClass('active');
            jQuery('.sub-menu-trigger').parent().not(currentParents).find('.sub-menu').slideUp(300);

            jQuery(this).prev().slideDown();
            jQuery(this).parent().addClass('active');
        }
    });
    jQuery('.mobile-header-menu-container .main-menu a').on('click', function() {
        jQuery('.site-search, .body-overlay, .mobile-header-menu-container').removeClass('active');
    });
}

// Scroll to Anchor
function scroll_to_anchor() {
    jQuery('.pwb-az-listing-header a').on('click', function(){
        var target = jQuery(this).attr('href');
        jQuery('body, html').animate({scrollTop: jQuery(target).offset().top - 200 +'px'}, 600);
        return false;
    });
}

function page_loader_controller (){
    var page_loader, interval, timeLaps ;
    page_loader = jQuery('.page-loader');
    timeLaps = 0;
    interval = setInterval( function (){
        var page_loaded = check_if_page_loaded ();
        timeLaps ++;
        if ( page_loaded ||  timeLaps == 12) {
            clearInterval ( interval );
            page_loader.stop_loader ();
        }
    }, 10);
}

function check_if_page_loaded (){
    var keys, key, i, r;
    if ( window.modules_state === undefined ) return false;
    r = true;
    keys = Object.keys( window.modules_state );
    for ( i = 0; i < keys.length; i++ ){
        key = keys[i];
        if ( !window.modules_state[key] ){
            r = false;
            break;
        }
    }
    return r;
}

function start_loader (){
    let loader = jQuery(this);
    if ( !loader.length ) return;
    let loader_container = loader[0].parentNode;
    if ( loader_container != null ){
        loader_container.style.opacity = 1;
        setTimeout( function (){
            loader_container.style.display = "block";
        }, 10);
    }
}

function stop_loader (){
    let loader = jQuery(this);
    if ( !loader.length ) return;
    let loader_container = loader[0].parentNode;
    jQuery('body').trigger('pageloader_start_hidden');
    if ( loader_container != null ){
        setTimeout( function (){
            loader_container.style.opacity = 0;
            setTimeout( function (){
                loader_container.style.display = "none";
            }, 300);
        }, 500);
    }
}

// Main AJAX function
function genre_get_posts(paged = 1, id = null, filter_term = null, filter_taxonomy = null) {
    var ajax_url    = ajax_params.ajax_url;
    var args        = jQuery('.archive-listing', '.elementor-element-' + id).attr('data-ajax');
    var widget      = jQuery('.archive-listing', '.elementor-element-' + id).attr('data-widget');
    var classes     = jQuery('.archive-listing-wrapper', '.elementor-element-' + id).attr('class');

    jQuery.ajax({
        type:       'POST',
        url:        ajax_url,
        data:       {
            action:             'pagination',
            args:               args,
            widget:             widget,
            paged:              paged,
            classes:            classes,
            id:                 id,
            filter_term:        filter_term,
            filter_taxonomy:    filter_taxonomy,
            security:           ajax_params.ajax_nonce
        },
        beforeSend: function (){
            var height = jQuery('.archive-listing', '.elementor-element-' + id).outerHeight();
            jQuery('.archive-listing', '.elementor-element-' + id).height(height).addClass('loading');
        },
        success:    function(data){
            jQuery('.archive-listing', '.elementor-element-' + id).html(data);
            if (jQuery(window.wp.mediaelement).length > 0) {
                jQuery(window.wp.mediaelement.initialize);
            }
            setTimeout(function() {
                jQuery('.archive-listing', '.elementor-element-' + id).removeAttr('style').removeClass('loading');
            }, 500);
            setTimeout(elements_slider_init, 300);
            setTimeout(fix_responsive_iframe, 600);
            setTimeout(isotope_init, 500);
            setTimeout(tilt_effect, 500);
        },
        error:      function(){
            jQuery('.archive-listing', '.elementor-element-' + id).html('<p class="error">AJAX ERROR</p>');
        }
    });
}

// ---------------------- //
// --- Document Ready --- //
// ---------------------- //
jQuery(document).ready(function () {

    side_panel_open();
    extra_panel_open();
    search_panel_open();
    switch_form_columns();
    setTimeout(sticky_menu_active, 300);
    mobile_menu_open();
    simple_sidebar_open();
    help_item_acardeon();
    page_title_animate();

    // Parallax
    background_image_parallax(jQuery('[data-parallax="scroll"]'), 0.7);

    mobile_menu();

    scroll_to_anchor();

    // Scroll Down
    jQuery('.content-slider-scroll-down').on('click', function(){
        let target = jQuery(this).parents('.elementor-section').next('.elementor-section');
        jQuery('body, html').animate({scrollTop: target.offset().top - 150 +'px'}, 600);
    });

    // Scroll To Top
    scroll_to_top_init();
    jQuery('.footer-scroll-top').on('click', function() {
        jQuery('html, body').animate({
            scrollTop: 0
        }, 500);
    });

    // Tilt alter
    document.addEventListener("mousemove", parallax);
    function parallax(e){
        var moving_value = -10;
        jQuery('.tilt-part img').each(function(){
            var x = (e.clientX * moving_value) / 250;
            var y = (e.clientY * moving_value) / 250;
            moving_value = moving_value + 4;
            jQuery(this).css({
                'transform': 'translate(' + x + 'px, ' + y + 'px)'
            }).attr('data-value', moving_value);
        });
    }

    tilt_effect();
    widget_list_hierarchy_init();
    setTimeout(fix_responsive_iframe, 800);
    setTimeout(elements_slider_init, 500);
    setTimeout(isotope_init, 500);
    wrap_multycolumns_wpform_fields();
    project_slider_init();

    // Check custom form fields
    jQuery('.energium-form-field input, .energium-form-field textarea').each(function() {
        check_custom_field(jQuery(this));
    }).on('change', function(){
        check_custom_field(jQuery(this));
    });

    // Elementor DOM customize
    if ( jQuery('.elementor-container').length > 0 ) {
        jQuery('.elementor-container').each(function(){
            jQuery(this).children('.elementor-column').wrapAll('<div class="elementor-row" />');
        });
    }

    // AJAX Filter for Elementor Post Listing
    jQuery('.elementor-widget').on('click', '.filter-control-list .filter-control-item', function(e){
        console.log('11111');
        e.preventDefault();
        var paged           = 1;
        var id              = jQuery(this).parents('.elementor-widget').attr('data-id');
        var filter_term     = jQuery(this).attr('data-value');
        var filter_taxonomy = jQuery(this).parents('.filter-control-list').attr('data-taxonomy');
        if ( filter_term === 'all' ) {
            filter_term = null;
        }

        jQuery(this).addClass('active').siblings('.filter-control-item').removeClass('active');

        genre_get_posts(paged, id, filter_term, filter_taxonomy);
    });

    // Page Preloader
    var loader;
    jQuery.fn.start_loader = start_loader;
    jQuery.fn.stop_loader = stop_loader;

    jQuery(document).ready(function (){
        page_loader_controller ();
    });

    // AJAX Pagination for Elementor Post Listing
    jQuery('.elementor-widget').on('click', '.content-pagination a', function(e){
        e.preventDefault();
        var paged           = null;
        var id              = jQuery(this).parents('.elementor-widget').attr('data-id');
        if ( jQuery(this).hasClass('prev') ) {
            paged = parseInt(jQuery(this).siblings('.current').text()) - 1;
        } else if ( jQuery(this).hasClass('next') ) {
            paged = parseInt(jQuery(this).siblings('.current').text()) + 1;
        } else {
            paged = parseInt(jQuery(this).text());
        }
        var filter_term     = jQuery('.filter-control-list .dot.active', jQuery(this).parents('.archive-listing').siblings('.filter-control-wrapper')).attr('data-value');
        var filter_taxonomy = jQuery('.filter-control-list', jQuery(this).parents('.archive-listing').siblings('.filter-control-wrapper')).attr('data-taxonomy');

        genre_get_posts(paged, id, filter_term, filter_taxonomy);
    });

});

// --------------------- //
// --- Window Resize --- //
// --------------------- //
jQuery(window).on('resize', function () {
    setTimeout(sticky_menu_active, 300);
    mobile_menu_open();
    background_image_parallax(jQuery('[data-parallax="scroll"]'), 0.7);
});

// --------------------- //
// --- Window Scroll --- //
// --------------------- //
jQuery(window).on('scroll', function () {
    scroll_to_top_init();
});