<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme and one
 * of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query,
 * e.g., it puts together the home page when no home.php file exists.
 *
 * @link http://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage Energium
 * @since Energium 1.0
 */

get_header();

$sidebar_args = energium_get_sidebar_args();
$sidebar_position = $sidebar_args['sidebar_position'];

$content_classes = 'content-wrapper';
$content_classes .= ( energium_get_post_option('content_top_margin') == 'on' ? ' content-wrapper-remove-top-margin' : '' );
$content_classes .= ( energium_get_post_option('content_bottom_margin') == 'on' ? ' content-wrapper-remove-bottom-margin' : '' );
$content_classes .= ' content-wrapper-sidebar-position-' . esc_attr($sidebar_position);

$wrapper_classes = 'archive-listing-wrapper';

?>

    <div class="<?php echo esc_attr($content_classes); ?>">
        <div class="content">
            <!-- Content Container -->
            <div class="content-inner">

                <div class="archive-listing">
                    <div class="<?php echo esc_attr($wrapper_classes); ?>">
                        <?php
                            while ( have_posts() ) {
                                the_post();
                                get_template_part('content');
                            };
                        ?>
                    </div>

                    <?php
                        echo '<div class="content-pagination">';
                            echo '<nav class="pagination">';
                                echo '<div class="nav-links">';
                                    echo paginate_links( array(
                                        'end_size'  => 2,
                                        'prev_text' => esc_html__('Prev', 'energium'),
                                        'next_text' => esc_html__('Next', 'energium')
                                    ) );
                                echo '</div>';
                            echo '</nav>';
                        echo '</div>';
                    ?>
                </div>

            </div>
        </div>

        <!-- Sidebar Container -->
        <?php get_sidebar(); ?>

    </div>

<?php
get_footer();