<?php
/*
 * Created by Artureanec
*/

# General
add_theme_support('post-thumbnails');
add_theme_support('title-tag');
add_theme_support('automatic-feed-links');
add_theme_support('post-formats', array('image', 'video', 'gallery', 'quote'));
add_theme_support('html5', array( 'comment-list', 'comment-form', 'search-form', 'gallery', 'caption' ) );

if( !isset( $content_width ) ) $content_width = 1170;

# ADD Localization Folder
add_action('init', 'energium_pomo');
if (!function_exists('energium_pomo')) {
    function energium_pomo() {
        load_theme_textdomain('energium', get_template_directory() . '/languages');
    }
}

require_once(get_template_directory() . '/core/helper-functions.php');
require_once(get_template_directory() . '/core/layout-functions.php');
require_once(get_template_directory() . '/core/init.php');

# Register CSS/JS
add_action('wp_enqueue_scripts', 'energium_css_js');
if (!function_exists('energium_css_js')) {
    function energium_css_js() {
        # CSS
        wp_enqueue_style('energium-theme', get_template_directory_uri() . '/css/theme.css');

        if (class_exists('WooCommerce')) {
            wp_enqueue_style('energium-woocommerce', get_template_directory_uri() . '/css/woocommerce.css');
            wp_enqueue_style('energium-style', get_template_directory_uri() . '/style.css', array('energium-theme', 'energium-woocommerce'), wp_get_theme()->get('Version') );
        } else {
            wp_enqueue_style('energium-style', get_template_directory_uri() . '/style.css', array('energium-theme'), wp_get_theme()->get('Version') );
        }

        # JS
        wp_enqueue_script('jquery-cookie', get_template_directory_uri() . '/js/jquery.cookie.min.js', array('jquery'), false, true);
        wp_enqueue_script('tilt', get_template_directory_uri() . '/js/tilt.jquery.min.js', array('jquery'), false, true);
        wp_enqueue_script('owl-carousel', get_template_directory_uri() . '/js/owl.carousel.min.js', true, false, true);
        wp_enqueue_script('isotope', get_template_directory_uri() . '/js/isotope.min.js', array(), false, true );

        wp_register_script('energium-theme', get_template_directory_uri() . '/js/theme.js', array('jquery', 'isotope', 'tilt'), false, true);
        wp_localize_script( 'energium-theme', 'ajax_params',
            array(
                'ajax_url'      => admin_url( 'admin-ajax.php' ),
                'ajax_nonce'    => wp_create_nonce('energium_ajax_nonce_value')
            )
        );
        wp_enqueue_script('energium-theme');


        if ( is_singular() && comments_open() ) {
            wp_enqueue_script('comment-reply');
        }

        if ( class_exists('\Elementor\Plugin') ) {
            $localize_theme = [];
            if( \Elementor\Plugin::$instance->preview->is_preview_mode() ) {
                $localize_theme['is_editor_preview'] = true;
            }
            wp_localize_script('energium-theme', 'theme', $localize_theme);
        }

        # Colors & Settings
        require_once(get_template_directory() . "/css/custom/custom.php");

        global $energium_custom_css;
        wp_add_inline_style('energium-theme', $energium_custom_css);
    }
}

# Register CSS/JS for Admin Settings
add_action('admin_enqueue_scripts', 'energium_admin_css_js');
if (!function_exists('energium_admin_css_js')) {
    function energium_admin_css_js() {
        # CSS
        wp_enqueue_style('energium-admin', get_template_directory_uri() . '/css/admin.css');
        # JS
        wp_enqueue_script('energium-admin', get_template_directory_uri() . '/js/admin.js', array('jquery', 'jquery-ui-core', 'jquery-ui-sortable'), false, true);
    }
}

# Register CSS for Gutenberg Editor
add_action('enqueue_block_editor_assets', 'energium_gutenberg_css', 1, 1);
add_action('enqueue_block_editor_assets', 'energium_register_theme_fonts', 1, 1);
if (!function_exists('energium_gutenberg_css')) {
    function energium_gutenberg_css() {
        add_theme_support( 'editor-styles' );
        add_editor_style( 'css/gutenberg-editor.css' );

        require_once(get_template_directory() . "/css/custom/custom.php");
        global $energium_custom_css;
        wp_enqueue_style('energium-admin', get_template_directory_uri() . '/css/admin.css');
        wp_add_inline_style('energium-admin', $energium_custom_css);
    }
}

# Register Google Fonts
add_action('wp_enqueue_scripts', 'energium_register_theme_fonts');
if (!function_exists('energium_register_theme_fonts')) {
    function energium_register_theme_fonts() {
        $font_control_list      = !empty(get_theme_mod('current_fonts')) ? get_theme_mod('current_fonts') : array();
        $current_fonts_array    = array();
        $families               = array();
        $result                 = array();
        foreach ( $font_control_list as $control ) {
            $values = energium_get_theme_mod($control);
            $values = json_decode($values, true);
            if ( isset($values['font_family']) && !empty($values['font_family']) ) {
                $current_font = array();
                $current_font['font_family'] = $values['font_family'];
                $current_font['font_styles'] = $values['font_styles'];
                $current_font['font_subset'] = $values['font_subset'];
                $current_fonts_array[$control] = $current_font;
            }
        }

        if ( !empty($current_fonts_array) && is_array($current_fonts_array) ) {
            foreach ( $current_fonts_array as $item ) {
                if ( !in_array($item['font_family'], $families) ) {
                    $families[] = $item['font_family'];
                }
            }
            foreach ( $families as $variant ) {
                foreach ( $current_fonts_array as $key => $item ) {
                    if ( $variant == $item['font_family'] ) {
                        $result[$variant]['font_styles'] = empty($result[$variant]['font_styles']) ? $item['font_styles'] : $result[$variant]['font_styles'] . ',' . $item['font_styles'];
                        $result[$variant]['font_subset'] = empty($result[$variant]['font_subset']) ? $item['font_subset'] : $result[$variant]['font_subset'] . ',' . $item['font_subset'];
                    }
                }
            }
            foreach ( $result as $key => $value ) {
                $styles = array_unique(explode(',', $result[$key]['font_styles']));
                asort($styles, SORT_NUMERIC );
                $subset = array_unique(explode(',', $result[$key]['font_subset']));
                asort($subset, SORT_NUMERIC );
                $result[$key]['font_styles'] = implode( ',', $styles );
                $result[$key]['font_subset'] = implode( ',', $subset );
            }
            if ( !empty($result) && is_array($result) ) {
                $fonts = array();
                foreach ( $result as $font_name => $font_params ) {
                    // exclude local fonts
                    $fonts[] = $font_name . ':' . $font_params['font_styles'] . '&subset=' . $font_params['font_subset'];
                }
                $fonts_url = '//fonts.googleapis.com/css?family=' . urlencode( implode('|', $fonts) );
                wp_enqueue_style('energium-fonts', $fonts_url);
            }
        }
    }
}



# WP Footer
add_action('wp_footer', 'energium_wp_footer');
if (!function_exists('energium_wp_footer')) {
    function energium_wp_footer() {
        Energium_Helper::getInstance()->echoFooter();
    }
}

# Register Menu
add_action('init', 'energium_register_menu');
if (!function_exists('energium_register_menu')) {
    function energium_register_menu() {
        register_nav_menus(
            [
                'main'              => esc_html__('Main menu', 'energium'),
                'footer_menu'       => esc_html__('Footer Menu', 'energium'),
                'footer_add_menu'   => esc_html__('Footer Additional Menu', 'energium')
            ]
        );
    }
}


# Register Sidebars
add_action('widgets_init', 'energium_widgets_init');
if (!function_exists('energium_widgets_init')) {
    function energium_widgets_init() {
        register_sidebar(
            array(
                'name'          => esc_html__('Page Sidebar', 'energium'),
                'id'            => 'sidebar',
                'description'   => esc_html__('Widgets in this area will be shown on all pages.', 'energium'),
                'before_widget' => '<div id="%1$s" class="widget %2$s"><div class="widget-wrapper">',
                'after_widget'  => '</div></div>',
                'before_title'  => '<h4 class="widget-title"><span>',
                'after_title'   => '</span></h4>',
            )
        );

        register_sidebar(
            array(
                'name'          => esc_html__('Post Sidebar', 'energium'),
                'id'            => 'sidebar-post',
                'description'   => esc_html__('Widgets in this area will be shown on all posts.', 'energium'),
                'before_widget' => '<div id="%1$s" class="widget %2$s"><div class="widget-wrapper">',
                'after_widget'  => '</div></div>',
                'before_title'  => '<h4 class="widget-title"><span>',
                'after_title'   => '</span></h4>',
            )
        );

        register_sidebar(
            array(
                'name'          => esc_html__('Service Sidebar', 'energium'),
                'id'            => 'sidebar-service',
                'description'   => esc_html__('Widgets in this area will be shown on all service pages.', 'energium'),
                'before_widget' => '<div id="%1$s" class="widget %2$s"><div class="widget-wrapper">',
                'after_widget'  => '</div></div>',
                'before_title'  => '<h4 class="widget-title"><span>',
                'after_title'   => '</span></h4>',
            )
        );

        register_sidebar(
            array(
                'name'          => esc_html__('Archive Sidebar', 'energium'),
                'id'            => 'sidebar-archive',
                'description'   => esc_html__('Widgets in this area will be shown on all posts and archive pages.', 'energium'),
                'before_widget' => '<div id="%1$s" class="widget %2$s"><div class="widget-wrapper">',
                'after_widget'  => '</div></div>',
                'before_title'  => '<h4 class="widget-title"><span>',
                'after_title'   => '</span></h4>',
            )
        );

        register_sidebar(
            array(
                'name'          => esc_html__('Side Panel Sidebar', 'energium'),
                'id'            => 'sidebar-side',
                'description'   => esc_html__('Widgets in this area will be shown on side panel.', 'energium'),
                'before_widget' => '<div id="%1$s" class="widget side-widget %2$s"><div class="widget-wrapper side-widget-wrapper">',
                'after_widget'  => '</div></div>',
                'before_title'  => '<h4 class="widget-title side-widget-title">',
                'after_title'   => '</h4>',
            )
        );

        register_sidebar(
            array(
                'name'          => esc_html__('Footer Sidebar (Style 1)', 'energium'),
                'id'            => 'sidebar-footer-style1',
                'description'   => esc_html__('Widgets in this area will be shown on footer area.', 'energium'),
                'before_widget' => '<div id="%1$s" class="widget footer-widget %2$s"><div class="widget-wrapper footer-widget-wrapper">',
                'after_widget'  => '</div></div>',
                'before_title'  => '<h6 class="widget-title footer-widget-title">',
                'after_title'   => '</h6>',
            )
        );

        register_sidebar(
            array(
                'name'          => esc_html__('Footer Sidebar (Style 2)', 'energium'),
                'id'            => 'sidebar-footer-style2',
                'description'   => esc_html__('Widgets in this area will be shown on footer area.', 'energium'),
                'before_widget' => '<div id="%1$s" class="widget footer-widget %2$s"><div class="widget-wrapper footer-widget-wrapper">',
                'after_widget'  => '</div></div>',
                'before_title'  => '<h6 class="widget-title footer-widget-title">',
                'after_title'   => '</h6>',
            )
        );

        register_sidebar(
            array(
                'name'          => esc_html__('Footer Sidebar (Style 3)', 'energium'),
                'id'            => 'sidebar-footer-style3',
                'description'   => esc_html__('Widgets in this area will be shown on footer area.', 'energium'),
                'before_widget' => '<div id="%1$s" class="widget footer-widget %2$s"><div class="widget-wrapper footer-widget-wrapper">',
                'after_widget'  => '</div></div>',
                'before_title'  => '<h6 class="widget-title footer-widget-title">',
                'after_title'   => '</h6>',
            )
        );

        register_sidebar(
            array(
                'name'          => esc_html__('Footer Sidebar (Style 4)', 'energium'),
                'id'            => 'sidebar-footer-style4',
                'description'   => esc_html__('Widgets in this area will be shown on footer area.', 'energium'),
                'before_widget' => '<div id="%1$s" class="widget footer-widget %2$s"><div class="widget-wrapper footer-widget-wrapper">',
                'after_widget'  => '</div></div>',
                'before_title'  => '<h6 class="widget-title footer-widget-title">',
                'after_title'   => '</h6>',
            )
        );

        register_sidebar(
            array(
                'name'          => esc_html__('Footer Sidebar (Style 5)', 'energium'),
                'id'            => 'sidebar-footer-style5',
                'description'   => esc_html__('Widgets in this area will be shown on footer area.', 'energium'),
                'before_widget' => '<div id="%1$s" class="widget footer-widget %2$s"><div class="widget-wrapper footer-widget-wrapper">',
                'after_widget'  => '</div></div>',
                'before_title'  => '<h6 class="widget-title footer-widget-title">',
                'after_title'   => '</h6>',
            )
        );

        if (class_exists('WooCommerce')) {
            register_sidebar(
                array(
                    'name'          => esc_html__('Sidebar WooCommerce', 'energium'),
                    'id'            => 'sidebar-woocommerce',
                    'description'   => esc_html__('Widgets in this area will be shown on Woocommerce Pages.', 'energium'),
                    'before_widget' => '<div id="%1$s" class="widget wooсommerce-widget %2$s"><div class="widget-wrapper">',
                    'after_widget'  => '</div></div>',
                    'before_title'  => '<h4 class="widget-title"><span>',
                    'after_title'   => '</span></h4>',
                )
            );
        }
    }
}

// Init Custom Widgets
if (!function_exists('energium_custom_widgets_init')) {
    function energium_custom_widgets_init() {
        if (function_exists('energium_add_custom_widget')) {
            energium_add_custom_widget('Energium_Contacts_Widget');
            energium_add_custom_widget('Energium_Nav_Menu_Widget');
        }
    }
}
add_action('widgets_init', 'energium_custom_widgets_init');

// Init Elementor for Custom Post Types
if (!function_exists('energium_init_elementor_for_portfolio_post_type')) {
    function energium_init_elementor_for_portfolio_post_type() {
        add_post_type_support('energium-portfolio', 'elementor');
    }
}
add_action('init', 'energium_init_elementor_for_portfolio_post_type');

# WooCommerce
if (class_exists('WooCommerce')) {
    require_once( get_template_directory() . '/woocommerce/wooinit.php');
}

// Remove standard WP gallery styles
add_filter( 'use_default_gallery_style', '__return_false' );

// Register custom image sizes
if ( function_exists( 'add_theme_support' ) ) {
    add_theme_support( 'post-thumbnails' );
    set_post_thumbnail_size( 1170, 620, true );
}
if ( function_exists( 'add_image_size' ) ) {
    add_image_size( 'energium_post_thumbnail_mobile', 535, 400, array('center', 'center') );
    add_image_size( 'energium_post_thumbnail_tablet', 951, 438, array('center', 'center') );
    add_image_size( 'energium_post_thumbnail_default', 870, 460, array('center', 'center') );
    add_image_size( 'energium_post_thumbnail_full', 1170, 620, array('center', 'center') );

    add_image_size( 'energium_single_project_gallery', 770, 387, array('center', 'center') );

    add_image_size( 'energium_post_grid_2_columns', 920, 832, array('center', 'center') );
    add_image_size( 'energium_post_grid_3_columns', 600, 543, array('center', 'center') );
    add_image_size( 'energium_post_grid_4_columns', 440, 398, array('center', 'center') );
    add_image_size( 'energium_post_grid_5_columns', 344, 311, array('center', 'center') );
    add_image_size( 'energium_post_grid_6_columns', 280, 253, array('center', 'center') );

    add_image_size( 'energium_portfolio_thumbnail', 530, 456, array('center', 'center') );
    add_image_size( 'energium_portfolio_grid_1_columns', 1170, 745, array('center', 'center') );
    add_image_size( 'energium_portfolio_grid_2_columns', 960, 960, array('center', 'center') );
    add_image_size( 'energium_portfolio_grid_3_columns', 640, 640, array('center', 'center') );
    add_image_size( 'energium_portfolio_grid_4_columns', 480, 480, array('center', 'center') );
    add_image_size( 'energium_portfolio_grid_5_columns', 384, 384, array('center', 'center') );
    add_image_size( 'energium_portfolio_grid_6_columns', 320, 320, array('center', 'center') );

    add_image_size( 'energium_portfolio_masonry_1_columns', 1920, 1440, array('center', 'center') );
    add_image_size( 'energium_portfolio_masonry_2_columns', 1920, 1440, array('center', 'center') );
    add_image_size( 'energium_portfolio_masonry_3_columns', 1280, 960, array('center', 'center') );
    add_image_size( 'energium_portfolio_masonry_4_columns', 960, 720, array('center', 'center') );
    add_image_size( 'energium_portfolio_masonry_5_columns', 768, 576, array('center', 'center') );
    add_image_size( 'energium_portfolio_masonry_6_columns', 640, 480, array('center', 'center') );

    add_image_size( 'energium_team_thumbnail', 572, 661, array('center', 'center') );

    add_image_size( 'energium_services_grid_2_columns', 960, 1270, array('center', 'center') );
    add_image_size( 'energium_services_grid_3_columns', 640, 847, array('center', 'center') );
    add_image_size( 'energium_services_grid_4_columns', 480, 635, array('center', 'center') );
    add_image_size( 'energium_services_grid_5_columns', 384, 508, array('center', 'center') );
    add_image_size( 'energium_services_grid_6_columns', 320, 424, array('center', 'center') );
}
add_filter( 'image_size_names_choose', 'energium_image_size_names' );
if ( !function_exists( 'energium_image_size_names' ) ) {
    function energium_image_size_names($sizes) {
        return array_merge($sizes, array(
            'energium_post_thumbnail_default'    => esc_html__('Post Thumbnail (Default)', 'energium'),
            'energium_post_thumbnail_full'       => esc_html__('Post Thumbnail (Full)', 'energium'),
        ));
    }
}

// Media Upload
if (!function_exists('energium_enqueue_media')) {
    function energium_enqueue_media() {
        wp_enqueue_media();
    }
}
add_action( 'admin_enqueue_scripts', 'energium_enqueue_media' );

// Responsive video
add_filter('embed_oembed_html', 'energium_wrap_oembed_video', 99, 4);
if (!function_exists('energium_wrap_oembed_video')) {
    function energium_wrap_oembed_video($html, $url, $attr, $post_id) {
        return '<div class="video-embed">' . $html . '</div>';
    }
}

// Custom Search form
add_filter('get_search_form', 'energium_get_search_form', 1, 3);
if ( !function_exists('energium_get_search_form') ) {
    function energium_get_search_form($form, $args, $customize = true) {
        $search_rand = mt_rand(0, 999);
        $search_js = 'javascript:document.getElementById("search-' . esc_js($search_rand) . '").submit();';
        $placeholder = ( isset($args['aria_label']) && $args['aria_label'] == 'global' ? esc_attr__('Search', 'energium') : esc_attr__('Search...', 'energium') );

        $form = '<form name="search_form" method="get" action="' . esc_url(home_url('/')) . '" class="search-form" id="search-' . esc_attr($search_rand) . '">';
            if ( $customize ) {
                $form .= '<span class="search-form-icon" onclick="' . esc_js($search_js) . '"></span>';
                $form .= '<div class="energium-form-field">';
                    $form .= '<div class="energium-label-wrapper">';
                        $form .= '<div class="energium-form-field-border-angle"></div>';
                            $form .= '<label>' . esc_attr($placeholder) . '</label>';
                        $form .= '<div class="energium-form-field-border-top"></div>';
                    $form .= '</div>';
                    $form .= '<input type="text" name="s" value="" title="' . esc_attr__('Search', 'energium') . '" class="search-form-field">';
                    $form .= '<div class="energium-form-field-border-bottom"></div>';
                $form .= '</div>';
            } else {
                $form .= '<span class="search-form-icon" onclick="' . esc_js($search_js) . '"></span>';
                $form .= '<input type="text" name="s" value="" placeholder="' . esc_attr($placeholder) . '" title="' . esc_attr__('Search', 'energium') . '" class="search-form-field">';
            }
        $form .= '</form>';

        return $form;
    }
}

// Customize WP Categories Widget
add_filter('wp_list_categories', 'energium_customize_categories_widget', 10, 2);
if ( !function_exists('energium_customize_categories_widget') ) {
    function energium_customize_categories_widget($output, $args) {
        $args['use_desc_for_title'] = false;
        if ( $args['hierarchical'] ) {
            $output = str_replace('"cat-item', '"cat-item cat-item-hierarchical', $output);
        }

        return $output;
    }
}

// Add 'Background color' button to Tiny MCE text editor
add_action( 'init', 'energium_tiny_mce_background_color' );
if ( !function_exists('energium_tiny_mce_background_color') ) {
    function energium_tiny_mce_background_color() {
        add_filter('mce_buttons_2', 'energium_tiny_mce_background_color_button', 999, 1);
    }
}
if ( !function_exists('energium_tiny_mce_background_color_button') ) {
    function energium_tiny_mce_background_color_button($buttons) {
        array_splice($buttons, 4, 0, 'backcolor');
        return $buttons;
    }
}

// Move Comment Message field in Comment form
add_filter( 'comment_form_fields', 'energium_move_comment_fields' );
if ( !function_exists('energium_move_comment_fields') ) {
    function energium_move_comment_fields($fields) {
        if ( !function_exists('is_product') || !is_product() ) {
            $comment_field = $fields['comment'];
            $cookies_field = $fields['cookies'];
            unset($fields['comment']);
            unset($fields['cookies']);
            $fields['comment'] = $comment_field;
            $fields['cookies'] = $cookies_field;
        }
        return $fields;
    }
}

// WPForms Plugin Dropdown Menu Fix
if ( function_exists( 'wpforms') ) {
    add_action( 'wpforms_display_field_select', 'energium_wpform_start_select_wrapper', 5, 1 );
    if ( !function_exists('energium_wpform_start_select_wrapper') ) {
        function energium_wpform_start_select_wrapper($field) {
            echo '<div class="select-wrap' . (!empty($field['size']) && isset($field['size']) ? ' wpforms-field-' . esc_attr($field['size']) : '') . '">';
        }
    }
    add_action( 'wpforms_display_field_select', 'energium_wpform_finish_select_wrapper', 15 );
    if ( !function_exists('energium_wpform_finish_select_wrapper') ) {
        function energium_wpform_finish_select_wrapper() {
            echo '</div>';
        }
    }
}

// Custom Password Form
add_filter( 'the_password_form', 'energium_password_form', 9999 );
if ( !function_exists('energium_password_form') ) {
    function energium_password_form() {
        global $post;
        $out = '<form action="' . esc_url(site_url('wp-login.php?action=postpass', 'login_post')) . '" class="post-password-form" method="post">';
            $out .= '<p>' . esc_html__('This content is password protected. To view it please enter your password below:', 'energium') . '</p>';
            $out .= '<div class="password-form">';
                $out .= '<div class="energium-form-field">';
                    $out .= '<div class="energium-label-wrapper">';
                        $out .= '<div class="energium-form-field-border-angle"></div>';
                        $out .= '<label for="password">' . esc_attr__('Password', 'energium') . '</label>';
                        $out .= '<div class="energium-form-field-border-top"></div>';
                    $out .= '</div>';
                    $out .= '<input name="post_password" id="password" type="password" size="20" required />';
                    $out .= '<div class="energium-form-field-border-bottom"></div>';
                $out .= '</div>';
                $out .= '<button name="Submit">' . esc_html__('Enter', 'energium') . '</button>';
            $out .= '</div>';
        $out .= '</form>';

        return $out;
    }
}

// Set Elementor Features Default Values
add_action( 'elementor/experiments/feature-registered', 'energium_elementor_features_set_default', 10, 2 );
if ( !function_exists('energium_elementor_features_set_default') ) {
    function energium_elementor_features_set_default( Elementor\Core\Experiments\Manager $experiments_manager ) {
        $experiments_manager->set_feature_default_state('e_dom_optimization', 'inactive');
    }
}

// Set custom palette in customizer colorpicker
add_action( 'customize_controls_enqueue_scripts', 'energium_custom_color_palette' );
if ( !function_exists('energium_custom_color_palette') ) {
    function energium_custom_color_palette() {
        $color_palettes = json_encode(energium_get_custom_color_palette());
        wp_add_inline_script('wp-color-picker', 'jQuery.wp.wpColorPicker.prototype.options.palettes = ' . sprintf('%s', $color_palettes) . ';');
    }
}

// Filter for widgets
add_filter( 'dynamic_sidebar_params', 'energium_dynamic_sidebar_params' );
if (!function_exists('energium_dynamic_sidebar_params')) {
    function energium_dynamic_sidebar_params($sidebar_params) {
        if (is_admin()) {
            return $sidebar_params;
        }
        global $wp_registered_widgets;
        $widget_id = $sidebar_params[0]['widget_id'];
        $wp_registered_widgets[$widget_id]['original_callback'] = $wp_registered_widgets[$widget_id]['callback'];
        $wp_registered_widgets[$widget_id]['callback'] = 'energium_widget_callback_function';

        return $sidebar_params;
    }
}
add_filter( 'widget_output', 'energium_output_filter', 10, 3 );
if (!function_exists('energium_output_filter')) {
    function energium_output_filter($widget_output, $widget_id_base, $widget_id) {
        if ($widget_id_base != 'woocommerce_product_categories' && $widget_id_base != 'wpforms-widget' && $widget_id_base != 'block') {
            $widget_output = str_replace('<select', '<div class="energium-form-field"><div class="select-wrap"><div class="energium-label-wrapper"><div class="energium-form-field-border-angle"></div><div class="energium-form-field-border-top"></div></div><select', $widget_output);
            $widget_output = str_replace('</select>', '</select><div class="energium-form-field-border-bottom"></div></div></div>', $widget_output);
        }

        return $widget_output;
    }
}

// Admin Footer
add_filter('admin_footer', 'energium_admin_footer');
if (!function_exists('energium_admin_footer')) {
    function energium_admin_footer() {
        if (strlen(get_page_template_slug())>0) {
            echo "<input type='hidden' name='' value='" . (get_page_template_slug() ? get_page_template_slug() : '') . "' class='energium_this_template_file'>";
        }
    }
}

// Remove post format parameter
add_filter('preview_post_link', 'energium_remove_post_format_parameter', 9999);
if (!function_exists('energium_remove_post_format_parameter')) {
    function energium_remove_post_format_parameter($url) {
        $url = remove_query_arg('post_format', $url);
        return $url;
    }
}

// Post excerpt customize
add_filter( 'excerpt_length', function() {
    return 41;
} );
add_filter( 'excerpt_more', function(){
    return '...';
} );

//Add Ajax Actions
add_action('wp_ajax_pagination', 'energium_ajax_pagination');
add_action('wp_ajax_nopriv_pagination', 'energium_ajax_pagination');

//Construct Loop & Results
if ( !function_exists('energium_ajax_pagination') ) {
    function energium_ajax_pagination() {
        check_ajax_referer('energium_ajax_nonce_value', 'security');

        $query_data         = $_POST;

        $paged              = (isset($query_data['paged'])) ? intval($query_data['paged']) : 1;
        $filter_term        = (isset($query_data['filter_term'])) ? $query_data['filter_term'] : null;
        $filter_taxonomy    = (isset($query_data['filter_taxonomy'])) ? $query_data['filter_taxonomy'] : null;
        $args               = (isset($query_data['args'])) ? json_decode(stripslashes($query_data['args']), true) : array();
        $args               = array_merge($args, array('paged' => sanitize_key($paged)));
        if (!empty($filter_term) && !empty($filter_taxonomy) && $filter_term != 'all') {
            $args = array_merge($args, array(sanitize_key($filter_taxonomy) => sanitize_key($filter_term)));
        }
        $post_type          = isset($args['post_type']) ? $args['post_type'] : 'post';
        $widget             = (isset($query_data['widget'])) ? json_decode(stripslashes($query_data['widget']), true) : array();
        $query              = new WP_Query($args);

        $wrapper_class      = isset($query_data['classes']) ? $query_data['classes'] : '';
        $id                 = isset($query_data['id']) ? $query_data['id'] : '';
        $link_base          = isset($args['link_base']) ? $args['link_base'] : '';

        echo '<div class="' . esc_attr($wrapper_class) . '">';
            while ($query->have_posts()) {
                $query->the_post();
                get_template_part('content', $post_type, $widget);
            };
            wp_reset_postdata();
        echo '</div>';

        echo '<div class="content-pagination">';
            echo '<nav class="pagination">';
                echo '<div class="nav-links">';
                    echo paginate_links(array(
                        'base'      => $link_base . '/?' . esc_attr($id) . '-paged=%#%',
                        'current'   => max(1, $paged),
                        'total'     => $query->max_num_pages,
                        'end_size'  => 2,
                        'prev_text' => esc_html__('Prev', 'energium'),
                        'next_text' => esc_html__('Next', 'energium'),
                        'add_args'  => false
                    )
                );
                echo '</div>';
            echo '</nav>';
        echo '</div>';

        die();
    }
}

// Customize WP-Blocks Output
if ( !function_exists('energium_wpblock_dropdown_wrapper') ) {
    function energium_wpblock_dropdown_wrapper($block_content, $block) {

        if (
            ( isset($block['attrs']['displayAsDropdown']) && $block['attrs']['displayAsDropdown'] === true ) ||
            ( isset($block['attrs']['isDropdown']) && $block['attrs']['isDropdown'] === true )
        ) {
            $block_content = str_replace('<select', '<div class="energium-form-field"><div class="energium-label-wrapper"><div class="energium-form-field-border-angle"></div><div class="energium-form-field-border-top"></div></div><div 
class="select-wrap"><select',
                $block_content);
            $block_content = str_replace('</select>', '</select></div><div class="energium-form-field-border-bottom"></div></div>', $block_content);
        }

        if (
            ( $block['blockName'] == 'core/search' && isset($block['attrs']['buttonUseIcon']) && $block['attrs']['buttonUseIcon'] === true ) ||
            ( $block['blockName'] == 'woocommerce/product-search' )
        ) {
            $block_content = preg_replace('/<svg\s+.*(<\/svg>)/s', '', $block_content);
        }

        if (
            $block['blockName'] == 'core/search'
        ) {
            if (
                isset($block['attrs']['buttonPosition']) && !empty($block['attrs']['buttonPosition']) &&
                (
                    $block['attrs']['buttonPosition'] === 'no-button' ||
                    $block['attrs']['buttonPosition'] === 'button-inside'
                )
            ) {
                $block_content = str_replace('</div>', '<div class="energium-form-field-border-bottom"></div></div></div>', $block_content);
                $block_content = str_replace('<input', '<div class="energium-form-field"><div class="energium-label-wrapper"><div class="energium-form-field-border-angle"></div><div class="energium-form-field-border-top"></div></div><input', $block_content);
            } else {
                $block_content = str_replace('<input', '<div class="energium-form-field"><div class="energium-label-wrapper"><div class="energium-form-field-border-angle"></div><div class="energium-form-field-border-top"></div></div><input', $block_content);
                $block_content = str_replace('<button', '<div class="energium-form-field-border-bottom"></div></div><button', $block_content);
            }
        }

        if (
            $block['blockName'] == 'woocommerce/product-search'
        ) {
            $block_content = str_replace('</button>', '</button><div class="energium-form-field-border-bottom"></div></div>', $block_content);
            $block_content = str_replace('<input type="search"', '<div class="energium-form-field"><div class="energium-label-wrapper"><div class="energium-form-field-border-angle"></div><div class="energium-form-field-border-top"></div></div><input type="search"', $block_content);
        }

        if ( $block['blockName'] == 'core/loginout' && isset($block['attrs']['displayLoginAsForm']) && $block['attrs']['displayLoginAsForm'] === true ) {
            $block_content = str_replace('login-username', 'login-username energium-form-field', $block_content);
            $block_content = str_replace('login-password', 'login-password energium-form-field', $block_content);
            $block_content = str_replace('size="20" />', 'size="20" /><span class="energium-form-field-border-bottom"></span>', $block_content);
            $block_content = str_replace('<label for', '<span class="energium-label-wrapper"><span class="energium-form-field-border-angle"></span><label for', $block_content);
            $block_content = str_replace('<input type="text"', '<span class="energium-form-field-border-top"></span></span><input type="text"', $block_content);
            $block_content = str_replace('<input type="password"', '<span class="energium-form-field-border-top"></span></span><input type="password"', $block_content);

            $block_content = str_replace('<input type="submit"', '<button', $block_content);
            $block_content = str_replace('<input type="hidden"', esc_html__('Log In', 'energium') . '</button><input type="hidden"', $block_content);
        }

        if (
            $block['blockName'] == 'core/heading'
        ) {
            $block_content = sprintf('<div class="wp-block-title">%s</div>', $block_content);
            $block_content = str_replace('</h1>', '</h1><div class="wp-block-title-pattern"></div>', $block_content);
            $block_content = str_replace('</h2>', '</h2><div class="wp-block-title-pattern"></div>', $block_content);
            $block_content = str_replace('</h3>', '</h3><div class="wp-block-title-pattern"></div>', $block_content);
            $block_content = str_replace('</h4>', '</h4><div class="wp-block-title-pattern"></div>', $block_content);
        }

        if (
            $block['blockName'] == 'core/archives'
        ) {
            $block_content = str_replace('(', '', $block_content);
            $block_content = str_replace(')', '', $block_content);
        }

        if (
            $block['blockName'] == 'woocommerce/featured-product' ||
            $block['blockName'] == 'woocommerce/featured-category'
        ) {
            $block_content = str_replace('<h2', '<h3', $block_content);
            $block_content = str_replace('</h2>', '</h3>', $block_content);
        }

        if (
            $block['blockName'] == 'core/file'
        ) {
            if ( isset($block['attrs']['showDownloadButton']) && $block['attrs']['showDownloadButton'] == false ) {
                $date = get_the_date('F j, Y', $block['attrs']['id']);
                $icon = '<img class="wp-block-file-icon" alt="' . esc_attr__('Document', 'energium') . '" src="' . esc_url(get_template_directory_uri() . '/img/doc-icon.png') . '" />';

                $block_content = str_replace('"wp-block-file"', '"wp-block-file wp-block-file-with-icon"', $block_content);
                $block_content = str_replace('<a', wp_kses($icon, 'post') . '<div class="wp-block-file-info"><a', $block_content);
                $block_content = str_replace('</a>', '</a><div class="wp-block-file-date">' . esc_html($date) . '</div></div>', $block_content);
            }
        }

        return $block_content;
    }
}
add_filter( 'render_block', 'energium_wpblock_dropdown_wrapper', 10, 2 );


// Customize WPForms fields
if ( function_exists('wpforms') ) {
    add_action( 'wpforms_display_field_before', 'energium_wrap_wpforms_fields_open', 10, 2 );
    if ( !function_exists('energium_wrap_wpforms_fields_open') ) {
        function energium_wrap_wpforms_fields_open($field, $form_data) {
            if (
                ($field['type'] == 'text') ||
                ($field['type'] == 'textarea') ||
                ($field['type'] == 'select') ||
                ($field['type'] == 'number') ||
                ($field['type'] == 'name' && $field['format'] == 'simple') ||
                ($field['type'] == 'email' && !isset($field['confirmation'])) ||
                ($field['type'] == 'phone') ||
                ($field['type'] == 'url')
            ) {
                echo '<div class="wpforms-field-wrapper energium-form-field">';
            }
        }
    }
    add_action( 'wpforms_display_field_before', 'energium_wpforms_fields_top_border_open', 10, 2 );
    if ( !function_exists('energium_wpforms_fields_top_border_open') ) {
        function energium_wpforms_fields_top_border_open($field, $form_data) {
            if (
                ($field['type'] == 'text') ||
                ($field['type'] == 'textarea') ||
                ($field['type'] == 'select') ||
                ($field['type'] == 'number') ||
                ($field['type'] == 'name' && $field['format'] == 'simple') ||
                ($field['type'] == 'email' && !isset($field['confirmation'])) ||
                ($field['type'] == 'phone') ||
                ($field['type'] == 'url')
            ) {
                echo '<div class="energium-label-wrapper">';
                    echo '<div class="energium-form-field-border-angle"></div>';
            }
        }
    }
    add_action( 'wpforms_display_field_before', 'energium_wpforms_fields_top_border_close', 17, 2 );
    if ( !function_exists('energium_wpforms_fields_top_border_close') ) {
        function energium_wpforms_fields_top_border_close($field, $form_data) {
            if (
                ($field['type'] == 'text') ||
                ($field['type'] == 'textarea') ||
                ($field['type'] == 'select') ||
                ($field['type'] == 'number') ||
                ($field['type'] == 'name' && $field['format'] == 'simple') ||
                ($field['type'] == 'email' && !isset($field['confirmation'])) ||
                ($field['type'] == 'phone') ||
                ($field['type'] == 'url')
            ) {
                    echo '<div class="energium-form-field-border-top"></div>';
                echo '</div>';
            }
        }
    }
    add_action( 'wpforms_display_field_after', 'energium_wrap_wpforms_fields_close', 1, 2 );
    if ( !function_exists('energium_wrap_wpforms_fields_close') ) {
        function energium_wrap_wpforms_fields_close($field, $form_data) {
            if (
                ($field['type'] == 'text') ||
                ($field['type'] == 'textarea') ||
                ($field['type'] == 'select') ||
                ($field['type'] == 'number') ||
                ($field['type'] == 'name' && $field['format'] == 'simple') ||
                ($field['type'] == 'email' && !isset($field['confirmation'])) ||
                ($field['type'] == 'phone') ||
                ($field['type'] == 'url')
            ) {
                    echo '<div class="energium-form-field-border-bottom"></div>';
                echo '</div>';
            }
        }
    }
}