<?php

// --------------------------------- //
// ------ Page Title Settings ------ //
// --------------------------------- //

# General
$page_title_height              = energium_get_prepared_option('page_title_height', '', 'page_title_customize');
$page_title_background_position = energium_get_prepared_option('page_title_background_position', '', 'page_title_customize');
$page_title_background_repeat   = energium_get_prepared_option('page_title_background_repeat', '', 'page_title_customize');
$page_title_background_size     = energium_get_prepared_option('page_title_background_size', '', 'page_title_customize');

$hide_page_title_background_mobile = (bool)energium_get_prepared_option('hide_page_title_background_mobile', '', 'page_title_customize');
$hide_page_title_background_tablet = (bool)energium_get_prepared_option('hide_page_title_background_tablet', '', 'page_title_customize');

$page_title_background_image = energium_get_prepared_img_url('page_title_background_image', 'page_title_customize');
if ( !empty($page_title_height) ) {
    $energium_custom_css .= '
        @media only screen and (min-width: 992px) {
            .body-container .page-title-container,
            .edit-post-visual-editor__post-title-wrapper {' .
                ( !empty($page_title_height) ? 'min-height: ' . esc_attr($page_title_height) . 'px;' : '' ) .
            '}
        }
    ';
}
if ( !empty($page_title_background_position) || !empty($page_title_background_repeat) || !empty($page_title_background_size) ) {
    $energium_custom_css .= '
        .body-container .page-title-container .page-title-bg,
        .edit-post-visual-editor__post-title-wrapper:before {' .
            ( !empty($page_title_background_position) ? 'background-position: ' . esc_attr($page_title_background_position) . ';' : '' ) .
            ( !empty($page_title_background_repeat) ? 'background-repeat: ' . esc_attr($page_title_background_repeat) . ';' : '' ) .
            ( !empty($page_title_background_size) ? '-webkit-background-size: ' . esc_attr($page_title_background_size) . ';' : '' ) .
            ( !empty($page_title_background_size) ? 'background-size: ' . esc_attr($page_title_background_size) . ';' : '' ) .
        '}
    ';
}
if ( !empty($page_title_background_image) ) {
    $energium_custom_css .= '
        .body-container .page-title-container .page-title-bg,
        .edit-post-visual-editor__post-title-wrapper:before {' .
            ( !empty($page_title_background_image) ? 'background-image: url("' . esc_attr($page_title_background_image) . '");' : '' ) .
        '}';
    }
    if ( $hide_page_title_background_mobile ) {
        $energium_custom_css .= '
            @media only screen and (max-width: 767px) {
                .body-container .page-title-container .page-title-bg,
                .edit-post-visual-editor__post-title-wrapper:before {
                    background-image: none;
                }
            }
        ';
    }
    if ( $hide_page_title_background_mobile ) {
        $energium_custom_css .= '
            @media only screen and (min-width: 768px) and (max-width: 991px) {
                .body-container .page-title-container .page-title-bg,
                .edit-post-visual-editor__post-title-wrapper:before {
                    background-image: none;
                }
            }
        ';
    }

# Heading
$page_title_heading_font        = energium_get_prepared_option('page_title_heading_font', '', 'page_title_heading_customize');
$page_title_heading_font_array  = json_decode($page_title_heading_font, true);
if (
    !empty($page_title_heading_font_array['font_family']) ||
    !empty($page_title_heading_font_array['text_transform']) ||
    !empty($page_title_heading_font_array['letter_spacing']) ||
    !empty($page_title_heading_font_array['word_spacing']) ||
    !empty($page_title_heading_font_array['font_style']) ||
    !empty($page_title_heading_font_array['font_weight'])
) {
    $energium_custom_css .= '
        .body-container .page-title-container h1.page-title,
        .body-container .page-title-container .page-title-wrapper .page-title-box,
        .edit-post-visual-editor__post-title-wrapper .editor-post-title {' .
            energium_print_font_styles( $page_title_heading_font, array('font_family', 'text_transform', 'letter_spacing', 'word_spacing', 'font_style', 'font_weight') ) .
        '}
    ';
}
if (
    !empty($page_title_heading_font_array['font_size']) ||
    !empty($page_title_heading_font_array['line_height'])
) {
    if ( (int)$page_title_heading_font_array['font_size'] >= 50 ) {
        $energium_custom_css .= '
            @media only screen and (min-width: 576px) {
                .body-container .page-title-container h1.page-title,
                .body-container .page-title-container .page-title-wrapper .page-title-box,
                .edit-post-visual-editor__post-title-wrapper .editor-post-title {
                    font-size: 45px;
                }
            }
            @media only screen and (min-width: 992px) {
                .body-container .page-title-container h1.page-title,
                .body-container .page-title-container .page-title-wrapper .page-title-box,
                .edit-post-visual-editor__post-title-wrapper .editor-post-title {' .
                    energium_print_font_styles( $page_title_heading_font, array('font_size', 'line_height' ) ) .
                '}
            }
        ';
    } else {
        $energium_custom_css .= '
            @media only screen and (min-width: 576px) {
                .body-container .page-title-container h1.page-title,
                .body-container .page-title-container .page-title-wrapper .page-title-box,
                .edit-post-visual-editor__post-title-wrapper .editor-post-title {' .
                    energium_print_font_styles( $page_title_heading_font, array('font_size', 'line_height' ) ) .
                '}
            }
        ';
    }
}