<?php

// ---------------------------- //
// ------ Header Colors ------- //
// ---------------------------- //
$header_default_text_color = energium_get_prepared_option('header_default_text_color', 'standard_default_text_color', 'header_customize');
if ( !empty($header_default_text_color) ) {
    $energium_custom_css .= '
        .header,
        .mobile-header,
        .callback .callback-title {
            color: ' . esc_attr($header_default_text_color) . ';
        }
    ';
}

$header_dark_text_color = energium_get_prepared_option('header_dark_text_color', 'standard_dark_text_color', 'header_customize');
if ( !empty($header_dark_text_color) ) {
    $energium_custom_css .= '
        .header a,
        .header .main-menu > li > a,
        .header .logo-link .logo-site-name,
        .header .header-icon,
        .mobile-header a,
        .mobile-header .logo-link .logo-site-name,
        .mobile-header .header-icon,
        .mobile-header-menu-container a,
        .mobile-header-menu-container .logo-link .logo-site-name,
        .mobile-header-menu-container .header-icon,
        .error-404-header .logo-link .logo-site-name,
        .mini-cart .mini-cart-trigger,
        .mini-cart .mini-cart-trigger:hover,
        .mobile-header-menu-container,
        .callback .callback-text,
        .menu-close .menu-close-icon,
        .mobile-header-menu-container .header-mobile-contacts .contact-item .contact-item-value,
        .mobile-header-menu-container .header-mobile-contacts .contact-item .contact-item-value a,
        .mobile-header-menu-container .main-menu > li .sub-menu-trigger,
        .mobile-header-menu-container .header-mobile-contacts .contact-item .contact-item-label,
         
        .header .main-menu > li.current-menu-item > a:not([href *= "/#"]),
        .mobile-header-menu-container .main-menu li.current-menu-item > a:not([href *= "/#"]) {
            color: ' . esc_attr($header_dark_text_color) . ';
        }
        .mobile-header .menu-trigger .hamburger span {
            background-color: ' . esc_attr($header_dark_text_color) . ';
        }
        .dropdown-trigger .dropdown-trigger-item.colors-light svg .cls-1 {
            stroke: ' . esc_attr($header_dark_text_color) . ';
        }
    ';
}

$header_light_text_color = energium_get_prepared_option('header_light_text_color', 'standard_light_text_color', 'header_customize');
if ( !empty($header_light_text_color) ) {
    $energium_custom_css .= '
        .site-search .search-form .search-form-field::-webkit-input-placeholder {
             color: ' . esc_attr($header_light_text_color) . ';
        }
        .site-search .search-form .search-form-field:-moz-placeholder {
             color: ' . esc_attr($header_light_text_color) . ';
        }
        .site-search .search-form .search-form-field::-moz-placeholder {
             color: ' . esc_attr($header_light_text_color) . ';
        }
        .site-search .search-form .search-form-field:-ms-input-placeholder {
            color: ' . esc_attr($header_light_text_color) . ';
        }
    ';
}

$header_accent_text_color = energium_get_prepared_option('header_accent_text_color', 'standard_accent_text_color', 'header_customize');
if ( !empty($header_accent_text_color) ) {
    $energium_custom_css .= '
        .mobile-header-menu-container .header-mobile-contacts .contact-item:before,
        .header .main-menu > li > a:hover,
        .header .main-menu > li.current-menu-ancestor > a,
        .header .main-menu > li.current-menu-parent > a,
        .header .main-menu > li.current-menu-item > a:not([href *= "/#"]),
        .mobile-header-menu-container .main-menu li.active > a,
        .mobile-header-menu-container .main-menu li.current-menu-ancestor > a,
        .mobile-header-menu-container .main-menu li.current-menu-parent > a,
        .mobile-header-menu-container .main-menu li.current-menu-item > a:not([href *= "/#"]),
        .callback:before,
        .header .header-icon .search-trigger-icon:hover,
        .menu-close .menu-close-icon:hover,
        .mobile-header-menu-container .header-mobile-contacts .contact-item .contact-item-value a:hover,
        .header .main-menu > li.current-menu-item > a:not([href *= "/#"]):hover,
        .mobile-header-menu-container .main-menu li.current-menu-item > a:not([href *= "/#"]):hover {
            color: ' . esc_attr($header_accent_text_color) . ';
        }
        .dropdown-trigger .dropdown-trigger-item.colors-light svg .cls-2 {
            stroke: ' . esc_attr($header_accent_text_color) . ';
        }
    ';
}

$header_hover_text_color = energium_get_prepared_option('header_hover_text_color', 'standard_hover_text_color', 'header_customize');
if ( !empty($header_hover_text_color) ) {
    $energium_custom_css .= '';
}

$header_border_color = energium_get_prepared_option('header_border_color', 'standard_border_color', 'header_customize');
if ( !empty($header_border_color) ) {
    $energium_custom_css .= '
        .site-search,
        .dropdown-trigger .dropdown-trigger-item.colors-light.separated,
        .mobile-header-menu-container .main-menu > li > ul.sub-menu,
        .mobile-header-menu-container .main-menu > li {
            border-color: ' . esc_attr($header_border_color) . ';
        }
    ';
}

$header_border_hover_color = energium_get_prepared_option('header_border_hover_color', 'standard_border_hover_color', 'header_customize');
if ( !empty($header_border_hover_color) ) {
    $energium_custom_css .= '';
}

$header_background_color = energium_get_prepared_option('header_background_color', 'standard_background_color', 'header_customize');
if ( !empty($header_background_color) ) {
    $energium_custom_css .= '
        .header,
        .mobile-header,
        .site-search,
        .mobile-header-menu-container,
        .header.sticky-header-on.sticky-ready .sticky-wrapper,
        .mobile-header.sticky-header-on.sticky-ready .sticky-wrapper {
            background-color: ' . esc_attr($header_background_color) . ';
        }
        .mini-cart .mini-cart-count > span {
            border-color: ' . esc_attr($header_background_color) . ';
        }
    ';
}

$header_background_alter_color = energium_get_prepared_option('header_background_alter_color', 'standard_background_alter_color', 'header_customize');
if ( !empty($header_background_alter_color) ) {
    $energium_custom_css .= '';
}

$header_button_text_color = energium_get_prepared_option('header_button_text_color', 'standard_button_text_color', 'header_customize');
if ( !empty($header_button_text_color) ) {
    $energium_custom_css .= '
        .header .energium-button, 
        .mobile-header .energium-button, 
        .mobile-header-menu-container .energium-button,
        .mobile-header-menu-container .wrapper-socials li a {
            color: ' . esc_attr($header_button_text_color) . ';
        }
    ';
}

$header_button_border_color = energium_get_prepared_option('header_button_border_color', 'standard_button_border_color', 'header_customize');
if ( !empty($header_button_border_color) ) {
    $energium_custom_css .= '
        .mobile-header-menu-container .wrapper-socials li a {
            border-color: ' . esc_attr($header_button_border_color) . ';
        }
    ';
}

$header_button_background_color = energium_get_prepared_option('header_button_background_color', 'standard_button_background_color', 'header_customize');
if ( !empty($header_button_background_color) ) {
    $energium_custom_css .= '';
}

$header_button_text_hover = energium_get_prepared_option('header_button_text_hover', 'standard_button_text_hover', 'header_customize');
if ( !empty($header_button_text_hover) ) {
    $energium_custom_css .= '
        .header .energium-button:hover, 
        .mobile-header .energium-button:hover, 
        .mobile-header-menu-container .energium-button:hover,
        .header a.header-button,
        .header a.header-button:hover,
        .mobile-header-menu-container .wrapper-socials li a:hover {
            color: ' . esc_attr($header_button_text_hover) . ';
        }
    ';
}

$header_button_border_hover = energium_get_prepared_option('header_button_border_hover', 'standard_button_border_hover', 'header_customize');
if ( !empty($header_button_border_hover) ) {
    $energium_custom_css .= '
        .mobile-header-menu-container .wrapper-socials li a:hover {
            border-color: ' . esc_attr($header_button_border_hover) . ';
        }
    ';
}

$header_button_background_hover = energium_get_prepared_option('header_button_background_hover', 'standard_button_background_hover', 'header_customize');
if ( !empty($header_button_background_hover) ) {
    $energium_custom_css .= '
        .header-button,
        .mobile-header-menu-container .wrapper-socials li a:hover {
            background-color: ' . esc_attr($header_button_background_hover) . ';
        }
    ';
}