<?php
/*
 * Created by Artureanec
*/

global $energium_custom_css;

if (class_exists('WooCommerce') && is_woocommerce()) {
    global $post;
    $page_id    = wc_get_page_id('shop');
    $post       = get_post($page_id);
}

require_once(get_template_directory() . "/css/custom/additional-fonts.php");
require_once(get_template_directory() . "/css/custom/typography-settings.php");
require_once(get_template_directory() . "/css/custom/top-bar-colors.php");
require_once(get_template_directory() . "/css/custom/header-colors.php");
require_once(get_template_directory() . "/css/custom/page-title-colors.php");
require_once(get_template_directory() . "/css/custom/footer-colors.php");
require_once(get_template_directory() . "/css/custom/standard-colors.php");
require_once(get_template_directory() . "/css/custom/contrast-colors.php");

require_once(get_template_directory() . "/css/custom/header-settings.php");
require_once(get_template_directory() . "/css/custom/page-title-settings.php");
require_once(get_template_directory() . "/css/custom/footer-settings.php");
require_once(get_template_directory() . "/css/custom/404-error-page-settings.php");

if ( class_exists('\Elementor\Plugin' )) {
    if ( did_action('elementor/init') ) {
        $active_breakpoints = \Elementor\Plugin::$instance->breakpoints->get_active_breakpoints();
        if( !empty($active_breakpoints) ) {
            global $energium_custom_css;
            $counter                = 0;
            $prev_breakpoint        = null;

            $energium_custom_css    .= PHP_EOL;
            foreach ( $active_breakpoints as $breakpoint_key => $breakpoint ) {
                $counter++;
                if( $breakpoint->get_name() === 'widescreen' ) {
                    $energium_custom_css .= '@media only screen and (min-width:' . $breakpoint->get_value() . 'px) {' . PHP_EOL;
                    for ( $i = 1, $j = 10; $i <= 10; $i++, $j-- ) {
                        $energium_custom_css .= "\t.elementor-reverse-" . $breakpoint->get_name() . ' > .elementor-container > .elementor-row > ' . ( $i == 1 ? ':first-child' : ':nth-child(' . $i . ')') . ' {' . PHP_EOL;
                        $energium_custom_css .= "\t\t" . 'order:' . $j . ';' . PHP_EOL;
                        $energium_custom_css .= "\t" . '}' . PHP_EOL;
                    }
                    $energium_custom_css .= "}" . PHP_EOL;
                    continue;
                }
                if( $counter === 1 ) {
                    $energium_custom_css .= '@media only screen and (max-width:' . $breakpoint->get_value() . 'px) {' . PHP_EOL;
                    for ( $i = 1, $j = 10; $i <= 10; $i++, $j-- ) {
                        $energium_custom_css .= "\t.elementor-reverse-" . $breakpoint->get_name() . ' > .elementor-container > .elementor-row > ' . ( $i == 1 ? ':first-child' : ':nth-child(' . $i . ')') . ' {' . PHP_EOL;
                        $energium_custom_css .= "\t\t" . 'order:' . $j . ';' . PHP_EOL;
                        $energium_custom_css .= "\t" . '}' . PHP_EOL;
                    }
                    $energium_custom_css .= "}" . PHP_EOL;
                } elseif ( $counter !== 1 && $prev_breakpoint ) {
                    $energium_custom_css .= '@media only screen and (min-width:' . ($prev_breakpoint + 1) . 'px) and (max-width:' . $breakpoint->get_value() . 'px) {' . PHP_EOL;
                    for ( $i = 1, $j = 10; $i <= 10; $i++, $j-- ) {
                        $energium_custom_css .= "\t.elementor-reverse-" . $breakpoint->get_name() . ' > .elementor-container > .elementor-row > ' . ( $i == 1 ? ':first-child' : ':nth-child(' . $i . ')') . ' {' . PHP_EOL;
                        $energium_custom_css .= "\t\t" . 'order:' . $j . ';' . PHP_EOL;
                        $energium_custom_css .= "\t" . '}' . PHP_EOL;
                    }
                    $energium_custom_css .= "}" . PHP_EOL;
                }
                $prev_breakpoint = $breakpoint->get_value();
            }
        }
    }
}