<?php

// ----------------------------- //
// ------ Contrast Colors ------ //
// ----------------------------- //

$contrast_default_text_color = energium_get_prefered_option('contrast_default_text_color');
if ( !empty($contrast_default_text_color) ) {
    $energium_custom_css .= '
        .slide-sidebar-wrapper .slide-sidebar-content,
        .slide-sidebar-wrapper .widget_energium_featured_posts_widget .featured-posts-item-link,
        .slide-sidebar-wrapper .widget_recent_entries ul li a,
        .slide-sidebar-wrapper .wp-block-latest-posts li a,
        .slide-sidebar-wrapper .widget_recent_comments ul .recentcomments,
        .slide-sidebar-wrapper .widget_categories ul li:hover li,
         
        .content-wrapper .widget_calendar table thead th, 
        .content-wrapper .wp-block-calendar table thead th,
        .content-wrapper .widget_calendar .wp-calendar-nav a,
        .content-wrapper .wp-block-calendar .wp-calendar-nav a,
        .block-editor-block-list__layout .widget_calendar table thead th, 
        .block-editor-block-list__layout .wp-block-calendar table thead th,
        .block-editor-block-list__layout .widget_calendar .wp-calendar-nav a,
        .block-editor-block-list__layout .wp-block-calendar .wp-calendar-nav a,
         
        .slide-sidebar-wrapper div.wpforms-container-full .wpforms-form .energium-form-field .energium-label-wrapper label, 
        .slide-sidebar-wrapper form .energium-form-field .energium-label-wrapper label {
            color: ' . esc_attr($contrast_default_text_color) . ';
        }
    ';
}

$contrast_dark_text_color = energium_get_prefered_option('contrast_dark_text_color');
if ( !empty($contrast_dark_text_color) ) {
    $energium_custom_css .= '
        .project-listing-wrapper.text-position-inside .project-item-wrapper .post-title,
        .project-listing-wrapper.text-position-inside .project-item-wrapper .project-item-categories,
        .project-listing-wrapper.text-position-inside .project-item-wrapper .project-item-categories a,
        .header .main-menu ul.sub-menu > li > a,
        .widget_media_audio .mejs-container .mejs-button > button,
        .widget_media_audio .mejs-container .mejs-time,
        .widget_media_audio .mejs-container .mejs-duration,
        .mejs-audio.mejs-container .mejs-button > button,
        .mejs-audio.mejs-container .mejs-time,
        .mejs-audio.mejs-container .mejs-duration,
        .wp-video .mejs-container .mejs-button > button,
        .wp-video .mejs-container .mejs-time,
        .wp-video .mejs-container .mejs-duration,
        .widget_energium_banner_widget .banner-widget-wrapper.banner-contrast-colors,
        .widget_energium_banner_widget .banner-widget-wrapper.banner-contrast-colors .banner-title,
        .slide-sidebar-wrapper .slide-sidebar-content h1, 
        .slide-sidebar-wrapper .slide-sidebar-content h2, 
        .slide-sidebar-wrapper .slide-sidebar-content h3, 
        .slide-sidebar-wrapper .slide-sidebar-content h4, 
        .slide-sidebar-wrapper .slide-sidebar-content h5, 
        .slide-sidebar-wrapper .slide-sidebar-content h6,
        .slide-sidebar-wrapper .slide-sidebar-close,
        .slide-sidebar-wrapper input[type="text"],
        .slide-sidebar-wrapper input[type="email"],
        .slide-sidebar-wrapper input[type="url"],
        .slide-sidebar-wrapper input[type="password"],
        .slide-sidebar-wrapper input[type="search"],
        .slide-sidebar-wrapper input[type="number"],
        .slide-sidebar-wrapper input[type="tel"],
        .slide-sidebar-wrapper input[type="range"],
        .slide-sidebar-wrapper input[type="date"],
        .slide-sidebar-wrapper input[type="month"],
        .slide-sidebar-wrapper input[type="week"],
        .slide-sidebar-wrapper input[type="time"],
        .slide-sidebar-wrapper input[type="datetime"],
        .slide-sidebar-wrapper input[type="datetime-local"],
        .slide-sidebar-wrapper input[type="color"],
        .slide-sidebar-wrapper select,
        .slide-sidebar-wrapper .select2-container .select2-selection--single,
        .slide-sidebar-wrapper textarea,
        .slide-sidebar-wrapper div.wpforms-container-full .wpforms-form .energium-form-field input[type="text"], 
        .slide-sidebar-wrapper div.wpforms-container-full .wpforms-form .energium-form-field input[type="email"], 
        .slide-sidebar-wrapper div.wpforms-container-full .wpforms-form .energium-form-field input[type="url"], 
        .slide-sidebar-wrapper div.wpforms-container-full .wpforms-form .energium-form-field input[type="password"], 
        .slide-sidebar-wrapper div.wpforms-container-full .wpforms-form .energium-form-field input[type="search"], 
        .slide-sidebar-wrapper div.wpforms-container-full .wpforms-form .energium-form-field input[type="number"], 
        .slide-sidebar-wrapper div.wpforms-container-full .wpforms-form .energium-form-field input[type="tel"], 
        .slide-sidebar-wrapper div.wpforms-container-full .wpforms-form .energium-form-field input[type="date"], 
        .slide-sidebar-wrapper div.wpforms-container-full .wpforms-form .energium-form-field input[type="month"], 
        .slide-sidebar-wrapper div.wpforms-container-full .wpforms-form .energium-form-field input[type="week"], 
        .slide-sidebar-wrapper div.wpforms-container-full .wpforms-form .energium-form-field input[type="time"], 
        .slide-sidebar-wrapper div.wpforms-container-full .wpforms-form .energium-form-field input[type="datetime"], 
        .slide-sidebar-wrapper div.wpforms-container-full .wpforms-form .energium-form-field input[type="datetime-local"], 
        .slide-sidebar-wrapper div.wpforms-container-full .wpforms-form .energium-form-field input[type="color"], 
        .slide-sidebar-wrapper div.wpforms-container-full .wpforms-form .energium-form-field select, 
        .slide-sidebar-wrapper div.wpforms-container-full .wpforms-form .energium-form-field textarea, 
        .slide-sidebar-wrapper form .energium-form-field input[type="text"], 
        .slide-sidebar-wrapper form .energium-form-field input[type="email"], 
        .slide-sidebar-wrapper form .energium-form-field input[type="url"], 
        .slide-sidebar-wrapper form .energium-form-field input[type="password"], 
        .slide-sidebar-wrapper form .energium-form-field input[type="search"], 
        .slide-sidebar-wrapper form .energium-form-field input[type="number"], 
        .slide-sidebar-wrapper form .energium-form-field input[type="tel"], 
        .slide-sidebar-wrapper form .energium-form-field input[type="date"], 
        .slide-sidebar-wrapper form .energium-form-field input[type="month"], 
        .slide-sidebar-wrapper form .energium-form-field input[type="week"], 
        .slide-sidebar-wrapper form .energium-form-field input[type="time"], 
        .slide-sidebar-wrapper form .energium-form-field input[type="datetime"], 
        .slide-sidebar-wrapper form .energium-form-field input[type="datetime-local"], 
        .slide-sidebar-wrapper form .energium-form-field input[type="color"], 
        .slide-sidebar-wrapper form .energium-form-field select, 
        .slide-sidebar-wrapper form .energium-form-field textarea,
        .slide-sidebar-wrapper .wpforms-field-select .energium-form-field .choices .choices__inner,
        .slide-sidebar-wrapper .select2-container--default .select2-results__option.select2-results__option--highlighted[aria-selected], 
        .slide-sidebar-wrapper .select2-container--default .select2-results__option.select2-results__option--highlighted[data-selected],
        .slide-sidebar-wrapper .widget_search .search-form .search-form-icon,
        .slide-sidebar-wrapper .widget_energium_featured_posts_widget .featured-posts-item-link,
        .slide-sidebar-wrapper .widget_recent_entries ul li a,
        .slide-sidebar-wrapper .wp-block-latest-posts li a,
        .slide-sidebar-wrapper .widget_recent_comments ul .recentcomments a,
        .slide-sidebar-wrapper .wp-block-latest-comments li a,
        .slide-sidebar-wrapper .widget_rss cite,
        .slide-sidebar-wrapper .widget_rss ul a.rsswidget,
        .slide-sidebar-wrapper .wp-block-rss .wp-block-rss__item-title a,
        .slide-sidebar-wrapper .wp-block-rss .wp-block-rss__item-author,
        .slide-sidebar-wrapper .widget .widget-title a,
        .slide-sidebar-wrapper .widget_pages .widget-wrapper > ul li > a,
        .slide-sidebar-wrapper .wp-block-page-list li.wp-block-pages-list__item a,
        .slide-sidebar-wrapper .widget_meta ul li > a,
        .slide-sidebar-wrapper .widget_categories ul li > a, 
        .slide-sidebar-wrapper .widget_categories ul li .widget-archive-trigger,
        
        .slide-sidebar-wrapper .widget_pages ul li .widget-archive-trigger,
        .slide-sidebar-wrapper .wp-block-page-list .wp-block-pages-list__item .widget-archive-trigger,
        
        .slide-sidebar-wrapper .widget_archive ul li > a,
        .energium-content-slider-widget .content-item,
        .energium-content-slider-widget .bottom-area,
        .energium-content-slider-widget .bottom-area .contacts .contact-item a,
        .slide-sidebar-wrapper .wp-block-loginout,
        .slide-sidebar-wrapper .wp-block-loginout a,
        
        .slide-sidebar-wrapper .wp-block-search .wp-block-search__label,
        .slide-sidebar-wrapper .wp-block-woocommerce-product-search .wc-block-product-search__label,
        .slide-sidebar-wrapper .wp-block-woocommerce-product-search .wc-block-product-search__fields .wc-block-product-search__button:not(.customize-partial-edit-shortcut-button):not(.components-button):not([class*="elementor"]),
        .content-wrapper .widget_calendar caption, 
        .content-wrapper .wp-block-calendar caption,
        .content-wrapper .widget_calendar table tbody td a, 
        .content-wrapper .wp-block-calendar table tbody td a,
        
        .block-editor-block-list__layout .widget_calendar caption, 
        .block-editor-block-list__layout .wp-block-calendar caption,
        .block-editor-block-list__layout .widget_calendar table tbody td a, 
        .block-editor-block-list__layout .wp-block-calendar table tbody td a,
        
        .slide-sidebar-wrapper h1,
        .slide-sidebar-wrapper h2,
        .slide-sidebar-wrapper h3,
        .slide-sidebar-wrapper h4,
        .slide-sidebar-wrapper h5,
        .slide-sidebar-wrapper h6,
        .slide-sidebar-wrapper .widget_categories ul li a,
        .slide-sidebar-wrapper ul.wp-block-categories li a,
        .slide-sidebar-wrapper .widget_product_tag_cloud .tagcloud .tag-cloud-link,
        .slide-sidebar-wrapper .widget_tag_cloud .tagcloud .tag-cloud-link,
        .slide-sidebar-wrapper .wp-block-tag-cloud .tag-cloud-link,
        .slide-sidebar-wrapper .widget_archive ul li > a,
        .slide-sidebar-wrapper .wp-block-archives li > a,
         
        .slide-sidebar-wrapper .wp-block-social-links:not(.is-style-logos-only):not(.is-style-pill-shape):not(.has-icon-color) .wp-block-social-link svg,
        .slide-sidebar-wrapper .wrapper-socials a,
        
        .slide-sidebar-wrapper div.wpforms-container-full .wpforms-form .energium-form-field:focus-within .energium-label-wrapper label, 
        .slide-sidebar-wrapper div.wpforms-container-full .wpforms-form .energium-form-field.not-empty .energium-label-wrapper label, 
        .slide-sidebar-wrapper .energium-form-field:focus-within .energium-label-wrapper label, 
        .slide-sidebar-wrapper form .energium-form-field.not-empty .energium-label-wrapper label,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form .wpforms-field-number-slider .wpforms-field-number-slider-hint,
        .slide-sidebar-wrapper .widget_energium_contacts_widget .energium-contacts-widget-field-text,
        
        .slide-sidebar-wrapper .widget_nav_menu ul li a, 
        .slide-sidebar-wrapper .widget_energium_nav_menu_widget ul li a,
        
        .energium-format-quote .post-quote,
        .energium-format-quote .post-quote:hover,
         
        .woocommerce div.product .woocommerce-tabs ul.tabs li.active,
        .woocommerce .shop_mode_grid .products ul li.product .product-buttons-wrapper a.button, 
        .woocommerce .shop_mode_grid .products ul li.product .product-buttons-wrapper a.added_to_cart, 
        .woocommerce .shop_mode_grid .woocommerce ul.products li.product .product-buttons-wrapper a.button, 
        .woocommerce .shop_mode_grid .woocommerce ul.products li.product .product-buttons-wrapper a.added_to_cart, 
        .woocommerce .shop_mode_grid ul.products li.product .product-buttons-wrapper a.button, 
        .woocommerce .shop_mode_grid ul.products li.product .product-buttons-wrapper a.added_to_cart, 
        .woocommerce-page .shop_mode_grid .products ul li.product .product-buttons-wrapper a.button, 
        .woocommerce-page .shop_mode_grid .products ul li.product .product-buttons-wrapper a.added_to_cart, 
        .woocommerce-page .shop_mode_grid .woocommerce ul.products li.product .product-buttons-wrapper a.button, 
        .woocommerce-page .shop_mode_grid .woocommerce ul.products li.product .product-buttons-wrapper a.added_to_cart, 
        .woocommerce-page .shop_mode_grid ul.products li.product .product-buttons-wrapper a.button, 
        .woocommerce-page .shop_mode_grid ul.products li.product .product-buttons-wrapper a.added_to_cart,
         
        .slide-sidebar-wrapper .widget_price_filter .price_slider_amount .price_label,
        .slide-sidebar-wrapper .wc-block-grid__products .wc-block-grid__product .wc-block-grid__product-link .wc-block-grid__product-title,
        .slide-sidebar-wrapper .widget div[class*="wp-block-"] .wc-block-review-list-item__item .wc-block-review-list-item__product a,
        .slide-sidebar-wrapper .widget div[class*="wp-block-"] .wc-block-review-list-item__item .wc-block-review-list-item__author,
        .slide-sidebar-wrapper ul.product_list_widget li a .product-title,
        .slide-sidebar-wrapper .widget_shopping_cart .cart_list li .content-woocommerce-wrapper h6 a,
        .slide-sidebar-wrapper .widget_layered_nav_filters ul .chosen a,
        .slide-sidebar-wrapper .widget_rating_filter ul li a,
        .slide-sidebar-wrapper .widget_rating_filter ul li.chosen a:after,
        .energium-price-item-widget .price-item.active .price-item-title,
        .energium-price-item-widget .price-item.active .price-item-container,
        .energium-price-item-widget .price-item.active .price-item-custom-fields .price-item-custom-field.active,
        .energium-price-item-widget .price-item.active .price-item-icon i,
        .energium-content-slider-widget .bottom-area,
        .energium-content-slider-widget .bottom-area .content-slider-video .elementor-custom-embed-play .eicon-play:before,
        .elementor-widget-video .elementor-custom-embed-play:before,
        .energium-video-button .elementor-custom-embed-play:before,
        
        .woocommerce-cart-form table.shop_table th,
        .woocommerce-cart-form table.shop_table td.actions .coupon .button,
        .woocommerce-account .woocommerce-MyAccount-navigation ul li.is-active a,
        .energium-content-slider-widget .slider-progress-wrapper .slider-progress-current, 
        .energium-content-slider-widget .slider-progress-wrapper .slider-progress-all,
        .energium-content-slider-widget .content-slider-socials-wrapper .content-slider-socials li a,
        .content-wrapper .woocommerce-product-gallery .flex-control-nav .slick-button,
        .block-editor-block-list__layout .woocommerce-product-gallery .flex-control-nav .slick-button,
        .energium-testimonial-carousel-widget .slider-progress-wrapper .slider-progress-current,
        .energium-testimonial-carousel-widget .slider-progress-wrapper .slider-progress-all {
            color: ' . esc_attr($contrast_dark_text_color) . ';
        }
        
        .slide-sidebar-wrapper .wp-block-social-links:not(.is-style-logos-only):not(.is-style-pill-shape):not(.has-icon-color) .wp-block-social-link svg,
        .energium-price-item-widget .price-item.active .price-item-icon svg {
            fill: ' . esc_attr($contrast_dark_text_color) . ';
        }
        
        .widget_media_audio .mejs-controls .mejs-horizontal-volume-slider .mejs-horizontal-volume-current, 
        .widget_media_audio .mejs-controls .mejs-time-rail .mejs-time-loaded,
        .mejs-audio .mejs-controls .mejs-horizontal-volume-slider .mejs-horizontal-volume-current, 
        .mejs-audio .mejs-controls .mejs-time-rail .mejs-time-loaded,
        .wp-video .mejs-controls .mejs-horizontal-volume-slider .mejs-horizontal-volume-current, 
        .wp-video .mejs-controls .mejs-time-rail .mejs-time-loaded,
        .wp-video .mejs-volume-current,
        .wp-video .mejs-volume-handle,
        .widget_media_audio .mejs-controls .mejs-horizontal-volume-slider .mejs-horizontal-volume-total, 
        .widget_media_audio .mejs-controls .mejs-time-rail .mejs-time-total,
        .mejs-audio .mejs-controls .mejs-horizontal-volume-slider .mejs-horizontal-volume-total, 
        .mejs-audio .mejs-controls .mejs-time-rail .mejs-time-total,
        .wp-video .mejs-controls .mejs-horizontal-volume-slider .mejs-horizontal-volume-total, 
        .wp-video .mejs-controls .mejs-time-rail .mejs-time-total,
        .wp-video .mejs-volume-total,
        
        .slide-sidebar-wrapper .wp-block-social-links:not(.is-style-logos-only):not(.is-style-pill-shape):not(.has-icon-background-color) .wp-block-social-link:hover,
        .slide-sidebar-wrapper .wrapper-socials a:hover {
            background-color: ' . esc_attr($contrast_dark_text_color) . ';
        }
         
        .slide-sidebar-wrapper .wp-block-social-links:not(.is-style-logos-only):not(.is-style-pill-shape):not(.has-icon-background-color) .wp-block-social-link:hover,
        .slide-sidebar-wrapper .wrapper-socials a:hover,
        .energium-content-slider-widget .bottom-area .owl-dots .owl-dot.active span,
        .energium-content-slider-widget .bottom-area .owl-dots .owl-dot span:after {
            border-color: ' . esc_attr($contrast_dark_text_color) . ';
        }
        .dropdown-trigger .dropdown-trigger-item.colors-dark svg .cls-1 {
            stroke: ' . esc_attr($contrast_dark_text_color) . ';
        }
    ';
}

$contrast_light_text_color = energium_get_prefered_option('contrast_light_text_color');
if ( !empty($contrast_light_text_color) ) {
    $energium_custom_css .= '
        .slide-sidebar-wrapper .widget_energium_featured_posts_widget .featured-posts-item-date,
        .slide-sidebar-wrapper .widget_recent_entries ul li .post-date,
        .slide-sidebar-wrapper .wp-block-latest-posts li .wp-block-latest-posts__post-date,
        .slide-sidebar-wrapper .widget_rss .rss-date,
        .slide-sidebar-wrapper .wp-block-rss .wp-block-rss__item-publish-date,
        .slide-sidebar-wrapper .wp-block-latest-comments li .wp-block-latest-comments__comment-meta,
        .content-wrapper .widget_calendar table tbody td, 
        .content-wrapper .wp-block-calendar table tbody td,
        .block-editor-block-list__layout .widget_calendar table tbody td, 
        .block-editor-block-list__layout .wp-block-calendar table tbody td,
         
        .slide-sidebar-wrapper .energium-form-field .select-wrap:after,
        .slide-sidebar-wrapper div.wpforms-container .wpforms-form .choices[data-type*="select-one"]:after,
        .slide-sidebar-wrapper .widget_energium_contacts_widget .energium-contacts-widget-field-label,
        .slide-sidebar-wrapper .wc-block-grid__products .wc-block-grid__product .wc-block-grid__product-price del,
        .slide-sidebar-wrapper .widget div[class*="wp-block-"] .wc-block-review-list-item__item .wc-block-review-list-item__published-date,
        .slide-sidebar-wrapper ul.product_list_widget li .price_wrapper del,
        .slide-sidebar-wrapper .widget_shopping_cart .cart_list li .content-woocommerce-wrapper .quantity,
        .energium-price-item-widget .price-item.active .price-item-custom-fields .price-item-custom-field,
        .energium-content-slider-widget .bottom-area .contacts .contact-item-title {
             color: ' . esc_attr($contrast_light_text_color) . ';
        }
        
        .slide-sidebar-wrapper input[type="text"]::-webkit-input-placeholder,
        .slide-sidebar-wrapper input[type="email"]::-webkit-input-placeholder,
        .slide-sidebar-wrapper input[type="url"]::-webkit-input-placeholder,
        .slide-sidebar-wrapper input[type="password"]::-webkit-input-placeholder,
        .slide-sidebar-wrapper input[type="search"]::-webkit-input-placeholder,
        .slide-sidebar-wrapper input[type="tel"]::-webkit-input-placeholder,
        .slide-sidebar-wrapper input[type="number"]::-webkit-input-placeholder, 
        .slide-sidebar-wrapper input[type="date"]::-webkit-input-placeholder, 
        .slide-sidebar-wrapper input[type="month"]::-webkit-input-placeholder, 
        .slide-sidebar-wrapper input[type="week"]::-webkit-input-placeholder, 
        .slide-sidebar-wrapper input[type="time"]::-webkit-input-placeholder, 
        .slide-sidebar-wrapper input[type="datetime"]::-webkit-input-placeholder, 
        .slide-sidebar-wrapper input[type="datetime-local"]::-webkit-input-placeholder, 
        .slide-sidebar-wrapper textarea::-webkit-input-placeholder,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form input[type="text"]::-webkit-input-placeholder,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form input[type="email"]::-webkit-input-placeholder,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form input[type="url"]::-webkit-input-placeholder,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form input[type="password"]::-webkit-input-placeholder,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form input[type="search"]::-webkit-input-placeholder,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form input[type="number"]::-webkit-input-placeholder,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form input[type="tel"]::-webkit-input-placeholder,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form input[type="date"]::-webkit-input-placeholder,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form input[type="month"]::-webkit-input-placeholder,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form input[type="week"]::-webkit-input-placeholder,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form input[type="time"]::-webkit-input-placeholder,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form input[type="datetime"]::-webkit-input-placeholder,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form input[type="datetime-local"]::-webkit-input-placeholder,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form textarea::-webkit-input-placeholder {
             color: ' . esc_attr($contrast_light_text_color) . ';
        }
        
        .slide-sidebar-wrapper input[type="text"]:-moz-placeholder,
        .slide-sidebar-wrapper input[type="url"]:-moz-placeholder,
        .slide-sidebar-wrapper input[type="email"]:-moz-placeholder,
        .slide-sidebar-wrapper input[type="password"]:-moz-placeholder,
        .slide-sidebar-wrapper input[type="search"]:-moz-placeholder,
        .slide-sidebar-wrapper input[type="tel"]:-moz-placeholder, 
        .slide-sidebar-wrapper input[type="number"]:-moz-placeholder, 
        .slide-sidebar-wrapper input[type="date"]:-moz-placeholder, 
        .slide-sidebar-wrapper input[type="month"]:-moz-placeholder, 
        .slide-sidebar-wrapper input[type="week"]:-moz-placeholder, 
        .slide-sidebar-wrapper input[type="time"]:-moz-placeholder, 
        .slide-sidebar-wrapper input[type="datetime"]:-moz-placeholder, 
        .slide-sidebar-wrapper input[type="datetime-local"]:-moz-placeholder, 
        .slide-sidebar-wrapper textarea:-moz-placeholder,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form input[type="text"]:-moz-placeholder,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form input[type="email"]:-moz-placeholder,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form input[type="url"]:-moz-placeholder,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form input[type="password"]:-moz-placeholder,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form input[type="search"]:-moz-placeholder,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form input[type="number"]:-moz-placeholder,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form input[type="tel"]:-moz-placeholder,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form input[type="date"]:-moz-placeholder,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form input[type="month"]:-moz-placeholder,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form input[type="week"]:-moz-placeholder,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form input[type="time"]:-moz-placeholder,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form input[type="datetime"]:-moz-placeholder,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form input[type="datetime-local"]:-moz-placeholder,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form textarea:-moz-placeholder {
             color: ' . esc_attr($contrast_light_text_color) . ';
        }
        
        .slide-sidebar-wrapper input[type="text"]::-moz-placeholder,
        .slide-sidebar-wrapper input[type="url"]::-moz-placeholder,
        .slide-sidebar-wrapper input[type="email"]::-moz-placeholder,
        .slide-sidebar-wrapper input[type="password"]::-moz-placeholder,
        .slide-sidebar-wrapper input[type="search"]::-moz-placeholder,
        .slide-sidebar-wrapper input[type="tel"]::-moz-placeholder, 
        .slide-sidebar-wrapper input[type="number"]::-moz-placeholder, 
        .slide-sidebar-wrapper input[type="date"]::-moz-placeholder, 
        .slide-sidebar-wrapper input[type="month"]::-moz-placeholder, 
        .slide-sidebar-wrapper input[type="week"]::-moz-placeholder, 
        .slide-sidebar-wrapper input[type="time"]::-moz-placeholder, 
        .slide-sidebar-wrapper input[type="datetime"]::-moz-placeholder, 
        .slide-sidebar-wrapper input[type="datetime-local"]::-moz-placeholder, 
        .slide-sidebar-wrapper textarea::-moz-placeholder,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form input[type="text"]::-moz-placeholder,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form input[type="email"]::-moz-placeholder,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form input[type="url"]::-moz-placeholder,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form input[type="password"]::-moz-placeholder,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form input[type="search"]::-moz-placeholder,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form input[type="number"]::-moz-placeholder,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form input[type="tel"]::-moz-placeholder,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form input[type="date"]::-moz-placeholder,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form input[type="month"]::-moz-placeholder,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form input[type="week"]::-moz-placeholder,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form input[type="time"]::-moz-placeholder,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form input[type="datetime"]::-moz-placeholder,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form input[type="datetime-local"]::-moz-placeholder,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form textarea::-moz-placeholder {
             color: ' . esc_attr($contrast_light_text_color) . ';
        }
        
        .slide-sidebar-wrapper input[type="text"]:-ms-input-placeholder,
        .slide-sidebar-wrapper input[type="email"]:-ms-input-placeholder,
        .slide-sidebar-wrapper input[type="url"]:-ms-input-placeholder,
        .slide-sidebar-wrapper input[type="password"]:-ms-input-placeholder,
        .slide-sidebar-wrapper input[type="search"]:-ms-input-placeholder,
        .slide-sidebar-wrapper input[type="tel"]:-ms-input-placeholder, 
        .slide-sidebar-wrapper input[type="number"]:-ms-input-placeholder, 
        .slide-sidebar-wrapper input[type="date"]:-ms-input-placeholder, 
        .slide-sidebar-wrapper input[type="month"]:-ms-input-placeholder, 
        .slide-sidebar-wrapper input[type="week"]:-ms-input-placeholder, 
        .slide-sidebar-wrapper input[type="time"]:-ms-input-placeholder, 
        .slide-sidebar-wrapper input[type="datetime"]:-ms-input-placeholder, 
        .slide-sidebar-wrapper input[type="datetime-local"]:-ms-input-placeholder, 
        .slide-sidebar-wrapper textarea:-ms-input-placeholder,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form input[type="text"]:-ms-input-placeholder,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form input[type="email"]:-ms-input-placeholder,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form input[type="url"]:-ms-input-placeholder,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form input[type="password"]:-ms-input-placeholder,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form input[type="search"]:-ms-input-placeholder,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form input[type="number"]:-ms-input-placeholder,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form input[type="tel"]:-ms-input-placeholder,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form input[type="date"]:-ms-input-placeholder,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form input[type="month"]:-ms-input-placeholder,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form input[type="week"]:-ms-input-placeholder,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form input[type="time"]:-ms-input-placeholder,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form input[type="datetime"]:-ms-input-placeholder,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form input[type="datetime-local"]:-ms-input-placeholder,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form textarea:-ms-input-placeholder {
            color: ' . esc_attr($contrast_light_text_color) . ';
        }
        .energium-content-slider-widget .content-item .energium-heading .energium-subheading {
            -webkit-text-stroke: 1px ' . esc_attr($contrast_light_text_color) . ';
        }
    ';
}

$contrast_accent_text_color = energium_get_prefered_option('contrast_accent_text_color');
if ( !empty($contrast_accent_text_color) ) {
    $energium_custom_css .= '
        .widget_media_audio .mejs-container .mejs-button > button:hover,
        .mejs-audio.mejs-container .mejs-button > button:hover,
        .wp-video .mejs-container .mejs-button > button:hover,
        .slide-sidebar-wrapper .widget_search .search-form .search-form-icon:hover,
        .slide-sidebar-wrapper .widget_categories ul > li:hover, 
        .slide-sidebar-wrapper .widget_categories ul li:hover > a, 
        .slide-sidebar-wrapper .widget_energium_featured_posts_widget .featured-posts-item-link:hover,
        .slide-sidebar-wrapper .widget_archive ul li:hover > a,
        .slide-sidebar-wrapper .widget_archive ul > li:hover,
        .slide-sidebar-wrapper .widget_pages .widget-wrapper > ul li > a:hover,
        .slide-sidebar-wrapper .wp-block-page-list li.wp-block-pages-list__item a:hover,
        .slide-sidebar-wrapper .widget_meta ul li:hover > a,
        .slide-sidebar-wrapper .widget_recent_entries ul li a:hover,
        .slide-sidebar-wrapper .wp-block-latest-posts li a:hover,
        .slide-sidebar-wrapper .widget_recent_comments ul .recentcomments a:hover,
        .slide-sidebar-wrapper .wp-block-latest-comments li a:hover,
        .slide-sidebar-wrapper .widget_rss ul a.rsswidget:hover,
        .slide-sidebar-wrapper .wp-block-rss .wp-block-rss__item-title a:hover,
        .slide-sidebar-wrapper .widget .widget-title a:hover,
        .energium-content-slider-widget .bottom-area .contacts .contact-item a:hover,
        .energium-content-slider-widget .bottom-area .contacts .contact-item:before,
        .slide-sidebar-wrapper .wp-block-loginout a:hover,
        .slide-sidebar-wrapper .wp-block-search.wp-block-search__button-inside .wp-block-search__inside-wrapper .wp-block-search__button.has-icon:not(.customize-partial-edit-shortcut-button):not(.components-button):not([class*="elementor"]):hover,
        .slide-sidebar-wrapper .wp-block-woocommerce-product-search .wc-block-product-search__fields .wc-block-product-search__button:not(.customize-partial-edit-shortcut-button):not(.components-button):not([class*="elementor"]):hover,
        .content-wrapper .widget_calendar .wp-calendar-nav a:hover,
        .content-wrapper .wp-block-calendar .wp-calendar-nav a:hover,
        .content-wrapper .widget_calendar table tbody td a:hover, 
        .content-wrapper .wp-block-calendar table tbody td a:hover,
        .block-editor-block-list__layout .widget_calendar .wp-calendar-nav a:hover,
        .block-editor-block-list__layout .wp-block-calendar .wp-calendar-nav a:hover,
        .block-editor-block-list__layout .widget_calendar table tbody td a:hover, 
        .block-editor-block-list__layout .wp-block-calendar table tbody td a:hover,
        .slide-sidebar-wrapper .widget_categories ul li a:hover,
        .slide-sidebar-wrapper ul.wp-block-categories li a:hover,
        .slide-sidebar-wrapper .widget_archive ul li > a:hover,
        .slide-sidebar-wrapper .wp-block-archives li > a:hover,
        .slide-sidebar-wrapper .slide-sidebar-close:hover,
        .slide-sidebar-wrapper .widget_energium_contacts_widget .energium-contacts-widget-map-link,
        .slide-sidebar-wrapper .widget_energium_contacts_widget .energium-contacts-widget-map-link a,
        .slide-sidebar-wrapper .widget_energium_contacts_widget .energium-contacts-widget-map-link a:hover,
        
        .slide-sidebar-wrapper .widget_nav_menu ul li a:hover, 
        .slide-sidebar-wrapper .widget_nav_menu ul li.current-menu-item > a:not([href *= "/#"]), 
        .slide-sidebar-wrapper .widget_nav_menu ul li.current-menu-ancestor > a, 
        .slide-sidebar-wrapper .widget_nav_menu ul li.current-menu-parent > a, 
        .slide-sidebar-wrapper .widget_energium_nav_menu_widget ul li a:hover, 
        .slide-sidebar-wrapper .widget_energium_nav_menu_widget ul li.current-menu-item > a:not([href *= "/#"]),
        .slide-sidebar-wrapper .widget_energium_nav_menu_widget ul li.current-menu-ancestor > a,
        .slide-sidebar-wrapper .widget_energium_nav_menu_widget ul li.current-menu-parent > a, 
        .slide-sidebar-wrapper .wc-block-grid__products .wc-block-grid__product .wc-block-grid__product-link:hover .wc-block-grid__product-title,
        .slide-sidebar-wrapper .wc-block-grid__products .wc-block-grid__product .wc-block-grid__product-price,
        .slide-sidebar-wrapper .widget div[class*="wp-block-"] .wc-block-review-list-item__item .wc-block-review-list-item__product a:hover,
        .slide-sidebar-wrapper ul.product_list_widget li a:hover .product-title,
        .slide-sidebar-wrapper ul.product_list_widget li .price_wrapper,
        .slide-sidebar-wrapper .widget_shopping_cart .cart_list li .content-woocommerce-wrapper h6 a:hover,
        .slide-sidebar-wrapper .widget_shopping_cart .cart_list li .content-woocommerce-wrapper .quantity .amount,
        .slide-sidebar-wrapper .widget_shopping_cart .total .amount,
        .energium-content-slider-widget .bottom-area .content-slider-video .elementor-custom-embed-play:hover .eicon-play:before,
        .service-listing-wrapper.owl-carousel .service-item-button .more-button,
        .energium-content-slider-widget .content-slider-socials-wrapper .content-slider-socials li a:hover {
            color: ' . esc_attr($contrast_accent_text_color) . ';
        }
        .widget_media_audio .mejs-controls .mejs-time-rail .mejs-time-current,
        .mejs-audio .mejs-controls .mejs-time-rail .mejs-time-current,
        .wp-video .mejs-controls .mejs-time-rail .mejs-time-current,
        .widget_media_audio .mejs-controls .mejs-time-rail .mejs-time-handle-content,
        .mejs-audio .mejs-controls .mejs-time-rail .mejs-time-handle-content,
        .wp-video .mejs-controls .mejs-time-rail .mejs-time-handle-content,
        .slide-sidebar-wrapper .widget_nav_menu ul li a:before, 
        .slide-sidebar-wrapper .widget_energium_nav_menu_widget ul li a:before,
        .slide-sidebar-wrapper .widget_recent_comments ul .recentcomments:hover:before,
        .slide-sidebar-wrapper .widget_price_filter .ui-slider .ui-slider-range {
            background-color: ' . esc_attr($contrast_accent_text_color) . ';
        }
        .widget_media_audio .mejs-controls .mejs-time-rail .mejs-time-handle-content,
        .mejs-audio .mejs-controls .mejs-time-rail .mejs-time-handle-content,
        .wp-video .mejs-controls .mejs-time-rail .mejs-time-handle-content,
         
        .slide-sidebar-wrapper ul > li:before, 
        .slide-sidebar-wrapper .widget_categories ul > li:before, 
        .slide-sidebar-wrapper ul.wp-block-categories > li:before,
        .slide-sidebar-wrapper .widget_archive ul li:before,
        .slide-sidebar-wrapper .wp-block-archives li:before,
        .slide-sidebar-wrapper .widget_recent_comments ul .recentcomments:before,
        .slide-sidebar-wrapper .wp-block-latest-comments li:before,
        .slide-sidebar-wrapper .widget_pages .widget-wrapper > ul > li:before,
        .slide-sidebar-wrapper .wp-block-page-list li.wp-block-pages-list__item:before,
        .slide-sidebar-wrapper .widget_meta ul li:before,
        .content-wrapper .widget_calendar table tbody td#today:before, 
        .content-wrapper .wp-block-calendar table tbody td#today:before,
        .block-editor-block-list__layout .widget_calendar table tbody td#today:before, 
        .block-editor-block-list__layout .wp-block-calendar table tbody td#today:before,
         
        .slide-sidebar-wrapper .wp-block-social-links:not(.is-style-logos-only):not(.is-style-pill-shape):not(.has-icon-background-color) .wp-block-social-link,
        .slide-sidebar-wrapper .wrapper-socials a,
        .slide-sidebar-wrapper .widget_price_filter .ui-slider .ui-slider-handle,
        .slide-sidebar-wrapper .widget_price_filter .ui-slider .ui-slider-handle:before {
            border-color: ' . esc_attr($contrast_accent_text_color) . ';
        }
        .widget_media_audio .mejs-controls .mejs-time-rail .mejs-time-hovered,
        .mejs-audio .mejs-controls .mejs-time-rail .mejs-time-hovered,
        .wp-video .mejs-controls .mejs-time-rail .mejs-time-hovered {
             background-color: rgba(' . esc_attr(energium_hex2rgb($contrast_accent_text_color)) . ', 0.4);
        }
        
        .slide-sidebar-wrapper input[type="range"]::-webkit-slider-thumb {
            border-color: ' . esc_attr($contrast_accent_text_color) . ';
        }
        .slide-sidebar-wrapper input[type="range"]::-moz-range-thumb {
            border-color: ' . esc_attr($contrast_accent_text_color) . ';
        }
        .slide-sidebar-wrapper input[type="range"]::-ms-thumb {
            border-color: ' . esc_attr($contrast_accent_text_color) . ';
        }
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form .wpforms-field-number-slider input[type="range"]::-webkit-slider-thumb {
            border-color: ' . esc_attr($contrast_accent_text_color) . ';
        }
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form .wpforms-field-number-slider input[type="range"]::-moz-range-thumb {
            border-color: ' . esc_attr($contrast_accent_text_color) . ';
        }
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form .wpforms-field-number-slider input[type="range"]::-ms-thumb {
            border-color: ' . esc_attr($contrast_accent_text_color) . ';
        }
    ';
}

$contrast_hover_text_color = energium_get_prefered_option('contrast_hover_text_color');
if ( !empty($contrast_hover_text_color) ) {
    $energium_custom_css .= '
        .header .main-menu ul.sub-menu > li > a:hover,
        .header .main-menu ul.sub-menu > li.current-menu-ancestor > a,
        .header .main-menu ul.sub-menu > li.current-menu-parent > a,
        .header .main-menu ul.sub-menu > li.current-menu-item > a:not([href *= "/#"]),
        .energium-price-item-widget .price-item.active .price-item-custom-fields .price-item-custom-field:before,
        .service-listing-wrapper.owl-carousel .service-item-button .more-button:hover {
            color: ' . esc_attr($contrast_hover_text_color) . ';
        }
        .header .main-menu > li ul.sub-menu > li.menu-item-has-children > a:after,
        .energium-content-slider-widget .slider-progress-wrapper .slider-progress-track .progress,
        .energium-testimonial-carousel-widget .slider-progress-wrapper .progress {
            background-color: ' . esc_attr($contrast_hover_text_color) . ';
        }
        .dropdown-trigger .dropdown-trigger-item.colors-dark svg .cls-2 {
            stroke: ' . esc_attr($contrast_hover_text_color) . ';
        }
    ';
}

$contrast_border_color = energium_get_prefered_option('contrast_border_color');
if ( !empty($contrast_border_color) ) {
    $energium_custom_css .= '
        .slide-sidebar-wrapper div.wpforms-container-full .wpforms-form .energium-form-field .energium-form-field-border-bottom, 
        .slide-sidebar-wrapper form .energium-form-field .energium-form-field-border-bottom,
        .slide-sidebar-wrapper div.wpforms-container-full .wpforms-form .wpforms-field input[type="radio"], 
        .slide-sidebar-wrapper div.wpforms-container-full .wpforms-form .wpforms-field input[type="checkbox"], 
        .slide-sidebar-wrapper form input[type="radio"],
        .slide-sidebar-wrapper form input[type="checkbox"],
        .slide-sidebar-wrapper .wc-block-grid__products .wc-block-grid__product .wc-block-grid__product-image,
        .slide-sidebar-wrapper .widget div[class*="wp-block-"] .wc-block-review-list-item__item,
        .slide-sidebar-wrapper .widget div[class*="wp-block-"] .wc-block-review-list-item__item .wc-block-review-list-item__image,
        .slide-sidebar-wrapper ul.product_list_widget li img,
        .slide-sidebar-wrapper .wc-block-product-categories.is-list .wc-block-product-categories-list--has-images .wc-block-product-categories-list-item .wc-block-product-categories-list-item__image,
        .slide-sidebar-wrapper .widget_shopping_cart .cart_list li,
        .slide-sidebar-wrapper .widget_shopping_cart .total,
        .slide-sidebar-wrapper .widget_rating_filter ul li a:before {
             border-color: ' . esc_attr($contrast_border_color) . ';
        }
        
        .slide-sidebar-wrapper div.wpforms-container-full .wpforms-form .energium-form-field .energium-form-field-border-bottom:before, 
        .slide-sidebar-wrapper div.wpforms-container-full .wpforms-form .energium-form-field .energium-form-field-border-bottom:after, 
        .slide-sidebar-wrapper div.wpforms-container-full .wpforms-form .energium-form-field .energium-form-field-border-top:before, 
        .slide-sidebar-wrapper div.wpforms-container-full .wpforms-form .energium-form-field .energium-form-field-border-angle:before, 
        .slide-sidebar-wrapper form .energium-form-field .energium-form-field-border-bottom:before, 
        .slide-sidebar-wrapper form .energium-form-field .energium-form-field-border-bottom:after, 
        .slide-sidebar-wrapper form .energium-form-field .energium-form-field-border-top:before, 
        .slide-sidebar-wrapper form .energium-form-field .energium-form-field-border-angle:before,
        .slide-sidebar-wrapper div.wpforms-container-full .wpforms-form .wpforms-field.wpforms-field-number-slider input[type="range"], 
        .slide-sidebar-wrapper form input[type="range"],
        .slide-sidebar-wrapper .widget_price_filter .price_slider_wrapper .ui-widget-content,
        .energium-content-slider-widget .slider-progress-wrapper .slider-progress-track {
            background-color: ' . esc_attr($contrast_border_color) . ';
        }
    ';
}

$contrast_border_hover_color = energium_get_prefered_option('contrast_border_hover_color');
if ( !empty($contrast_border_hover_color) ) {
    $energium_custom_css .= '
        .slide-sidebar-wrapper .widget_media_audio .mejs-container, 
        .slide-sidebar-wrapper .widget_media_audio .mejs-container .mejs-controls, 
        .slide-sidebar-wrapper .widget_media_audio .mejs-embed, 
        .slide-sidebar-wrapper .widget_media_audio .mejs-embed body,
        .slide-sidebar-wrapper .wp-video .mejs-container, 
        .slide-sidebar-wrapper .wp-video .mejs-container .mejs-controls, 
        .slide-sidebar-wrapper .wp-video .mejs-embed, 
        .slide-sidebar-wrapper .wp-video .mejs-embed body,
        .slide-sidebar-wrapper .mejs-volume-button > .mejs-volume-slider,
        .energium-testimonial-carousel-widget .slider-progress-wrapper .slider-progress-track {
            background-color: ' . esc_attr($contrast_border_hover_color) . ';
        }
    ';
}

$contrast_background_color = energium_get_prefered_option('contrast_background_color');
if ( !empty($contrast_background_color) ) {
    $energium_custom_css .= '
        .header .main-menu > li ul.sub-menu,
        .content-wrapper .widget_media_audio .mejs-container, 
        .content-wrapper .widget_media_audio .mejs-container .mejs-controls, 
        .content-wrapper .widget_media_audio .mejs-embed, 
        .content-wrapper .widget_media_audio .mejs-embed body,
        .content-wrapper .mejs-audio.mejs-container, 
        .content-wrapper .mejs-audio.mejs-container .mejs-controls, 
        .content-wrapper .mejs-audio .mejs-embed, 
        .content-wrapper .mejs-audio .mejs-embed body,
        .content-wrapper .wp-video .mejs-container, 
        .content-wrapper .wp-video .mejs-container .mejs-controls, 
        .content-wrapper .wp-video .mejs-embed, 
        .content-wrapper .wp-video .mejs-embed body,
        .content-wrapper .mejs-volume-button > .mejs-volume-slider,
        .block-editor-block-list__layout .widget_media_audio .mejs-container, 
        .block-editor-block-list__layout .widget_media_audio .mejs-container .mejs-controls, 
        .block-editor-block-list__layout .widget_media_audio .mejs-embed, 
        .block-editor-block-list__layout .widget_media_audio .mejs-embed body,
        .block-editor-block-list__layout .mejs-audio.mejs-container, 
        .block-editor-block-list__layout .mejs-audio.mejs-container .mejs-controls, 
        .block-editor-block-list__layout .mejs-audio .mejs-embed, 
        .block-editor-block-list__layout .mejs-audio .mejs-embed body,
        .block-editor-block-list__layout .wp-video .mejs-container, 
        .block-editor-block-list__layout .wp-video .mejs-container .mejs-controls, 
        .block-editor-block-list__layout .wp-video .mejs-embed, 
        .block-editor-block-list__layout .wp-video .mejs-embed body,
        .block-editor-block-list__layout .mejs-volume-button > .mejs-volume-slider,
        .slide-sidebar-wrapper,
        .energium-content-slider-widget .bottom-area .content-slider-video,
         
        .content-wrapper .widget_calendar .calendar_wrap,
        .content-wrapper .wp-block-calendar,
        .block-editor-block-list__layout .widget_calendar .calendar_wrap,
        .block-editor-block-list__layout .wp-block-calendar,
        .energium-content-slider-widget .bottom-area .content-slider-contacts,
        .woocommerce div.product .woocommerce-tabs ul.tabs li.active,
         
        .woocommerce .shop_mode_grid .products ul li.product .product-buttons-wrapper a.button, 
        .woocommerce .shop_mode_grid .products ul li.product .product-buttons-wrapper a.added_to_cart, 
        .woocommerce .shop_mode_grid .woocommerce ul.products li.product .product-buttons-wrapper a.button, 
        .woocommerce .shop_mode_grid .woocommerce ul.products li.product .product-buttons-wrapper a.added_to_cart, 
        .woocommerce .shop_mode_grid ul.products li.product .product-buttons-wrapper a.button, 
        .woocommerce .shop_mode_grid ul.products li.product .product-buttons-wrapper a.added_to_cart, 
        .woocommerce-page .shop_mode_grid .products ul li.product .product-buttons-wrapper a.button, 
        .woocommerce-page .shop_mode_grid .products ul li.product .product-buttons-wrapper a.added_to_cart, 
        .woocommerce-page .shop_mode_grid .woocommerce ul.products li.product .product-buttons-wrapper a.button, 
        .woocommerce-page .shop_mode_grid .woocommerce ul.products li.product .product-buttons-wrapper a.added_to_cart, 
        .woocommerce-page .shop_mode_grid ul.products li.product .product-buttons-wrapper a.button, 
        .woocommerce-page .shop_mode_grid ul.products li.product .product-buttons-wrapper a.added_to_cart,
        .slide-sidebar-wrapper .widget_price_filter .ui-slider .ui-slider-handle,
        .energium-price-item-widget .price-item.active,
        .energium-content-slider-widget .bottom-area,
        .elementor-widget-video .elementor-custom-embed-play,
        .energium-video-button .elementor-custom-embed-play,
         
        .woocommerce-cart-form table.shop_table th,
        .woocommerce-cart-form table.shop_table td.actions .coupon .button:before,
        .woocommerce-account .woocommerce-MyAccount-navigation ul li.is-active,
        .energium-content-slider-widget .aside-area,
        .energium-content-slider-widget .content-slider-socials-wrapper,
        .energium-content-slider-widget .content-slider-socials-wrapper .socials-trigger,
        .energium-content-slider-widget .content-slider-socials-wrapper .content-slider-socials,
        .woocommerce-product-gallery .flex-control-nav .slick-button,
        .dropdown-trigger .dropdown-trigger-item.colors-dark {
            background-color: ' . esc_attr($contrast_background_color) . ';
        }
        
        .woocommerce div.product .woocommerce-tabs ul.tabs li.active,
        .woocommerce-cart-form table.shop_table td.actions .coupon .button,
        .woocommerce-account .woocommerce-MyAccount-navigation ul li,
        .dropdown-trigger .dropdown-trigger-item.colors-dark.separated {
            border-color: ' . esc_attr($contrast_background_color) . ' !important;
        }
        
        .slide-sidebar-wrapper .wp-block-social-links:not(.is-style-logos-only):not(.is-style-pill-shape):not(.has-icon-color) .wp-block-social-link:hover svg,
        .slide-sidebar-wrapper .wrapper-socials a:hover,
        .service-listing-wrapper.owl-carousel .service-item-media .service-item-index {
            color: ' . esc_attr($contrast_background_color) . ';
        }
         
        .slide-sidebar-wrapper .wp-block-social-links:not(.is-style-logos-only):not(.is-style-pill-shape):not(.has-icon-color) .wp-block-social-link:hover svg {
            fill: ' . esc_attr($contrast_background_color) . ';
        }
        
        
        .slide-sidebar-wrapper input[type="range"]::-webkit-slider-thumb {
            background-color: ' . esc_attr($contrast_background_color) . ';
        }
        .slide-sidebar-wrapper input[type="range"]::-moz-range-thumb {
            background-color: ' . esc_attr($contrast_background_color) . ';
        }
        .slide-sidebar-wrapper input[type="range"]::-ms-thumb {
            background-color: ' . esc_attr($contrast_background_color) . ';
        }
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form .wpforms-field-number-slider input[type="range"]::-webkit-slider-thumb {
            background-color: ' . esc_attr($contrast_background_color) . ';
        }
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form .wpforms-field-number-slider input[type="range"]::-moz-range-thumb {
             background-color: ' . esc_attr($contrast_background_color) . ';
        }
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form .wpforms-field-number-slider input[type="range"]::-ms-thumb {
             background-color: ' . esc_attr($contrast_background_color) . ';
        }
    ';
}

$contrast_background_alter_color = energium_get_prefered_option('contrast_background_alter_color');
if ( !empty($contrast_background_alter_color) ) {
    $energium_custom_css .= '
        .slide-sidebar-wrapper .widget_product_tag_cloud .tagcloud .tag-cloud-link,
        .slide-sidebar-wrapper .widget_tag_cloud .tagcloud .tag-cloud-link,
        .slide-sidebar-wrapper .wp-block-tag-cloud .tag-cloud-link,
        .slide-sidebar-wrapper .widget_layered_nav_filters ul .chosen a {
            background-color: ' . esc_attr($contrast_background_alter_color) . ';
        }
    ';
}

$contrast_button_text_color = energium_get_prefered_option('contrast_button_text_color');
if ( !empty($contrast_button_text_color) ) {
    $energium_custom_css .= '
        .slide-sidebar-wrapper .wp-block-gallery .blocks-gallery-grid .blocks-gallery-item a:after, 
        .slide-sidebar-wrapper .media_gallery .blocks-gallery-grid .blocks-gallery-item a:after,
        .slide-sidebar-wrapper .gallery .gallery-item .gallery-icon a:after,
        .slide-sidebar-wrapper .wp-block-button:not(.is-style-outline) .wp-block-button__link:not(.has-text-color),
        .wp-block-cover .wp-block-button:not(.is-style-outline) .wp-block-button__link:not(.has-text-color),
         
        .content-wrapper .wc-block-featured-product .wp-block-button .wp-block-button__link:not(.has-text-color),
        .block-editor-block-list__layout .wc-block-featured-product .wp-block-button .wp-block-button__link:not(.has-text-color),
        .footer-widgets .wc-block-featured-product .wp-block-button .wp-block-button__link:not(.has-text-color),
        .slide-sidebar-wrapper .wc-block-featured-product .wp-block-button .wp-block-button__link:not(.has-text-color),
        .content-wrapper .wc-block-featured-category .wp-block-button .wp-block-button__link:not(.has-text-color),
        .block-editor-block-list__layout .wc-block-featured-category .wp-block-button .wp-block-button__link:not(.has-text-color),
        .footer-widgets .wc-block-featured-category .wp-block-button .wp-block-button__link:not(.has-text-color),
        .slide-sidebar-wrapper .wc-block-featured-category .wp-block-button .wp-block-button__link:not(.has-text-color),
        .slide-sidebar-wrapper .wp-block-button.wc-block-load-more .wp-block-button__link,
        .slide-sidebar-wrapper .wc-block-grid__products .wc-block-grid__product .wc-block-grid__product-info .wp-block-button .wp-block-button__link,
        .slide-sidebar-wrapper .wc-block-grid__products .wc-block-grid__product .wc-block-grid__product-info .wp-block-button .added_to_cart,
        .slide-sidebar-wrapper #form-preview button,
        .slide-sidebar-wrapper .energium-button,
        .body-container .slide-sidebar-wrapper button:not(.customize-partial-edit-shortcut-button):not([class*="elementor"]),
        .body-container .slide-sidebar-wrapper input[type="submit"],
        .body-container .slide-sidebar-wrapper input[type="button"],
        .body-container .slide-sidebar-wrapper input[type="reset"],
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form input[type=submit],
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form button[type=submit],
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form .wpforms-page-button,
        .slide-sidebar-wrapper .woocommerce a.button,
        .slide-sidebar-wrapper .woocommerce a.button.alt,
        .slide-sidebar-wrapper .woocommerce button.button,
        .slide-sidebar-wrapper .woocommerce button.button.alt,
        .slide-sidebar-wrapper .woocommerce input.button,
        .slide-sidebar-wrapper .woocommerce #respond input#submit,
        .slide-sidebar-wrapper .woocommerce a.added_to_cart,
        .slide-sidebar-wrapper .woocommerce #respond input#submit.disabled,
        .slide-sidebar-wrapper .woocommerce #respond input#submit:disabled,
        .slide-sidebar-wrapper .woocommerce #respond input#submit:disabled[disabled],
        .slide-sidebar-wrapper .woocommerce a.button.disabled,
        .slide-sidebar-wrapper .woocommerce a.button:disabled,
        .slide-sidebar-wrapper .woocommerce a.button:disabled[disabled],
        .slide-sidebar-wrapper .woocommerce button.button.disabled,
        .slide-sidebar-wrapper .woocommerce button.button:disabled,
        .slide-sidebar-wrapper .woocommerce button.button:disabled[disabled],
        .slide-sidebar-wrapper .woocommerce input.button.disabled,
        .slide-sidebar-wrapper .woocommerce input.button:disabled,
        .slide-sidebar-wrapper .woocommerce input.button:disabled[disabled],
        
        .slide-sidebar-wrapper .wp-block-button:not(.is-style-fill) .wp-block-button__link:not(.has-text-color),
        .sidebar .wp-block-cover .wp-block-button:not(.is-style-fill) .wp-block-button__link:not(.has-text-color),
        .energium-price-item-widget .price-item.active .price-item-button-container .energium-button {
            color: ' . esc_attr($contrast_button_text_color) . ';
        }
    ';
}

$contrast_button_border_color = energium_get_prefered_option('contrast_button_border_color');
if ( !empty($contrast_button_border_color) ) {
    $energium_custom_css .= '
        .widget_energium_banner_widget .banner-widget-wrapper.banner-contrast-colors {
            background-color: ' . esc_attr($contrast_button_border_color) . ';
        }
        .content-wrapper .wc-block-featured-product .wp-block-button .wp-block-button__link:not(.has-background),
        .block-editor-block-list__layout .wc-block-featured-product .wp-block-button .wp-block-button__link:not(.has-background),
        .footer-widgets .wc-block-featured-product .wp-block-button .wp-block-button__link:not(.has-background),
        .slide-sidebar-wrapper .wc-block-featured-product .wp-block-button .wp-block-button__link:not(.has-background),
        .content-wrapper .wc-block-featured-category .wp-block-button .wp-block-button__link:not(.has-background),
        .block-editor-block-list__layout .wc-block-featured-category .wp-block-button .wp-block-button__link:not(.has-background),
        .footer-widgets .wc-block-featured-category .wp-block-button .wp-block-button__link:not(.has-background),
        .slide-sidebar-wrapper .wc-block-featured-category .wp-block-button .wp-block-button__link:not(.has-background),
        .slide-sidebar-wrapper .wp-block-button.wc-block-load-more .wp-block-button__link,
        .slide-sidebar-wrapper .wc-block-grid__products .wc-block-grid__product .wc-block-grid__product-info .wp-block-button .wp-block-button__link,
        .slide-sidebar-wrapper .wc-block-grid__products .wc-block-grid__product .wc-block-grid__product-info .wp-block-button .added_to_cart,
        .slide-sidebar-wrapper #form-preview button,
        .slide-sidebar-wrapper .energium-button,
        .body-container .slide-sidebar-wrapper button:not(.customize-partial-edit-shortcut-button):not([class*="elementor"]),
        .body-container .slide-sidebar-wrapper input[type="submit"],
        .body-container .slide-sidebar-wrapper input[type="button"],
        .body-container .slide-sidebar-wrapper input[type="reset"],
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form input[type=submit],
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form button[type=submit],
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form .wpforms-page-button,
        .slide-sidebar-wrapper .woocommerce a.button,
        .slide-sidebar-wrapper .woocommerce a.button.alt,
        .slide-sidebar-wrapper .woocommerce button.button,
        .slide-sidebar-wrapper .woocommerce button.button.alt,
        .slide-sidebar-wrapper .woocommerce input.button,
        .slide-sidebar-wrapper .woocommerce #respond input#submit,
        .slide-sidebar-wrapper .woocommerce a.added_to_cart,
        .slide-sidebar-wrapper .woocommerce #respond input#submit.disabled,
        .slide-sidebar-wrapper .woocommerce #respond input#submit:disabled,
        .slide-sidebar-wrapper .woocommerce #respond input#submit:disabled[disabled],
        .slide-sidebar-wrapper .woocommerce a.button.disabled,
        .slide-sidebar-wrapper .woocommerce a.button:disabled,
        .slide-sidebar-wrapper .woocommerce a.button:disabled[disabled],
        .slide-sidebar-wrapper .woocommerce button.button.disabled,
        .slide-sidebar-wrapper .woocommerce button.button:disabled,
        .slide-sidebar-wrapper .woocommerce button.button:disabled[disabled],
        .slide-sidebar-wrapper .woocommerce input.button.disabled,
        .slide-sidebar-wrapper .woocommerce input.button:disabled,
        .slide-sidebar-wrapper .woocommerce input.button:disabled[disabled],
         
        .slide-sidebar-wrapper .wp-block-button:not(.is-style-fill) .wp-block-button__link:not(.has-text-color), 
        .sidebar .wp-block-cover .wp-block-button:not(.is-style-fill) .wp-block-button__link:not(.has-text-color),
        .energium-price-item-widget .price-item.active .price-item-button-container .energium-button {
            border-color: ' . esc_attr($contrast_button_border_color) . ';
        }
        .slide-sidebar-wrapper .wp-block-gallery .blocks-gallery-grid .blocks-gallery-item a:before, 
        .slide-sidebar-wrapper .media_gallery .blocks-gallery-grid .blocks-gallery-item a:before,
        .slide-sidebar-wrapper .gallery .gallery-item .gallery-icon a:before,
        .widget_instagram-feed-widget #sb_instagram #sbi_images .sbi_photo:before, 
        .widget_instagram-feed-widget#sb_instagram #sbi_images .sbi_photo:before, 
        .widget #sb_instagram #sbi_images .sbi_photo:before, 
        .widget#sb_instagram #sbi_images .sbi_photo:before {
             background-color: ' . esc_attr($contrast_button_border_color) . ';
        }
    ';
}

$contrast_button_background_color = energium_get_prefered_option('contrast_button_background_color');
if ( !empty($contrast_button_background_color) ) {
    $energium_custom_css .= '
        .energium-price-item-widget .price-item.active .price-item-button-container .energium-button:before {
            background-color: ' . esc_attr($contrast_button_background_color) . ';
        }
    ';
}

$contrast_button_text_hover = energium_get_prefered_option('contrast_button_text_hover');
if ( !empty($contrast_button_text_hover) ) {
    $energium_custom_css .= '
        .content-wrapper .wc-block-featured-product .wp-block-button .wp-block-button__link:not(.has-text-color):hover,
        .block-editor-block-list__layout .wc-block-featured-product .wp-block-button .wp-block-button__link:not(.has-text-color):hover,
        .footer-widgets .wc-block-featured-product .wp-block-button .wp-block-button__link:not(.has-text-color):hover,
        .slide-sidebar-wrapper .wc-block-featured-product .wp-block-button .wp-block-button__link:not(.has-text-color):hover,
        .content-wrapper .wc-block-featured-category .wp-block-button .wp-block-button__link:not(.has-text-color):hover,
        .block-editor-block-list__layout .wc-block-featured-category .wp-block-button .wp-block-button__link:not(.has-text-color):hover,
        .footer-widgets .wc-block-featured-category .wp-block-button .wp-block-button__link:not(.has-text-color):hover,
        .slide-sidebar-wrapper .wc-block-featured-category .wp-block-button .wp-block-button__link:not(.has-text-color):hover,
        .slide-sidebar-wrapper .wp-block-button.wc-block-load-more .wp-block-button__link:hover,
        .slide-sidebar-wrapper .wc-block-grid__products .wc-block-grid__product .wc-block-grid__product-info .wp-block-button .wp-block-button__link:hover,
        .slide-sidebar-wrapper .wc-block-grid__products .wc-block-grid__product .wc-block-grid__product-info .wp-block-button .added_to_cart:hover,
        .slide-sidebar-wrapper #form-preview button:hover,
        .slide-sidebar-wrapper .energium-button:hover,
        .body-container .slide-sidebar-wrapper button:not(.customize-partial-edit-shortcut-button):not([class*="elementor"]):hover,
        .body-container .slide-sidebar-wrapper input[type="submit"]:hover,
        .body-container .slide-sidebar-wrapper input[type="button"]:hover,
        .body-container .slide-sidebar-wrapper input[type="reset"]:hover,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form input[type=submit]:hover,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form button[type=submit]:hover,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form .wpforms-page-button:hover,
        .slide-sidebar-wrapper .woocommerce a.button:hover,
        .slide-sidebar-wrapper .woocommerce a.button.alt:hover,
        .slide-sidebar-wrapper .woocommerce button.button:hover,
        .slide-sidebar-wrapper .woocommerce button.button.alt:hover,
        .slide-sidebar-wrapper .woocommerce input.button:hover,
        .slide-sidebar-wrapper .woocommerce #respond input#submit:hover,
        .slide-sidebar-wrapper .woocommerce a.added_to_cart:hover,
        .slide-sidebar-wrapper .woocommerce #respond input#submit:not(.disabled):hover,
        .slide-sidebar-wrapper .woocommerce #respond input#submit:not(:disabled):hover,
        .slide-sidebar-wrapper .woocommerce a.button:not(.disabled):hover,
        .slide-sidebar-wrapper .woocommerce a.button:not(:disabled):hover,
        .slide-sidebar-wrapper .woocommerce button.button:not(.disabled):hover,
        .slide-sidebar-wrapper .woocommerce button.button:not(:disabled):hover,
        .slide-sidebar-wrapper .woocommerce input.button:not(.disabled):hover,
        .slide-sidebar-wrapper .woocommerce input.button:not(:disabled):hover,
        
        .slide-sidebar-wrapper .widget_product_tag_cloud .tagcloud .tag-cloud-link:hover,
        .slide-sidebar-wrapper .widget_tag_cloud .tagcloud .tag-cloud-link:hover,
        .slide-sidebar-wrapper .wp-block-tag-cloud .tag-cloud-link:hover,
         
        .slide-sidebar-wrapper .wp-block-button:not(.is-style-fill) .wp-block-button__link:not(.has-text-color):hover, 
        .sidebar .wp-block-cover .wp-block-button:not(.is-style-fill) .wp-block-button__link:not(.has-text-color):hover,
         
        .slide-sidebar-wrapper #sb_instagram .sbi_item .sbi_photo:after,
        .slide-sidebar-wrapper .wp-block-gallery .blocks-gallery-grid .blocks-gallery-item a:after, 
        .slide-sidebar-wrapper .media_gallery .blocks-gallery-grid .blocks-gallery-item a:after,
        .slide-sidebar-wrapper .gallery .gallery-item .gallery-icon a:after,
        .slide-sidebar-wrapper .widget_media_gallery .gallery .gallery-icon a:after,
        .slide-sidebar-wrapper .widget .wp-block-image a:after,
         
        .woocommerce .shop_mode_grid .products ul li.product .product-buttons-wrapper a.button:hover, 
        .woocommerce .shop_mode_grid .products ul li.product .product-buttons-wrapper a.added_to_cart:hover, 
        .woocommerce .shop_mode_grid .woocommerce ul.products li.product .product-buttons-wrapper a.button:hover, 
        .woocommerce .shop_mode_grid .woocommerce ul.products li.product .product-buttons-wrapper a.added_to_cart:hover, 
        .woocommerce .shop_mode_grid ul.products li.product .product-buttons-wrapper a.button:hover, 
        .woocommerce .shop_mode_grid ul.products li.product .product-buttons-wrapper a.added_to_cart:hover, 
        .woocommerce-page .shop_mode_grid .products ul li.product .product-buttons-wrapper a.button:hover, 
        .woocommerce-page .shop_mode_grid .products ul li.product .product-buttons-wrapper a.added_to_cart:hover, 
        .woocommerce-page .shop_mode_grid .woocommerce ul.products li.product .product-buttons-wrapper a.button:hover, 
        .woocommerce-page .shop_mode_grid .woocommerce ul.products li.product .product-buttons-wrapper a.added_to_cart:hover, 
        .woocommerce-page .shop_mode_grid ul.products li.product .product-buttons-wrapper a.button:hover, 
        .woocommerce-page .shop_mode_grid ul.products li.product .product-buttons-wrapper a.added_to_cart:hover,
        .slide-sidebar-wrapper .widget_layered_nav_filters ul .chosen a:hover,
        .energium-price-item-widget .price-item.active .price-item-button-container .energium-button:hover,
        .elementor-widget-video .elementor-custom-embed-play:hover:before,
        .energium-video-button .elementor-custom-embed-play:hover:before {
            color: ' . esc_attr($contrast_button_text_hover) . ';
        }
    ';
}

$contrast_button_border_hover = energium_get_prefered_option('contrast_button_border_hover');
if ( !empty($contrast_button_border_hover) ) {
    $energium_custom_css .= '
        .content-wrapper .wc-block-featured-product .wp-block-button .wp-block-button__link:not(.has-background):hover,
        .block-editor-block-list__layout .wc-block-featured-product .wp-block-button .wp-block-button__link:not(.has-background):hover,
        .footer-widgets .wc-block-featured-product .wp-block-button .wp-block-button__link:not(.has-background):hover,
        .slide-sidebar-wrapper .wc-block-featured-product .wp-block-button .wp-block-button__link:not(.has-background):hover,
        .content-wrapper .wc-block-featured-category .wp-block-button .wp-block-button__link:not(.has-background):hover,
        .block-editor-block-list__layout .wc-block-featured-category .wp-block-button .wp-block-button__link:not(.has-background):hover,
        .footer-widgets .wc-block-featured-category .wp-block-button .wp-block-button__link:not(.has-background):hover,
        .slide-sidebar-wrapper .wc-block-featured-category .wp-block-button .wp-block-button__link:not(.has-background):hover,
        .slide-sidebar-wrapper .wp-block-button.wc-block-load-more .wp-block-button__link:hover,
        .slide-sidebar-wrapper .wc-block-grid__products .wc-block-grid__product .wc-block-grid__product-info .wp-block-button .wp-block-button__link:hover,
        .slide-sidebar-wrapper .wc-block-grid__products .wc-block-grid__product .wc-block-grid__product-info .wp-block-button .added_to_cart:hover,
        .slide-sidebar-wrapper #form-preview button:hover,
        .slide-sidebar-wrapper .energium-button:hover,
        .body-container .slide-sidebar-wrapper button:not(.customize-partial-edit-shortcut-button):not([class*="elementor"]):hover,
        .body-container .slide-sidebar-wrapper input[type="submit"]:hover,
        .body-container .slide-sidebar-wrapper input[type="button"]:hover,
        .body-container .slide-sidebar-wrapper input[type="reset"]:hover,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form input[type=submit]:hover,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form button[type=submit]:hover,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form .wpforms-page-button:hover,
        .slide-sidebar-wrapper .woocommerce a.button:hover,
        .slide-sidebar-wrapper .woocommerce a.button.alt:hover,
        .slide-sidebar-wrapper .woocommerce button.button:hover,
        .slide-sidebar-wrapper .woocommerce button.button.alt:hover,
        .slide-sidebar-wrapper .woocommerce input.button:hover,
        .slide-sidebar-wrapper .woocommerce #respond input#submit:hover,
        .slide-sidebar-wrapper .woocommerce a.added_to_cart:hover,
        .slide-sidebar-wrapper .woocommerce #respond input#submit:not(.disabled):hover,
        .slide-sidebar-wrapper .woocommerce #respond input#submit:not(:disabled):hover,
        .slide-sidebar-wrapper .woocommerce a.button:not(.disabled):hover,
        .slide-sidebar-wrapper .woocommerce a.button:not(:disabled):hover,
        .slide-sidebar-wrapper .woocommerce button.button:not(.disabled):hover,
        .slide-sidebar-wrapper .woocommerce button.button:not(:disabled):hover,
        .slide-sidebar-wrapper .woocommerce input.button:not(.disabled):hover,
        .slide-sidebar-wrapper .woocommerce input.button:not(:disabled):hover,
        
        .slide-sidebar-wrapper .wp-block-button:not(.is-style-fill) .wp-block-button__link:not(.has-text-color):hover,
        .sidebar .wp-block-cover .wp-block-button:not(.is-style-fill) .wp-block-button__link:not(.has-text-color):hover,
        .energium-price-item-widget .price-item.active .price-item-button-container .energium-button:hover {
            border-color: ' . esc_attr($contrast_button_border_hover) . ';
        }
    ';
}

$contrast_button_background_hover = energium_get_prefered_option('contrast_button_background_hover');
if ( !empty($contrast_button_background_hover) ) {
    $energium_custom_css .= '
        .content-wrapper .wc-block-featured-product .wp-block-button .wp-block-button__link:not(.has-background):after,
        .block-editor-block-list__layout .wc-block-featured-product .wp-block-button .wp-block-button__link:not(.has-background):after,
        .footer-widgets .wc-block-featured-product .wp-block-button .wp-block-button__link:not(.has-background):after,
        .slide-sidebar-wrapper .wc-block-featured-product .wp-block-button .wp-block-button__link:not(.has-background):after,
        .content-wrapper .wc-block-featured-category .wp-block-button .wp-block-button__link:not(.has-background):after,
        .block-editor-block-list__layout .wc-block-featured-category .wp-block-button .wp-block-button__link:not(.has-background):after,
        .footer-widgets .wc-block-featured-category .wp-block-button .wp-block-button__link:not(.has-background):after,
        .slide-sidebar-wrapper .wc-block-featured-category .wp-block-button .wp-block-button__link:not(.has-background):after,
        .slide-sidebar-wrapper .wp-block-button.wc-block-load-more .wp-block-button__link:after,
        .slide-sidebar-wrapper .wc-block-grid__products .wc-block-grid__product .wc-block-grid__product-info .wp-block-button .wp-block-button__link:after,
        .slide-sidebar-wrapper .wc-block-grid__products .wc-block-grid__product .wc-block-grid__product-info .wp-block-button .added_to_cart:after,
        .slide-sidebar-wrapper #form-preview button:after,
        .slide-sidebar-wrapper .energium-button:after,
        .body-container .slide-sidebar-wrapper button:not(.customize-partial-edit-shortcut-button):not([class*="elementor"]):after,
        .body-container .slide-sidebar-wrapper input[type="submit"]:after,
        .body-container .slide-sidebar-wrapper input[type="button"]:after,
        .body-container .slide-sidebar-wrapper input[type="reset"]:after,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form input[type=submit]:after,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form button[type=submit]:after,
        .slide-sidebar-wrapper div.wpforms-container.wpforms-container-full .wpforms-form .wpforms-page-button:after,
        .slide-sidebar-wrapper .woocommerce a.button:after,
        .slide-sidebar-wrapper .woocommerce a.button.alt:after,
        .slide-sidebar-wrapper .woocommerce button.button:after,
        .slide-sidebar-wrapper .woocommerce button.button.alt:after,
        .slide-sidebar-wrapper .woocommerce input.button:after,
        .slide-sidebar-wrapper .woocommerce #respond input#submit:after,
        .slide-sidebar-wrapper .woocommerce a.added_to_cart:after,
        .slide-sidebar-wrapper .woocommerce #respond input#submit:not(.disabled):after,
        .slide-sidebar-wrapper .woocommerce #respond input#submit:not(:disabled):after,
        .slide-sidebar-wrapper .woocommerce a.button:not(.disabled):after,
        .slide-sidebar-wrapper .woocommerce a.button:not(:disabled):after,
        .slide-sidebar-wrapper .woocommerce button.button:not(.disabled):after,
        .slide-sidebar-wrapper .woocommerce button.button:not(:disabled):after,
        .slide-sidebar-wrapper .woocommerce input.button:not(.disabled):after,
        .slide-sidebar-wrapper .woocommerce input.button:not(:disabled):after,
        
        .slide-sidebar-wrapper .widget_product_tag_cloud .tagcloud .tag-cloud-link:hover,
        .slide-sidebar-wrapper .widget_tag_cloud .tagcloud .tag-cloud-link:hover,
        .slide-sidebar-wrapper .wp-block-tag-cloud .tag-cloud-link:hover,
         
        .slide-sidebar-wrapper .wp-block-button:not(.is-style-fill) .wp-block-button__link:not(.has-background):after, 
        .sidebar .wp-block-cover .wp-block-button:not(.is-style-fill) .wp-block-button__link:not(.has-background):after,
        .slide-sidebar-wrapper #sb_instagram .sbi_item .sbi_photo:before,
        .slide-sidebar-wrapper .wp-block-gallery .blocks-gallery-grid .blocks-gallery-item a:before, 
        .slide-sidebar-wrapper .media_gallery .blocks-gallery-grid .blocks-gallery-item a:before,
        .slide-sidebar-wrapper .gallery .gallery-item .gallery-icon a:before,
        .slide-sidebar-wrapper .widget_media_gallery .gallery .gallery-icon a:before,
        .slide-sidebar-wrapper .widget .wp-block-image a:before,
         
        .woocommerce .shop_mode_grid .products ul li.product .product-buttons-wrapper a.button:hover, 
        .woocommerce .shop_mode_grid .products ul li.product .product-buttons-wrapper a.added_to_cart:hover, 
        .woocommerce .shop_mode_grid .woocommerce ul.products li.product .product-buttons-wrapper a.button:hover, 
        .woocommerce .shop_mode_grid .woocommerce ul.products li.product .product-buttons-wrapper a.added_to_cart:hover, 
        .woocommerce .shop_mode_grid ul.products li.product .product-buttons-wrapper a.button:hover, 
        .woocommerce .shop_mode_grid ul.products li.product .product-buttons-wrapper a.added_to_cart:hover, 
        .woocommerce-page .shop_mode_grid .products ul li.product .product-buttons-wrapper a.button:hover, 
        .woocommerce-page .shop_mode_grid .products ul li.product .product-buttons-wrapper a.added_to_cart:hover, 
        .woocommerce-page .shop_mode_grid .woocommerce ul.products li.product .product-buttons-wrapper a.button:hover, 
        .woocommerce-page .shop_mode_grid .woocommerce ul.products li.product .product-buttons-wrapper a.added_to_cart:hover, 
        .woocommerce-page .shop_mode_grid ul.products li.product .product-buttons-wrapper a.button:hover, 
        .woocommerce-page .shop_mode_grid ul.products li.product .product-buttons-wrapper a.added_to_cart:hover,
        .slide-sidebar-wrapper .widget_layered_nav_filters ul .chosen a:hover,
        .energium-price-item-widget .price-item.active .price-item-button-container .energium-button:after,
        .elementor-widget-video .elementor-custom-embed-play:hover,
        .energium-video-button .elementor-custom-embed-play:hover {
            background-color: ' . esc_attr($contrast_button_background_hover) . ';
        }
    ';
}

if ( !empty($contrast_accent_text_color) && !empty($contrast_background_color) ) {
    $energium_custom_css .= '
        .slide-sidebar-wrapper input[type="range"]::-webkit-slider-thumb {
            background: -moz-radial-gradient(center, circle, ' . esc_attr($contrast_background_color) . ' 1.5px, ' . esc_attr($contrast_accent_text_color) . ' 1.5px, ' . esc_attr($contrast_accent_text_color) . ' 2.5px, ' . esc_attr($contrast_background_color) . ' 2.5px);
            background: -webkit-radial-gradient(center, circle, ' . esc_attr($contrast_background_color) . ' 1.5px, ' . esc_attr($contrast_accent_text_color) . ' 1.5px, ' . esc_attr($contrast_accent_text_color) . ' 2.5px, ' . esc_attr($contrast_background_color) . ' 2.5px);
            background: radial-gradient(circle at center, ' . esc_attr($contrast_background_color) . ' 1.5px, ' . esc_attr($contrast_accent_text_color) . ' 1.5px, ' . esc_attr($contrast_accent_text_color) . ' 2.5px, ' . esc_attr($contrast_background_color) . ' 2.5px);
        }
        .slide-sidebar-wrapper input[type="range"]::-moz-range-thumb {
            background: -moz-radial-gradient(center, circle, ' . esc_attr($contrast_background_color) . ' 1.5px, ' . esc_attr($contrast_accent_text_color) . ' 1.5px, ' . esc_attr($contrast_accent_text_color) . ' 2.5px, ' . esc_attr($contrast_background_color) . ' 2.5px);
            background: -webkit-radial-gradient(center, circle, ' . esc_attr($contrast_background_color) . ' 1.5px, ' . esc_attr($contrast_accent_text_color) . ' 1.5px, ' . esc_attr($contrast_accent_text_color) . ' 2.5px, ' . esc_attr($contrast_background_color) . ' 2.5px);
            background: radial-gradient(circle at center, ' . esc_attr($contrast_background_color) . ' 1.5px, ' . esc_attr($contrast_accent_text_color) . ' 1.5px, ' . esc_attr($contrast_accent_text_color) . ' 2.5px, ' . esc_attr($contrast_background_color) . ' 2.5px);
        }
        .slide-sidebar-wrapper input[type="range"]::-ms-thumb {
            background: -moz-radial-gradient(center, circle, ' . esc_attr($contrast_background_color) . ' 1.5px, ' . esc_attr($contrast_accent_text_color) . ' 1.5px, ' . esc_attr($contrast_accent_text_color) . ' 2.5px, ' . esc_attr($contrast_background_color) . ' 2.5px);
            background: -webkit-radial-gradient(center, circle, ' . esc_attr($contrast_background_color) . ' 1.5px, ' . esc_attr($contrast_accent_text_color) . ' 1.5px, ' . esc_attr($contrast_accent_text_color) . ' 2.5px, ' . esc_attr($contrast_background_color) . ' 2.5px);
            background: radial-gradient(circle at center, ' . esc_attr($contrast_background_color) . ' 1.5px, ' . esc_attr($contrast_accent_text_color) . ' 1.5px, ' . esc_attr($contrast_accent_text_color) . ' 2.5px, ' . esc_attr($contrast_background_color) . ' 2.5px);
        }
        .slide-sidebar-wrapper input[type="range"]:focus::-ms-thumb {
            background: -moz-radial-gradient(center, circle, ' . esc_attr($contrast_background_color) . ' 1.5px, ' . esc_attr($contrast_accent_text_color) . ' 1.5px, ' . esc_attr($contrast_accent_text_color) . ' 2.5px, ' . esc_attr($contrast_background_color) . ' 2.5px);
            background: -webkit-radial-gradient(center, circle, ' . esc_attr($contrast_background_color) . ' 1.5px, ' . esc_attr($contrast_accent_text_color) . ' 1.5px, ' . esc_attr($contrast_accent_text_color) . ' 2.5px, ' . esc_attr($contrast_background_color) . ' 2.5px);
            background: radial-gradient(circle at center, ' . esc_attr($contrast_background_color) . ' 1.5px, ' . esc_attr($contrast_accent_text_color) . ' 1.5px, ' . esc_attr($contrast_accent_text_color) . ' 2.5px, ' . esc_attr($contrast_background_color) . ' 2.5px);
        }
        .slide-sidebar-wrapper div.wpforms-container-full .wpforms-form .wpforms-field.wpforms-field-number-slider input[type="range"]::-webkit-slider-thumb {
            background: -moz-radial-gradient(center, circle, ' . esc_attr($contrast_background_color) . ' 1.5px, ' . esc_attr($contrast_accent_text_color) . ' 1.5px, ' . esc_attr($contrast_accent_text_color) . ' 2.5px, ' . esc_attr($contrast_background_color) . ' 2.5px);
            background: -webkit-radial-gradient(center, circle, ' . esc_attr($contrast_background_color) . ' 1.5px, ' . esc_attr($contrast_accent_text_color) . ' 1.5px, ' . esc_attr($contrast_accent_text_color) . ' 2.5px, ' . esc_attr($contrast_background_color) . ' 2.5px);
            background: radial-gradient(circle at center, ' . esc_attr($contrast_background_color) . ' 1.5px, ' . esc_attr($contrast_accent_text_color) . ' 1.5px, ' . esc_attr($contrast_accent_text_color) . ' 2.5px, ' . esc_attr($contrast_background_color) . ' 2.5px);
        }
        .slide-sidebar-wrapper div.wpforms-container-full .wpforms-form .wpforms-field.wpforms-field-number-slider input[type="range"]::-moz-range-thumb {
            background: -moz-radial-gradient(center, circle, ' . esc_attr($contrast_background_color) . ' 1.5px, ' . esc_attr($contrast_accent_text_color) . ' 1.5px, ' . esc_attr($contrast_accent_text_color) . ' 2.5px, ' . esc_attr($contrast_background_color) . ' 2.5px);
            background: -webkit-radial-gradient(center, circle, ' . esc_attr($contrast_background_color) . ' 1.5px, ' . esc_attr($contrast_accent_text_color) . ' 1.5px, ' . esc_attr($contrast_accent_text_color) . ' 2.5px, ' . esc_attr($contrast_background_color) . ' 2.5px);
            background: radial-gradient(circle at center, ' . esc_attr($contrast_background_color) . ' 1.5px, ' . esc_attr($contrast_accent_text_color) . ' 1.5px, ' . esc_attr($contrast_accent_text_color) . ' 2.5px, ' . esc_attr($contrast_background_color) . ' 2.5px);
        }
        .slide-sidebar-wrapper div.wpforms-container-full .wpforms-form .wpforms-field.wpforms-field-number-slider input[type="range"]::-ms-thumb {
            background: -moz-radial-gradient(center, circle, ' . esc_attr($contrast_background_color) . ' 1.5px, ' . esc_attr($contrast_accent_text_color) . ' 1.5px, ' . esc_attr($contrast_accent_text_color) . ' 2.5px, ' . esc_attr($contrast_background_color) . ' 2.5px);
            background: -webkit-radial-gradient(center, circle, ' . esc_attr($contrast_background_color) . ' 1.5px, ' . esc_attr($contrast_accent_text_color) . ' 1.5px, ' . esc_attr($contrast_accent_text_color) . ' 2.5px, ' . esc_attr($contrast_background_color) . ' 2.5px);
            background: radial-gradient(circle at center, ' . esc_attr($contrast_background_color) . ' 1.5px, ' . esc_attr($contrast_accent_text_color) . ' 1.5px, ' . esc_attr($contrast_accent_text_color) . ' 2.5px, ' . esc_attr($contrast_background_color) . ' 2.5px);
        }
        .slide-sidebar-wrapper div.wpforms-container-full .wpforms-form .wpforms-field.wpforms-field-number-slider input[type="range"]:focus::-ms-thumb {
            background: -moz-radial-gradient(center, circle, ' . esc_attr($contrast_background_color) . ' 1.5px, ' . esc_attr($contrast_accent_text_color) . ' 1.5px, ' . esc_attr($contrast_accent_text_color) . ' 2.5px, ' . esc_attr($contrast_background_color) . ' 2.5px);
            background: -webkit-radial-gradient(center, circle, ' . esc_attr($contrast_background_color) . ' 1.5px, ' . esc_attr($contrast_accent_text_color) . ' 1.5px, ' . esc_attr($contrast_accent_text_color) . ' 2.5px, ' . esc_attr($contrast_background_color) . ' 2.5px);
            background: radial-gradient(circle at center, ' . esc_attr($contrast_background_color) . ' 1.5px, ' . esc_attr($contrast_accent_text_color) . ' 1.5px, ' . esc_attr($contrast_accent_text_color) . ' 2.5px, ' . esc_attr($contrast_background_color) . ' 2.5px);
        }
    ';
}