<?php
# One Click Demo Content Import
if (!function_exists('energium_ocdi_import_files')) {
    function energium_ocdi_import_files() {
        return array(
            array(
                'import_file_name'              => 'Energium',
                'categories'                    => array('With Images'),
                'import_file_url'               => trailingslashit(get_template_directory_uri()) . 'core/import/import.xml',
                'import_widget_file_url'        => trailingslashit(get_template_directory_uri()) . 'core/import/widgets.xml',
                'import_customizer_file_url'    => trailingslashit(get_template_directory_uri()) . 'core/import/customizer.xml',
                'import_preview_image_url'      => trailingslashit(get_template_directory_uri()) . 'screenshot.png',
                'preview_url'                   => 'https://demo.artureanec.com/themes/energium',
            ),
        );
    }
}
add_filter( 'pt-ocdi/import_files', 'energium_ocdi_import_files' );

# Remove Branding Message
add_filter( 'pt-ocdi/disable_pt_branding', '__return_true' );

# Disable Regenerate for Thumbs
//add_filter( 'pt-ocdi/regenerate_thumbnails_in_content_import', '__return_false' ); // This will greatly improve the time needed to import the content (images), but only the original sized images will be imported.

if (!function_exists('energium_after_activation')) {
    function energium_after_activation() {
        function energium_after_switch_theme_message() {
            echo '<div class="updated notice is-dismissible"><p>' . esc_html__('After activating all the recommended plugins, you can import all demo content in one-touch. Appearance > Import Demo Data.', 'energium') . '</p></div>';
        }
        add_action('admin_notices', 'energium_after_switch_theme_message');
    }
}
add_action('after_switch_theme', 'energium_after_activation', 10 , 2);

# Remove all posts, pages and products before content import
if ( !function_exists('energium_ocdi_before_content_import') ) {
    function energium_ocdi_before_content_import() {
        // Remove posts and pages
        $allposts= get_posts( array(
            'post_type'     => array('post', 'page', 'products', 'product_variation', 'shop_coupon', 'attachment', 'energium_portfolio', 'energium_project', 'energium_service'),
            'numberposts'   => -1
        ) );
        foreach ($allposts as $eachpost) {
            wp_delete_post( $eachpost->ID, true );
        }
    }
}
add_action( 'pt-ocdi/before_content_import', 'energium_ocdi_before_content_import' );

# Clear sidebars before the widgets get imported
if ( !function_exists('energium_ocdi_before_widgets_import') ) {
    function energium_ocdi_before_widgets_import() {
        // Remove widgets
        update_option( 'sidebars_widgets', array() );
    }
}
add_action( 'pt-ocdi/before_widgets_import', 'energium_ocdi_before_widgets_import' );


if (!function_exists('energium_ocdi_after_import_setup')) {
    function energium_ocdi_after_import_setup() {
        // Assign menus to their locations.
        $main_menu              = get_term_by('name', 'Main Menu', 'nav_menu');
        $footer_menu            = get_term_by('name', 'Footer Menu', 'nav_menu');
        $footer_additional_menu = get_term_by('name', 'Footer Additional Menu', 'nav_menu');

        set_theme_mod('nav_menu_locations', array(
            'main'              => $main_menu->term_id,
            'footer_menu'       => $footer_menu->term_id,
            'footer_add_menu'   => $footer_additional_menu->term_id
        ));

        // Set media sizes
        update_option('thumbnail_size_w', '150');
        update_option('thumbnail_size_h', '150');
        update_option('thumbnail_crop', '1');
        update_option('medium_size_w', '300');
        update_option('medium_size_h', '300');
        update_option('medium_crop', '1');
        update_option('large_size_w', '1024');
        update_option('large_size_h', '1024');
        update_option('large_crop', '1');

        // Assign front page and posts page (blog page).
        $front_page_id = get_page_by_path('/home-1/');
        update_option('show_on_front', 'page');
        update_option('page_on_front', $front_page_id->ID);
        // update_option( 'page_for_posts', $blog_page_id->ID );

        // Set Mailchimp for WP options
        if ( function_exists( 'mc4wp' ) ) {
            $has_forms = get_posts(
                array(
                    'post_type'   => 'mc4wp-form',
                    'post_status' => 'publish',
                    'numberposts' => 1,
                )
            );
            update_option( 'mc4wp_default_form_id', $has_forms[0]->ID );
        }

        // Set WooCommerce options
        if ( class_exists('WooCommerce') ) {
            if (!wc_update_product_lookup_tables_is_running()) {
                wc_update_product_lookup_tables();
            }
            $args = array(
                'post_type'     => 'product',
                'post_status'   => 'publish',
                'orderby'       => 'date',
                'order'         => 'ASC'
            );
            $loop = new WP_Query($args);
            while ($loop->have_posts()) {
                $loop->the_post();
                global $product;
                wc_delete_product_transients($product->get_id());
            }

            $shop_page_id       = get_page_by_path('/shop/');
            $cart_page_id       = get_page_by_path('/cart/');
            $checkout_page_id   = get_page_by_path('/checkout/');
            $account_page_id    = get_page_by_path('/my-account/');

            update_option( 'woocommerce_shop_page_id', $shop_page_id->ID );
            update_option( 'woocommerce_cart_page_id', $cart_page_id->ID );
            update_option( 'woocommerce_checkout_page_id', $checkout_page_id->ID );
            update_option( 'woocommerce_myaccount_page_id', $account_page_id->ID );
            update_option( 'permalink_structure', '/%postname%/' );
        }

        // Set Elementor options
        if ( did_action('elementor/loaded') ) {
            // General
            update_option('elementor_cpt_support', array('post', 'page', 'energium_service'));
            update_option('elementor_disable_color_schemes', 'yes');
            update_option('elementor_disable_typography_schemes', 'yes');
            // Advanced
            update_option('elementor_load_fa4_shim', '');
            // Performance
            update_option('elementor_optimized_gutenberg_loading', '0');
            // Features
            update_option('elementor_experiment-e_font_icon_svg', 'inactive');
            update_option('elementor_experiment-container', 'inactive');
            update_option('elementor_experiment-editor_v2', 'inactive');
            update_option('elementor_experiment-landing-pages', 'inactive');
            update_option('elementor_experiment-nested-elements', 'inactive');
            update_option('elementor_experiment-a11y_improvements', 'inactive');
            update_option('elementor_experiment-additional_custom_breakpoints', 'active');
            update_option('elementor_experiment-e_local_google_fonts', 'inactive');

            update_option('elementor_experiment-e_swiper_latest', 'inactive');

            $kit = \Elementor\Plugin::$instance->kits_manager->get_active_kit_for_frontend();
            $kit->update_settings(
                [
                    'container_width'       => [
                        'unit'  => 'px',
                        'size'  => 1170,
                        'sizes' => []
                    ],
                    'space_between_widgets' => [
                        'column'    => '30',
                        'row'       => '30',
                        'isLinked'  => true,
                        'unit'      => 'px',
                        'size'      => 30,
                        'sizes'     => []
                    ],
                    'active_breakpoints'    => [
                        0   => 'viewport_mobile',
                        1   => 'viewport_mobile_extra',
                        2   => 'viewport_tablet',
                        3   => 'viewport_tablet_extra',
                        4   => 'viewport_laptop',
                        5   => 'viewport_widescreen'
                    ],
                    'viewport_mobile'       => 767,
                    'viewport_mobile_extra' => 880,
                    'viewport_tablet'       => 1024,
                    'viewport_tablet_extra' => 1200,
                    'viewport_laptop'       => 1366,
                    'viewport_widescreen'   => 2400,
                    'system_colors'         => [
                        0       => [
                            '_id'   => 'primary',
                            'title' => esc_html__('Primary', 'energium'),
                            'color' => '#0dceb5'
                        ],
                        1       => [
                            '_id'   => 'secondary',
                            'title' => esc_html__('Secondary', 'energium'),
                            'color' => '#27333a'
                        ],
                        2       => [
                            '_id'   => 'text',
                            'title' => esc_html__('Text', 'energium'),
                            'color' => '#666666'
                        ],
                        3       => [
                            '_id'   => 'accent',
                            'title' => esc_html__('Accent', 'energium'),
                            'color' => '#0d80ce'
                        ]
                    ],
                    'system_typography'     => [
                        0       => [
                            '_id'                       => 'primary',
                            'title'                     => esc_html__('Primary', 'energium'),
                            'typography_typography'     => 'custom',
                            'typography_font_family'    => 'Manrope',
                            'typography_font_weight'    => '400',
                            'typography_font_size'      => [
                                'unit'      => 'px',
                                'size'      => '',
                                'sizes'     => []
                            ]
                        ],
                        1       => [
                            '_id'                       => 'secondary',
                            'title'                     => esc_html__('Secondary', 'energium'),
                            'typography_typography'     => 'custom',
                            'typography_font_family'    => 'Manrope',
                            'typography_font_weight'    => '400',
                            'typography_font_size'      => [
                                'unit'      => 'px',
                                'size'      => '',
                                'sizes'     => []
                            ]
                        ],
                        2       => [
                            '_id'                       => 'text',
                            'title'                     => esc_html__('Text', 'energium'),
                            'typography_typography'     => 'custom',
                            'typography_font_family'    => 'Manrope',
                            'typography_font_weight'    => '400',
                            'typography_font_size'      => [
                                'unit'      => 'px',
                                'size'      => '',
                                'sizes'     => []
                            ]
                        ],
                        3       => [
                            '_id'                       => 'accent',
                            'title'                     => esc_html__('Accent', 'energium'),
                            'typography_typography'     => 'custom',
                            'typography_font_family'    => 'Manrope',
                            'typography_font_weight'    => '400',
                            'typography_font_size'      => [
                                'unit'      => 'px',
                                'size'      => '',
                                'sizes'     => []
                            ]
                        ]
                    ]
                ]
            );
        }

        // Import forms
        if ( function_exists('wpforms') ) {
            $title = __('Request a Quote', 'energium');
            $form_id = wpforms()->form->add(esc_html($title));
            $form_id = wpforms()->form->update(
                $form_id,
                array(
                    'id'        => '4264',
                    'field_id'  => 6,
                    'fields'    => array(
                        '1'                         => array(
                            'id'                        => '1',
                            'type'                      => 'text',
                            'label'                     => esc_html__('Full name', 'energium'),
                            'description'               => '',
                            'required'                  => '1',
                            'size'                      => 'large',
                            'placeholder'               => '',
                            'default_value'             => '',
                            'input_mask'                => '',
                            'css'                       => 'wpforms-one-half wpforms-first',
                            'sublabel_hide'             => '1',
                        ),
                        '2'                         => array(
                            'id'                        => '2',
                            'type'                      => 'email',
                            'label'                     => esc_html__('Email', 'energium'),
                            'description'               => '',
                            'required'                  => '1',
                            'size'                      => 'large',
                            'placeholder'               => '',
                            'confirmation_placeholder'  => '',
                            'default_value'             => '',
                            'filter_type'               => '',
                            'allowlist'                 => '',
                            'denylist'                  => '',
                            'css'                       => 'wpforms-one-half',
                            'sublabel_hide'             => '1',
                        ),
                        '5'                         => array(
                            'id'                        => '5',
                            'type'                      => 'text',
                            'label'                     => esc_html__('Subject', 'energium'),
                            'description'               => '',
                            'size'                      => 'large',
                            'placeholder'               => '',
                            'limit_count'               => '1',
                            'limit_mode'                => 'characters',
                            'default_value'             => '',
                            'input_mask'                => '',
                            'css'                       => '',
                            'sublabel_hide'             => '1',
                        ),
                        '3'                         => array(
                            'id'                        => '3',
                            'type'                      => 'textarea',
                            'label'                     => esc_html_x('Comment', '"Request a Quote" form', 'energium'),
                            'description'               => '',
                            'size'                      => 'large',
                            'placeholder'               => '',
                            'limit_count'               => '1',
                            'limit_mode'                => 'characters',
                            'default_value'             => '',
                            'css'                       => '',
                            'sublabel_hide'             => '1',
                        ),
                    ),
                    'settings' => array(
                        'form_title'                => esc_html($title),
                        'form_desc'                 => esc_html__('We always looking for great partners and customers. \r\nLet\'s message us and make something together.', 'energium'),
                        'submit_text'               => esc_html__('Send Message', 'energium'),
                        'submit_text_processing'    => esc_html__('Sending...', 'energium'),
                        'antispam'                  => '1',
                        'form_class'                => '',
                        'submit_class'              => '',
                        'ajax_submit'               => '1',
                        'notification_enable'       => '1',
                        'notifications'             => array(
                            '1'                         => array(
                                'email'                     => '{admin_email}',
                                'subject'                   => esc_html__('New Contact Form Entry', 'energium'),
                                'sender_name'               => 'Energium',
                                'sender_address'            => '{admin_email}',
                                'replyto'                   => '',
                                'message'                   => '{all_fields}',
                            ),
                        ),
                        'confirmations'             => array(
                            '1'                         => array(
                                'type'                      => 'message',
                                'message'                   => '<p>' . esc_html__('Thanks for contacting us! We will be in touch with you shortly.', 'energium') . '</p>',
                                'message_scroll'            => '1',
                                'page'                      => '19',
                                'redirect'                  => '',
                            ),
                        ),
                    ),
                    'meta'                      => array(
                        'template'                  => 'blank',
                    ),
                )
            );
            wp_update_post(
                array(
                    'ID'         => $form_id,
                    'post_title' => esc_html($title),
                )
            );

            $title2 = __('Contact Form', 'energium');
            $form_id2 = wpforms()->form->add(esc_html($title2));
            $form_id2 = wpforms()->form->update(
                $form_id2,
                array(
                    'id'        => '282',
                    'field_id'  => 6,
                    'fields'    => array(
                        '1'                         => array(
                            'id'                        => '1',
                            'type'                      => 'text',
                            'label'                     => esc_html__('Full name', 'energium'),
                            'description'               => '',
                            'required'                  => '1',
                            'size'                      => 'large',
                            'placeholder'               => '',
                            'default_value'             => '',
                            'input_mask'                => '',
                            'css'                       => 'wpforms-one-half wpforms-first',
                            'sublabel_hide'             => '1',
                        ),
                        '2'                         => array(
                            'id'                        => '2',
                            'type'                      => 'email',
                            'label'                     => esc_html__('Email', 'energium'),
                            'description'               => '',
                            'required'                  => '1',
                            'size'                      => 'large',
                            'placeholder'               => '',
                            'confirmation_placeholder'  => '',
                            'default_value'             => '',
                            'filter_type'               => '',
                            'allowlist'                 => '',
                            'denylist'                  => '',
                            'css'                       => 'wpforms-one-half',
                            'sublabel_hide'             => '1',
                        ),
                        '5'                         => array(
                            'id'                        => '5',
                            'type'                      => 'text',
                            'label'                     => esc_html__('Subject', 'energium'),
                            'description'               => '',
                            'size'                      => 'large',
                            'placeholder'               => '',
                            'limit_count'               => '1',
                            'limit_mode'                => 'characters',
                            'default_value'             => '',
                            'input_mask'                => '',
                            'css'                       => '',
                            'sublabel_hide'             => '1',
                        ),
                        '3'                         => array(
                            'id'                        => '3',
                            'type'                      => 'textarea',
                            'label'                     => esc_html_x('Comment', 'Contact form', 'energium'),
                            'description'               => '',
                            'size'                      => 'medium',
                            'placeholder'               => '',
                            'limit_count'               => '1',
                            'limit_mode'                => 'characters',
                            'default_value'             => '',
                            'css'                       => '',
                            'sublabel_hide'             => '1',
                        ),
                    ),
                    'settings' => array(
                        'form_title'                => esc_html($title2),
                        'form_desc'                 => '',
                        'submit_text'               => esc_html__('Send Message', 'energium'),
                        'submit_text_processing'    => esc_html__('Sending...', 'energium'),
                        'antispam'                  => '1',
                        'form_class'                => '',
                        'submit_class'              => '',
                        'ajax_submit'               => '1',
                        'notification_enable'       => '1',
                        'notifications'             => array(
                            '1'                         => array(
                                'email'                     => '{admin_email}',
                                'subject'                   => esc_html__('New Contact Form Entry', 'energium'),
                                'sender_name'               => 'Energium',
                                'sender_address'            => '{admin_email}',
                                'replyto'                   => '',
                                'message'                   => '{all_fields}',
                            ),
                        ),
                        'confirmations'             => array(
                            '1'                         => array(
                                'type'                      => 'message',
                                'message'                   => '<p>' . esc_html__('Thanks for contacting us! We will be in touch with you shortly.', 'energium') . '</p>',
                                'message_scroll'            => '1',
                                'page'                      => '19',
                                'redirect'                  => '',
                            ),
                        ),
                    ),
                    'meta'                      => array(
                        'template'                  => 'blank',
                    ),
                )
            );
            wp_update_post(
                array(
                    'ID'         => $form_id2,
                    'post_title' => esc_html($title2),
                )
            );
        }

    }
}
add_action( 'pt-ocdi/after_import', 'energium_ocdi_after_import_setup' );