<?php
/*
 * Created by Artureanec
*/

require_once(get_template_directory() . "/core/customizer/customizer-sanitize-functions.php");
require_once(get_template_directory() . "/core/customizer/customizer-defaults.php");
require_once(get_template_directory() . "/core/customizer/customizer-controls.php");

# Register Customizer
add_action('customize_register', 'energium_customizer_register');
if (!function_exists('energium_customizer_register')) {
    function energium_customizer_register($wp_customize) {
        global $energium_customizer_default_values;

        // -------------------------------------------- //
        // ---------- Top Bar Settings Panel ---------- //
        // -------------------------------------------- //
        $wp_customize->add_panel('energium_top_bar_settings',
            array(
                'title'     => esc_html__('Top Bar Settings', 'energium'),
                'priority'  => 130
            )
        );

        // ---#######################--- //
        // ---### Top Bar General ###--- //
        // ---#######################--- //
        $wp_customize->add_section('energium_top_bar_general',
            array(
                'title' => esc_html__('General', 'energium'),
                'panel' => 'energium_top_bar_settings'
            )
        );

        // ---------------------- //
        // --- Top Bar Status --- //
        // ---------------------- //
        $wp_setting_name = 'top_bar_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Top Bar', 'energium'),
                'section'   => 'energium_top_bar_general',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'energium'),
                    'off'       => esc_html__('No', 'energium')
                )
            )
        ));

        // ------------------------- //
        // --- Top Bar Customize --- //
        // ------------------------- //
        $wp_setting_name = 'top_bar_customize';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Customize', 'energium'),
                'section'   => 'energium_top_bar_general',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'energium'),
                    'off'       => esc_html__('No', 'energium')
                )
            )
        ));

        // ---------------------------------- //
        // --- Top Bar Default Text Color --- //
        // ---------------------------------- //
        $wp_setting_name = 'top_bar_default_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Energium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Default Text Color', 'energium'),
                'section'       => 'energium_top_bar_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'top_bar_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ],
                'separator'     => 'before'
            )
        ));

        // ------------------------------- //
        // --- Top Bar Dark Text Color --- //
        // ------------------------------- //
        $wp_setting_name = 'top_bar_dark_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Energium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Dark Text Color', 'energium'),
                'section'       => 'energium_top_bar_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'top_bar_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // -------------------------------- //
        // --- Top Bar Light Text Color --- //
        // -------------------------------- //
        $wp_setting_name = 'top_bar_light_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Energium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Light Text Color', 'energium'),
                'section'       => 'energium_top_bar_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'top_bar_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // --------------------------------- //
        // --- Top Bar Accent Text Color --- //
        // --------------------------------- //
        $wp_setting_name = 'top_bar_accent_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Energium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Accent Text Color', 'energium'),
                'section'       => 'energium_top_bar_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'top_bar_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // -------------------------------- //
        // --- Top Bar Hover Text Color --- //
        // -------------------------------- //
        $wp_setting_name = 'top_bar_hover_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Energium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Hover Text Color', 'energium'),
                'section'       => 'energium_top_bar_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'top_bar_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ---------------------------- //
        // --- Top Bar Border Color --- //
        // ---------------------------- //
        $wp_setting_name = 'top_bar_border_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Energium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Border Color', 'energium'),
                'section'       => 'energium_top_bar_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'top_bar_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ],
                'separator'     => 'before'
            )
        ));

        // ------------------------------------ //
        // --- Top Bar Hovered Border Color --- //
        // ------------------------------------ //
        $wp_setting_name = 'top_bar_border_hover_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Energium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Hovered Border Color', 'energium'),
                'section'       => 'energium_top_bar_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'top_bar_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // -------------------------------- //
        // --- Top Bar Background Color --- //
        // -------------------------------- //
        $wp_setting_name = 'top_bar_background_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Energium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Background Color', 'energium'),
                'section'       => 'energium_top_bar_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'top_bar_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ],
                'separator'     => 'before'
            )
        ));

        // -------------------------------------------- //
        // --- Top Bar Alternative Background Color --- //
        // -------------------------------------------- //
        $wp_setting_name = 'top_bar_background_alter_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Energium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Alternative Background Color', 'energium'),
                'section'       => 'energium_top_bar_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'top_bar_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // --------------------------------- //
        // --- Top Bar Button Text Color --- //
        // --------------------------------- //
        $wp_setting_name = 'top_bar_button_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Energium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Text Color', 'energium'),
                'section'       => 'energium_top_bar_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'top_bar_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ],
                'separator'     => 'before'
            )
        ));

        // ----------------------------------- //
        // --- Top Bar Button Border Color --- //
        // ----------------------------------- //
        $wp_setting_name = 'top_bar_button_border_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Energium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Border Color', 'energium'),
                'section'       => 'energium_top_bar_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'top_bar_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // --------------------------------------- //
        // --- Top Bar Button Background Color --- //
        // --------------------------------------- //
        $wp_setting_name = 'top_bar_button_background_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Energium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Background Color', 'energium'),
                'section'       => 'energium_top_bar_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'top_bar_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // --------------------------------- //
        // --- Top Bar Button Text Hover --- //
        // --------------------------------- //
        $wp_setting_name = 'top_bar_button_text_hover';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Energium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Text Hover', 'energium'),
                'section'       => 'energium_top_bar_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'top_bar_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ----------------------------------- //
        // --- Top Bar Button Border Hover --- //
        // ----------------------------------- //
        $wp_setting_name = 'top_bar_button_border_hover';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Energium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Border Hover', 'energium'),
                'section'       => 'energium_top_bar_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'top_bar_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // --------------------------------------- //
        // --- Top Bar Button Background Hover --- //
        // --------------------------------------- //
        $wp_setting_name = 'top_bar_button_background_hover';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Energium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Background Hover', 'energium'),
                'section'       => 'energium_top_bar_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'top_bar_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));


        // ---##############################--- //
        // ---### Top Bar Social Buttons ###--- //
        // ---##############################--- //
        $wp_customize->add_section('energium_top_bar_socials',
            array(
                'title' => esc_html__('Social Buttons', 'energium'),
                'panel' => 'energium_top_bar_settings'
            )
        );

        // ------------------------------ //
        // --- Top Bar Socials Status --- //
        // ------------------------------ //
        $wp_setting_name = 'top_bar_socials_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Social Buttons', 'energium'),
                'section'   => 'energium_top_bar_socials',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'energium'),
                    'off'       => esc_html__('No', 'energium')
                )
            )
        ));

        // ----------------------------- //
        // --- Top Bar Socials Label --- //
        // ----------------------------- //
        $wp_setting_name = 'top_bar_socials_label';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'wp_kses_post'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Social Buttons Label Text', 'energium'),
                'section'       => 'energium_top_bar_socials',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'top_bar_socials_status',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));


        // ---########################--- //
        // ---### Top Bar Contacts ###--- //
        // ---########################--- //
        $wp_customize->add_section('energium_top_bar_contacts',
            array(
                'title' => esc_html__('Contacts', 'energium'),
                'panel' => 'energium_top_bar_settings'
            )
        );

        // ------------------------------------ //
        // --- Top Bar Email Address Status --- //
        // ------------------------------------ //
        $wp_setting_name = 'top_bar_contacts_email_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Email Address', 'energium'),
                'section'   => 'energium_top_bar_contacts',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'energium'),
                    'off'       => esc_html__('No', 'energium')
                )
            )
        ));

        // --------------------------- //
        // --- Top Bar Email Label --- //
        // --------------------------- //
        $wp_setting_name = 'top_bar_contacts_email_label';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'wp_kses_post'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Email Address Label Text', 'energium'),
                'section'       => 'energium_top_bar_contacts',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'top_bar_contacts_email_status',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ----------------------------- //
        // --- Top Bar Email Address --- //
        // ----------------------------- //
        $wp_setting_name = 'top_bar_contacts_email';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_email'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Email Address', 'energium'),
                'section'       => 'energium_top_bar_contacts',
                'type'          => 'email',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'top_bar_contacts_email_status',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ----------------------------------- //
        // --- Top Bar Phone Number Status --- //
        // ----------------------------------- //
        $wp_setting_name = 'top_bar_contacts_phone_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Phone Number', 'energium'),
                'section'   => 'energium_top_bar_contacts',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'energium'),
                    'off'       => esc_html__('No', 'energium')
                ),
                'separator' => 'before'
            )
        ));

        // ---------------------------------- //
        // --- Top Bar Phone Number Label --- //
        // ---------------------------------- //
        $wp_setting_name = 'top_bar_contacts_phone_label';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'wp_kses_post'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Phone Number Label Text', 'energium'),
                'section'       => 'energium_top_bar_contacts',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'top_bar_contacts_phone_status',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ---------------------------- //
        // --- Top Bar Phone Number --- //
        // ---------------------------- //
        $wp_setting_name = 'top_bar_contacts_phone';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Phone Number', 'energium'),
                'section'       => 'energium_top_bar_contacts',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'top_bar_contacts_phone_status',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------------------ //
        // --- Top Bar Address Status --- //
        // ------------------------------ //
        $wp_setting_name = 'top_bar_contacts_address_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Address', 'energium'),
                'section'   => 'energium_top_bar_contacts',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'energium'),
                    'off'       => esc_html__('No', 'energium')
                ),
                'separator' => 'before'
            )
        ));

        // ----------------------------- //
        // --- Top Bar Address Label --- //
        // ----------------------------- //
        $wp_setting_name = 'top_bar_contacts_address_label';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'wp_kses_post'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Address Label Text', 'energium'),
                'section'       => 'energium_top_bar_contacts',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'top_bar_contacts_address_status',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ----------------------- //
        // --- Top Bar Address --- //
        // ----------------------- //
        $wp_setting_name = 'top_bar_contacts_address';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Address', 'energium'),
                'section'       => 'energium_top_bar_contacts',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'top_bar_contacts_address_status',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));


        // ------------------------------------------- //
        // ---------- Header Settings Panel ---------- //
        // ------------------------------------------- //
        $wp_customize->add_panel('energium_header_settings',
            array(
                'title'     => esc_html__('Header Settings', 'energium'),
                'priority'  => 130
            )
        );

        // ---######################--- //
        // ---### Header General ###--- //
        // ---######################--- //
        $wp_customize->add_section('energium_header_general',
            array(
                'title' => esc_html__('General', 'energium'),
                'panel' => 'energium_header_settings'
            )
        );

        // --------------------- //
        // --- Header Status --- //
        // --------------------- //
        $wp_setting_name = 'header_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Header', 'energium'),
                'section'   => 'energium_header_general',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'energium'),
                    'off'       => esc_html__('No', 'energium')
                )
            )
        ));

        // ----------------------- //
        // --- Header Position --- //
        // ----------------------- //
        $wp_setting_name = 'header_position';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Header Position', 'energium'),
                'section'   => 'energium_header_general',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'above'     => esc_html__('Above', 'energium'),
                    'over'      => esc_html__('Over', 'energium')
                )
            )
        ));

        // ------------------------ //
        // --- Header Customize --- //
        // ------------------------ //
        $wp_setting_name = 'header_customize';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Customize', 'energium'),
                'section'   => 'energium_header_general',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'energium'),
                    'off'       => esc_html__('No', 'energium')
                )
            )
        ));

        // --------------------------------- //
        // --- Header Default Text Color --- //
        // --------------------------------- //
        $wp_setting_name = 'header_default_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Energium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Default text color', 'energium'),
                'section'       => 'energium_header_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'header_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ],
                'separator'     => 'before'
            )
        ));

        // ------------------------------ //
        // --- Header Dark Text Color --- //
        // ------------------------------ //
        $wp_setting_name = 'header_dark_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Energium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Dark text color', 'energium'),
                'section'       => 'energium_header_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'header_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------------------- //
        // --- Header Light Text Color --- //
        // ------------------------------- //
        $wp_setting_name = 'header_light_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Energium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Light text color', 'energium'),
                'section'       => 'energium_header_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'header_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // -------------------------------- //
        // --- Header Accent Text Color --- //
        // -------------------------------- //
        $wp_setting_name = 'header_accent_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Energium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Accent text color', 'energium'),
                'section'       => 'energium_header_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'header_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------------------- //
        // --- Header Hover Text Color --- //
        // ------------------------------- //
        $wp_setting_name = 'header_hover_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Energium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Hover text color', 'energium'),
                'section'       => 'energium_header_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'header_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // --------------------------- //
        // --- Header Border Color --- //
        // --------------------------- //
        $wp_setting_name = 'header_border_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Energium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Border color', 'energium'),
                'section'       => 'energium_header_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'header_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ],
                'separator'     => 'before'
            )
        ));

        // ----------------------------------- //
        // --- Header Hovered Border Color --- //
        // ----------------------------------- //
        $wp_setting_name = 'header_border_hover_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Energium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Hovered Border color', 'energium'),
                'section'       => 'energium_header_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'header_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------------------- //
        // --- Header Background Color --- //
        // ------------------------------- //
        $wp_setting_name = 'header_background_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Energium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Background color', 'energium'),
                'section'       => 'energium_header_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'header_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ],
                'separator'     => 'before'
            )
        ));

        // ------------------------------------------- //
        // --- Header Background Alternative Color --- //
        // ------------------------------------------- //
        $wp_setting_name = 'header_background_alter_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Energium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Alternative background color', 'energium'),
                'section'       => 'energium_header_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'header_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // -------------------------------- //
        // --- Header Button Text Color --- //
        // -------------------------------- //
        $wp_setting_name = 'header_button_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Energium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Text color', 'energium'),
                'section'       => 'energium_header_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'header_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ],
                'separator'     => 'before'
            )
        ));

        // ---------------------------------- //
        // --- Header Button Border Color --- //
        // ---------------------------------- //
        $wp_setting_name = 'header_button_border_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Energium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Border color', 'energium'),
                'section'       => 'energium_header_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'header_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // -------------------------------------- //
        // --- Header Button Background Color --- //
        // -------------------------------------- //
        $wp_setting_name = 'header_button_background_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Energium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Background Color', 'energium'),
                'section'       => 'energium_header_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'header_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // -------------------------------- //
        // --- Header Button Text Hover --- //
        // -------------------------------- //
        $wp_setting_name = 'header_button_text_hover';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Energium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Text Hover', 'energium'),
                'section'       => 'energium_header_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'header_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ---------------------------------- //
        // --- Header Button Border Hover --- //
        // ---------------------------------- //
        $wp_setting_name = 'header_button_border_hover';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Energium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Border Hover', 'energium'),
                'section'       => 'energium_header_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'header_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // -------------------------------------- //
        // --- Header Button Background Hover --- //
        // -------------------------------------- //
        $wp_setting_name = 'header_button_background_hover';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Energium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Background Hover', 'energium'),
                'section'       => 'energium_header_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'header_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));


        // ---#######################--- //
        // ---### Header Callback ###--- //
        // ---#######################--- //
        $wp_customize->add_section('energium_header_callback',
            array(
                'title' => esc_html__('Header Callback', 'energium'),
                'panel' => 'energium_header_settings'
            )
        );

        // ----------------------- //
        // --- Header Callback --- //
        // ----------------------- //
        $wp_setting_name = 'header_callback_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Show header callback block', 'energium'),
                'section'       => 'energium_header_callback',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => array(
                    'on'            => esc_html__('Yes', 'energium'),
                    'off'           => esc_html__('No', 'energium')
                )
            )
        ));

        // ----------------------------- //
        // --- Header Callback Title --- //
        // ----------------------------- //
        $wp_setting_name = 'header_callback_title';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Header callback title', 'energium'),
                'section'       => 'energium_header_callback',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'header_callback_status',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ---------------------------- //
        // --- Header Callback Text --- //
        // ---------------------------- //
        $wp_setting_name = 'header_callback_text';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Header callback text', 'energium'),
                'section'       => 'energium_header_callback',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'header_callback_status',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));


        // ---#####################--- //
        // ---### Sticky Header ###--- //
        // ---#####################--- //
        $wp_customize->add_section('energium_header_sticky',
            array(
                'title' => esc_html__('Sticky Header', 'energium'),
                'panel' => 'energium_header_settings'
            )
        );


        // --------------------- //
        // --- Sticky Header --- //
        // --------------------- //
        $wp_setting_name = 'sticky_header_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Sticky Header', 'energium'),
                'section'   => 'energium_header_sticky',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'energium'),
                    'off'       => esc_html__('No', 'energium')
                )
            )
        ));


        // ---#####################--- //
        // ---### Mobile Header ###--- //
        // ---#####################--- //
        $wp_customize->add_section('energium_header_mobile',
            array(
                'title' => esc_html__('Mobile Header', 'energium'),
                'panel' => 'energium_header_settings'
            )
        );

        // -------------------------------- //
        // --- Mobile Header Breakpoint --- //
        // -------------------------------- //
        $wp_setting_name = 'mobile_header_breakpoint';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'absint'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Mobile Header Breakpoint, in px', 'energium'),
                'section'       => 'energium_header_mobile',
                'type'          => 'number',
                'settings'      => $wp_setting_name
            )
        ));


        // ---#####################--- //
        // ---### Logo Settings ###--- //
        // ---#####################--- //
        $wp_customize->add_section('energium_header_logo',
            array(
                'title' => esc_html__('Logo', 'energium'),
                'panel' => 'energium_header_settings'
            )
        );

        // -------------------------- //
        // --- Header Logo Status --- //
        // -------------------------- //
        $wp_setting_name = 'header_logo_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Logo', 'energium'),
                'section'   => 'energium_header_logo',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'energium'),
                    'off'       => esc_html__('No', 'energium')
                )
            )
        ));

        // ----------------------------- //
        // --- Header Logo Customize --- //
        // ----------------------------- //
        $wp_setting_name = 'header_logo_customize';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Customize', 'energium'),
                'section'   => 'energium_header_logo',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'energium'),
                    'off'       => esc_html__('No', 'energium')
                )
            )
        ));

        // ------------------- //
        // --- Header Logo --- //
        // ------------------- //
        $wp_setting_name = 'header_logo_image';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'esc_url_raw'
            )
        );
        $wp_customize->add_control(new Energium_Image_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Logo Image', 'energium'),
                'section'       => 'energium_header_logo',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'header_logo_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------- //
        // --- Logo Retina --- //
        // ------------------- //
        $wp_setting_name = 'header_logo_retina';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_checkbox'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Logo Retina', 'energium'),
                'section'       => 'energium_header_logo',
                'type'          => 'checkbox',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'header_logo_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // -------------------------- //
        // --- Mobile Header Logo --- //
        // -------------------------- //
        $wp_setting_name = 'header_logo_mobile_image';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'esc_url_raw'
            )
        );
        $wp_customize->add_control(new Energium_Image_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Mobile Logo Image', 'energium'),
                'section'       => 'energium_header_logo',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'header_logo_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ],
                'separator'     => 'before'
            )
        ));

        // -------------------------- //
        // --- Mobile Logo Retina --- //
        // -------------------------- //
        $wp_setting_name = 'header_logo_mobile_retina';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_checkbox'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Mobile Logo Retina', 'energium'),
                'section'       => 'energium_header_logo',
                'type'          => 'checkbox',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'header_logo_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));


        // ---#####################--- //
        // ---### Header Button ###--- //
        // ---#####################--- //
        $wp_customize->add_section('energium_header_button',
            array(
                'title' => esc_html__('Header Button', 'energium'),
                'panel' => 'energium_header_settings'
            )
        );

        // --------------------- //
        // --- Header Button --- //
        // --------------------- //
        $wp_setting_name = 'header_button_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show header button', 'energium'),
                'section'   => 'energium_header_button',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'energium'),
                    'off'       => esc_html__('No', 'energium')
                )
            )
        ));

        // -------------------------- //
        // --- Header Button Size --- //
        // -------------------------- //
        $wp_setting_name = 'header_button_size';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Header button size', 'energium'),
                'section'       => 'energium_header_button',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => array(
                    'large'         => esc_html__('Large', 'energium'),
                    'small'         => esc_html__('Small', 'energium')
                ),
                'dependency'    => [
                    [
                        'control'   => 'header_button_status',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // -------------------------- //
        // --- Header Button Text --- //
        // -------------------------- //
        $wp_setting_name = 'header_button_text';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Header button text', 'energium'),
                'section'       => 'energium_header_button',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'header_button_status',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // -------------------------- //
        // --- Header Button URL ---- //
        // -------------------------- //
        $wp_setting_name = 'header_button_url';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'esc_url_raw'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Header button link', 'energium'),
                'section'       => 'energium_header_button',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'header_button_status',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));


        // ---############################--- //
        // ---### Header Menu Settings ###--- //
        // ---############################--- //
        $wp_customize->add_section('energium_header_menu',
            array(
                'title' => esc_html__('Header Menu', 'energium'),
                'panel' => 'energium_header_settings'
            )
        );

        // -------------------------- //
        // --- Header Menu Status --- //
        // -------------------------- //
        $wp_setting_name = 'header_menu_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show header menu', 'energium'),
                'section'   => 'energium_header_menu',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'energium'),
                    'off'       => esc_html__('No', 'energium')
                )
            )
        ));

        // -------------------------- //
        // --- Header Menu Select --- //
        // -------------------------- //
        $wp_setting_name = 'header_menu_select';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Select Menu', 'energium'),
                'section'       => 'energium_header_menu',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => energium_get_all_menu_list()
            )
        ));

        // ----------------------------- //
        // --- Header Menu Customize --- //
        // ----------------------------- //
        $wp_setting_name = 'header_menu_customize';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Customize', 'energium'),
                'section'   => 'energium_header_menu',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'energium'),
                    'off'       => esc_html__('No', 'energium')
                )
            )
        ));

        // ------------------- //
        // --- Header Font --- //
        // ------------------- //
        $wp_setting_name = 'header_menu_font';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Google_Font_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Menu Font', 'energium'),
                'section'       => 'energium_header_menu',
                'settings'      => $wp_setting_name,
                'show_field'    => [
                    'font_family'       => true,
                    'font_backup'       => true,
                    'font_styles'       => true,
                    'font_subset'       => true,
                    'font_size'         => true,
                    'line_height'       => true,
                    'text_transform'    => true,
                    'letter_spacing'    => true,
                    'word_spacing'      => true,
                    'font_style'        => true,
                    'font_weight'       => true
                ],
                'dependency'            => [
                    [
                        'control'           => 'header_menu_customize',
                        'operator'          => '==',
                        'value'             => 'on'
                    ]
                ]
            )
        ));

        // --------------------- //
        // --- Sub Menu Font --- //
        // --------------------- //
        $wp_setting_name = 'header_sub_menu_font';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Google_Font_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Sub Menu Font', 'energium'),
                'section'       => 'energium_header_menu',
                'settings'      => $wp_setting_name,
                'show_field'    => [
                    'font_family'       => true,
                    'font_backup'       => true,
                    'font_styles'       => true,
                    'font_subset'       => true,
                    'font_size'         => true,
                    'line_height'       => true,
                    'text_transform'    => true,
                    'letter_spacing'    => true,
                    'word_spacing'      => true,
                    'font_style'        => true,
                    'font_weight'       => true
                ],
                'separator'     => 'before',
                'dependency'    => [
                    [
                        'control'           => 'header_menu_customize',
                        'operator'          => '==',
                        'value'             => 'on'
                    ]
                ]
            )
        ));


        // ---####################--- //
        // ---### Header Icons ###--- //
        // ---####################--- //
        $wp_customize->add_section('header_icons',
            array(
                'title' => esc_html__('Header Icons', 'energium'),
                'panel' => 'energium_header_settings'
            )
        );

        // ------------------------- //
        // --- Header Side Panel --- //
        // ------------------------- //
        $wp_setting_name = 'side_panel_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show side panel trigger', 'energium'),
                'section'   => 'header_icons',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'energium'),
                    'off'       => esc_html__('No', 'energium')
                )
            )
        ));

        // ----------------------------------- //
        // --- Header Side Panel Separator --- //
        // ----------------------------------- //
        $wp_setting_name = 'side_panel_separator';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Show trigger separator', 'energium'),
                'section'       => 'header_icons',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => array(
                    'on'            => esc_html__('Yes', 'energium'),
                    'off'           => esc_html__('No', 'energium')
                ),
                'dependency'    => [
                    [
                        'control'   => 'side_panel_status',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ---------------------------------------- //
        // --- Header Side Panel Trigger Colors --- //
        // ---------------------------------------- //
        $wp_setting_name = 'side_panel_colors';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Choose trigger colors', 'energium'),
                'section'       => 'header_icons',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => array(
                    'light'         => esc_html__('Light', 'energium'),
                    'dark'          => esc_html__('Dark', 'energium')
                ),
                'dependency'    => [
                    [
                        'control'   => 'side_panel_status',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // --------------------- //
        // --- Header Search --- //
        // --------------------- //
        $wp_setting_name = 'header_search_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show header search', 'energium'),
                'section'   => 'header_icons',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'energium'),
                    'off'       => esc_html__('No', 'energium')
                ),
                'separator' => 'before'
            )
        ));


        if ( class_exists('WooCommerce') ) {
            // ------------------------ //
            // --- Header Mini Cart --- //
            // ------------------------ //
            $wp_setting_name = 'header_minicart_status';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $energium_customizer_default_values[$wp_setting_name],
                    'sanitize_callback'	=> 'energium_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Energium_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'     => esc_html__('Show product cart', 'energium'),
                    'section'   => 'header_icons',
                    'type'      => 'select',
                    'settings'  => $wp_setting_name,
                    'choices'   => array(
                        'on'        => esc_html__('Yes', 'energium'),
                        'off'       => esc_html__('No', 'energium')
                    ),
                    'separator' => 'before'
                )
            ));
        }


        // ------------------------------- //
        // ---------- Page Tile ---------- //
        // ------------------------------- //
        $wp_customize->add_panel('energium_page_title_settings',
            array(
                'title'     => esc_html__('Page Title Settings', 'energium'),
                'priority'  => 140
            )
        );

        // ---########################--- //
        // ---### General Settings ###--- //
        // ---########################--- //
        $wp_customize->add_section('energium_page_title_general',
            array(
                'title' => esc_html__('General', 'energium'),
                'panel' => 'energium_page_title_settings'
            )
        );

        // ------------------------- //
        // --- Page Title Status --- //
        // ------------------------- //
        $wp_setting_name = 'page_title_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show page title', 'energium'),
                'section'   => 'energium_page_title_general',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'energium'),
                    'off'       => esc_html__('No', 'energium')
                )
            )
        ));

        // -------------------------- //
        // --- Page Title Overlay --- //
        // -------------------------- //
        $wp_setting_name = 'page_title_overlay_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show overlay', 'energium'),
                'section'   => 'energium_page_title_general',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'energium'),
                    'off'       => esc_html__('No', 'energium')
                )
            )
        ));

        // -------------------------------- //
        // --- Page Title Overlay Color --- //
        // -------------------------------- //
        $wp_setting_name = 'page_title_overlay_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Energium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Overlay color', 'energium'),
                'section'       => 'energium_page_title_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'page_title_overlay_status',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ---------------------------- //
        // --- Page Title Customize --- //
        // ---------------------------- //
        $wp_setting_name = 'page_title_customize';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Customize', 'energium'),
                'section'   => 'energium_page_title_general',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'energium'),
                    'off'       => esc_html__('No', 'energium')
                ),
                'separator' => 'before'
            )
        ));

        // ------------------------------- //
        // --- Page Title Block Height --- //
        // ------------------------------- //
        $wp_setting_name = 'page_title_height';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Page title height, in px', 'energium'),
                'section'       => 'energium_page_title_general',
                'type'          => 'number',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'page_title_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------------------------- //
        // --- Page Title Default Text Color --- //
        // ------------------------------------- //
        $wp_setting_name = 'page_title_default_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Energium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Default text color', 'energium'),
                'section'       => 'energium_page_title_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'page_title_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ],
                'separator'     => 'before'
            )
        ));

        // ---------------------------------- //
        // --- Page Title Dark Text Color --- //
        // ---------------------------------- //
        $wp_setting_name = 'page_title_dark_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Energium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Dark text color', 'energium'),
                'section'       => 'energium_page_title_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'page_title_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ----------------------------------- //
        // --- Page Title Light Text Color --- //
        // ----------------------------------- //
        $wp_setting_name = 'page_title_light_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Energium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Light text color', 'energium'),
                'section'       => 'energium_page_title_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'page_title_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------------------------ //
        // --- Page Title Accent Text Color --- //
        // ------------------------------------ //
        $wp_setting_name = 'page_title_accent_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Energium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Accent text color', 'energium'),
                'section'       => 'energium_page_title_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'page_title_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ----------------------------------- //
        // --- Page Title Hover Text Color --- //
        // ----------------------------------- //
        $wp_setting_name = 'page_title_hover_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Energium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Hover text color', 'energium'),
                'section'       => 'energium_page_title_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'page_title_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------------------- //
        // --- Page Title Border Color --- //
        // ------------------------------- //
        $wp_setting_name = 'page_title_border_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Energium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Border color', 'energium'),
                'section'       => 'energium_page_title_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'page_title_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ],
                'separator'     => 'before'
            )
        ));

        // --------------------------------------- //
        // --- Page Title Hovered Border Color --- //
        // --------------------------------------- //
        $wp_setting_name = 'page_title_border_hover_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Energium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Hovered border color', 'energium'),
                'section'       => 'energium_page_title_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'page_title_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ----------------------------------- //
        // --- Page Title Background Color --- //
        // ----------------------------------- //
        $wp_setting_name = 'page_title_background_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Energium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Background color', 'energium'),
                'section'       => 'energium_page_title_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'page_title_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ],
                'separator'     => 'before'
            )
        ));

        // ----------------------------------------------- //
        // --- Page Title Alternative Background Color --- //
        // ----------------------------------------------- //
        $wp_setting_name = 'page_title_background_alter_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Energium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Alternative background color', 'energium'),
                'section'       => 'energium_page_title_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'page_title_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------------------------ //
        // --- Page Title Button Text Color --- //
        // ------------------------------------ //
        $wp_setting_name = 'page_title_button_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Energium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Text Color', 'energium'),
                'section'       => 'energium_page_title_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'page_title_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ],
                'separator'     => 'before'
            )
        ));

        // -------------------------------------- //
        // --- Page Title Button Border Color --- //
        // -------------------------------------- //
        $wp_setting_name = 'page_title_button_border_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Energium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Border Color', 'energium'),
                'section'       => 'energium_page_title_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'page_title_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------------------------------ //
        // --- Page Title Button Background Color --- //
        // ------------------------------------------ //
        $wp_setting_name = 'page_title_button_background_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Energium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Background Color', 'energium'),
                'section'       => 'energium_page_title_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'page_title_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------------------------ //
        // --- Page Title Button Text Hover --- //
        // ------------------------------------ //
        $wp_setting_name = 'page_title_button_text_hover';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Energium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Text Hover', 'energium'),
                'section'       => 'energium_page_title_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'page_title_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // -------------------------------------- //
        // --- Page Title Button Border Hover --- //
        // -------------------------------------- //
        $wp_setting_name = 'page_title_button_border_hover';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Energium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Border Hover', 'energium'),
                'section'       => 'energium_page_title_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'page_title_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------------------------------ //
        // --- Page Title Button Background Hover --- //
        // ------------------------------------------ //
        $wp_setting_name = 'page_title_button_background_hover';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_color'
            )
        );
        $wp_customize->add_control(new Energium_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Background Hover', 'energium'),
                'section'       => 'energium_page_title_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'page_title_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ----------------------------------- //
        // --- Page Title Background Image --- //
        // ----------------------------------- //
        $wp_setting_name = 'page_title_background_image';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'esc_url_raw'
            )
        );
        $wp_customize->add_control(new Energium_Image_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Background Image', 'energium'),
                'section'       => 'energium_page_title_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'page_title_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ],
                'separator'     => 'before'
            )
        ));

        // -------------------------------------- //
        // --- Page Title Background Position --- //
        // -------------------------------------- //
        $wp_setting_name = 'page_title_background_position';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Background Position', 'energium'),
                'section'       => 'energium_page_title_general',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => energium_get_background_position_options(),
                'dependency'    => [
                    [
                        'control'   => 'page_title_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------------------------ //
        // --- Page Title Background Repeat --- //
        // ------------------------------------ //
        $wp_setting_name = 'page_title_background_repeat';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Background Repeat', 'energium'),
                'section'       => 'energium_page_title_general',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => energium_get_background_repeat_options(),
                'dependency'    => [
                    [
                        'control'   => 'page_title_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ---------------------------------- //
        // --- Page Title Background Size --- //
        // ---------------------------------- //
        $wp_setting_name = 'page_title_background_size';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Background Size', 'energium'),
                'section'       => 'energium_page_title_general',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => energium_get_background_size_options(),
                'dependency'    => [
                    [
                        'control'   => 'page_title_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ---------------------------------------------------- //
        // --- Hide Page Title Background on Mobile Devices --- //
        // ---------------------------------------------------- //
        $wp_setting_name = 'hide_page_title_background_mobile';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_checkbox'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Hide Background Image on Mobile Devices', 'energium'),
                'section'       => 'energium_page_title_general',
                'type'          => 'checkbox',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'page_title_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ---------------------------------------------------- //
        // --- Hide Page Title Background on Tablet Devices --- //
        // ---------------------------------------------------- //
        $wp_setting_name = 'hide_page_title_background_tablet';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_checkbox'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Hide Background Image on Tablet Devices', 'energium'),
                'section'       => 'energium_page_title_general',
                'type'          => 'checkbox',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'page_title_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));


        // ---########################--- //
        // ---### Heading Settings ###--- //
        // ---########################--- //
        $wp_customize->add_section('energium_page_title_heading',
            array(
                'title' => esc_html__('Heading', 'energium'),
                'panel' => 'energium_page_title_settings'
            )
        );

        // ------------------------------------ //
        // --- Page Title Heading Customize --- //
        // ------------------------------------ //
        $wp_setting_name = 'page_title_heading_customize';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Customize', 'energium'),
                'section'       => 'energium_page_title_heading',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => array(
                    'on'        => esc_html__('Yes', 'energium'),
                    'off'       => esc_html__('No', 'energium')
                )
            )
        ));

        // ------------------------------- //
        // --- Page Title Heading Icon --- //
        // ------------------------------- //
        $wp_setting_name = 'page_title_heading_icon_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Add Image Icon before Title', 'energium'),
                'section'       => 'energium_page_title_heading',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => array(
                    'on'        => esc_html__('Yes', 'energium'),
                    'off'       => esc_html__('No', 'energium')
                ),
                'dependency'    => [
                    [
                        'control'   => 'page_title_heading_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------------------------- //
        // --- Page Title Heading Icon Image --- //
        // ------------------------------------- //
        $wp_setting_name = 'page_title_heading_icon_image';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'esc_url_raw'
            )
        );
        $wp_customize->add_control(new Energium_Image_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Icon Image', 'energium'),
                'section'       => 'energium_page_title_heading',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'page_title_heading_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ],
                    [
                        'control'   => 'page_title_heading_icon_status',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ],
                'separator'     => 'before'
            )
        ));

        // ------------------------------- //
        // --- Page Title Heading Font --- //
        // ------------------------------- //
        $wp_setting_name = 'page_title_heading_font';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Google_Font_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Heading Font', 'energium'),
                'section'       => 'energium_page_title_heading',
                'settings'      => $wp_setting_name,
                'show_field'    => [
                    'font_family'       => true,
                    'font_backup'       => true,
                    'font_styles'       => true,
                    'font_subset'       => true,
                    'font_size'         => true,
                    'line_height'       => true,
                    'text_transform'    => true,
                    'letter_spacing'    => true,
                    'word_spacing'      => true,
                    'font_style'        => true,
                    'font_weight'       => true
                ],
                'dependency'            => [
                    [
                        'control'           => 'page_title_heading_customize',
                        'operator'          => '==',
                        'value'             => 'on'
                    ]
                ]
            )
        ));


        // -------------------------------- //
        // ---------- Typography ---------- //
        // -------------------------------- //
        $wp_customize->add_panel('energium_typography_settings',
            array(
                'title'     => esc_html__('Typography Settings', 'energium'),
                'priority'  => 140
            )
        );

        // ---#################--- //
        // ---### Main Font ###--- //
        // ---#################--- //
        $wp_customize->add_section('energium_typography_main_font',
            array(
                'title' => esc_html__('Main Font', 'energium'),
                'panel' => 'energium_typography_settings'
            )
        );

        // ----------------- //
        // --- Main Font --- //
        // ----------------- //
        $wp_setting_name = 'main_font';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Google_Font_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Main Font', 'energium'),
                'section'       => 'energium_typography_main_font',
                'settings'      => $wp_setting_name,
                'show_field'    => [
                    'font_family'       => true,
                    'font_backup'       => true,
                    'font_styles'       => true,
                    'font_subset'       => true,
                    'font_size'         => true,
                    'line_height'       => true,
                    'text_transform'    => true,
                    'letter_spacing'    => true,
                    'word_spacing'      => true,
                    'font_style'        => true,
                    'font_weight'       => true
                ]
            )
        ));

        // ---#######################--- //
        // ---### Additional Font ###--- //
        // ---#######################--- //
        $wp_customize->add_section('energium_typography_additional_font',
            array(
                'title' => esc_html__('Additional Font', 'energium'),
                'panel' => 'energium_typography_settings'
            )
        );

        // ----------------------- //
        // --- Additional Font --- //
        // ----------------------- //
        $wp_setting_name = 'additional_font';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Google_Font_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Additional Font', 'energium'),
                'section'       => 'energium_typography_additional_font',
                'settings'      => $wp_setting_name,
                'show_field'    => [
                    'font_family'       => true,
                    'font_backup'       => true,
                    'font_styles'       => true,
                    'font_subset'       => true,
                    'font_weight'       => true
                ]
            )
        ));

        // ---################--- //
        // ---### Headings ###--- //
        // ---################--- //
        $wp_customize->add_section('energium_typography_headings',
            array(
                'title' => esc_html__('Headings', 'energium'),
                'panel' => 'energium_typography_settings'
            )
        );

        // --------------------- //
        // --- Headings Font --- //
        // --------------------- //
        $wp_setting_name = 'headings_font';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Google_Font_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Headings Font', 'energium'),
                'section'       => 'energium_typography_headings',
                'settings'      => $wp_setting_name,
                'show_field'    => [
                    'font_family'       => true,
                    'font_backup'       => true,
                    'font_styles'       => true,
                    'font_subset'       => true,
                    'text_transform'    => true,
                    'font_style'        => true
                ]
            )
        ));

        // --------------- //
        // --- H1 Font --- //
        // --------------- //
        $wp_setting_name = 'h1_font';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Google_Font_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('H1 Font', 'energium'),
                'section'       => 'energium_typography_headings',
                'settings'      => $wp_setting_name,
                'show_field'    => [
                    'font_size'         => true,
                    'line_height'       => true,
                    'letter_spacing'    => true,
                    'word_spacing'      => true,
                    'font_weight'       => true
                ],
                'separator'             => 'before'
            )
        ));

        // --------------- //
        // --- H2 Font --- //
        // --------------- //
        $wp_setting_name = 'h2_font';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Google_Font_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('H2 Font', 'energium'),
                'section'       => 'energium_typography_headings',
                'settings'      => $wp_setting_name,
                'show_field'    => [
                    'font_size'         => true,
                    'line_height'       => true,
                    'letter_spacing'    => true,
                    'word_spacing'      => true,
                    'font_weight'       => true
                ],
                'separator'             => 'before'
            )
        ));

        // --------------- //
        // --- H3 Font --- //
        // --------------- //
        $wp_setting_name = 'h3_font';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Google_Font_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('H3 Font', 'energium'),
                'section'       => 'energium_typography_headings',
                'settings'      => $wp_setting_name,
                'show_field'    => [
                    'font_size'         => true,
                    'line_height'       => true,
                    'letter_spacing'    => true,
                    'word_spacing'      => true,
                    'font_weight'       => true
                ],
                'separator'             => 'before'
            )
        ));

        // --------------- //
        // --- H4 Font --- //
        // --------------- //
        $wp_setting_name = 'h4_font';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Google_Font_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('H4 Font', 'energium'),
                'section'       => 'energium_typography_headings',
                'settings'      => $wp_setting_name,
                'show_field'    => [
                    'font_size'         => true,
                    'line_height'       => true,
                    'letter_spacing'    => true,
                    'word_spacing'      => true,
                    'font_weight'       => true
                ],
                'separator'             => 'before'
            )
        ));

        // --------------- //
        // --- H5 Font --- //
        // --------------- //
        $wp_setting_name = 'h5_font';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Google_Font_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('H5 Font', 'energium'),
                'section'       => 'energium_typography_headings',
                'settings'      => $wp_setting_name,
                'show_field'    => [
                    'font_size'         => true,
                    'line_height'       => true,
                    'letter_spacing'    => true,
                    'word_spacing'      => true,
                    'font_weight'       => true
                ],
                'separator'             => 'before'
            )
        ));

        // --------------- //
        // --- H6 Font --- //
        // --------------- //
        $wp_setting_name = 'h6_font';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Google_Font_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('H6 Font', 'energium'),
                'section'       => 'energium_typography_headings',
                'settings'      => $wp_setting_name,
                'show_field'    => [
                    'font_size'         => true,
                    'line_height'       => true,
                    'letter_spacing'    => true,
                    'word_spacing'      => true,
                    'font_weight'       => true
                ],
                'separator'             => 'before'
            )
        ));

        // ---###############--- //
        // ---### Buttons ###--- //
        // ---###############--- //
        $wp_customize->add_section('energium_typography_buttons',
            array(
                'title' => esc_html__('Buttons', 'energium'),
                'panel' => 'energium_typography_settings'
            )
        );

        // --------------------------- //
        // --- Buttons Font Family --- //
        // --------------------------- //
        $wp_setting_name = 'buttons_font';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Google_Font_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Buttons Font', 'energium'),
                'section'       => 'energium_typography_buttons',
                'settings'      => $wp_setting_name,
                'show_field'    => [
                    'font_family'       => true,
                    'font_backup'       => true,
                    'font_styles'       => true,
                    'font_subset'       => true,
                    'font_size'         => true,
                    'text_transform'    => true,
                    'letter_spacing'    => true,
                    'word_spacing'      => true,
                    'font_style'        => true,
                    'font_weight'       => true
                ]
            )
        ));


        // ---------------------------------- //
        // ---------- Social Links ---------- //
        // ---------------------------------- //
        $wp_customize->add_section('energium_socials_settings',
            array(
                'title'     => esc_html__('Social Links', 'energium'),
                'priority'  => 145
            )
        );

        // ---------------------- //
        // --- Socials Target --- //
        // ---------------------- //
        $wp_setting_name = 'socials_target';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_checkbox'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Open Socials in New Tab', 'energium'),
                'section'       => 'energium_socials_settings',
                'type'          => 'checkbox',
                'settings'      => $wp_setting_name
            )
        ));

        // ---------------------- //
        // --- Social Buttons --- //
        // ---------------------- //
        $wp_setting_name = 'social_buttons';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'sanitize_callback' => 'energium_sanitize_repeater'
            )
        );
        $wp_customize->add_control( new Energium_Customize_Socials_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'                 => esc_html__('Social Buttons', 'energium'),
                'section'               => 'energium_socials_settings',
                'separator'             => 'before'
            )
        ));


        // ------------------------------------ //
        // ---------- Color Settings ---------- //
        // ------------------------------------ //
        $wp_customize->add_panel('energium_color_settings',
            array(
                'title'     => esc_html__('Color Settings', 'energium'),
                'priority'  => 150
            )
        );

        // ---################--- //
        // ---### STANDARD ###--- //
        // ---################--- //
        $wp_customize->add_section('energium_standard_colors',
            array(
                'title' => esc_html__('Standard Colors', 'energium'),
                'panel' => 'energium_color_settings'
            )
        );

        // ----------------------------------- //
        // --- Standard Default Text Color --- //
        // ----------------------------------- //
        $wp_setting_name = 'standard_default_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Energium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Default Text Color', 'energium'),
                'section'       => 'energium_standard_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => energium_get_custom_color_palette()
            )
        ));

        // -------------------------------- //
        // --- Standard Dark Text Color --- //
        // -------------------------------- //
        $wp_setting_name = 'standard_dark_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Energium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Dark Text Color', 'energium'),
                'section'       => 'energium_standard_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => energium_get_custom_color_palette()
            )
        ));

        // --------------------------------- //
        // --- Standard Light Text Color --- //
        // --------------------------------- //
        $wp_setting_name = 'standard_light_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Energium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Light Text Color', 'energium'),
                'section'       => 'energium_standard_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => energium_get_custom_color_palette()
            )
        ));

        // ---------------------------------- //
        // --- Standard Accent Text Color --- //
        // ---------------------------------- //
        $wp_setting_name = 'standard_accent_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Energium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Accent Text Color', 'energium'),
                'section'       => 'energium_standard_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => energium_get_custom_color_palette()
            )
        ));

        // --------------------------------- //
        // --- Standard Hover Text Color --- //
        // --------------------------------- //
        $wp_setting_name = 'standard_hover_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Energium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Hover Text Color', 'energium'),
                'section'       => 'energium_standard_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => energium_get_custom_color_palette()
            )
        ));

        // ----------------------------- //
        // --- Standard Border Color --- //
        // ----------------------------- //
        $wp_setting_name = 'standard_border_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Energium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Border Color', 'energium'),
                'section'       => 'energium_standard_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => energium_get_custom_color_palette(),
                'separator'     => 'before'
            )
        ));

        // ----------------------------------- //
        // --- Standard Border Hover Color --- //
        // ----------------------------------- //
        $wp_setting_name = 'standard_border_hover_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Energium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Border Hover Color', 'energium'),
                'section'       => 'energium_standard_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => energium_get_custom_color_palette()
            )
        ));

        // --------------------------------- //
        // --- Standard Background Color --- //
        // --------------------------------- //
        $wp_setting_name = 'standard_background_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Energium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Background Color', 'energium'),
                'section'       => 'energium_standard_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => energium_get_custom_color_palette(),
                'separator'     => 'before'
            )
        ));

        // --------------------------------------- //
        // --- Standard Background Alter Color --- //
        // --------------------------------------- //
        $wp_setting_name = 'standard_background_alter_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Energium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Alternative Background Color', 'energium'),
                'section'       => 'energium_standard_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => energium_get_custom_color_palette()
            )
        ));

        // ---------------------------------- //
        // --- Standard Button Text Color --- //
        // ---------------------------------- //
        $wp_setting_name = 'standard_button_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Energium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Text Color', 'energium'),
                'section'       => 'energium_standard_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => energium_get_custom_color_palette(),
                'separator'     => 'before'
            )
        ));

        // ------------------------------------ //
        // --- Standard Button Border Color --- //
        // ------------------------------------ //
        $wp_setting_name = 'standard_button_border_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Energium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Border Color', 'energium'),
                'section'       => 'energium_standard_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => energium_get_custom_color_palette()
            )
        ));

        // ---------------------------------------- //
        // --- Standard Button Background Color --- //
        // ---------------------------------------- //
        $wp_setting_name = 'standard_button_background_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Energium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Background Color', 'energium'),
                'section'       => 'energium_standard_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => energium_get_custom_color_palette()
            )
        ));

        // ---------------------------------- //
        // --- Standard Button Text Hover --- //
        // ---------------------------------- //
        $wp_setting_name = 'standard_button_text_hover';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Energium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Text Hover', 'energium'),
                'section'       => 'energium_standard_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => energium_get_custom_color_palette()
            )
        ));

        // ------------------------------------ //
        // --- Standard Button Border Hover --- //
        // ------------------------------------ //
        $wp_setting_name = 'standard_button_border_hover';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Energium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Border Hover', 'energium'),
                'section'       => 'energium_standard_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => energium_get_custom_color_palette()
            )
        ));

        // ---------------------------------------- //
        // --- Standard Button Background Hover --- //
        // ---------------------------------------- //
        $wp_setting_name = 'standard_button_background_hover';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Energium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Background Hover', 'energium'),
                'section'       => 'energium_standard_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => energium_get_custom_color_palette()
            )
        ));

        // ---################--- //
        // ---### CONTRAST ###--- //
        // ---################--- //
        $wp_customize->add_section('energium_contrast_colors',
            array(
                'title' => esc_html__('Contrast Colors', 'energium'),
                'panel' => 'energium_color_settings'
            )
        );

        // ----------------------------------- //
        // --- Contrast Default Text Color --- //
        // ----------------------------------- //
        $wp_setting_name = 'contrast_default_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Energium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Default Text Color', 'energium'),
                'section'       => 'energium_contrast_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => energium_get_custom_color_palette()
            )
        ));

        // -------------------------------- //
        // --- Contrast Dark Text Color --- //
        // -------------------------------- //
        $wp_setting_name = 'contrast_dark_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Energium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Dark Text Color', 'energium'),
                'section'       => 'energium_contrast_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => energium_get_custom_color_palette()
            )
        ));

        // --------------------------------- //
        // --- Contrast Light Text Color --- //
        // --------------------------------- //
        $wp_setting_name = 'contrast_light_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Energium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Light Text Color', 'energium'),
                'section'       => 'energium_contrast_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => energium_get_custom_color_palette()
            )
        ));

        // ---------------------------------- //
        // --- Contrast Accent Text Color --- //
        // ---------------------------------- //
        $wp_setting_name = 'contrast_accent_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Energium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Accent Text Color', 'energium'),
                'section'       => 'energium_contrast_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => energium_get_custom_color_palette()
            )
        ));

        // --------------------------------- //
        // --- Contrast Hover Text Color --- //
        // --------------------------------- //
        $wp_setting_name = 'contrast_hover_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Energium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Hover Text Color', 'energium'),
                'section'       => 'energium_contrast_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => energium_get_custom_color_palette()
            )
        ));

        // ----------------------------- //
        // --- Contrast Border Color --- //
        // ----------------------------- //
        $wp_setting_name = 'contrast_border_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Energium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Border Color', 'energium'),
                'section'       => 'energium_contrast_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => energium_get_custom_color_palette(),
                'separator'     => 'before'
            )
        ));

        // ----------------------------------- //
        // --- Contrast Border Hover Color --- //
        // ----------------------------------- //
        $wp_setting_name = 'contrast_border_hover_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Energium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Border Hover Color', 'energium'),
                'section'       => 'energium_contrast_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => energium_get_custom_color_palette()
            )
        ));

        // --------------------------------- //
        // --- Contrast Background Color --- //
        // --------------------------------- //
        $wp_setting_name = 'contrast_background_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Energium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Background Color', 'energium'),
                'section'       => 'energium_contrast_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => energium_get_custom_color_palette(),
                'separator'     => 'before'
            )
        ));

        // --------------------------------------- //
        // --- Contrast Background Alter Color --- //
        // --------------------------------------- //
        $wp_setting_name = 'contrast_background_alter_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Energium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Alternative Background Color', 'energium'),
                'section'       => 'energium_contrast_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => energium_get_custom_color_palette()
            )
        ));

        // ---------------------------------- //
        // --- Contrast Button Text Color --- //
        // ---------------------------------- //
        $wp_setting_name = 'contrast_button_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Energium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Text Color', 'energium'),
                'section'       => 'energium_contrast_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => energium_get_custom_color_palette(),
                'separator'     => 'before'
            )
        ));

        // ------------------------------------ //
        // --- Contrast Button Border Color --- //
        // ------------------------------------ //
        $wp_setting_name = 'contrast_button_border_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Energium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Border Color', 'energium'),
                'section'       => 'energium_contrast_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => energium_get_custom_color_palette()
            )
        ));

        // ---------------------------------------- //
        // --- Contrast Button Background Color --- //
        // ---------------------------------------- //
        $wp_setting_name = 'contrast_button_background_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Energium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Background Color', 'energium'),
                'section'       => 'energium_contrast_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => energium_get_custom_color_palette()
            )
        ));

        // ---------------------------------- //
        // --- Contrast Button Text Hover --- //
        // ---------------------------------- //
        $wp_setting_name = 'contrast_button_text_hover';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Energium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Text Hover', 'energium'),
                'section'       => 'energium_contrast_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => energium_get_custom_color_palette()
            )
        ));

        // ------------------------------------ //
        // --- Contrast Button Border Hover --- //
        // ------------------------------------ //
        $wp_setting_name = 'contrast_button_border_hover';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Energium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Border Hover', 'energium'),
                'section'       => 'energium_contrast_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => energium_get_custom_color_palette()
            )
        ));

        // ---------------------------------------- //
        // --- Contrast Button Background Hover --- //
        // ---------------------------------------- //
        $wp_setting_name = 'contrast_button_background_hover';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Energium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Background Hover', 'energium'),
                'section'       => 'energium_contrast_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => energium_get_custom_color_palette()
            )
        ));


        // ------------------------------------------- //
        // ---------- Footer Settings Panel ---------- //
        // ------------------------------------------- //
        $wp_customize->add_panel('energium_footer_settings',
            array(
                'title'     => esc_html__('Footer Settings', 'energium'),
                'priority'  => 160
            )
        );

        // ---###############--- //
        // ---### General ###--- //
        // ---###############--- //
        $wp_customize->add_section('energium_footer_general',
            array(
                'title' => esc_html__('General', 'energium'),
                'panel' => 'energium_footer_settings'
            )
        );

        // --------------------- //
        // --- Footer Status --- //
        // --------------------- //
        $wp_setting_name = 'footer_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Footer', 'energium'),
                'section'   => 'energium_footer_general',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'energium'),
                    'off'       => esc_html__('No', 'energium')
                )
            )
        ));

        // -------------------- //
        // --- Footer Style --- //
        // -------------------- //
        $wp_setting_name = 'footer_style';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Footer Style', 'energium'),
                'section'       => 'energium_footer_general',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => array(
                    'type-1'        => esc_html__('Style 1', 'energium'),
                    'type-2'        => esc_html__('Style 2', 'energium'),
                    'type-3'        => esc_html__('Style 3', 'energium'),
                    'type-4'        => esc_html__('Style 4', 'energium')
                ),
                'dependency'    => [
                    [
                        'control'   => 'footer_status',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------------ //
        // --- Footer Customize --- //
        // ------------------------ //
        $wp_setting_name = 'footer_customize';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Customize', 'energium'),
                'section'   => 'energium_footer_general',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'energium'),
                    'off'       => esc_html__('No', 'energium')
                )
            )
        ));

        // --------------------------------- //
        // --- Footer Default Text Color --- //
        // --------------------------------- //
        $wp_setting_name = 'footer_default_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Energium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Default Text Color', 'energium'),
                'section'       => 'energium_footer_general',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => energium_get_custom_color_palette(),
                'dependency'    => [
                    [
                        'control'   => 'footer_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ],
                'separator'     => 'before'
            )
        ));

        // ------------------------------ //
        // --- Footer Dark Text Color --- //
        // ------------------------------ //
        $wp_setting_name = 'footer_dark_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Energium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Dark Text Color', 'energium'),
                'section'       => 'energium_footer_general',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => energium_get_custom_color_palette(),
                'dependency'    => [
                    [
                        'control'   => 'footer_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------------------- //
        // --- Footer Light Text Color --- //
        // ------------------------------- //
        $wp_setting_name = 'footer_light_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Energium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Light Text Color', 'energium'),
                'section'       => 'energium_footer_general',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => energium_get_custom_color_palette(),
                'dependency'    => [
                    [
                        'control'   => 'footer_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // -------------------------------- //
        // --- Footer Accent Text Color --- //
        // -------------------------------- //
        $wp_setting_name = 'footer_accent_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Energium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Accent Text Color', 'energium'),
                'section'       => 'energium_footer_general',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => energium_get_custom_color_palette(),
                'dependency'    => [
                    [
                        'control'   => 'footer_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------------------- //
        // --- Footer Hover Text Color --- //
        // ------------------------------- //
        $wp_setting_name = 'footer_hover_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Energium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Hover Text Color', 'energium'),
                'section'       => 'energium_footer_general',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => energium_get_custom_color_palette(),
                'dependency'    => [
                    [
                        'control'   => 'footer_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // -------------------------------- //
        // --- Footer Border Text Color --- //
        // -------------------------------- //
        $wp_setting_name = 'footer_border_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Energium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Border Color', 'energium'),
                'section'       => 'energium_footer_general',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => energium_get_custom_color_palette(),
                'dependency'    => [
                    [
                        'control'   => 'footer_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ],
                'separator'     => 'before'
            )
        ));

        // ---------------------------------------- //
        // --- Footer Hovered Border Text Color --- //
        // ---------------------------------------- //
        $wp_setting_name = 'footer_border_hover_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Energium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Hovered Border Color', 'energium'),
                'section'       => 'energium_footer_general',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => energium_get_custom_color_palette(),
                'dependency'    => [
                    [
                        'control'   => 'footer_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------------------- //
        // --- Footer Background Color --- //
        // ------------------------------- //
        $wp_setting_name = 'footer_background_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Energium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Background Color', 'energium'),
                'section'       => 'energium_footer_general',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => energium_get_custom_color_palette(),
                'dependency'    => [
                    [
                        'control'   => 'footer_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ],
                'separator'     => 'before'
            )
        ));

        // ------------------------------------------- //
        // --- Footer Alternative Background Color --- //
        // ------------------------------------------- //
        $wp_setting_name = 'footer_background_alter_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Energium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Alternative Background Color', 'energium'),
                'section'       => 'energium_footer_general',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => energium_get_custom_color_palette(),
                'dependency'    => [
                    [
                        'control'   => 'footer_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------------------------ //
        // --- Page Title Button Text Color --- //
        // ------------------------------------ //
        $wp_setting_name = 'page_title_button_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Energium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Text Color', 'energium'),
                'section'       => 'energium_footer_general',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => energium_get_custom_color_palette(),
                'dependency'    => [
                    [
                        'control'   => 'footer_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ],
                'separator'     => 'before'
            )
        ));

        // ---------------------------------- //
        // --- Footer Button Border Color --- //
        // ---------------------------------- //
        $wp_setting_name = 'footer_button_border_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Energium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Border Color', 'energium'),
                'section'       => 'energium_footer_general',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => energium_get_custom_color_palette(),
                'dependency'    => [
                    [
                        'control'   => 'footer_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // -------------------------------------- //
        // --- Footer Button Background Color --- //
        // -------------------------------------- //
        $wp_setting_name = 'footer_button_background_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Energium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Background Color', 'energium'),
                'section'       => 'energium_footer_general',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => energium_get_custom_color_palette(),
                'dependency'    => [
                    [
                        'control'   => 'footer_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // -------------------------------- //
        // --- Footer Button Text Hover --- //
        // -------------------------------- //
        $wp_setting_name = 'footer_button_text_hover';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Energium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Text Hover', 'energium'),
                'section'       => 'energium_footer_general',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => energium_get_custom_color_palette(),
                'dependency'    => [
                    [
                        'control'   => 'footer_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ---------------------------------- //
        // --- Footer Button Border Hover --- //
        // ---------------------------------- //
        $wp_setting_name = 'footer_button_border_hover';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Energium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Border Hover', 'energium'),
                'section'       => 'energium_footer_general',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => energium_get_custom_color_palette(),
                'dependency'    => [
                    [
                        'control'   => 'footer_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // -------------------------------------- //
        // --- Footer Button Background Hover --- //
        // -------------------------------------- //
        $wp_setting_name = 'footer_button_background_hover';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Energium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Background Hover', 'energium'),
                'section'       => 'energium_footer_general',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => energium_get_custom_color_palette(),
                'dependency'    => [
                    [
                        'control'   => 'footer_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------------------- //
        // --- Footer Background Image --- //
        // ------------------------------- //
        $wp_setting_name = 'footer_background_image';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'esc_url_raw'
            )
        );
        $wp_customize->add_control(new Energium_Image_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Bottom Image', 'energium'),
                'section'       => 'energium_footer_general',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'footer_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ],
                'separator'     => 'before'
            )
        ));

        // ---------------------------------- //
        // --- Footer Background Position --- //
        // ---------------------------------- //
        $wp_setting_name = 'footer_background_position';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Background Position', 'energium'),
                'section'       => 'energium_footer_general',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => energium_get_background_position_options(),
                'dependency'    => [
                    [
                        'control'   => 'footer_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // -------------------------------- //
        // --- Footer Background Repeat --- //
        // -------------------------------- //
        $wp_setting_name = 'footer_background_repeat';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Background Repeat', 'energium'),
                'section'       => 'energium_footer_general',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => energium_get_background_repeat_options(),
                'dependency'    => [
                    [
                        'control'   => 'footer_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------------------ //
        // --- Footer Background Size --- //
        // ------------------------------ //
        $wp_setting_name = 'footer_background_size';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Background Size', 'energium'),
                'section'       => 'energium_footer_general',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => energium_get_background_size_options(),
                'dependency'    => [
                    [
                        'control'   => 'footer_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));


        // ---######################--- //
        // ---### Footer Widgets ###--- //
        // ---######################--- //
        $wp_customize->add_section('energium_footer_sidebar',
            array(
                'title' => esc_html__('Footer Sidebar', 'energium'),
                'panel' => 'energium_footer_settings'
            )
        );

        // ----------------------------- //
        // --- Footer Widgets Status --- //
        // ----------------------------- //
        $wp_setting_name = 'footer_sidebar_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Footer Widgets', 'energium'),
                'section'   => 'energium_footer_sidebar',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'energium'),
                    'off'       => esc_html__('No', 'energium')
                )
            )
        ));

        // ----------------------------- //
        // --- Footer Sidebar Select --- //
        // ----------------------------- //
        $wp_setting_name = 'footer_sidebar_select';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Select Sidebar', 'energium'),
                'section'       => 'energium_footer_sidebar',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => energium_get_all_sidebar_list(),
                'dependency'    => [
                    [
                        'control'   => 'footer_sidebar_status',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));


        // ---#################--- //
        // ---### Copyright ###--- //
        // ---#################--- //
        $wp_customize->add_section('energium_footer_copyright',
            array(
                'title' => esc_html__('Copyright', 'energium'),
                'panel' => 'energium_footer_settings'
            )
        );

        // ------------------------ //
        // --- Copyright Status --- //
        // ------------------------ //
        $wp_setting_name = 'footer_copyright_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Copyright', 'energium'),
                'section'   => 'energium_footer_copyright',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'energium'),
                    'off'       => esc_html__('No', 'energium')
                )
            )
        ));

        // ---------------------- //
        // --- Copyright Text --- //
        // ---------------------- //
        $wp_setting_name = 'footer_copyright_text';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Copyright Text', 'energium'),
                'section'       => 'energium_footer_copyright',
                'type'          => 'text',
                'settings'      => $wp_setting_name
            )
        ));

        // ---###################--- //
        // ---### Footer Menu ###--- //
        // ---###################--- //
        $wp_customize->add_section('energium_footer_menu',
            array(
                'title' => esc_html__('Footer Menu', 'energium'),
                'panel' => 'energium_footer_settings'
            )
        );

        // -------------------------- //
        // --- Footer Menu Status --- //
        // -------------------------- //
        $wp_setting_name = 'footer_menu_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Footer Menu', 'energium'),
                'section'   => 'energium_footer_menu',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'energium'),
                    'off'       => esc_html__('No', 'energium')
                )
            )
        ));

        // -------------------------- //
        // --- Footer Menu Select --- //
        // -------------------------- //
        $wp_setting_name = 'footer_menu_select';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Select Menu', 'energium'),
                'section'   => 'energium_footer_menu',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => energium_get_all_menu_list()
            )
        ));

        // ---##############################--- //
        // ---### Footer Additional Menu ###--- //
        // ---##############################--- //
        $wp_customize->add_section('energium_footer_additional_menu',
            array(
                'title' => esc_html__('Footer Additional Menu', 'energium'),
                'panel' => 'energium_footer_settings'
            )
        );

        // ------------------------------------- //
        // --- Footer Additional Menu Status --- //
        // ------------------------------------- //
        $wp_setting_name = 'footer_additional_menu_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Additional Footer Menu', 'energium'),
                'section'   => 'energium_footer_additional_menu',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'energium'),
                    'off'       => esc_html__('No', 'energium')
                )
            )
        ));

        // ------------------------------------- //
        // --- Footer Additional Menu Select --- //
        // ------------------------------------- //
        $wp_setting_name = 'footer_additional_menu_select';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Select Menu', 'energium'),
                'section'   => 'energium_footer_additional_menu',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => energium_get_all_menu_list()
            )
        ));

        // ------------------------------ //
        // ---------- Sidebars ---------- //
        // ------------------------------ //
        $wp_customize->add_section('energium_sidebar_settings',
            array(
                'title'     => esc_html__('Sidebars', 'energium'),
                'priority'  => 190
            )
        );

        // ----------------------------- //
        // --- Page Sidebar Position --- //
        // ----------------------------- //
        $wp_setting_name = 'sidebar_position';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Page Sidebar Position', 'energium'),
                'section'   => 'energium_sidebar_settings',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'left'      => esc_html__('Left', 'energium'),
                    'right'     => esc_html__('Right', 'energium'),
                    'none'      => esc_html__('None', 'energium')
                )
            )
        ));

        // -------------------------------- //
        // --- Archive Sidebar Position --- //
        // -------------------------------- //
        $wp_setting_name = 'archive_sidebar_position';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Archive Sidebar Position', 'energium'),
                'section'   => 'energium_sidebar_settings',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'left'      => esc_html__('Left', 'energium'),
                    'right'     => esc_html__('Right', 'energium'),
                    'none'      => esc_html__('None', 'energium')
                )
            )
        ));

        // ------------------------------------ //
        // --- Single Post Sidebar Position --- //
        // ------------------------------------ //
        $wp_setting_name = 'post_sidebar_position';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Single Post Sidebar Position', 'energium'),
                'section'   => 'energium_sidebar_settings',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'left'      => esc_html__('Left', 'energium'),
                    'right'     => esc_html__('Right', 'energium'),
                    'none'      => esc_html__('None', 'energium')
                )
            )
        ));

        // -------------------------------- //
        // --- Service Sidebar Position --- //
        // -------------------------------- //
        $wp_setting_name = 'service_sidebar_position';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Service Sidebar Position', 'energium'),
                'section'   => 'energium_sidebar_settings',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'left'      => esc_html__('Left', 'energium'),
                    'right'     => esc_html__('Right', 'energium'),
                    'none'      => esc_html__('None', 'energium')
                )
            )
        ));

        if ( class_exists('WooCommerce')) {
            // -------------------------------------------- //
            // --- WooCommerce Catalog Sidebar Position --- //
            // -------------------------------------------- //
            $wp_setting_name = 'catalog_sidebar_position';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $energium_customizer_default_values[$wp_setting_name],
                    'sanitize_callback'	=> 'energium_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Energium_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'     => esc_html__('Catalog Sidebar Position', 'energium'),
                    'section'   => 'energium_sidebar_settings',
                    'type'      => 'select',
                    'settings'  => $wp_setting_name,
                    'choices'   => array(
                        'left'      => esc_html__('Left', 'energium'),
                        'right'     => esc_html__('Right', 'energium'),
                        'none'      => esc_html__('None', 'energium')
                    )
                )
            ));
        }

        // --------------------------------- //
        // ---------- Single Post ---------- //
        // --------------------------------- //
        $wp_customize->add_section('energium_single_post_settings',
            array(
                'title'     => esc_html__('Single Post', 'energium'),
                'priority'  => 200
            )
        );

        // ------------------------------ //
        // --- Single Post Page Title --- //
        // ------------------------------ //
        $wp_setting_name = 'post_page_title';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => stripslashes($energium_customizer_default_values[$wp_setting_name]),
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Single Post Page Title', 'energium'),
                'section'       => 'energium_single_post_settings',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'description'   => esc_html__('Use variable \'%s\' for display Post name', 'energium')
            )
        ));

        // ------------------------------- //
        // --- Post Media Image Status --- //
        // ------------------------------- //
        $wp_setting_name = 'post_media_image_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Media Image', 'energium'),
                'section'   => 'energium_single_post_settings',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'energium'),
                    'off'       => esc_html__('No', 'energium')
                )
            )
        ));

        // ---------------------------- //
        // --- Post Category Status --- //
        // ---------------------------- //
        $wp_setting_name = 'post_category_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Post Categories', 'energium'),
                'section'   => 'energium_single_post_settings',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'energium'),
                    'off'       => esc_html__('No', 'energium')
                )
            )
        ));

        // ------------------------ //
        // --- Post Date Status --- //
        // ------------------------ //
        $wp_setting_name = 'post_date_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Post Date', 'energium'),
                'section'   => 'energium_single_post_settings',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'energium'),
                    'off'       => esc_html__('No', 'energium')
                )
            )
        ));

        // -------------------------- //
        // --- Post Author Status --- //
        // -------------------------- //
        $wp_setting_name = 'post_author_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Post Author', 'energium'),
                'section'   => 'energium_single_post_settings',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'energium'),
                    'off'       => esc_html__('No', 'energium')
                )
            )
        ));

        // ------------------------- //
        // --- Post Title Status --- //
        // ------------------------- //
        $wp_setting_name = 'post_title_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Post Title', 'energium'),
                'section'   => 'energium_single_post_settings',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'energium'),
                    'off'       => esc_html__('No', 'energium')
                )
            )
        ));

        // ------------------------ //
        // --- Post Tags Status --- //
        // ------------------------ //
        $wp_setting_name = 'post_tags_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Post Tags', 'energium'),
                'section'   => 'energium_single_post_settings',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'energium'),
                    'off'       => esc_html__('No', 'energium')
                )
            )
        ));

        // --------------------------- //
        // --- Post Socials Status --- //
        // --------------------------- //
        $wp_setting_name = 'post_socials_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Post Social Buttons', 'energium'),
                'section'   => 'energium_single_post_settings',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'energium'),
                    'off'       => esc_html__('No', 'energium')
                )
            )
        ));

        // --------------------------- //
        // --- Recent Posts Status --- //
        // --------------------------- //
        $wp_setting_name = 'recent_posts_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Recent Posts', 'energium'),
                'section'   => 'energium_single_post_settings',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'energium'),
                    'off'       => esc_html__('No', 'energium')
                )
            )
        ));

        // ------------------------------ //
        // --- Recent Posts Customize --- //
        // ------------------------------ //
        $wp_setting_name = 'recent_posts_customize';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Customize', 'energium'),
                'section'   => 'energium_single_post_settings',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'energium'),
                    'off'       => esc_html__('No', 'energium')
                ),
                'separator' => 'before'
            )
        ));

        // ---------------------------- //
        // --- Recent Posts Heading --- //
        // ---------------------------- //
        $wp_setting_name = 'recent_posts_section_heading';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Recent Posts Section Title', 'energium'),
                'section'       => 'energium_single_post_settings',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'recent_posts_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ----------------------- //
        // --- Number of Posts --- //
        // ----------------------- //
        $wp_setting_name = 'recent_posts_number';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Number of Posts', 'energium'),
                'section'       => 'energium_single_post_settings',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => array(
                    '2'         => esc_html__('2 Items', 'energium'),
                    '3'         => esc_html__('3 Items', 'energium'),
                    '4'         => esc_html__('4 Items', 'energium')
                ),
                'dependency'    => [
                    [
                        'control'   => 'recent_posts_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ---------------- //
        // --- Order By --- //
        // ---------------- //
        $wp_setting_name = 'recent_posts_order_by';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Order By', 'energium'),
                'section'       => 'energium_single_post_settings',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => array(
                    'random'        => esc_html__('Random', 'energium'),
                    'date'          => esc_html__('Date', 'energium'),
                    'name'          => esc_html__('Name', 'energium')
                ),
                'dependency'    => [
                    [
                        'control'   => 'recent_posts_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------ //
        // --- Sort Order --- //
        // ------------------ //
        $wp_setting_name = 'recent_posts_order';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Sort Order', 'energium'),
                'section'       => 'energium_single_post_settings',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => array(
                    'desc'  => esc_html__('Descending', 'energium'),
                    'asc'   => esc_html__('Ascending', 'energium')
                ),
                'dependency'    => [
                    [
                        'control'   => 'recent_posts_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------------------ //
        // --- Show Recent Post Image --- //
        // ------------------------------ //
        $wp_setting_name = 'recent_posts_image';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Recent Posts Featured Image', 'energium'),
                'section'       => 'energium_single_post_settings',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => array(
                    'on'    => esc_html__('Show', 'energium'),
                    'off'   => esc_html__('Hide', 'energium')
                ),
                'dependency'    => [
                    [
                        'control'   => 'recent_posts_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // --------------------------------- //
        // --- Show Recent Post Category --- //
        // --------------------------------- //
        $wp_setting_name = 'recent_posts_category';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Recent Posts Categories', 'energium'),
                'section'       => 'energium_single_post_settings',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => array(
                    'on'    => esc_html__('Show', 'energium'),
                    'off'   => esc_html__('Hide', 'energium')
                ),
                'dependency'    => [
                    [
                        'control'   => 'recent_posts_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ----------------------------- //
        // --- Show Recent Post Date --- //
        // ----------------------------- //
        $wp_setting_name = 'recent_posts_date';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Recent Posts Date', 'energium'),
                'section'       => 'energium_single_post_settings',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => array(
                    'on'    => esc_html__('Show', 'energium'),
                    'off'   => esc_html__('Hide', 'energium')
                ),
                'dependency'    => [
                    [
                        'control'   => 'recent_posts_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------------------- //
        // --- Show Recent Post Author --- //
        // ------------------------------- //
        $wp_setting_name = 'recent_posts_author';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Recent Posts Author', 'energium'),
                'section'       => 'energium_single_post_settings',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => array(
                    'on'    => esc_html__('Show', 'energium'),
                    'off'   => esc_html__('Hide', 'energium')
                ),
                'dependency'    => [
                    [
                        'control'   => 'recent_posts_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------------------ //
        // --- Show Recent Post Title --- //
        // ------------------------------ //
        $wp_setting_name = 'recent_posts_title';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Recent Posts Title', 'energium'),
                'section'       => 'energium_single_post_settings',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => array(
                    'on'    => esc_html__('Show', 'energium'),
                    'off'   => esc_html__('Hide', 'energium')
                ),
                'dependency'    => [
                    [
                        'control'   => 'recent_posts_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // -------------------------------- //
        // --- Show Recent Post Excerpt --- //
        // -------------------------------- //
        $wp_setting_name = 'recent_posts_excerpt';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Recent Posts Excerpt', 'energium'),
                'section'       => 'energium_single_post_settings',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => array(
                    'on'    => esc_html__('Show', 'energium'),
                    'off'   => esc_html__('Hide', 'energium')
                ),
                'dependency'    => [
                    [
                        'control'   => 'recent_posts_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // --------------------------------------- //
        // --- Show Recent Post Excerpt Length --- //
        // --------------------------------------- //
        $wp_setting_name = 'recent_posts_excerpt_length';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'absint'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Recent Posts Excerpt Length', 'energium'),
                'section'       => 'energium_single_post_settings',
                'type'          => 'number',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'recent_posts_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ],
                'input_attrs' => [
                    'min'   => 0,
                    'step'  => 1
                ]
            )
        ));

        // ----------------------------- //
        // --- Show Recent Post Tags --- //
        // ----------------------------- //
        $wp_setting_name = 'recent_posts_tags';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Recent Posts Tags', 'energium'),
                'section'       => 'energium_single_post_settings',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => array(
                    'on'    => esc_html__('Show', 'energium'),
                    'off'   => esc_html__('Hide', 'energium')
                ),
                'dependency'    => [
                    [
                        'control'   => 'recent_posts_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ----------------------------------------- //
        // --- Show Recent Post Read More Button --- //
        // ----------------------------------------- //
        $wp_setting_name = 'recent_posts_more';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Recent Posts \'Read More\' Button', 'energium'),
                'section'       => 'energium_single_post_settings',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => array(
                    'on'    => esc_html__('Show', 'energium'),
                    'off'   => esc_html__('Hide', 'energium')
                ),
                'dependency'    => [
                    [
                        'control'   => 'recent_posts_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));


        // ------------------------------------- //
        // ---------- Portfolio Panel ---------- //
        // ------------------------------------- //
        $wp_customize->add_panel('energium_portfolio_settings',
            array(
                'title'     => esc_html__('Portfolio', 'energium'),
                'priority'  => 205
            )
        );

        // ---#########################--- //
        // ---### Portfolio Archive ###--- //
        // ---#########################--- //
        $wp_customize->add_section('energium_portfolio_archive',
            array(
                'title' => esc_html__('Archive Settings', 'energium'),
                'panel' => 'energium_portfolio_settings'
            )
        );

        // ------------------------------------ //
        // --- Portfolio Archive Page Title --- //
        // ------------------------------------ //
        $wp_setting_name = 'portfolio_archive_page_title';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => stripslashes($energium_customizer_default_values[$wp_setting_name]),
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Portfolio Archive Page Title', 'energium'),
                'section'       => 'energium_portfolio_archive',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'description'   => esc_html__('Use variable \'%s\' for display Post type name', 'energium')
            )
        ));

        // ---------------------------------------- //
        // --- Portfolio Archive Columns Number --- //
        // ---------------------------------------- //
        $wp_setting_name = 'portfolio_archive_columns_number';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'absint'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Portfolio Archive Columns Number', 'energium'),
                'section'       => 'energium_portfolio_archive',
                'type'          => 'number',
                'settings'      => $wp_setting_name,
                'input_attrs' => [
                    'min'   => 1,
                    'max'   => 4,
                    'step'  => 1
                ]
            )
        ));

        // ---------------------------------------- //
        // --- Portfolio Archive Posts per Page --- //
        // ---------------------------------------- //
        $wp_setting_name = 'portfolio_archive_posts_per_page';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'absint'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Portfolio Posts Per Page', 'energium'),
                'section'       => 'energium_portfolio_archive',
                'type'          => 'number',
                'settings'      => $wp_setting_name,
                'input_attrs' => [
                    'min'   => 1,
                    'step'  => 1
                ]
            )
        ));

        // ---########################--- //
        // ---### Portfolio Single ###--- //
        // ---########################--- //
        $wp_customize->add_section('energium_portfolio_single',
            array(
                'title' => esc_html__('Single Page Settings', 'energium'),
                'panel' => 'energium_portfolio_settings'
            )
        );

        // ------------------------------------ //
        // --- Portfolio Single Page Title --- //
        // ------------------------------------ //
        $wp_setting_name = 'portfolio_single_page_title';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => stripslashes($energium_customizer_default_values[$wp_setting_name]),
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Portfolio Single Page Title', 'energium'),
                'section'       => 'energium_portfolio_single',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'description'   => esc_html__('Use variable \'%s\' for display Post name', 'energium')
            )
        ));


        // ------------------------------------ //
        // ---------- Projects Panel ---------- //
        // ------------------------------------ //
        $wp_customize->add_panel('energium_projects_settings',
            array(
                'title'     => esc_html__('Projects', 'energium'),
                'priority'  => 206
            )
        );

        // ---########################--- //
        // ---### Projects Archive ###--- //
        // ---########################--- //
        $wp_customize->add_section('energium_project_archive',
            array(
                'title' => esc_html__('Archive Settings', 'energium'),
                'panel' => 'energium_projects_settings'
            )
        );

        // ---------------------------------- //
        // --- Project Archive Page Title --- //
        // ---------------------------------- //
        $wp_setting_name = 'project_archive_page_title';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => stripslashes($energium_customizer_default_values[$wp_setting_name]),
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Project Archive Page Title', 'energium'),
                'section'       => 'energium_project_archive',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'description'   => esc_html__('Use variable \'%s\' for display Post type name', 'energium')
            )
        ));

        // -------------------------------------- //
        // --- Project Archive Columns Number --- //
        // -------------------------------------- //
        $wp_setting_name = 'project_archive_columns_number';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'absint'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Project Archive Columns Number', 'energium'),
                'section'       => 'energium_project_archive',
                'type'          => 'number',
                'settings'      => $wp_setting_name,
                'input_attrs' => [
                    'min'   => 1,
                    'max'   => 4,
                    'step'  => 1
                ]
            )
        ));

        // -------------------------------------- //
        // --- Project Archive Posts per Page --- //
        // -------------------------------------- //
        $wp_setting_name = 'project_archive_posts_per_page';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'absint'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Project Posts Per Page', 'energium'),
                'section'       => 'energium_project_archive',
                'type'          => 'number',
                'settings'      => $wp_setting_name,
                'input_attrs' => [
                    'min'   => 1,
                    'step'  => 1
                ]
            )
        ));

        // ------------------------------------------- //
        // --- Project Archive Post Excerpt Length --- //
        // ------------------------------------------- //
        $wp_setting_name = 'project_archive_excerpt_length';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'absint'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Project Posts Excerpt Length', 'energium'),
                'section'       => 'energium_project_archive',
                'type'          => 'number',
                'settings'      => $wp_setting_name,
                'input_attrs' => [
                    'min'   => 0,
                    'step'  => 1
                ]
            )
        ));

        // ---######################--- //
        // ---### Project Single ###--- //
        // ---######################--- //
        $wp_customize->add_section('energium_project_single',
            array(
                'title' => esc_html__('Single Page Settings', 'energium'),
                'panel' => 'energium_projects_settings'
            )
        );

        // --------------------------------- //
        // --- Project Single Page Title --- //
        // --------------------------------- //
        $wp_setting_name = 'project_single_page_title';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => stripslashes($energium_customizer_default_values[$wp_setting_name]),
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Project Single Page Title', 'energium'),
                'section'       => 'energium_project_single',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'description'   => esc_html__('Use variable \'%s\' for display Post name', 'energium')
            )
        ));


        // ------------------------------------ //
        // ---------- Services Panel ---------- //
        // ------------------------------------ //
        $wp_customize->add_panel('energium_services_settings',
            array(
                'title'     => esc_html__('Services', 'energium'),
                'priority'  => 210
            )
        );

        // ---########################--- //
        // ---### Services Archive ###--- //
        // ---########################--- //
        $wp_customize->add_section('energium_service_archive',
            array(
                'title' => esc_html__('Archive Settings', 'energium'),
                'panel' => 'energium_services_settings'
            )
        );

        // ----------------------------------- //
        // --- Services Archive Page Title --- //
        // ----------------------------------- //
        $wp_setting_name = 'service_archive_page_title';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => stripslashes($energium_customizer_default_values[$wp_setting_name]),
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Services Archive Page Title', 'energium'),
                'section'       => 'energium_service_archive',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'description'   => esc_html__('Use variable \'%s\' for display Post type name', 'energium')
            )
        ));

        // --------------------------------------- //
        // --- Services Archive Excerpt Length --- //
        // --------------------------------------- //
        $wp_setting_name = 'service_archive_excerpt_length';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'absint'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Services Excerpt Length', 'energium'),
                'section'       => 'energium_service_archive',
                'type'          => 'number',
                'settings'      => $wp_setting_name,
                'input_attrs' => [
                    'min'   => 0,
                    'step'  => 1
                ]
            )
        ));

        // -------------------------------------- //
        // --- Service Archive Columns Number --- //
        // -------------------------------------- //
        $wp_setting_name = 'service_archive_columns_number';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'absint'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Service Archive Columns Number', 'energium'),
                'section'       => 'energium_service_archive',
                'type'          => 'number',
                'settings'      => $wp_setting_name,
                'input_attrs' => [
                    'min'   => 1,
                    'max'   => 4,
                    'step'  => 1
                ]
            )
        ));

        // --------------------------------------- //
        // --- Services Archive Posts per Page --- //
        // --------------------------------------- //
        $wp_setting_name = 'service_archive_posts_per_page';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'absint'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Service Posts Per Page', 'energium'),
                'section'       => 'energium_service_archive',
                'type'          => 'number',
                'settings'      => $wp_setting_name,
                'input_attrs' => [
                    'min'   => 1,
                    'step'  => 1
                ]
            )
        ));

        // ---######################--- //
        // ---### Service Single ###--- //
        // ---######################--- //
        $wp_customize->add_section('energium_service_single',
            array(
                'title' => esc_html__('Single Page Settings', 'energium'),
                'panel' => 'energium_services_settings'
            )
        );

        // ---------------------------------- //
        // --- Services Single Page Title --- //
        // ---------------------------------- //
        $wp_setting_name = 'service_single_page_title';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => stripslashes($energium_customizer_default_values[$wp_setting_name]),
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Service Single Page Title', 'energium'),
                'section'       => 'energium_service_single',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'description'   => esc_html__('Use variable \'%s\' for display Post name', 'energium')
            )
        ));


        // ------------------------------ //
        // ------- 404 Error Page ------- //
        // ------------------------------ //
        $wp_customize->add_section('energium_error_page_settings',
            array(
                'title'     => esc_html__('Error 404 Page', 'energium'),
                'priority'  => 210
            )
        );

        // ----------------------- //
        // --- 404 Error Title --- //
        // ----------------------- //
        $wp_setting_name = 'error_title';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'wp_kses_post'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('404 Error Title', 'energium'),
                'section'       => 'energium_error_page_settings',
                'type'          => 'textarea',
                'settings'      => $wp_setting_name
            )
        ));

        // ---------------------- //
        // --- 404 Error Text --- //
        // ---------------------- //
        $wp_setting_name = 'error_text';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'wp_kses_post'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('404 Error Info Text', 'energium'),
                'section'       => 'energium_error_page_settings',
                'type'          => 'textarea',
                'settings'      => $wp_setting_name
            )
        ));

        // --------------------------- //
        // --- 404 Page Main Image --- //
        // --------------------------- //
        $wp_setting_name = 'error_main_image';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'esc_url_raw'
            )
        );
        $wp_customize->add_control(new Energium_Image_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Main Image', 'energium'),
                'section'       => 'energium_error_page_settings',
                'settings'      => $wp_setting_name
            )
        ));

        // ----------------------------- //
        // --- 404 Error Logo Status --- //
        // ----------------------------- //
        $wp_setting_name = 'error_logo_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Show Header Logo', 'energium'),
                'section'       => 'energium_error_page_settings',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => array(
                    'on'    => esc_html__('Yes', 'energium'),
                    'off'   => esc_html__('No', 'energium')
                ),
                'description'   => esc_html__('Works only if the logo image is set in "Header Settings"', 'energium')
            )
        ));

        // --------------------------------------- //
        // --- 404 Error Social Buttons Status --- //
        // --------------------------------------- //
        $wp_setting_name = 'error_socials_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Show Social Buttons', 'energium'),
                'section'       => 'energium_error_page_settings',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => array(
                    'on'    => esc_html__('Yes', 'energium'),
                    'off'   => esc_html__('No', 'energium')
                )
            )
        ));

        // ------------------------------------ //
        // --- 404 Error Home Button Status --- //
        // ------------------------------------ //
        $wp_setting_name = 'error_button_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Home Button', 'energium'),
                'section'   => 'energium_error_page_settings',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'energium'),
                    'off'       => esc_html__('No', 'energium')
                )
            )
        ));

        // ----------------------------- //
        // --- 404 Error Button Text --- //
        // ----------------------------- //
        $wp_setting_name = 'error_button_text';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Home Button Text', 'energium'),
                'section'       => 'energium_error_page_settings',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'error_button_status',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // -------------------------------------- //
        // --- 404 Error Background Customize --- //
        // -------------------------------------- //
        $wp_setting_name = 'error_background_customize';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Customize Background', 'energium'),
                'section'   => 'energium_error_page_settings',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'energium'),
                    'off'       => esc_html__('No', 'energium')
                )
            )
        ));

        // --------------------------------- //
        // --- 404 Page Background Color --- //
        // --------------------------------- //
        $wp_setting_name = 'error_background_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Energium_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Background Color', 'energium'),
                'section'       => 'energium_error_page_settings',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => energium_get_custom_color_palette(),
                'dependency'    => [
                    [
                        'control'   => 'error_background_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // --------------------------------- //
        // --- 404 Page Background Image --- //
        // --------------------------------- //
        $wp_setting_name = 'error_background_image';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'esc_url_raw'
            )
        );
        $wp_customize->add_control(new Energium_Image_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Background Image', 'energium'),
                'section'       => 'energium_error_page_settings',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'error_background_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------------------------ //
        // --- 404 Page Background Position --- //
        // ------------------------------------ //
        $wp_setting_name = 'error_background_position';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Background Position', 'energium'),
                'section'       => 'energium_error_page_settings',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => energium_get_background_position_options(),
                'dependency'    => [
                    [
                        'control'   => 'error_background_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ---------------------------------- //
        // --- 404 Page Background Repeat --- //
        // ---------------------------------- //
        $wp_setting_name = 'error_background_repeat';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Background Repeat', 'energium'),
                'section'       => 'energium_error_page_settings',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => energium_get_background_repeat_options(),
                'dependency'    => [
                    [
                        'control'   => 'error_background_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // -------------------------------- //
        // --- 404 Page Background Size --- //
        // -------------------------------- //
        $wp_setting_name = 'error_background_size';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Background Size', 'energium'),
                'section'       => 'energium_error_page_settings',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => energium_get_background_size_options(),
                'dependency'    => [
                    [
                        'control'   => 'error_background_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        if ( class_exists('WooCommerce') ) {

            // ------------------------------------------ //
            // ---------- WooCommerce Settings ---------- //
            // ------------------------------------------ //

            // ---######################--- //
            // ---### Single Product ###--- //
            // ---######################--- //
            $wp_customize->add_section('energium_woocommerce_single_product',
                array(
                    'title' => esc_html__('Single Product', 'energium'),
                    'panel' => 'woocommerce'
                )
            );

            // ----------------------------------------------- //
            // --- Single Product Related Products Section --- //
            // ----------------------------------------------- //
            $wp_setting_name = 'woo_single_product_show_related_section';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $energium_customizer_default_values[$wp_setting_name],
                    'sanitize_callback'	=> 'energium_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Energium_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'     => esc_html__('Show Related Products', 'energium'),
                    'section'   => 'energium_woocommerce_single_product',
                    'type'      => 'select',
                    'settings'  => $wp_setting_name,
                    'choices'   => array(
                        'on'        => esc_html__('Yes', 'energium'),
                        'off'       => esc_html__('No', 'energium')
                    )
                )
            ));

            // -------------------------------- //
            // --- Related Products Heading --- //
            // -------------------------------- //
            $wp_setting_name = 'woo_related_title';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $energium_customizer_default_values[$wp_setting_name],
                    'sanitize_callback'	=> 'sanitize_text_field'
                )
            );
            $wp_customize->add_control(new Energium_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Related Products Section Title', 'energium'),
                    'section'       => 'energium_woocommerce_single_product',
                    'type'          => 'text',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'woo_single_product_show_related_section',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // --------------------------------- //
            // --- Single Product Page Title --- //
            // --------------------------------- //
            $wp_setting_name = 'woo_single_product_title';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => stripslashes($energium_customizer_default_values[$wp_setting_name]),
                    'sanitize_callback'	=> 'sanitize_text_field'
                )
            );
            $wp_customize->add_control(new Energium_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Single Product Page Title', 'energium'),
                    'section'       => 'energium_woocommerce_single_product',
                    'type'          => 'text',
                    'settings'      => $wp_setting_name,
                    'description'   => esc_html__('Use variable \'%s\' for display Product title', 'energium')
                )
            ));

            // ------------------------- //
            // --- Show Product Name --- //
            // ------------------------- //
            $wp_setting_name = 'woo_single_product_show_name';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $energium_customizer_default_values[$wp_setting_name],
                    'sanitize_callback'	=> 'energium_sanitize_checkbox'
                )
            );
            $wp_customize->add_control(new Energium_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Show Product name above the Price', 'energium'),
                    'section'       => 'energium_woocommerce_single_product',
                    'type'          => 'checkbox',
                    'settings'      => $wp_setting_name
                )
            ));


            // --------------------------------- //
            // --- Up-sells Products Heading --- //
            // --------------------------------- //
            $wp_setting_name = 'woo_upsells_title';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => stripslashes($energium_customizer_default_values[$wp_setting_name]),
                    'sanitize_callback'	=> 'sanitize_text_field'
                )
            );
            $wp_customize->add_control(new Energium_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Up-sells Section Title', 'energium'),
                    'section'       => 'energium_woocommerce_single_product',
                    'type'          => 'text',
                    'settings'      => $wp_setting_name
                )
            ));

            // ---##########################--- //
            // ---### Product Categories ###--- //
            // ---##########################--- //
            $wp_customize->add_section('energium_woocommerce_product_archive',
                array(
                    'title' => esc_html__('Product Archive', 'energium'),
                    'panel' => 'woocommerce'
                )
            );

            // -------------------------------- //
            // --- Product Categories Title --- //
            // -------------------------------- //
            $wp_setting_name = 'woo_product_categories_title';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => stripslashes($energium_customizer_default_values[$wp_setting_name]),
                    'sanitize_callback'	=> 'sanitize_text_field'
                )
            );
            $wp_customize->add_control(new Energium_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Product Category Page Title', 'energium'),
                    'section'       => 'energium_woocommerce_product_archive',
                    'type'          => 'text',
                    'settings'      => $wp_setting_name,
                    'description'   => esc_html__('Use variable \'%s\' for display Product category name', 'energium')
                )
            ));

            // -------------------------- //
            // --- Product Tags Title --- //
            // -------------------------- //
            $wp_setting_name = 'woo_product_tags_title';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => stripslashes($energium_customizer_default_values[$wp_setting_name]),
                    'sanitize_callback'	=> 'sanitize_text_field'
                )
            );
            $wp_customize->add_control(new Energium_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Product Tag Page Title', 'energium'),
                    'section'       => 'energium_woocommerce_product_archive',
                    'type'          => 'text',
                    'settings'      => $wp_setting_name,
                    'description'   => esc_html__('Use variable \'%s\' for display Product tag name', 'energium')
                )
            ));

        }

        // ----------------------------------------------- //
        // ---------- Additional Settings Panel ---------- //
        // ----------------------------------------------- //
        $wp_customize->add_panel('energium_additional_settings',
            array(
                'title'     => esc_html__('Additional Settings', 'energium'),
                'priority'  => 220
            )
        );

        // ---###################--- //
        // ---### Page Loader ###--- //
        // ---###################--- //
        $wp_customize->add_section('energium_page_loader',
            array(
                'title' => esc_html__('Page Loader', 'energium'),
                'panel' => 'energium_additional_settings'
            )
        );

        // -------------------------- //
        // --- Page Loader Status --- //
        // -------------------------- //
        $wp_setting_name = 'page_loader_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Page Loader', 'energium'),
                'section'   => 'energium_page_loader',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'energium'),
                    'off'       => esc_html__('No', 'energium')
                )
            )
        ));

        // ------------------------- //
        // --- Page Loader Image --- //
        // ------------------------- //
        $wp_setting_name = 'page_loader_image';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'esc_url_raw'
            )
        );
        $wp_customize->add_control(new Energium_Image_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Page Loader Image', 'energium'),
                'section'       => 'energium_page_loader',
                'settings'      => $wp_setting_name,
                'description'   => esc_html__('Maximum 100x100px', 'energium'),
                'dependency'    => [
                    [
                        'control'   => 'page_loader_status',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ---##################--- //
        // ---### Top Button ###--- //
        // ---##################--- //
        $wp_customize->add_section('energium_top_button',
            array(
                'title' => esc_html__('"Go to top" Button', 'energium'),
                'panel' => 'energium_additional_settings'
            )
        );

        // ------------------------- //
        // --- Top Button Status --- //
        // ------------------------- //
        $wp_setting_name = 'top_button_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $energium_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'energium_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Energium_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show "Go to Top" Button', 'energium'),
                'section'   => 'energium_top_button',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'energium'),
                    'off'       => esc_html__('No', 'energium')
                )
            )
        ));

    }
}
