<?php
    $show_icon                      = ( isset($args['show_icon']) ? $args['show_icon'] : true );
    $show_media                     = ( isset($args['show_media']) ? $args['show_media'] : false );
    $show_name                      = ( isset($args['show_name']) ? $args['show_name'] : true );
    $show_excerpt                   = ( isset($args['show_excerpt']) ? $args['show_excerpt'] : true );
    $show_more                      = ( isset($args['show_more']) ? $args['show_more'] : false );

    $columns_number                 = isset($args['columns_number']) && !empty($args['columns_number']) ? $args['columns_number'] : energium_get_theme_mod('service_archive_columns_number');
    $item_class                     = isset($args['item_class']) && !empty($args['item_class']) ? $args['item_class'] : 'service-item-wrapper';
    $excerpt_length                 = ( isset($args['excerpt_length']) && $args['excerpt_length'] != '' ? $args['excerpt_length'] : energium_get_theme_mod('service_archive_excerpt_length') );

    $item_index                     = ( isset($args['item_index']) ? $args['item_index'] : '' );
?>

<div <?php post_class($item_class); ?>>
    <div class="service-item">

        <?php
            if ( $show_media ) {
                echo '<a href="' . esc_url(get_the_permalink()) . '" class="service-item-link">';
                    echo '<span class="service-item-media">';
                        echo energium_services_grid_media_output(null, $columns_number, false);
                        echo '<span class="service-item-index">' . esc_html($item_index) . '</span>';
                    echo '</span>';
                echo '</a>';
            }

            if ( $show_name && !empty(get_the_title()) ) {
                echo '<h4 class="service-post-title"><a href="' . esc_url(get_the_permalink()) . '">' . get_the_title() . '</a></h4>';
            }

            if ( $show_excerpt && !empty($excerpt_length) && !empty(energium_get_post_option('service_description')) && $excerpt_length > 0 ) {
                echo '<div class="service-item-excerpt">';
                    if ( has_excerpt() ) {
                        echo substr(get_the_excerpt(), 0, $excerpt_length);
                    } else {
                        $content = substr(energium_get_post_option('service_description'), 0, $excerpt_length);
                        $content = strip_shortcodes($content);
                        $content = wp_strip_all_tags($content);
                        $content = preg_replace( '/\[.*?(\"title\":\"(.*?)\").*?\]/', '$2', $content );
                        $content = preg_replace( '/\[.*?(|title=\"(.*?)\".*?)\]/', '$2', $content );
                        $content = strip_tags( $content );
                        $content = preg_replace( '|\s+|', ' ', $content );
                        echo wp_kses($content, 'post');
                    }
                echo '</div>';
            }

            if ( $show_more ) {
                echo '<div class="service-item-button">';
                    echo '<a class="more-button fontello icon-arrow-right-square" href="' . esc_url(get_the_permalink()) . '"></a>';
                echo '</div>';
            }

            if ( $show_icon && !empty(energium_get_post_option('service_main_icon')) ) {
                echo '<div class="service-item-icon">';
                    echo '<div class="service-icon">';
                        echo '<i class="' . esc_attr(energium_get_post_option('service_main_icon')) . '"' . (!empty(energium_get_post_option('service_main_icon_color')) ? ' style="color: ' . esc_attr(energium_get_post_option('service_main_icon_color')) . '"' : '') . '></i>';
                    echo '</div>';
                echo '</div>';
            }
        ?>

    </div>
</div>