<?php
    $show_media                     = ( isset($args['show_media']) ? $args['show_media'] : true );
    $media_size                     = ( isset($args['media_size']) ? $args['media_size'] : 'small' );
    $show_categories                = ( isset($args['show_categories']) ? $args['show_categories'] : false );
    $show_name                      = ( isset($args['show_name']) ? $args['show_name'] : true );
    $name_position                  = ( isset($args['name_position']) && !empty($args['name_position']) ? $args['name_position'] : 'above_excerpt' );
    $show_excerpt                   = ( isset($args['show_excerpt']) ? $args['show_excerpt'] : true );
    $show_result_details            = ( isset($args['show_result_details']) ? $args['show_result_details'] : true );
    $show_result_details_separator  = ( isset($args['show_result_details_separator']) ? $args['show_result_details_separator'] : false );
    $result_details_count           = ( isset($args['result_details_count']) && !empty($args['result_details_count']) ? (int)$args['result_details_count'] : 3 );
    $show_more                      = ( isset($args['show_more']) ? $args['show_more'] : false );
    $more_text                      = ( isset($args['more_text']) && !empty($args['more_text']) ? $args['more_text'] : __('Explore more', 'energium') );

    $columns_number                 = isset($args['columns_number']) && !empty($args['columns_number']) ? $args['columns_number'] : energium_get_theme_mod('project_archive_columns_number');
    $item_class                     = isset($args['item_class']) && !empty($args['item_class']) ? $args['item_class'] : 'project-item-wrapper';
    $item_class                     .= isset($args['$name_position']) && !empty($name_position) ? ' ' . esc_attr($name_position) : '';
    $excerpt_length                 = ( isset($args['excerpt_length']) && $args['excerpt_length'] != '' ? $args['excerpt_length'] : energium_get_theme_mod('project_archive_excerpt_length') );

    $project_result_details         = energium_get_post_option('project_result_details');
?>

<div <?php post_class($item_class); ?>>
    <div class="project-item">
        <?php
            if ( $show_media ) {
                echo '<a href="' . esc_url(get_the_permalink()) . '" class="project-item-link">';
                    echo '<span class="project-item-media">';
                        echo energium_projects_grid_media_output(null, $columns_number, $media_size);
                    echo '</span>';
                echo '</a>';
            }
            echo '<div class="project-item-content">';

                if (
                    $name_position == 'over_image' && (
                        ( $show_categories && !empty(energium_taxonomy_output('energium_project_category')) ) ||
                        ( $show_name && !empty(get_the_title()) )
                    )
                ) {
                    echo '<div class="project-item-header">';
                }
                    if ( $show_categories && !empty(energium_taxonomy_output('energium_project_category')) ) {
                        echo '<div class="project-item-categories">';
                            echo energium_taxonomy_output('energium_project_category', '', true);
                        echo '</div>';
                    }

                    if ( $show_name && !empty(get_the_title()) ) {
                        echo '<h4 class="post-title"><a href="' . esc_url(get_the_permalink()) . '">' . get_the_title() . '</a></h4>';
                    }
                if (
                    $name_position == 'over_image' && (
                        ( $show_categories && !empty(energium_taxonomy_output('energium_project_category')) ) ||
                        ( $show_name && !empty(get_the_title()) )
                    )
                ) {
                    echo '</div>';
                }

                if ( $show_excerpt && !empty($excerpt_length) && !empty(get_the_excerpt()) && $excerpt_length > 0 ) {
                    echo '<div class="post-content">';
                        echo substr(get_the_excerpt(), 0, $excerpt_length);
                    echo '</div>';
                }

                if ( $show_result_details && !empty($project_result_details) ) {
                    echo '<div class="project-results-details-list' . ($show_result_details_separator ? ' with-separator' : '') . '">';
                        foreach ( $project_result_details as $key => $item ) {
                            if ( $key <= ($result_details_count - 1)) {
                                echo '<div class="project-results-detail">';
                                    echo (isset($item[1]) && !empty($item[1]) ? '<div class="project-results-detail-value">' . esc_html($item[1]) . '</div>' : '');
                                    echo (isset($item[0]) && !empty($item[0]) ? '<div class="project-results-detail-label">' . esc_html($item[0]) . '</div>' : '');
                                echo '</div>';
                                if ($key < ($result_details_count - 1) && $show_result_details_separator) {
                                    echo '<div class="detail-separator"></div>';
                                }
                            }
                        }
                    echo '</div>';
                }

                if ( $show_more && !empty($more_text) ) {
                    echo '<div class="project-item-button">';
                        echo '<a class="energium-button" href="' . esc_url(get_the_permalink()) . '">' . esc_attr($more_text) . '</a>';
                    echo '</div>';
                }
            echo '</div>';
        ?>
    </div>
</div>