//=======================================================================================
/**
 * @file RepairSelect.h
 * @brief 񕜑ΏۑI
 * @author obata_toshihiro
 * @date 2011.09.27
 */
//=======================================================================================
#ifndef __REPAIRSELECT_H__
#define __REPAIRSELECT_H__
#include <gflib.h>
#include <battle/btl_common.h>
#include <app/tool/app_tool_ButtonManager.h>
#include <app/tool/app_tool_CursorManager.h>
#include "IRepairSelect.h"


namespace btl {

  class BattleViewSystem;


  namespace app {

    class RepairSelect : public IRepairSelect
    {
      GFL_FORBID_COPY_AND_ASSIGN( RepairSelect );  // Rs[֎~


      public:

      //---------------------------------------------------------------------------------
      // RXgN^EfXgN^
      //---------------------------------------------------------------------------------
      /**
       * @brief RXgN^
       * @param heap          gpAvP[Vq[v
       * @param device_heap   gpfoCXq[v
       * @param btlv_system   og`RAVXe
       */
      RepairSelect( 
          gfl::heap::HeapBase* heap, gfl::heap::HeapBase* device_heap, 
          BattleViewSystem* btlv_system );

      /**
       * @brief fXgN^
       */
      virtual ~RepairSelect();



      //---------------------------------------------------------------------------------
      // ݒ
      //---------------------------------------------------------------------------------
      /**
       * @brief ݒύX
       * @param new_setting  Vݒ
       */
      virtual void ChangeSetting( const Setting& new_setting );




      //---------------------------------------------------------------------------------
      // {
      //--------------------------------------------------------------------------------- 
      /**
       * @brief XV
       */
      virtual void Update( void );

      /**
       * @brief ŏĊJ( ݒ͈p )
       */
      virtual void Start( void );

      /**
       * @brief I[g`tOZbg
       * @param flag  true Ȃ`悷
       */
      virtual void SetAutoDrawFlag( bool flag );





      private: 


      // V[PX
      enum Sequence {
        SEQ_INPUT_WAIT,  // ͑҂
        SEQ_ANIME_WAIT,  // Aj[V҂
        SEQ_ITEM_USE,    // Lǂ`FbN
        SEQ_MESSAGE,     // bZ[W\
        SEQ_FINISH,      // I
      }; 


      // {^ԍ
      enum ButtonIndex {
        BUTTON_POKE_0,  // 0Ԗڂ̃|P
        BUTTON_POKE_1,  // 1Ԗڂ̃|P
        BUTTON_POKE_2,  // 2Ԗڂ̃|P
        BUTTON_POKE_3,  // 3Ԗڂ̃|P 
        BUTTON_POKE_4,  // 4Ԗڂ̃|P 
        BUTTON_POKE_5,  // 5Ԗڂ̃|P 
        BUTTON_RETURN,  //uǂv{^
        BUTTON_NUM,
        BUTTON_NULL,
        POKE_BUTTON_NUM = 6,
      };


      // Aj[Vԍ
      enum AnimeIndex {
        ANIME_DUMMY_HP_GAUGE,
        ANIME_DUMMY_PLATE_NORMAL,
        ANIME_DUMMY_PLATE_PLAYER,
        ANIME_DUMMY_PLATE_PARTNER,
        ANIME_DUMMY_PLATE_HOLD,
        ANIME_DUMMY_PLATE_RELEASE,
        ANIME_DUMMY_PLATE_SELECT,
        ANIME_RETURN_HOLD,
        ANIME_RETURN_RELEASE,
        ANIME_RETURN_SELECT,
        ANIME_RETURN_PASSIVE,
        ANIME_RETURN_ACTIVE,
        ANIME_POKE0_ALIVE,
        ANIME_POKE0_DEAD,
        ANIME_POKE0_EMPTY,
        ANIME_POKE1_ALIVE,
        ANIME_POKE1_DEAD,
        ANIME_POKE1_EMPTY,
        ANIME_POKE2_ALIVE,
        ANIME_POKE2_DEAD,
        ANIME_POKE2_EMPTY,
        ANIME_POKE3_ALIVE,
        ANIME_POKE3_DEAD,
        ANIME_POKE3_EMPTY,
        ANIME_POKE4_ALIVE,
        ANIME_POKE4_DEAD,
        ANIME_POKE4_EMPTY,
        ANIME_POKE5_ALIVE,
        ANIME_POKE5_DEAD,
        ANIME_POKE5_EMPTY,
        ANIME_CURSOR_FLUCTUATE,
        ANIME_CURSOR_ON_POKE0,
        ANIME_CURSOR_ON_POKE1,
        ANIME_CURSOR_ON_POKE2,
        ANIME_CURSOR_ON_POKE3,
        ANIME_CURSOR_ON_POKE4,
        ANIME_CURSOR_ON_POKE5,
        ANIME_CURSOR_ON_RETURN,
        ANIME_MESSAGE_CLOSE,
        ANIME_MESSAGE_OPEN,
        // ȉ, LAj[V
        ANIME_POKE0_HP_GAUGE,
        ANIME_POKE0_PLATE_NORMAL = ANIME_POKE0_HP_GAUGE + POKE_BUTTON_NUM,
        ANIME_POKE0_PLATE_PLAYER = ANIME_POKE0_PLATE_NORMAL + POKE_BUTTON_NUM,
        ANIME_POKE0_PLATE_PARTNER = ANIME_POKE0_PLATE_PLAYER + POKE_BUTTON_NUM,
        ANIME_POKE0_PLATE_HOLD = ANIME_POKE0_PLATE_PARTNER + POKE_BUTTON_NUM,
        ANIME_POKE0_PLATE_RELEASE = ANIME_POKE0_PLATE_HOLD + POKE_BUTTON_NUM,
        ANIME_POKE0_PLATE_SELECT = ANIME_POKE0_PLATE_RELEASE + POKE_BUTTON_NUM,
        ANIME_NUM = ANIME_POKE0_PLATE_SELECT + POKE_BUTTON_NUM,
        ANIME_NULL,
      };


      // Aj[Vf[^ԍ
      enum AnimeDataIndex {
        ANIME_DATA_DUMMY_HP_GAUGE,
        ANIME_DATA_DUMMY_PLATE_NORMAL,
        ANIME_DATA_DUMMY_PLATE_PLAYER,
        ANIME_DATA_DUMMY_PLATE_PARTNER,
        ANIME_DATA_DUMMY_PLATE_HOLD,
        ANIME_DATA_DUMMY_PLATE_RELEASE,
        ANIME_DATA_DUMMY_PLATE_SELECT,
        ANIME_DATA_RETURN_HOLD,
        ANIME_DATA_RETURN_RELEASE,
        ANIME_DATA_RETURN_SELECT,
        ANIME_DATA_RETURN_PASSIVE,
        ANIME_DATA_RETURN_ACTIVE,
        ANIME_DATA_POKE0_ALIVE,
        ANIME_DATA_POKE0_DEAD,
        ANIME_DATA_POKE0_EMPTY,
        ANIME_DATA_POKE1_ALIVE,
        ANIME_DATA_POKE1_DEAD,
        ANIME_DATA_POKE1_EMPTY,
        ANIME_DATA_POKE2_ALIVE,
        ANIME_DATA_POKE2_DEAD,
        ANIME_DATA_POKE2_EMPTY,
        ANIME_DATA_POKE3_ALIVE,
        ANIME_DATA_POKE3_DEAD,
        ANIME_DATA_POKE3_EMPTY,
        ANIME_DATA_POKE4_ALIVE,
        ANIME_DATA_POKE4_DEAD,
        ANIME_DATA_POKE4_EMPTY,
        ANIME_DATA_POKE5_ALIVE,
        ANIME_DATA_POKE5_DEAD,
        ANIME_DATA_POKE5_EMPTY,
        ANIME_DATA_CURSOR_FLUCTUATE,
        ANIME_DATA_CURSOR_ON_POKE0,
        ANIME_DATA_CURSOR_ON_POKE1,
        ANIME_DATA_CURSOR_ON_POKE2,
        ANIME_DATA_CURSOR_ON_POKE3,
        ANIME_DATA_CURSOR_ON_POKE4,
        ANIME_DATA_CURSOR_ON_POKE5,
        ANIME_DATA_CURSOR_ON_RETURN,
        ANIME_DATA_MESSAGE_CLOSE,
        ANIME_DATA_MESSAGE_OPEN,
        ANIME_DATA_NUM,
      };


      // LAj[Vԍ
      enum ShareAnimeIndex {
        SHARE_ANIME_POKE_HP_GAUGE,
        SHARE_ANIME_POKE_PLATE_NORMAL,
        SHARE_ANIME_POKE_PLATE_PLAYER,
        SHARE_ANIME_POKE_PLATE_PARTNER,
        SHARE_ANIME_POKE_PLATE_HOLD,
        SHARE_ANIME_POKE_PLATE_RELEASE,
        SHARE_ANIME_POKE_PLATE_SELECT,
        SHARE_ANIME_NUM,
      };


      // LAj[VƂ̐ݒ
      struct ShareAnimeDesc {
        AnimeIndex start_anime_index;                   // o^CfbNX
        AnimeDataIndex anime_data_index;                // L̃Aj[Vԍ
        u32 max_share_num;                              // ő勤L
        gfl::grp::g2d::LytPaneIndex share_group_index;  // VFAΏۂ̃O[v
        gfl::grp::g2d::LytPaneIndex share_pane_index;   // VFAΏۂ̃yC
      };


      // {^Ƃ̐ݒ
      struct ButtonDesc {
        IRepairSelect::Result result;                 // Iꂽꍇ̌
        gfl::grp::g2d::LytPaneIndex pane_index;   // {^ƂĈyC
        AnimeIndex hold_anime;            // ꂽۂ̃Aj[V
        AnimeIndex release_anime;         // ꂽۂ̃Aj[V
        AnimeIndex select_anime;          // I΂ꂽۂ̃Aj[V
        AnimeIndex active_anime;          // {^Lȍۂ̃Aj[V
        AnimeIndex passive_anime;         // {^ȍۂ̃Aj[V
        AnimeIndex cursor_anime;          // J[\ZbgAj[V
        u32 select_se;                            // {^Îrd
      };

      // |P{^Ɍт|P肷
      struct PokeButtonLink {
        IRepairSelect::PartyId party_id;  // ǂ̃p[eBH
        u8 pokeindex;                   // Ԗڂ̃|PH
      };

      // |P{^Ƃ̐ݒ
      struct PokeButtonDesc {
        PokeButtonLink link;                        // ǂ̃|PɊ֘At邩H
        gfl::grp::g2d::LytPaneIndex name_pane;      // O\yC
        gfl::grp::g2d::LytPaneIndex sex_pane;       // ʂ\yC
        gfl::grp::g2d::LytPaneIndex lv_value_pane;  // x̒l\yC
        gfl::grp::g2d::LytPaneIndex hp_max_pane;    // őHP̒l\yC
        gfl::grp::g2d::LytPaneIndex hp_value_pane;  // HP̒l\yC
        gfl::grp::g2d::LytPaneIndex item_icon_pane; // ACeACR̃yC
        AnimeIndex hp_gauge_anime;          // HPQ[WAj
        AnimeIndex plate_normal_anime;      // ʏ̃v[gɂAj
        AnimeIndex plate_player_anime;      // }`ΐ( vC[ )p̃v[gɂAj
        AnimeIndex plate_partner_anime;     // }`ΐ( p[gi[ )p̃v[gɂAj
        AnimeIndex plate_alive_anime;       // 퓬\ȏԂ̃v[gɂAj
        AnimeIndex plate_dead_anime;        // mp̃v[gɂAj
        AnimeIndex plate_empty_anime;       // |PȂꍇ̃v[gɂAj
      };




      static const u32 APP_HEAPSIZE;
      static const u32 DEVICE_HEAPSIZE; 
      static const u32 LV_PLACE_COUNT;
      static const u32 HP_PLACE_COUNT;

      static const gfl::grp::g2d::LytWkSetUp LAYOUT_WORK_SETUP_DATA;
      static const gfl::grp::g2d::LytArcIndex ANIME_DATA_TABLE[ ANIME_DATA_NUM ];
      static const ShareAnimeDesc SHARE_ANIME_DESC[ SHARE_ANIME_NUM ];
      static const ::app::tool::CursorManager::MOVE_DATA CURSOR_MOVE_DATA[ BUTTON_NUM ];
      static const u16 MESSAGE_LINES = 2;  // bZ[W̍s
      static const gfl::grp::g2d::LytPaneIndex MESSAGE_LINES_PANE[ MESSAGE_LINES ];

      // ʏogp
      static const ButtonDesc BUTTON_DESC_NORMAL[ BUTTON_NUM ];
      static const PokeButtonDesc POKE_BUTTON_DESC_NORMAL[ POKE_BUTTON_NUM ]; 
      // }`ogp(  )
      static const ButtonDesc BUTTON_DESC_MULTI_L[ BUTTON_NUM ];
      static const PokeButtonDesc MULTI_POKE_BUTTON_DESC_L[ POKE_BUTTON_NUM ]; 
      // }`ogp( E )
      static const ButtonDesc BUTTON_DESC_MULTI_R[ BUTTON_NUM ];
      static const PokeButtonDesc MULTI_POKE_BUTTON_DESC_R[ POKE_BUTTON_NUM ];


      gfl::grp::g2d::LytWk* m_layout_work;
      gfl::grp::g2d::LytResID m_layout_resource_id;
      ::app::tool::ButtonManager* m_button_manager;
      ::app::tool::CursorManager* m_cursor_manager;
      print::MsgWin* m_str_win;

      Sequence m_seq;
      Sequence m_next_seq;
      AnimeIndex m_wait_anime_index;
      PokeButtonDesc m_poke_button_desc[ POKE_BUTTON_NUM ];


      const ButtonDesc& GetButtonDesc( ButtonIndex button_index ) const;
      const PokeButtonDesc& GetInitialPokeButtonDesc( ButtonIndex button_index ) const;
      const PokeButtonDesc& GetPokeButtonDesc( ButtonIndex button_index ) const; 

      void CreateLayoutWork( void );
      void CreateShareAnime( void );
      void CreateCursorManager( void );
      void CreateButtonManager( void );
      void SetupButtonManager( void ); 
      void SetupFont( void );
      void InitializeGraphicsSystem( void );
      void InitializeCursorPos( void );
      void InitialziePokeButtonDesc( void );
      void CreateStrWin( void );  // @todo rename MsgWin

      void DeleteLayoutWork( void );
      void DeleteCursorManager( void );
      void DeleteButtonManager( void );
      void FinalizeGraphicsSystem( void );
      void DeleteStrWin( void );

      void SetupMessage( void );
      void SetupReturnButtonActivity( void );
      void SetupPokeButtonActivity( ButtonIndex button_index );

      void SetupPokeButton( ButtonIndex button_index, const PokeButtonDesc& button_desc );
      bool SetupPokeButton_Kind( ButtonIndex button_index, const PokeButtonDesc& button_desc );
      bool SetupPokeButton_State( ButtonIndex button_index, const PokeButtonDesc& button_desc );
      void SetupPokeButton_Params( ButtonIndex button_index, const PokeButtonDesc& button_desc );
      void SetPokeButtonDisplay_Normal( ButtonIndex button_index, const PokeButtonDesc& button_desc );
      void SetPokeButtonDisplay_Player( ButtonIndex button_index, const PokeButtonDesc& button_desc );
      void SetPokeButtonDisplay_Partner( ButtonIndex button_index, const PokeButtonDesc& button_desc );
      void SetPokeButtonDisplay_Alive( ButtonIndex button_index, const PokeButtonDesc& button_desc );
      void SetPokeButtonDisplay_Dead( ButtonIndex button_index, const PokeButtonDesc& button_desc );
      void SetPokeButtonDisplay_Empty( ButtonIndex button_index, const PokeButtonDesc& button_desc );
      void SetPokeButtonDisplay_Name( ButtonIndex button_index, const PokeButtonDesc& button_desc, const BTL_POKEPARAM* btl_param );
      void SetPokeButtonDisplay_Sex( ButtonIndex button_index, const PokeButtonDesc& button_desc, const BTL_POKEPARAM* btl_param );
      void SetPokeButtonDisplay_Level( ButtonIndex button_index, const PokeButtonDesc& button_desc, u32 level );
      void SetPokeButtonDisplay_Hp( ButtonIndex button_index, const PokeButtonDesc& button_desc, u32 max_hp, u32 now_hp );
      void SetPokeButtonDisplay_HaveItem( ButtonIndex button_index, const PokeButtonDesc& button_desc );
      void SetPokeButtonDisplay_NotHaveItem( ButtonIndex button_index, const PokeButtonDesc& button_desc );

      void UpdateSequence( void );
      void UpdateSequence_INPUT_WAIT( void );
      void UpdateSequence_ANIME_WAIT( void );
      void UpdateSequence_ITEM_USE( void );
      void UpdateSequence_MESSAGE( void );
      bool IsWaitAnimeEnd( void ) const;
      void OnButtonSelectedByKey( ButtonIndex selected_button );
      void OnCursorMoved( ButtonIndex old_pos, ButtonIndex new_pos );

      bool IsButtonHolding( void ) const;
      bool IsButtonSelectedByTouch( void ) const;
      ButtonIndex GetSelectedButtonByTouch( void ) const;
      bool IsButtonSelectEnable( ButtonIndex button ) const;

      bool UpdateCursorMove( void );
      ButtonIndex GetCurrentCursorPos( void ) const;
      ButtonIndex GetPrevCursorPos( void ) const;

      bool IsFrontPoke( u8 pokeindex ) const;
      void StartMessageStream( u32 strID );
      bool UpdateMessageStream( void );
      void EndMessageStream( void );
    };


  }  // namespace app
}  // namespace btl


#endif  // __REPAIRSELECT_H__
