//=======================================================================================
/**
 * @file RepairSelect.cpp
 * @brief 񕜑ΏۑI
 * @author obata_toshihiro
 * @date 2011.09.27
 */
//=======================================================================================
#include <gflib.h>
#include <sound/SEController.h>
#include <sound/xy_sound.csid>
#include <print/xy_msgWin.h>
#include <app/util/app_util.h>
#include <app/tool/app_tool_ButtonManager.h>
#include <app/tool/app_tool_CursorManager.h>
#include <app/tool/app_tool_Gauge.h>
#include <battle/btl_common.h>
#include "IRepairSelect.h"
#include "RepairSelect.h"

#include <arc/arc_def.h>
#include <arc/btl_app.gaix>
#include <message/msg_btl_app.h>
#include "repair_select.h"
#include "repair_select_pane.h"


namespace btl {
  namespace app {


    // q[vTCY
    const u32 RepairSelect::APP_HEAPSIZE    =  0x1000;
    const u32 RepairSelect::DEVICE_HEAPSIZE = 0x80000;

    // ľ
    const u32 RepairSelect::LV_PLACE_COUNT = 3;
    const u32 RepairSelect::HP_PLACE_COUNT = 3;


    // bZ[W̊esɎgpyC
    const gfl::grp::g2d::LytPaneIndex RepairSelect::MESSAGE_LINES_PANE[ RepairSelect::MESSAGE_LINES ] =
    {
      PANENAME_REPAIR_SELECT_PANE_MESSAGE_01A,
      PANENAME_REPAIR_SELECT_PANE_MESSAGE_01B,
    };


    // CAEg[ÑZbgAbvf[^
    const gfl::grp::g2d::LytWkSetUp RepairSelect::LAYOUT_WORK_SETUP_DATA = 
    {
      gfl::math::VEC3( 0, LAYOUT_DOWN_OFS, 0 ),  // pos
      gfl::math::VEC2( 1, 1 ),                   // scale
      gfl::math::VEC3( 0, 0, 0 ),                // rotate
      1,                                         // priority
    };


    // Aj[Vf[^e[u
    const gfl::grp::g2d::LytArcIndex RepairSelect::ANIME_DATA_TABLE[ RepairSelect::ANIME_DATA_NUM ] = 
    {
      /* ANIME_DATA_DUMMY_HP_GAUGE */ LYTRES_REPAIR_SELECT_REPAIR_SELECT_DUMMY_HP_GAUGE_BCLAN,
      /* ANIME_DATA_DUMMY_PLATE_NORMAL */ LYTRES_REPAIR_SELECT_REPAIR_SELECT_DUMMY_PLATE_NORMAL_BCLAN,
      /* ANIME_DATA_DUMMY_PLATE_PLAYER */ LYTRES_REPAIR_SELECT_REPAIR_SELECT_DUMMY_PLATE_PLAYER_BCLAN,
      /* ANIME_DATA_DUMMY_PLATE_PARTNER */ LYTRES_REPAIR_SELECT_REPAIR_SELECT_DUMMY_PLATE_PARTNER_BCLAN,
      /* ANIME_DATA_DUMMY_PLATE_HOLD */ LYTRES_REPAIR_SELECT_REPAIR_SELECT_DUMMY_PLATE_HOLD_BCLAN,
      /* ANIME_DATA_DUMMY_PLATE_RELEASE */ LYTRES_REPAIR_SELECT_REPAIR_SELECT_DUMMY_PLATE_RELEASE_BCLAN,
      /* ANIME_DATA_DUMMY_PLATE_SELECT */ LYTRES_REPAIR_SELECT_REPAIR_SELECT_DUMMY_PLATE_SELECT_BCLAN,
      /* ANIME_DATA_RETURN_HOLD */ LYTRES_REPAIR_SELECT_REPAIR_SELECT_RETURN_HOLD_BCLAN,
      /* ANIME_DATA_RETURN_RELEASE */ LYTRES_REPAIR_SELECT_REPAIR_SELECT_RETURN_RELEASE_BCLAN,
      /* ANIME_DATA_RETURN_SELECT */ LYTRES_REPAIR_SELECT_REPAIR_SELECT_RETURN_SELECT_BCLAN,
      /* ANIME_DATA_RETURN_PASSIVE */ LYTRES_REPAIR_SELECT_REPAIR_SELECT_RETURN_PASSIVE_BCLAN,
      /* ANIME_DATA_RETURN_ACTIVE */ LYTRES_REPAIR_SELECT_REPAIR_SELECT_RETURN_ACTIVE_BCLAN,
      /* ANIME_DATA_POKE0_ALIVE */ LYTRES_REPAIR_SELECT_REPAIR_SELECT_POKE0_ALIVE_BCLAN,
      /* ANIME_DATA_POKE0_DEAD */ LYTRES_REPAIR_SELECT_REPAIR_SELECT_POKE0_DEAD_BCLAN,
      /* ANIME_DATA_POKE0_EMPTY */ LYTRES_REPAIR_SELECT_REPAIR_SELECT_POKE0_EMPTY_BCLAN,
      /* ANIME_DATA_POKE1_ALIVE */ LYTRES_REPAIR_SELECT_REPAIR_SELECT_POKE1_ALIVE_BCLAN,
      /* ANIME_DATA_POKE1_DEAD */ LYTRES_REPAIR_SELECT_REPAIR_SELECT_POKE1_DEAD_BCLAN,
      /* ANIME_DATA_POKE1_EMPTY */ LYTRES_REPAIR_SELECT_REPAIR_SELECT_POKE1_EMPTY_BCLAN,
      /* ANIME_DATA_POKE2_ALIVE */ LYTRES_REPAIR_SELECT_REPAIR_SELECT_POKE2_ALIVE_BCLAN,
      /* ANIME_DATA_POKE2_DEAD */ LYTRES_REPAIR_SELECT_REPAIR_SELECT_POKE2_DEAD_BCLAN,
      /* ANIME_DATA_POKE2_EMPTY */ LYTRES_REPAIR_SELECT_REPAIR_SELECT_POKE2_EMPTY_BCLAN,
      /* ANIME_DATA_POKE3_ALIVE */ LYTRES_REPAIR_SELECT_REPAIR_SELECT_POKE3_ALIVE_BCLAN,
      /* ANIME_DATA_POKE3_DEAD */ LYTRES_REPAIR_SELECT_REPAIR_SELECT_POKE3_DEAD_BCLAN,
      /* ANIME_DATA_POKE3_EMPTY */ LYTRES_REPAIR_SELECT_REPAIR_SELECT_POKE3_EMPTY_BCLAN,
      /* ANIME_DATA_POKE4_ALIVE */ LYTRES_REPAIR_SELECT_REPAIR_SELECT_POKE4_ALIVE_BCLAN,
      /* ANIME_DATA_POKE4_DEAD */ LYTRES_REPAIR_SELECT_REPAIR_SELECT_POKE4_DEAD_BCLAN,
      /* ANIME_DATA_POKE4_EMPTY */ LYTRES_REPAIR_SELECT_REPAIR_SELECT_POKE4_EMPTY_BCLAN,
      /* ANIME_DATA_POKE5_ALIVE */ LYTRES_REPAIR_SELECT_REPAIR_SELECT_POKE5_ALIVE_BCLAN,
      /* ANIME_DATA_POKE5_DEAD */ LYTRES_REPAIR_SELECT_REPAIR_SELECT_POKE5_DEAD_BCLAN,
      /* ANIME_DATA_POKE5_EMPTY */ LYTRES_REPAIR_SELECT_REPAIR_SELECT_POKE5_EMPTY_BCLAN,
      /* ANIME_DATA_CURSOR_FLUCTUATE */ LYTRES_REPAIR_SELECT_REPAIR_SELECT_CURSOR_FLUCTUATE_BCLAN,
      /* ANIME_DATA_CURSOR_ON_POKE0 */ LYTRES_REPAIR_SELECT_REPAIR_SELECT_CURSOR_ON_POKE0_BCLAN,
      /* ANIME_DATA_CURSOR_ON_POKE1 */ LYTRES_REPAIR_SELECT_REPAIR_SELECT_CURSOR_ON_POKE1_BCLAN,
      /* ANIME_DATA_CURSOR_ON_POKE2 */ LYTRES_REPAIR_SELECT_REPAIR_SELECT_CURSOR_ON_POKE2_BCLAN,
      /* ANIME_DATA_CURSOR_ON_POKE3 */ LYTRES_REPAIR_SELECT_REPAIR_SELECT_CURSOR_ON_POKE3_BCLAN,
      /* ANIME_DATA_CURSOR_ON_POKE4 */ LYTRES_REPAIR_SELECT_REPAIR_SELECT_CURSOR_ON_POKE4_BCLAN,
      /* ANIME_DATA_CURSOR_ON_POKE5 */ LYTRES_REPAIR_SELECT_REPAIR_SELECT_CURSOR_ON_POKE5_BCLAN,
      /* ANIME_DATA_CURSOR_ON_RETURN */ LYTRES_REPAIR_SELECT_REPAIR_SELECT_CURSOR_ON_RETURN_BCLAN,
      /* ANIME_DATA_MESSAGE_CLOSE */ LYTRES_REPAIR_SELECT_REPAIR_SELECT_MESSAGE_CLOSE_BCLAN,
      /* ANIME_DATA_MESSAGE_OPEN */ LYTRES_REPAIR_SELECT_REPAIR_SELECT_MESSAGE_OPEN_BCLAN,
    };


    // LAj[VƂ̐ݒ
    const RepairSelect::ShareAnimeDesc RepairSelect::SHARE_ANIME_DESC[ RepairSelect::SHARE_ANIME_NUM ] = 
    {
      /* SHARE_ANIME_POKE_HP_GAUGE */
      {
        ANIME_POKE0_HP_GAUGE, 
        ANIME_DATA_DUMMY_HP_GAUGE,
        POKE_BUTTON_NUM,
        PANENAME_REPAIR_SELECT_GROUP_HP_GAUGE,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
      /* SHARE_ANIME_POKE_PLATE_NORMAL */
      {
        ANIME_POKE0_PLATE_NORMAL, 
        ANIME_DATA_DUMMY_PLATE_NORMAL,
        POKE_BUTTON_NUM,
        PANENAME_REPAIR_SELECT_GROUP_PLATE,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
      /* SHARE_ANIME_POKE_PLATE_PLAYER */
      {
        ANIME_POKE0_PLATE_PLAYER, 
        ANIME_DATA_DUMMY_PLATE_PLAYER,
        POKE_BUTTON_NUM,
        PANENAME_REPAIR_SELECT_GROUP_PLATE,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
      /* SHARE_ANIME_POKE_PLATE_PARTNER */
      {
        ANIME_POKE0_PLATE_PARTNER, 
        ANIME_DATA_DUMMY_PLATE_PARTNER,
        POKE_BUTTON_NUM,
        PANENAME_REPAIR_SELECT_GROUP_PLATE,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
      /* SHARE_ANIME_POKE_PLATE_HOLD */
      {
        ANIME_POKE0_PLATE_HOLD, 
        ANIME_DATA_DUMMY_PLATE_HOLD,
        POKE_BUTTON_NUM,
        PANENAME_REPAIR_SELECT_GROUP_PLATE_EFFECT,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
      /* SHARE_ANIME_POKE_PLATE_RELEASE */
      {
        ANIME_POKE0_PLATE_RELEASE, 
        ANIME_DATA_DUMMY_PLATE_RELEASE,
        POKE_BUTTON_NUM,
        PANENAME_REPAIR_SELECT_GROUP_PLATE_EFFECT,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
      /* SHARE_ANIME_POKE_PLATE_SELECT */
      {
        ANIME_POKE0_PLATE_SELECT, 
        ANIME_DATA_DUMMY_PLATE_SELECT,
        POKE_BUTTON_NUM,
        PANENAME_REPAIR_SELECT_GROUP_PLATE_EFFECT,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
    };


    // J[\ړf[^
    const ::app::tool::CursorManager::MOVE_DATA RepairSelect::CURSOR_MOVE_DATA[ RepairSelect::BUTTON_NUM ] = 
    {
      /*   id            up             down           left           right  */
      { BUTTON_POKE_0, { BUTTON_POKE_0, BUTTON_POKE_2, BUTTON_POKE_0, BUTTON_POKE_1 } },
      { BUTTON_POKE_1, { BUTTON_POKE_1, BUTTON_POKE_3, BUTTON_POKE_0, BUTTON_POKE_1 } },
      { BUTTON_POKE_2, { BUTTON_POKE_0, BUTTON_POKE_4, BUTTON_POKE_2, BUTTON_POKE_3 } },
      { BUTTON_POKE_3, { BUTTON_POKE_1, BUTTON_POKE_5, BUTTON_POKE_2, BUTTON_POKE_3 } },
      { BUTTON_POKE_4, { BUTTON_POKE_2, BUTTON_RETURN, BUTTON_POKE_4, BUTTON_POKE_5 } },
      { BUTTON_POKE_5, { BUTTON_POKE_3, BUTTON_RETURN, BUTTON_POKE_4, BUTTON_POKE_5 } },
      { BUTTON_RETURN, { BUTTON_POKE_5, BUTTON_RETURN, BUTTON_RETURN, BUTTON_RETURN } },
    };









    //=====================================================================================
    // ʏogp
    //=====================================================================================

    //------------------
    // {^Ƃ̐ݒ
    //------------------
    const RepairSelect::ButtonDesc RepairSelect::BUTTON_DESC_NORMAL[ RepairSelect::BUTTON_NUM ] = 
    {
      /* BUTTON_POKE_0 */ 
      {
        IRepairSelect::RESULT_SELECT_PLAYER_POKE,
        PANENAME_REPAIR_SELECT_PANE_POKE0_PLATE,
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_HOLD + 0 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_RELEASE + 0 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_SELECT + 0 ),
        ANIME_NULL,
        ANIME_NULL,
        ANIME_CURSOR_ON_POKE0,
        SEQ_SE_DECIDE2,
      },
      /* BUTTON_POKE_1 */ 
      {
        IRepairSelect::RESULT_SELECT_PLAYER_POKE,
        PANENAME_REPAIR_SELECT_PANE_POKE1_PLATE,
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_HOLD + 1 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_RELEASE + 1 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_SELECT + 1 ),
        ANIME_NULL,
        ANIME_NULL,
        ANIME_CURSOR_ON_POKE1,
        SEQ_SE_DECIDE2,
      },
      /* BUTTON_POKE_2 */ 
      {
        IRepairSelect::RESULT_SELECT_PLAYER_POKE,
        PANENAME_REPAIR_SELECT_PANE_POKE2_PLATE,
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_HOLD + 2 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_RELEASE + 2 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_SELECT + 2 ),
        ANIME_NULL,
        ANIME_NULL,
        ANIME_CURSOR_ON_POKE2,
        SEQ_SE_DECIDE2,
      },
      /* BUTTON_POKE_3 */ 
      {
        IRepairSelect::RESULT_SELECT_PLAYER_POKE,
        PANENAME_REPAIR_SELECT_PANE_POKE3_PLATE,
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_HOLD + 3 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_RELEASE + 3 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_SELECT + 3 ),
        ANIME_NULL,
        ANIME_NULL,
        ANIME_CURSOR_ON_POKE3,
        SEQ_SE_DECIDE2,
      },
      /* BUTTON_POKE_4 */ 
      {
        IRepairSelect::RESULT_SELECT_PLAYER_POKE,
        PANENAME_REPAIR_SELECT_PANE_POKE4_PLATE,
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_HOLD + 4 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_RELEASE + 4 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_SELECT + 4 ),
        ANIME_NULL,
        ANIME_NULL,
        ANIME_CURSOR_ON_POKE4,
        SEQ_SE_DECIDE2,
      },
      /* BUTTON_POKE_5 */ 
      {
        IRepairSelect::RESULT_SELECT_PLAYER_POKE,
        PANENAME_REPAIR_SELECT_PANE_POKE5_PLATE,
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_HOLD + 5 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_RELEASE + 5 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_SELECT + 5 ),
        ANIME_NULL,
        ANIME_NULL,
        ANIME_CURSOR_ON_POKE5,
        SEQ_SE_DECIDE2,
      },
      /* BUTTON_RETURN */ 
      {
        IRepairSelect::RESULT_RETURN,
        PANENAME_REPAIR_SELECT_PANE_RETURN_BUTTON,
        ANIME_RETURN_HOLD,
        ANIME_RETURN_RELEASE,
        ANIME_RETURN_SELECT,
        ANIME_RETURN_ACTIVE,
        ANIME_RETURN_PASSIVE,
        ANIME_CURSOR_ON_RETURN,
        SEQ_SE_CANCEL2,
      },
    };



    //---------------------------
    // |P{^Ƃ̐ݒ
    //---------------------------
    const RepairSelect::PokeButtonDesc RepairSelect::POKE_BUTTON_DESC_NORMAL[ POKE_BUTTON_NUM ] = 
    {
      {
        { IRepairSelect::PARTY_PLAYER, 0 },
        PANENAME_REPAIR_SELECT_PANE_POKE0_NAME,
        PANENAME_REPAIR_SELECT_PANE_POKE0_SEX,
        PANENAME_REPAIR_SELECT_PANE_POKE0_LV_VALUE,
        PANENAME_REPAIR_SELECT_PANE_POKE0_HP_MAX,
        PANENAME_REPAIR_SELECT_PANE_POKE0_HP_VALUE,
        PANENAME_REPAIR_SELECT_PANE_POKE0_ITEM,
        static_cast<AnimeIndex>( ANIME_POKE0_HP_GAUGE + 0 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_NORMAL + 0 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_PLAYER + 0 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_PARTNER + 0 ),
        ANIME_POKE0_ALIVE,
        ANIME_POKE0_DEAD,
        ANIME_POKE0_EMPTY,
      },
      {
        { IRepairSelect::PARTY_PLAYER, 1 },
        PANENAME_REPAIR_SELECT_PANE_POKE1_NAME,
        PANENAME_REPAIR_SELECT_PANE_POKE1_SEX,
        PANENAME_REPAIR_SELECT_PANE_POKE1_LV_VALUE,
        PANENAME_REPAIR_SELECT_PANE_POKE1_HP_MAX,
        PANENAME_REPAIR_SELECT_PANE_POKE1_HP_VALUE,
        PANENAME_REPAIR_SELECT_PANE_POKE1_ITEM,
        static_cast<AnimeIndex>( ANIME_POKE0_HP_GAUGE + 1 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_NORMAL + 1 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_PLAYER + 1 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_PARTNER + 1 ),
        ANIME_POKE1_ALIVE,
        ANIME_POKE1_DEAD,
        ANIME_POKE1_EMPTY,
      },
      {
        { IRepairSelect::PARTY_PLAYER, 2 },
        PANENAME_REPAIR_SELECT_PANE_POKE2_NAME,
        PANENAME_REPAIR_SELECT_PANE_POKE2_SEX,
        PANENAME_REPAIR_SELECT_PANE_POKE2_LV_VALUE,
        PANENAME_REPAIR_SELECT_PANE_POKE2_HP_MAX,
        PANENAME_REPAIR_SELECT_PANE_POKE2_HP_VALUE,
        PANENAME_REPAIR_SELECT_PANE_POKE2_ITEM,
        static_cast<AnimeIndex>( ANIME_POKE0_HP_GAUGE + 2 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_NORMAL + 2 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_PLAYER + 2 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_PARTNER + 2 ),
        ANIME_POKE2_ALIVE,
        ANIME_POKE2_DEAD,
        ANIME_POKE2_EMPTY,
      },
      {
        { IRepairSelect::PARTY_PLAYER, 3 },
        PANENAME_REPAIR_SELECT_PANE_POKE3_NAME,
        PANENAME_REPAIR_SELECT_PANE_POKE3_SEX,
        PANENAME_REPAIR_SELECT_PANE_POKE3_LV_VALUE,
        PANENAME_REPAIR_SELECT_PANE_POKE3_HP_MAX,
        PANENAME_REPAIR_SELECT_PANE_POKE3_HP_VALUE,
        PANENAME_REPAIR_SELECT_PANE_POKE3_ITEM,
        static_cast<AnimeIndex>( ANIME_POKE0_HP_GAUGE + 3 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_NORMAL + 3 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_PLAYER + 3 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_PARTNER + 3 ),
        ANIME_POKE3_ALIVE,
        ANIME_POKE3_DEAD,
        ANIME_POKE3_EMPTY,
      },
      {
        { IRepairSelect::PARTY_PLAYER, 4 },
        PANENAME_REPAIR_SELECT_PANE_POKE4_NAME,
        PANENAME_REPAIR_SELECT_PANE_POKE4_SEX,
        PANENAME_REPAIR_SELECT_PANE_POKE4_LV_VALUE,
        PANENAME_REPAIR_SELECT_PANE_POKE4_HP_MAX,
        PANENAME_REPAIR_SELECT_PANE_POKE4_HP_VALUE,
        PANENAME_REPAIR_SELECT_PANE_POKE4_ITEM,
        static_cast<AnimeIndex>( ANIME_POKE0_HP_GAUGE + 4 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_NORMAL + 4 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_PLAYER + 4 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_PARTNER + 4 ),
        ANIME_POKE4_ALIVE,
        ANIME_POKE4_DEAD,
        ANIME_POKE4_EMPTY,
      },
      {
        { IRepairSelect::PARTY_PLAYER, 5 },
        PANENAME_REPAIR_SELECT_PANE_POKE5_NAME,
        PANENAME_REPAIR_SELECT_PANE_POKE5_SEX,
        PANENAME_REPAIR_SELECT_PANE_POKE5_LV_VALUE,
        PANENAME_REPAIR_SELECT_PANE_POKE5_HP_MAX,
        PANENAME_REPAIR_SELECT_PANE_POKE5_HP_VALUE,
        PANENAME_REPAIR_SELECT_PANE_POKE5_ITEM,
        static_cast<AnimeIndex>( ANIME_POKE0_HP_GAUGE + 5 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_NORMAL + 5 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_PLAYER + 5 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_PARTNER + 5 ),
        ANIME_POKE5_ALIVE,
        ANIME_POKE5_DEAD,
        ANIME_POKE5_EMPTY,
      },
    };







    //=====================================================================================
    // }`ogp( ̏ꍇ )
    //=====================================================================================

    //----------------------
    // {^Ƃ̐ݒ
    //----------------------
    const RepairSelect::ButtonDesc RepairSelect::BUTTON_DESC_MULTI_L[ RepairSelect::BUTTON_NUM ] = 
    {
      /* BUTTON_POKE_0 */ 
      {
        IRepairSelect::RESULT_SELECT_PLAYER_POKE,
        PANENAME_REPAIR_SELECT_PANE_POKE0_PLATE,
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_HOLD + 0 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_RELEASE + 0 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_SELECT + 0 ),
        ANIME_NULL,
        ANIME_NULL,
        ANIME_CURSOR_ON_POKE0,
        SEQ_SE_DECIDE2,
      },
      /* BUTTON_POKE_1 */ 
      {
        IRepairSelect::RESULT_SELECT_PARTNER_POKE,
        PANENAME_REPAIR_SELECT_PANE_POKE1_PLATE,
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_HOLD + 1 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_RELEASE + 1 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_SELECT + 1 ),
        ANIME_NULL,
        ANIME_NULL,
        ANIME_CURSOR_ON_POKE1,
        SEQ_SE_DECIDE2,
      },
      /* BUTTON_POKE_2 */ 
      {
        IRepairSelect::RESULT_SELECT_PLAYER_POKE,
        PANENAME_REPAIR_SELECT_PANE_POKE2_PLATE,
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_HOLD + 2 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_RELEASE + 2 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_SELECT + 2 ),
        ANIME_NULL,
        ANIME_NULL,
        ANIME_CURSOR_ON_POKE2,
        SEQ_SE_DECIDE2,
      },
      /* BUTTON_POKE_3 */ 
      {
        IRepairSelect::RESULT_SELECT_PARTNER_POKE,
        PANENAME_REPAIR_SELECT_PANE_POKE3_PLATE,
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_HOLD + 3 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_RELEASE + 3 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_SELECT + 3 ),
        ANIME_NULL,
        ANIME_NULL,
        ANIME_CURSOR_ON_POKE3,
        SEQ_SE_DECIDE2,
      },
      /* BUTTON_POKE_4 */ 
      {
        IRepairSelect::RESULT_SELECT_PLAYER_POKE,
        PANENAME_REPAIR_SELECT_PANE_POKE4_PLATE,
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_HOLD + 4 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_RELEASE + 4 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_SELECT + 4 ),
        ANIME_NULL,
        ANIME_NULL,
        ANIME_CURSOR_ON_POKE4,
        SEQ_SE_DECIDE2,
      },
      /* BUTTON_POKE_5 */ 
      {
        IRepairSelect::RESULT_SELECT_PARTNER_POKE,
        PANENAME_REPAIR_SELECT_PANE_POKE5_PLATE,
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_HOLD + 5 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_RELEASE + 5 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_SELECT + 5 ),
        ANIME_NULL,
        ANIME_NULL,
        ANIME_CURSOR_ON_POKE5,
        SEQ_SE_DECIDE2,
      },
      /* BUTTON_RETURN */ 
      {
        IRepairSelect::RESULT_RETURN,
        PANENAME_REPAIR_SELECT_PANE_RETURN_BUTTON,
        ANIME_RETURN_HOLD,
        ANIME_RETURN_RELEASE,
        ANIME_RETURN_SELECT,
        ANIME_RETURN_ACTIVE,
        ANIME_RETURN_PASSIVE,
        ANIME_CURSOR_ON_RETURN,
        SEQ_SE_CANCEL2,
      },
    };



    //----------------------
    // |P{^Ƃ̐ݒ
    //----------------------
    const RepairSelect::PokeButtonDesc RepairSelect::MULTI_POKE_BUTTON_DESC_L[ POKE_BUTTON_NUM ] = 
    {
      {
        { IRepairSelect::PARTY_PLAYER, 0 },
        PANENAME_REPAIR_SELECT_PANE_POKE0_NAME,
        PANENAME_REPAIR_SELECT_PANE_POKE0_SEX,
        PANENAME_REPAIR_SELECT_PANE_POKE0_LV_VALUE,
        PANENAME_REPAIR_SELECT_PANE_POKE0_HP_MAX,
        PANENAME_REPAIR_SELECT_PANE_POKE0_HP_VALUE,
        PANENAME_REPAIR_SELECT_PANE_POKE0_ITEM,
        static_cast<AnimeIndex>( ANIME_POKE0_HP_GAUGE + 0 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_NORMAL + 0 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_PLAYER + 0 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_PARTNER + 0 ),
        ANIME_POKE0_ALIVE,
        ANIME_POKE0_DEAD,
        ANIME_POKE0_EMPTY,
      },
      {
        { IRepairSelect::PARTY_PARTNER, 0 },
        PANENAME_REPAIR_SELECT_PANE_POKE1_NAME,
        PANENAME_REPAIR_SELECT_PANE_POKE1_SEX,
        PANENAME_REPAIR_SELECT_PANE_POKE1_LV_VALUE,
        PANENAME_REPAIR_SELECT_PANE_POKE1_HP_MAX,
        PANENAME_REPAIR_SELECT_PANE_POKE1_HP_VALUE,
        PANENAME_REPAIR_SELECT_PANE_POKE1_ITEM,
        static_cast<AnimeIndex>( ANIME_POKE0_HP_GAUGE + 1 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_NORMAL + 1 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_PLAYER + 1 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_PARTNER + 1 ),
        ANIME_POKE1_ALIVE,
        ANIME_POKE1_DEAD,
        ANIME_POKE1_EMPTY,
      },
      {
        { IRepairSelect::PARTY_PLAYER, 1 },
        PANENAME_REPAIR_SELECT_PANE_POKE2_NAME,
        PANENAME_REPAIR_SELECT_PANE_POKE2_SEX,
        PANENAME_REPAIR_SELECT_PANE_POKE2_LV_VALUE,
        PANENAME_REPAIR_SELECT_PANE_POKE2_HP_MAX,
        PANENAME_REPAIR_SELECT_PANE_POKE2_HP_VALUE,
        PANENAME_REPAIR_SELECT_PANE_POKE2_ITEM,
        static_cast<AnimeIndex>( ANIME_POKE0_HP_GAUGE + 2 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_NORMAL + 2 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_PLAYER + 2 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_PARTNER + 2 ),
        ANIME_POKE2_ALIVE,
        ANIME_POKE2_DEAD,
        ANIME_POKE2_EMPTY,
      },
      {
        { IRepairSelect::PARTY_PARTNER, 1 },
        PANENAME_REPAIR_SELECT_PANE_POKE3_NAME,
        PANENAME_REPAIR_SELECT_PANE_POKE3_SEX,
        PANENAME_REPAIR_SELECT_PANE_POKE3_LV_VALUE,
        PANENAME_REPAIR_SELECT_PANE_POKE3_HP_MAX,
        PANENAME_REPAIR_SELECT_PANE_POKE3_HP_VALUE,
        PANENAME_REPAIR_SELECT_PANE_POKE3_ITEM,
        static_cast<AnimeIndex>( ANIME_POKE0_HP_GAUGE + 3 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_NORMAL + 3 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_PLAYER + 3 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_PARTNER + 3 ),
        ANIME_POKE3_ALIVE,
        ANIME_POKE3_DEAD,
        ANIME_POKE3_EMPTY,
      },
      {
        { IRepairSelect::PARTY_PLAYER, 2 },
        PANENAME_REPAIR_SELECT_PANE_POKE4_NAME,
        PANENAME_REPAIR_SELECT_PANE_POKE4_SEX,
        PANENAME_REPAIR_SELECT_PANE_POKE4_LV_VALUE,
        PANENAME_REPAIR_SELECT_PANE_POKE4_HP_MAX,
        PANENAME_REPAIR_SELECT_PANE_POKE4_HP_VALUE,
        PANENAME_REPAIR_SELECT_PANE_POKE4_ITEM,
        static_cast<AnimeIndex>( ANIME_POKE0_HP_GAUGE + 4 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_NORMAL + 4 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_PLAYER + 4 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_PARTNER + 4 ),
        ANIME_POKE4_ALIVE,
        ANIME_POKE4_DEAD,
        ANIME_POKE4_EMPTY,
      },
      {
        { IRepairSelect::PARTY_PARTNER, 2 },
        PANENAME_REPAIR_SELECT_PANE_POKE5_NAME,
        PANENAME_REPAIR_SELECT_PANE_POKE5_SEX,
        PANENAME_REPAIR_SELECT_PANE_POKE5_LV_VALUE,
        PANENAME_REPAIR_SELECT_PANE_POKE5_HP_MAX,
        PANENAME_REPAIR_SELECT_PANE_POKE5_HP_VALUE,
        PANENAME_REPAIR_SELECT_PANE_POKE5_ITEM,
        static_cast<AnimeIndex>( ANIME_POKE0_HP_GAUGE + 5 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_NORMAL + 5 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_PLAYER + 5 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_PARTNER + 5 ),
        ANIME_POKE5_ALIVE,
        ANIME_POKE5_DEAD,
        ANIME_POKE5_EMPTY,
      },
    };








    //=====================================================================================
    // }`ogp( Ȅꍇ )
    //=====================================================================================

    //-------------------------
    // {^Ƃ̐ݒ
    //-------------------------
    const RepairSelect::ButtonDesc RepairSelect::BUTTON_DESC_MULTI_R[ RepairSelect::BUTTON_NUM ] = 
    {
      /* BUTTON_POKE_0 */ 
      {
        IRepairSelect::RESULT_SELECT_PARTNER_POKE,
        PANENAME_REPAIR_SELECT_PANE_POKE0_PLATE,
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_HOLD + 0 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_RELEASE + 0 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_SELECT + 0 ),
        ANIME_NULL,
        ANIME_NULL,
        ANIME_CURSOR_ON_POKE0,
      },
      /* BUTTON_POKE_1 */ 
      {
        IRepairSelect::RESULT_SELECT_PLAYER_POKE,
        PANENAME_REPAIR_SELECT_PANE_POKE1_PLATE,
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_HOLD + 1 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_RELEASE + 1 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_SELECT + 1 ),
        ANIME_NULL,
        ANIME_NULL,
        ANIME_CURSOR_ON_POKE1,
      },
      /* BUTTON_POKE_2 */ 
      {
        IRepairSelect::RESULT_SELECT_PARTNER_POKE,
        PANENAME_REPAIR_SELECT_PANE_POKE2_PLATE,
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_HOLD + 2 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_RELEASE + 2 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_SELECT + 2 ),
        ANIME_NULL,
        ANIME_NULL,
        ANIME_CURSOR_ON_POKE2,
      },
      /* BUTTON_POKE_3 */ 
      {
        IRepairSelect::RESULT_SELECT_PLAYER_POKE,
        PANENAME_REPAIR_SELECT_PANE_POKE3_PLATE,
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_HOLD + 3 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_RELEASE + 3 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_SELECT + 3 ),
        ANIME_NULL,
        ANIME_NULL,
        ANIME_CURSOR_ON_POKE3,
      },
      /* BUTTON_POKE_4 */ 
      {
        IRepairSelect::RESULT_SELECT_PARTNER_POKE,
        PANENAME_REPAIR_SELECT_PANE_POKE4_PLATE,
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_HOLD + 4 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_RELEASE + 4 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_SELECT + 4 ),
        ANIME_NULL,
        ANIME_NULL,
        ANIME_CURSOR_ON_POKE4,
      },
      /* BUTTON_POKE_5 */ 
      {
        IRepairSelect::RESULT_SELECT_PLAYER_POKE,
        PANENAME_REPAIR_SELECT_PANE_POKE5_PLATE,
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_HOLD + 5 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_RELEASE + 5 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_SELECT + 5 ),
        ANIME_NULL,
        ANIME_NULL,
        ANIME_CURSOR_ON_POKE5,
      },
      /* BUTTON_RETURN */ 
      {
        IRepairSelect::RESULT_RETURN,
        PANENAME_REPAIR_SELECT_PANE_RETURN_BUTTON,
        ANIME_RETURN_HOLD,
        ANIME_RETURN_RELEASE,
        ANIME_RETURN_SELECT,
        ANIME_RETURN_ACTIVE,
        ANIME_RETURN_PASSIVE,
        ANIME_CURSOR_ON_RETURN,
      },
    };



    //-------------------------
    // |P{^Ƃ̐ݒ
    //-------------------------
    const RepairSelect::PokeButtonDesc RepairSelect::MULTI_POKE_BUTTON_DESC_R[ POKE_BUTTON_NUM ] = 
    {
      {
        { IRepairSelect::PARTY_PARTNER, 0 },
        PANENAME_REPAIR_SELECT_PANE_POKE0_NAME,
        PANENAME_REPAIR_SELECT_PANE_POKE0_SEX,
        PANENAME_REPAIR_SELECT_PANE_POKE0_LV_VALUE,
        PANENAME_REPAIR_SELECT_PANE_POKE0_HP_MAX,
        PANENAME_REPAIR_SELECT_PANE_POKE0_HP_VALUE,
        PANENAME_REPAIR_SELECT_PANE_POKE0_ITEM,
        static_cast<AnimeIndex>( ANIME_POKE0_HP_GAUGE + 0 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_NORMAL + 0 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_PLAYER + 0 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_PARTNER + 0 ),
        ANIME_POKE0_ALIVE,
        ANIME_POKE0_DEAD,
        ANIME_POKE0_EMPTY,
      },
      {
        { IRepairSelect::PARTY_PLAYER, 0 },
        PANENAME_REPAIR_SELECT_PANE_POKE1_NAME,
        PANENAME_REPAIR_SELECT_PANE_POKE1_SEX,
        PANENAME_REPAIR_SELECT_PANE_POKE1_LV_VALUE,
        PANENAME_REPAIR_SELECT_PANE_POKE1_HP_MAX,
        PANENAME_REPAIR_SELECT_PANE_POKE1_HP_VALUE,
        PANENAME_REPAIR_SELECT_PANE_POKE1_ITEM,
        static_cast<AnimeIndex>( ANIME_POKE0_HP_GAUGE + 1 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_NORMAL + 1 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_PLAYER + 1 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_PARTNER + 1 ),
        ANIME_POKE1_ALIVE,
        ANIME_POKE1_DEAD,
        ANIME_POKE1_EMPTY,
      },
      {
        { IRepairSelect::PARTY_PARTNER, 1 },
        PANENAME_REPAIR_SELECT_PANE_POKE2_NAME,
        PANENAME_REPAIR_SELECT_PANE_POKE2_SEX,
        PANENAME_REPAIR_SELECT_PANE_POKE2_LV_VALUE,
        PANENAME_REPAIR_SELECT_PANE_POKE2_HP_MAX,
        PANENAME_REPAIR_SELECT_PANE_POKE2_HP_VALUE,
        PANENAME_REPAIR_SELECT_PANE_POKE2_ITEM,
        static_cast<AnimeIndex>( ANIME_POKE0_HP_GAUGE + 2 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_NORMAL + 2 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_PLAYER + 2 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_PARTNER + 2 ),
        ANIME_POKE2_ALIVE,
        ANIME_POKE2_DEAD,
        ANIME_POKE2_EMPTY,
      },
      {
        { IRepairSelect::PARTY_PLAYER, 1 },
        PANENAME_REPAIR_SELECT_PANE_POKE3_NAME,
        PANENAME_REPAIR_SELECT_PANE_POKE3_SEX,
        PANENAME_REPAIR_SELECT_PANE_POKE3_LV_VALUE,
        PANENAME_REPAIR_SELECT_PANE_POKE3_HP_MAX,
        PANENAME_REPAIR_SELECT_PANE_POKE3_HP_VALUE,
        PANENAME_REPAIR_SELECT_PANE_POKE3_ITEM,
        static_cast<AnimeIndex>( ANIME_POKE0_HP_GAUGE + 3 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_NORMAL + 3 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_PLAYER + 3 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_PARTNER + 3 ),
        ANIME_POKE3_ALIVE,
        ANIME_POKE3_DEAD,
        ANIME_POKE3_EMPTY,
      },
      {
        { IRepairSelect::PARTY_PARTNER, 2 },
        PANENAME_REPAIR_SELECT_PANE_POKE4_NAME,
        PANENAME_REPAIR_SELECT_PANE_POKE4_SEX,
        PANENAME_REPAIR_SELECT_PANE_POKE4_LV_VALUE,
        PANENAME_REPAIR_SELECT_PANE_POKE4_HP_MAX,
        PANENAME_REPAIR_SELECT_PANE_POKE4_HP_VALUE,
        PANENAME_REPAIR_SELECT_PANE_POKE4_ITEM,
        static_cast<AnimeIndex>( ANIME_POKE0_HP_GAUGE + 4 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_NORMAL + 4 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_PLAYER + 4 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_PARTNER + 4 ),
        ANIME_POKE4_ALIVE,
        ANIME_POKE4_DEAD,
        ANIME_POKE4_EMPTY,
      },
      {
        { IRepairSelect::PARTY_PLAYER, 2 },
        PANENAME_REPAIR_SELECT_PANE_POKE5_NAME,
        PANENAME_REPAIR_SELECT_PANE_POKE5_SEX,
        PANENAME_REPAIR_SELECT_PANE_POKE5_LV_VALUE,
        PANENAME_REPAIR_SELECT_PANE_POKE5_HP_MAX,
        PANENAME_REPAIR_SELECT_PANE_POKE5_HP_VALUE,
        PANENAME_REPAIR_SELECT_PANE_POKE5_ITEM,
        static_cast<AnimeIndex>( ANIME_POKE0_HP_GAUGE + 5 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_NORMAL + 5 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_PLAYER + 5 ),
        static_cast<AnimeIndex>( ANIME_POKE0_PLATE_PARTNER + 5 ),
        ANIME_POKE5_ALIVE,
        ANIME_POKE5_DEAD,
        ANIME_POKE5_EMPTY,
      },
    };


















    // |P{^̏ݒ擾
    const RepairSelect::PokeButtonDesc& RepairSelect::GetInitialPokeButtonDesc( ButtonIndex button_index ) const
    {
      GFL_ASSERT( button_index < POKE_BUTTON_NUM );
      switch( this->GetMode() ) {
      default:
      case IRepairSelect::MODE_NORMAL: return POKE_BUTTON_DESC_NORMAL[ button_index ];
      case IRepairSelect::MODE_MULTI_L: return MULTI_POKE_BUTTON_DESC_L[ button_index ];
      case IRepairSelect::MODE_MULTI_R: return MULTI_POKE_BUTTON_DESC_R[ button_index ];
      }
    }

    // |P{^Ƃ̐ݒ擾
    const RepairSelect::PokeButtonDesc& RepairSelect::GetPokeButtonDesc( ButtonIndex button_index ) const
    {
      GFL_ASSERT( button_index < POKE_BUTTON_NUM );
      return m_poke_button_desc[ button_index ];
    } 










    //---------------------------------------------------------------------------------
    // RXgN^
    //---------------------------------------------------------------------------------
    RepairSelect::RepairSelect( 
        gfl::heap::HeapBase* heap, gfl::heap::HeapBase* device_heap, 
        BattleViewSystem* btlv_system ) : 
      IRepairSelect( heap, APP_HEAPSIZE, device_heap, DEVICE_HEAPSIZE, btlv_system ),
      m_layout_work( NULL ),
      m_layout_resource_id( 0 ),
      m_button_manager( NULL ),
      m_cursor_manager( NULL ),
      m_str_win( NULL ),
      m_seq( SEQ_INPUT_WAIT ),
      m_next_seq( SEQ_INPUT_WAIT ),
      m_wait_anime_index( ANIME_NULL ),
      m_poke_button_desc()
    {
      this->InitializeGraphicsSystem();
      this->SetupFont();
      this->CreateLayoutWork();
      this->CreateShareAnime();
      this->CreateCursorManager();  // J[\ړ̓[hԂōقȂ߃RRŐ
      this->CreateStrWin();

#if 0 // q[vcʃ`FbN
      gfl::heap::HeapBase* app_heap = this->GetHeap();
      gfl::heap::HeapBase* dev_heap = this->GetDeviceHeap();
      GFL_PRINT( "HEAPID_BATTLE_RepairSelect: 0x%x/0x%x, 0x%x/0x%x\n", 
          app_heap->GetTotalFreeSize(), app_heap->GetTotalSize(),
          dev_heap->GetTotalFreeSize(), dev_heap->GetTotalSize() );
#endif
    }



    // OtBbNXVXe
    void RepairSelect::InitializeGraphicsSystem( void )
    {
      gfl::heap::NwAllocator* nw_device_allocator = this->GetNwDeviceAllocator();
      gfl::grp::GraphicsSystem* graphics_system = this->GetGraphicsSystem();
      graphics_system->InitializeApplicationMemory( nw_device_allocator );
    }


    // tHg̏
    void RepairSelect::SetupFont( void )
    {
      gfl::grp::g2d::LytSys::SetDefaultFont( SystemFont_GetFont(), "cbf_std.bcfnt" );
    }


    // CAEg[N𐶐
    void RepairSelect::CreateLayoutWork( void )
    {
      gfl::heap::HeapBase* heap = this->GetHeap();
      gfl::heap::NwAllocator* nw_device_allocator = this->GetNwDeviceAllocator();
      gfl::grp::g2d::LytSys* layout_system = this->GetLayoutSystem();

      gfl::fs::ArcFile arc_file( ARCID_BATTLE_APP, heap );
      m_layout_resource_id = layout_system->LoadLytRes( 
          nw_device_allocator, &arc_file, GARC_btl_app_repair_select_LYTDAT );
      layout_system->TransferAllTexture( m_layout_resource_id, gfl::grp::MEMORY_AREA_FCRAM );

      m_layout_work = layout_system->CreateLytWk(
          m_layout_resource_id,
          LYTRES_REPAIR_SELECT_REPAIR_SELECT_BCLYT,
          ANIME_DATA_TABLE, ANIME_DATA_NUM, ANIME_NUM,
          &LAYOUT_WORK_SETUP_DATA,
          false );  // Aj[VoChȂ
    }


    // LAj[V𐶐
    void RepairSelect::CreateShareAnime( void )
    {
      for( u32 i=0; i<SHARE_ANIME_NUM; i++ ) {
        m_layout_work->CreateShareAnime( 
            SHARE_ANIME_DESC[i].start_anime_index,
            ANIME_DATA_TABLE[ SHARE_ANIME_DESC[i].anime_data_index ],
            SHARE_ANIME_DESC[i].max_share_num,
            SHARE_ANIME_DESC[i].share_group_index,
            SHARE_ANIME_DESC[i].share_pane_index );
      }
    }


    // J[\ǗIuWFNg𐶐
    void RepairSelect::CreateCursorManager( void )
    {
      gfl::heap::HeapBase* heap = this->GetHeap();
      m_cursor_manager = GFL_NEW( heap ) 
        ::app::tool::CursorManager( CURSOR_MOVE_DATA, BUTTON_NUM, heap, 0 );
    }


    // IuWFNg𐶐
    void RepairSelect::CreateStrWin( void )
    {
      gfl::heap::HeapBase* heap = this->GetHeap();
      gfl::ui::DeviceManager* ui_device_manager = this->GetUiDeviceManager(); 
      m_str_win = GFL_NEW( heap ) 
        print::MsgWin( ui_device_manager, m_layout_work, MESSAGE_LINES, 0, heap );
      for( u16 i=0; i<MESSAGE_LINES; i++ ) {
        m_str_win->AddLinePaneIdx( MESSAGE_LINES_PANE[i] );
      }
    }












    //---------------------------------------------------------------------------------
    // fXgN^
    //---------------------------------------------------------------------------------
    RepairSelect::~RepairSelect()
    {
      this->DeleteStrWin();
      this->DeleteCursorManager();
      this->DeleteButtonManager();
      this->DeleteLayoutWork();
      this->FinalizeGraphicsSystem();
    }


    // IuWFNgj
    void RepairSelect::DeleteStrWin( void )
    {
      if( m_str_win ) {
        GFL_DELETE m_str_win;
      }
    }


    // J[\ǗIuWFNgj
    void RepairSelect::DeleteCursorManager( void )
    {
      if( m_cursor_manager ) {
        GFL_DELETE m_cursor_manager;
      }
    }


    // {^}l[Wj
    void RepairSelect::DeleteButtonManager( void )
    {
      if( m_button_manager ) {
        GFL_DELETE m_button_manager;
      }
    }


    // CAEg[Nj
    void RepairSelect::DeleteLayoutWork( void ) 
    {
      gfl::grp::g2d::LytSys* layout_system = this->GetLayoutSystem();
      layout_system->RemoveLytWk( m_layout_work );
      layout_system->ReleaseLytRes( m_layout_resource_id );
    }


    // OtBbNXVXȅI
    void RepairSelect::FinalizeGraphicsSystem( void )
    {
      gfl::grp::GraphicsSystem* graphics_system = this->GetGraphicsSystem();
      graphics_system->FinalizeApplicationMemory();
    }









    //---------------------------------------------------------------------------------
    /**
     * @brief I[g`tOZbg
     * @param flag  true Ȃ`悷
     */
    //---------------------------------------------------------------------------------
    void RepairSelect::SetAutoDrawFlag( bool flag )
    {
      if( m_layout_work ) {
        m_layout_work->SetAutoDrawFlag( flag );
      }
    }







    //---------------------------------------------------------------------------------
    // ݒύX
    //---------------------------------------------------------------------------------
    void RepairSelect::ChangeSetting( const Setting& new_setting )
    { 
      this->DeleteButtonManager();
      this->CreateButtonManager();

      this->SetSetting( new_setting ); 
      this->InitialziePokeButtonDesc(); 
      this->SetupButtonManager();
      this->SetupMessage();
      this->SetupReturnButtonActivity();

      for( u8 i=0; i<POKE_BUTTON_NUM; i++ ) {
        ButtonIndex button_index = static_cast<ButtonIndex>( i );
        const PokeButtonDesc& button_desc = this->GetPokeButtonDesc( button_index );
        this->SetupPokeButton( button_index, button_desc );
      }
    } 

    // |P{^̐ݒ
    void RepairSelect::InitialziePokeButtonDesc( void )
    {
      for( u8 i=0; i<POKE_BUTTON_NUM; i++ ) {
        ButtonIndex button_index = static_cast<ButtonIndex>( i );
        m_poke_button_desc[i] = this->GetInitialPokeButtonDesc( button_index );
      }
    } 


    // {^}l[W𐶐
    void RepairSelect::CreateButtonManager( void )
    {
      const gfl::ui::DeviceManager* ui_device_manager = this->GetUiDeviceManager(); 
      gfl::heap::HeapBase* heap = this->GetHeap();
      m_button_manager = GFL_NEW( heap ) 
        ::app::tool::ButtonManager( heap, ui_device_manager, BUTTON_NUM, ANIME_NULL );
    }


    // {^}l[WZbgAbv
    void RepairSelect::SetupButtonManager( void )
    {
      for( u32 i=0; i<BUTTON_NUM; i++ ) 
      {
        ButtonIndex button_index = static_cast<ButtonIndex>(i);
        const ButtonDesc& desc = this->GetButtonDesc( button_index );
        m_button_manager->AddButton( 
            this->GetHeap(), 
            i,  // ID ̓{^̃CfbNX
            m_layout_work,
            desc.pane_index,
            desc.hold_anime,
            desc.release_anime,
            desc.select_anime,
            desc.active_anime,
            desc.passive_anime,
            NULL );  // R[obNȂ

        m_button_manager->SetButtonSelectSE( i, desc.select_se );
      }
    }

    // {^Ƃ̐ݒ擾
    const RepairSelect::ButtonDesc& RepairSelect::GetButtonDesc( ButtonIndex button_index ) const
    {
      GFL_ASSERT( button_index < BUTTON_NUM );
      switch( this->GetMode() ) {
      default:
      case IRepairSelect::MODE_NORMAL: return BUTTON_DESC_NORMAL[ button_index ]; 
      case IRepairSelect::MODE_MULTI_L: return BUTTON_DESC_MULTI_L[ button_index ]; 
      case IRepairSelect::MODE_MULTI_R: return BUTTON_DESC_MULTI_R[ button_index ];
      }
    } 





    // \郁bZ[W̃ZbgAbv
    void RepairSelect::SetupMessage( void )
    {
      gfl::str::MsgData* message_data = AppBase::GetMessageData();
      ::app::util::SetTextboxPaneMessage( m_layout_work, 
          PANENAME_REPAIR_SELECT_PANE_MESSAGE_00, message_data, STR_SELECT_POKE_ITEM );
    }




    //uǂv{^L̃ZbgAbv
    void RepairSelect::SetupReturnButtonActivity( void )
    {
      if( this->IsReturnEnable() ) {
        m_button_manager->SetButtonActive( BUTTON_RETURN );
      }
      else {
        m_button_manager->SetButtonPassive( BUTTON_RETURN );
      }
    }




    // w肵|P{^̃ZbgAbv
    void RepairSelect::SetupPokeButton( ButtonIndex button_index, const PokeButtonDesc& button_desc )
    {
      GFL_ASSERT( button_index < POKE_BUTTON_NUM  );
      if( button_index < POKE_BUTTON_NUM  ) {
        this->SetupPokeButton_Params( button_index, button_desc );
        bool selectable_kind = this->SetupPokeButton_Kind( button_index, button_desc );
        bool selectable_state = this->SetupPokeButton_State( button_index, button_desc );
        if( selectable_kind && selectable_state ) {
          m_button_manager->SetButtonActive( button_index );
        }
        else {
          m_button_manager->SetButtonPassive( button_index );
        }
      }
    } 


    // {^̎ނZbgAbv
    // ZbgAbv̌, I\ǂԂ
    bool RepairSelect::SetupPokeButton_Kind( 
        ButtonIndex button_index, const PokeButtonDesc& button_desc )
    {
      if( ( this->GetMode() == IRepairSelect::MODE_MULTI_L ) ||
          ( this->GetMode() == IRepairSelect::MODE_MULTI_R ) ) 
      {
        if( button_desc.link.party_id == IRepairSelect::PARTY_PLAYER ) {
          this->SetPokeButtonDisplay_Player( button_index, button_desc );
          return true;  // I\
        }
        else {
          this->SetPokeButtonDisplay_Partner( button_index, button_desc );
          return false;  // Is 
        }
      }
      else
      {
        this->SetPokeButtonDisplay_Normal( button_index, button_desc );
        return true;  // I\
      }
    } 

    // ʏ펞̃v[gɂ
    void RepairSelect::SetPokeButtonDisplay_Normal(
        ButtonIndex button_index, const PokeButtonDesc& button_desc )
    {
      ::app::util::StartAnimation( m_layout_work, button_desc.plate_normal_anime );
      ::app::util::StopAnimation( m_layout_work, button_desc.plate_player_anime );
      ::app::util::StopAnimation( m_layout_work, button_desc.plate_partner_anime );
    }

    // }`og̃vC[pv[gɂ
    void RepairSelect::SetPokeButtonDisplay_Player( 
        ButtonIndex button_index, const PokeButtonDesc& button_desc )
    {
      ::app::util::StopAnimation( m_layout_work, button_desc.plate_normal_anime );
      ::app::util::StartAnimation( m_layout_work, button_desc.plate_player_anime );
      ::app::util::StopAnimation( m_layout_work, button_desc.plate_partner_anime );
    }

    // }`og̃p[gi[pv[gɂ
    void RepairSelect::SetPokeButtonDisplay_Partner( 
        ButtonIndex button_index, const PokeButtonDesc& button_desc )
    {
      ::app::util::StopAnimation( m_layout_work, button_desc.plate_normal_anime );
      ::app::util::StopAnimation( m_layout_work, button_desc.plate_player_anime );
      ::app::util::StartAnimation( m_layout_work, button_desc.plate_partner_anime );
    }




    // {^̏ԂZbgAbv
    // ZbgAbv̌, I\ǂԂ
    bool RepairSelect::SetupPokeButton_State( 
        ButtonIndex button_index, const PokeButtonDesc& button_desc )
    {
      const BTL_PARTY* party = this->GetParty( button_desc.link.party_id );
      u8 member_count = party->GetMemberCount();
      if( member_count <= button_desc.link.pokeindex ) {
        this->SetPokeButtonDisplay_Empty( button_index, button_desc );
        return false;  // Is
      }
      else {
        const BTL_POKEPARAM* btlparam = party->GetMemberDataConst( button_desc.link.pokeindex );
        if( btlparam->IsDead() ) {
          this->SetPokeButtonDisplay_Dead( button_index, button_desc );
          return true;  // I\
        }
        else {
          this->SetPokeButtonDisplay_Alive( button_index, button_desc );
          return true;  // I\
        }
      }
    } 

    // 퓬\Ԃ̕\ɂ
    void RepairSelect::SetPokeButtonDisplay_Alive( 
        ButtonIndex button_index, const PokeButtonDesc& button_desc )
    {
      ::app::util::StartAnimation( m_layout_work, button_desc.plate_alive_anime );
      ::app::util::StopAnimation( m_layout_work, button_desc.plate_dead_anime );
      ::app::util::StopAnimation( m_layout_work, button_desc.plate_empty_anime );
    }

    // 퓬s\Ԃ̕\ɂ
    void RepairSelect::SetPokeButtonDisplay_Dead(
        ButtonIndex button_index, const PokeButtonDesc& button_desc )
    {
      ::app::util::StopAnimation( m_layout_work, button_desc.plate_alive_anime );
      ::app::util::StartAnimation( m_layout_work, button_desc.plate_dead_anime );
      ::app::util::StopAnimation( m_layout_work, button_desc.plate_empty_anime );
    }

    // ̕\ɂ
    void RepairSelect::SetPokeButtonDisplay_Empty( 
        ButtonIndex button_index, const PokeButtonDesc& button_desc )
    {
      ::app::util::StopAnimation( m_layout_work, button_desc.plate_alive_anime );
      ::app::util::StopAnimation( m_layout_work, button_desc.plate_dead_anime );
      ::app::util::StartAnimation( m_layout_work, button_desc.plate_empty_anime );
    }






    // |P̃p[^𔽉f
    void RepairSelect::SetupPokeButton_Params( 
        ButtonIndex button_index, const PokeButtonDesc& button_desc )
    {
      const BTL_PARTY* party = this->GetParty( button_desc.link.party_id );
      u8 member_count = party->GetMemberCount();
      const BTL_POKEPARAM* poke_param = party->GetMemberDataConst( button_desc.link.pokeindex );
      if( button_desc.link.pokeindex < member_count ) {
        // jbNl[, 
        this->SetPokeButtonDisplay_Name( button_index, button_desc, poke_param );
        this->SetPokeButtonDisplay_Sex( button_index, button_desc, poke_param );
        // x, HP
        u32 level = poke_param->GetValue( BTL_POKEPARAM::BPP_LEVEL );
        u32 max_hp = poke_param->GetValue( BTL_POKEPARAM::BPP_MAX_HP );
        u32 now_hp = poke_param->GetValue( BTL_POKEPARAM::BPP_HP );
        // ACe
        u32 item = poke_param->GetItem();
        this->SetPokeButtonDisplay_Level( button_index, button_desc, level );
        this->SetPokeButtonDisplay_Hp( button_index, button_desc, max_hp, now_hp );
        if( ( item != ITEM_DUMMY_DATA ) && ( item < ITEM_DATA_MAX ) ) {
          this->SetPokeButtonDisplay_HaveItem( button_index, button_desc );
        }
        else {
          this->SetPokeButtonDisplay_NotHaveItem( button_index, button_desc );
        }
      }
    }


    // OZbg
    void RepairSelect::SetPokeButtonDisplay_Name( 
        ButtonIndex button_index, const PokeButtonDesc& button_desc, 
        const BTL_POKEPARAM* btl_param )
    {
      const pml::pokepara::PokemonParam* poke_param = btl_param->GetSrcData();
      gfl::str::StrBuf* strbuf = ::app::util::GetTempStrBuf();
      poke_param->GetNickName( strbuf );
      ::app::util::SetTextboxPaneString( m_layout_work, button_desc.name_pane, strbuf );
    }


    // ʂZbg
    void RepairSelect::SetPokeButtonDisplay_Sex(
        ButtonIndex button_index, const PokeButtonDesc& button_desc, 
        const BTL_POKEPARAM* btl_param )
    {
      pml::Sex sex = static_cast<pml::Sex>( btl_param->GetValue( BTL_POKEPARAM::BPP_SEX ) );
      ::app::util::SetTextboxPaneSex( m_layout_work, button_desc.sex_pane, sex ); 
    }


    // x̒lZbg
    void RepairSelect::SetPokeButtonDisplay_Level( 
        ButtonIndex button_index, const PokeButtonDesc& button_desc, u32 level )
    {
      ::app::util::SetTextboxPaneNumber( 
          m_layout_work, button_desc.lv_value_pane, level, LV_PLACE_COUNT );
    }


    // HP̒lZbg
    void RepairSelect::SetPokeButtonDisplay_Hp( 
        ButtonIndex button_index, const PokeButtonDesc& button_desc, u32 max_hp, u32 now_hp )
    {
      u32 gauge_frame = ::app::tool::Gauge::GetDottoNum( now_hp, max_hp, 100 );  // ő100t[
      ::app::util::SetTextboxPaneNumber( m_layout_work, button_desc.hp_max_pane, max_hp, HP_PLACE_COUNT );
      ::app::util::SetTextboxPaneNumber( m_layout_work, button_desc.hp_value_pane, now_hp, HP_PLACE_COUNT );
      ::app::util::StartAnimation( m_layout_work, button_desc.hp_gauge_anime );
      ::app::util::PauseAnimation( m_layout_work, button_desc.hp_gauge_anime, false );
      ::app::util::SetAnimationFrame( m_layout_work, button_desc.hp_gauge_anime, gauge_frame );
    } 


    // ACeĂԂ̕\ɂ
    void RepairSelect::SetPokeButtonDisplay_HaveItem( 
        ButtonIndex button_index, const PokeButtonDesc& button_desc )
    {
      ::app::util::SetPaneVisible( m_layout_work, button_desc.item_icon_pane );
    } 

    // ACeĂȂԂ̕\ɂ
    void RepairSelect::SetPokeButtonDisplay_NotHaveItem(
        ButtonIndex button_index, const PokeButtonDesc& button_desc )
    {
      ::app::util::SetPaneInvisible( m_layout_work, button_desc.item_icon_pane );
    }







    




    //---------------------------------------------------------------------------------
    // ŏĊJ( ݒ͈p )
    //---------------------------------------------------------------------------------
    void RepairSelect::Start( void )
    {
      this->ResetFinishFlag();
      this->ResetResult();
      m_seq = SEQ_INPUT_WAIT;
      m_next_seq = SEQ_INPUT_WAIT;
      m_wait_anime_index = ANIME_NULL;
      this->InitializeCursorPos();
    }


    // J[\ʒu
    void RepairSelect::InitializeCursorPos( void )
    {
      InitCursorPos init_pos = this->GetInitCursorPos();
      ButtonIndex init_button = BUTTON_RETURN;

      switch( init_pos ) {
      case INIT_CURSOR_POS_POKE0: init_button = BUTTON_POKE_0; break;
      case INIT_CURSOR_POS_POKE1: init_button = BUTTON_POKE_1; break;
      case INIT_CURSOR_POS_POKE2: init_button = BUTTON_POKE_2; break;
      case INIT_CURSOR_POS_POKE3: init_button = BUTTON_POKE_3; break;
      case INIT_CURSOR_POS_POKE4: init_button = BUTTON_POKE_4; break;
      case INIT_CURSOR_POS_POKE5: init_button = BUTTON_POKE_5; break;
      case INIT_CURSOR_POS_RETURN: init_button = BUTTON_RETURN; break;
      }

      for( u8 i=0; i<BUTTON_NUM; i++ ) {
        ButtonIndex button_index = static_cast<ButtonIndex>( i );
        const ButtonDesc& button_desc = this->GetButtonDesc( button_index );
        if( button_index == init_button ) {
          ::app::util::StartAnimation( m_layout_work, button_desc.cursor_anime );
        }
        else {
          ::app::util::StopAnimation( m_layout_work, button_desc.cursor_anime );
        }
      }
      m_cursor_manager->SetPos( init_button );
      ::app::util::StartAnimation( m_layout_work, ANIME_CURSOR_FLUCTUATE );
    }













    //---------------------------------------------------------------------------------
    // XV
    //---------------------------------------------------------------------------------
    void RepairSelect::Update( void )
    {
      m_button_manager->Update();
      this->UpdateSequence(); 

      if( m_seq == SEQ_FINISH ) {
        GFL_ASSERT( this->GetResult() != RESULT_NULL );
        this->SetFinishFlag();
      }
    } 

    /**
     * @brief V[PXXV
     */
    void RepairSelect::UpdateSequence( void )
    { 
      switch( m_seq )
      {
      case SEQ_INPUT_WAIT:
        this->UpdateSequence_INPUT_WAIT();
        break; 

      case SEQ_ANIME_WAIT:
        this->UpdateSequence_ANIME_WAIT();
        break; 

      case SEQ_ITEM_USE:
        this->UpdateSequence_ITEM_USE();
        break;

      case SEQ_MESSAGE:
        this->UpdateSequence_MESSAGE();
        break;

      default:
        GFL_ASSERT(0);
        break;
      }
    }



    //=========================================================================
    /**
     * @brief V[PXXV
     */
    //=========================================================================
    void RepairSelect::UpdateSequence_INPUT_WAIT( void )
    {
      const gfl::ui::Button* ui_button = this->GetButton();
      ButtonIndex selected_button = BUTTON_NULL;

      if( this->IsButtonSelectedByTouch() ) 
      {
        ButtonIndex touched_button = this->GetSelectedButtonByTouch();
        if( this->IsButtonSelectEnable( touched_button ) ) {
            selected_button = touched_button;
        }
      }
      else if( this->IsButtonHolding() ) 
      {
        // do nothing
      }
      else if( ui_button->IsTrigger( gfl::ui::BUTTON_B ) ) 
      {
        if( this->IsButtonSelectEnable( BUTTON_RETURN ) ) {
          this->OnButtonSelectedByKey( BUTTON_RETURN );
          selected_button = BUTTON_RETURN;
        }
      }
      else if( ui_button->IsTrigger( gfl::ui::BUTTON_A ) ) 
      {
        ButtonIndex cursor_pos = this->GetCurrentCursorPos();
        if( this->IsButtonSelectEnable( cursor_pos ) ) {
          this->OnButtonSelectedByKey( cursor_pos );
          selected_button = cursor_pos;
        }
      }
      else if( this->UpdateCursorMove() )  // J[\ړ
      {  
        ButtonIndex old_cursor_pos = this->GetPrevCursorPos();
        ButtonIndex new_cursor_pos = this->GetCurrentCursorPos();
        this->OnCursorMoved( old_cursor_pos, new_cursor_pos );
      }


      // Iꂽ{^ɂV[PXJ
      switch( selected_button ) 
      {
      case BUTTON_NULL:
        break;

      case BUTTON_RETURN:
        this->SetResult( RESULT_RETURN );
        m_wait_anime_index = this->GetButtonDesc( BUTTON_RETURN ).select_anime;
        m_seq = SEQ_ANIME_WAIT;
        m_next_seq = SEQ_FINISH;
        break;

      default:
        {
          const PokeButtonDesc& poke_button_desc = this->GetPokeButtonDesc( selected_button );
          this->SetSelectedPokeIndex( poke_button_desc.link.pokeindex );
          m_wait_anime_index = this->GetButtonDesc( selected_button ).select_anime;
          m_seq = SEQ_ANIME_WAIT;
          m_next_seq = SEQ_ITEM_USE;
        }
        break;
      }
    } 


    /**
     * @brief ^b`͂ɂ{^Iꂽǂ𒲂ׂ
     * @retval true   Iꂽ
     * @retval false  IĂȂ
     */
    bool RepairSelect::IsButtonSelectedByTouch( void ) const
    {
      return m_button_manager->IsButtonSelected();
    } 

    /**
     * @brief ^b`͂ɂIꂽ{^擾
     */
    RepairSelect::ButtonIndex RepairSelect::GetSelectedButtonByTouch( void ) const
    {
      return static_cast<ButtonIndex>( m_button_manager->GetSelectedButtonId() );
    }

    /**
     * @brief {^Ă邩ǂ𒲂ׂ
     * @retval true   Ă
     * @retval false  ĂȂ
     */
    bool RepairSelect::IsButtonHolding( void ) const
    {
      return m_button_manager->IsButtonHolding();
    }

    /**
     * @brief I\ǂ𒲂ׂ
     * @param button  `FbN{^
     * @retval true   Ił
     * @retval false  IłȂ
     */
    bool RepairSelect::IsButtonSelectEnable( ButtonIndex button ) const
    {
      return m_button_manager->IsButtonActive( button );
    }

    /**
     * @brief L[͂ɂ{^Iꂽۂ̏
     * @param selected_button  Iꂽ{^
     */
    void RepairSelect::OnButtonSelectedByKey( ButtonIndex selected_button )
    {
      m_button_manager->StartSelectedAct( selected_button ); 
    }

    /**
     * @brief J[\̓XV
     * @retval true   J[\ړ  
     * @retval false  J[\ړȂ
     */
    bool RepairSelect::UpdateCursorMove( void )
    {
      ::app::tool::CursorManager::MOVE_RET move_result = m_cursor_manager->MainTrigger();
      return( move_result == ::app::tool::CursorManager::RET_MOVE ); // ړǂ
    }

    /**
     * @brief ÕJ[\ʒu擾
     */
    RepairSelect::ButtonIndex RepairSelect::GetPrevCursorPos( void ) const
    {
      return static_cast<ButtonIndex>( m_cursor_manager->GetOldID() );
    }

    /**
     * @brief ݂̃J[\ʒu擾
     */
    RepairSelect::ButtonIndex RepairSelect::GetCurrentCursorPos( void ) const
    {
      return static_cast<ButtonIndex>( m_cursor_manager->GetID() );
    } 

    /**
     * @brief J[\ړۂ̏
     * @param old_pos  ړÕJ[\ʒu
     * @param new_pos  ړ̃J[\ʒu
     */
    void RepairSelect::OnCursorMoved( ButtonIndex old_pos, ButtonIndex new_pos )
    {
      const ButtonDesc& old_button_desc = this->GetButtonDesc( old_pos );
      const ButtonDesc& new_button_desc = this->GetButtonDesc( new_pos );
      ::app::util::StopAnimation( m_layout_work, old_button_desc.cursor_anime );
      ::app::util::StartAnimation( m_layout_work, new_button_desc.cursor_anime );
      snd::SEController::PlaySE( SEQ_SE_SELECT2 );
    }





    //=========================================================================
    /**
     * @brief V[PXXV
     */
    //=========================================================================
    void RepairSelect::UpdateSequence_ANIME_WAIT( void )
    {
      if( this->IsWaitAnimeEnd() ) {
        m_seq = m_next_seq;
      }
    }

    /**
     * @biref ҋ@Aj[VIǂ𒲂ׂ
     * @retval true   I
     * @retval false  IĂȂ
     */
    bool RepairSelect::IsWaitAnimeEnd( void ) const
    {
      if( m_wait_anime_index < ANIME_NUM ) {
        return ::app::util::IsAnimationEnd( m_layout_work, m_wait_anime_index );
      }
      return true;  // Aj[Vo^ȂIƂɂ
    }




    //=========================================================================
    /**
     * @brief V[PXXV
     */
    //=========================================================================
    void RepairSelect::UpdateSequence_ITEM_USE( void )
    {
      // @todo g邩ǂ𒲂ׂ
      if( !true ) {
        this->SetResult( RESULT_CANT_USE );
        this->StartMessageStream( str_btl_repair_00 );
        m_seq = SEQ_MESSAGE;
        m_next_seq = SEQ_FINISH;
      }
      else if( this->IsFrontPoke( this->GetSelectedPokeIndex() ) ) {
        this->SetResult( RESULT_SELECT_PLAYER_POKE );
        m_seq = SEQ_FINISH;
      }
      else if( this->IsHPRecoverItem() && this->IsSickRecoverItem() ) {
        this->SetResult( RESULT_SELECT_PLAYER_POKE );
        this->StartMessageStream( str_btl_repair_04 );
        m_seq = SEQ_MESSAGE;
        m_next_seq = SEQ_FINISH;
      }
      else if( this->IsHPRecoverItem() ) {
        this->SetResult( RESULT_SELECT_PLAYER_POKE );
        this->StartMessageStream( str_btl_repair_01 );
        m_seq = SEQ_MESSAGE;
        m_next_seq = SEQ_FINISH;
      }
      else if( this->IsSickRecoverItem() ) {
        this->SetResult( RESULT_SELECT_PLAYER_POKE );
        this->StartMessageStream( str_btl_repair_02 );
        m_seq = SEQ_MESSAGE;
        m_next_seq = SEQ_FINISH;
      }
      else if( this->IsDeathRecoverItem() ) {
        this->SetResult( RESULT_SELECT_PLAYER_POKE );
        this->StartMessageStream( str_btl_repair_03 );
        m_seq = SEQ_MESSAGE;
        m_next_seq = SEQ_FINISH;
      }
      else {
        this->SetResult( RESULT_SELECT_PLAYER_POKE );
        m_seq = SEQ_FINISH;
      }
    }

    /**
     * @brief ogɂ|Pǂ𒲂ׂ
     * @param pokeindex  `FbN|P̃CfbNX
     * @retval true   og̃|P
     * @retval false  T|P
     */
    bool RepairSelect::IsFrontPoke( u8 pokeindex ) const
    {
      return ( pokeindex < this->GetBattleViewSystem()->GetFrontPosCount_Self() );
    }

    /**
     * @brief bZ[W̕\Jn
     * @param strID  \镶ID
     */
    void RepairSelect::StartMessageStream( u32 strID )
    {
      gfl::str::StrBuf* strbuf = ::app::util::GetTempStrBuf( 0 );
      gfl::str::MsgData* message_data = AppBase::GetMessageData(); 

      if( ( strID == str_btl_repair_03 ) || ( strID == str_btl_repair_04 ) ) {
        u8 pokeindex = this->GetSelectedPokeIndex();
        const BTL_PARTY* btlparty = this->GetBattleViewSystem()->GetBattleParty_Self();
        const BTL_POKEPARAM* btlparam = btlparty->GetMemberDataConst( pokeindex );
        const pml::pokepara::PokemonParam* pokeparam = btlparam->GetSrcData();
        gfl::str::StrBuf* tempbuf = ::app::util::GetTempStrBuf( 1 );
        message_data->GetString( strID, *tempbuf );
        WordSet* wordset = ::app::util::GetWordset();
        wordset->RegisterPokeNickName( 0, pokeparam );
        wordset->Expand( strbuf, tempbuf );
      }
      else {
        message_data->GetString( strID, *strbuf );
      }

      m_str_win->Clear();
      m_str_win->SetString( *strbuf );
      m_str_win->SetFinishMode( gfl::str::StrWin::FINISH_USER, 0 );
      ::app::util::StopAnimation( m_layout_work, ANIME_MESSAGE_CLOSE );
      ::app::util::StartAnimation( m_layout_work, ANIME_MESSAGE_OPEN );
    } 




    //=========================================================================
    /**
     * @brief V[PXXV
     */
    //=========================================================================
    void RepairSelect::UpdateSequence_MESSAGE( void )
    {
      if( this->UpdateMessageStream() ) {
        this->EndMessageStream();
        m_seq = m_next_seq;
      }
    } 

    /**
     * @brief bZ[W̕\XV
     * @retval true   \I
     * @retval false  \p
     */
    bool RepairSelect::UpdateMessageStream( void )
    {
      gfl::str::StrWin::Result result = m_str_win->Proc();
      return ( result == gfl::str::StrWin::RES_FINISH );
    } 

    /**
     * @brief bZ[W̕\I
     */
    void RepairSelect::EndMessageStream( void )
    {
      ::app::util::StopAnimation( m_layout_work, ANIME_MESSAGE_OPEN );
      ::app::util::StartAnimation( m_layout_work, ANIME_MESSAGE_CLOSE );
    }




  }  // namespace app
}  // namespace btl
