//=======================================================================================
/**
 * @file IRepairSelect.h
 * @brief 񕜑ΏۑIʂ̊{NX
 * @author obata_toshihiro
 * @date 2011.09.27
 */
//=======================================================================================
#ifndef __IREPAIRSELECT_H__
#define __IREPAIRSELECT_H__
#include <gflib.h>
#include <battle/btl_common.h>
#include "AppBase.h"


namespace btl {

  class BattleViewSystem;


  namespace app {

    class IRepairSelect : public AppBase
    {
      GFL_FORBID_COPY_AND_ASSIGN( IRepairSelect );  // Rs[֎~

      public:


      //---------------------------------------------------------------------------------
      // ݒ
      //---------------------------------------------------------------------------------
      // 샂[h
      enum Mode {
        MODE_NORMAL,    // ʏp( 6̂̒I )
        MODE_MULTI_L,   // }`p( 3̂̒I, ͍ )
        MODE_MULTI_R,   // }`p( 3̂̒I, ͉E )
      }; 

      // \p[eB
      enum PartyId {
        PARTY_PLAYER,  // vC[̃p[eB
        PARTY_PARTNER, // p[gi[̃p[eB( }`ogp )
        PARTY_NUM,
      }; 

      // J[\ʒu
      enum InitCursorPos {
        INIT_CURSOR_POS_POKE0,   // 0Ԗڂ̃|P
        INIT_CURSOR_POS_POKE1,   // 1Ԗڂ̃|P
        INIT_CURSOR_POS_POKE2,   // 2Ԗڂ̃|P
        INIT_CURSOR_POS_POKE3,   // 3Ԗڂ̃|P 
        INIT_CURSOR_POS_POKE4,   // 4Ԗڂ̃|P 
        INIT_CURSOR_POS_POKE5,   // 5Ԗڂ̃|P 
        INIT_CURSOR_POS_RETURN,  //uǂv{^
      }; 


      /**
       * @brief ݒ
       */
      struct Setting {
        Mode mode;                        // 샂[h
        bool return_enable;               //uǂv{^邩ǂ
        u32 item_id;                      // gp铹
        InitCursorPos init_cursor_pos;    // J[\̏ʒu
      };

      /**
       * @brief ݒύX
       * @param new_setting  Vݒ
       */
      virtual void ChangeSetting( const Setting& new_setting ) = 0; 



      //---------------------------------------------------------------------------------
      // RXgN^EfXgN^
      //---------------------------------------------------------------------------------
      /**
       * @brief RXgN^
       * @param app_heap          gpAvP[Vq[v
       * @param app_heap_size     gpAvP[Vq[ṽTCY
       * @param device_heap       gpfoCXq[v
       * @param device_heap_size  gpfoCXq[ṽTCY
       * @param btlv_system       og`RAVXe
       */
      IRepairSelect( 
          gfl::heap::HeapBase* app_heap, u32 app_heap_size,
          gfl::heap::HeapBase* device_heap, u32 device_heap_size, 
          BattleViewSystem* btlv_system );

      /**
       * @brief fXgN^
       */
      virtual ~IRepairSelect(); 





      //---------------------------------------------------------------------------------
      // I
      //---------------------------------------------------------------------------------
      enum Result {
        RESULT_RETURN,               //uǂvI
        RESULT_CANT_USE,             // gpłȂ|PI
        RESULT_SELECT_PLAYER_POKE,   // vC[̃|PI
        RESULT_SELECT_PARTNER_POKE,  // p[gi[̃|PI( }`ogp )
        RESULT_NULL,
      };

      /**
       * @brief ʂ擾
       */
      Result GetResult( void ) const;

      /**
       * @brief Ԗڂ̃|PÎ擾
       */
      u8 GetSelectedPokeIndex( void ) const;




      protected: 
      void SetSetting( const Setting& new_setting ) { m_settings = new_setting; }
      Mode GetMode( void ) const { return m_settings.mode; }
      bool IsReturnEnable( void ) const { return m_settings.return_enable; }
      u32 GetItemID( void ) const { return m_settings.item_id; }
      bool IsHPRecoverItem( void ) const;
      bool IsSickRecoverItem( void ) const;
      bool IsDeathRecoverItem( void ) const;
      InitCursorPos GetInitCursorPos( void ) const { return m_settings.init_cursor_pos; }
      const BTL_PARTY* GetParty( PartyId party_id ) const;

      void SetResult( Result result ) { m_result = result; }
      void ResetResult( void ) { m_result = RESULT_NULL; }
      void SetSelectedPokeIndex( u8 pokeindex ) { m_selected_pokeindex = pokeindex; }


      private:
      Setting m_settings;
      Result m_result;
      u8 m_selected_pokeindex;
    };


  }  // namespace app
}  // namespace btl


#endif  // __IREPAIRSELECT_H__
