//=======================================================================================
/**
 * @file IRepairSelect.cpp
 * @brief 񕜑ΏۑIʂ̊{NX
 * @author obata_toshihiro
 * @date 2011.09.27
 */
//=======================================================================================
#include <gflib.h>
#include <item/item.h>
#include <battle/btl_common.h>
#include <battle/btlv/btlv_core.h>
#include "AppBase.h"
#include "IRepairSelect.h"


namespace btl {
  namespace app {


    //---------------------------------------------------------------------------------
    // RXgN^
    //---------------------------------------------------------------------------------
    IRepairSelect::IRepairSelect( 
        gfl::heap::HeapBase* app_heap, u32 app_heap_size,
        gfl::heap::HeapBase* device_heap, u32 device_heap_size, 
        BattleViewSystem* btlv_system ) : 
      AppBase( 
          app_heap, HEAPID_BATTLE_REPAIR_SELECT, app_heap_size, 
          device_heap, HEAPID_BATTLE_REPAIR_SELECT_DEVICE, device_heap_size, 
          btlv_system ),
      m_settings(),
      m_result( RESULT_NULL ),
      m_selected_pokeindex( 0 )
    {
    }


    //---------------------------------------------------------------------------------
    // fXgN^
    //---------------------------------------------------------------------------------
    IRepairSelect::~IRepairSelect()
    {
    }



    //---------------------------------------------------------------------------------
    // ʂ擾
    //---------------------------------------------------------------------------------
    IRepairSelect::Result IRepairSelect::GetResult( void ) const
    {
      return m_result;
    }

    //---------------------------------------------------------------------------------
    // I|P̃CfbNX擾
    //---------------------------------------------------------------------------------
    u8 IRepairSelect::GetSelectedPokeIndex( void ) const
    {
      return m_selected_pokeindex;
    }



    // w肵|Pp[eB擾
    const BTL_PARTY* IRepairSelect::GetParty( PartyId party_id ) const
    {
      switch( party_id ) {
      default:
        GFL_ASSERT(0);
      case PARTY_PLAYER:
        return this->GetPlayerParty();
      case PARTY_PARTNER:
        return this->GetPlayerParty();  // @todo p[gi[̃p[eBԂ
      }
    }



    // HP񕜌ñACeǂ𒲂ׂ
    bool IRepairSelect::IsHPRecoverItem( void ) const
    {
      gfl::heap::HeapBase* heap = this->GetHeap();
      item::ITEM_DATA item_data( this->GetItemID(), heap );
      return item_data.GetParam( item::ITEM_DATA::PRM_ID_HP_RCV );
    }

    // Ԉُ񕜌ñACeǂ𒲂ׂ
    bool IRepairSelect::IsSickRecoverItem( void ) const
    {
      gfl::heap::HeapBase* heap = this->GetHeap();
      item::ITEM_DATA item_data( this->GetItemID(), heap );
      return ( 
          item_data.GetParam( item::ITEM_DATA::PRM_ID_SLEEP_RCV ) ||
          item_data.GetParam( item::ITEM_DATA::PRM_ID_POISON_RCV ) ||
          item_data.GetParam( item::ITEM_DATA::PRM_ID_BURN_RCV ) ||
          item_data.GetParam( item::ITEM_DATA::PRM_ID_ICE_RCV ) ||
          item_data.GetParam( item::ITEM_DATA::PRM_ID_PARALYZE_RCV ) ||
          item_data.GetParam( item::ITEM_DATA::PRM_ID_PANIC_RCV ) );
    }

    // m񕜌ñACeǂ𒲂ׂ
    bool IRepairSelect::IsDeathRecoverItem( void ) const
    {
      gfl::heap::HeapBase* heap = this->GetHeap();
      item::ITEM_DATA item_data( this->GetItemID(), heap );
      return item_data.GetParam( item::ITEM_DATA::PRM_ID_DEATH_RCV );
    }





  }  // namespace app
}  // namespace btl
