﻿##============================================================================
=pod
     file   field_area_env_converter.pl
     brief  フィールドの環境設定(ライトやフォグなどの設定)を書いたExcelファイルをバイナリファイルに変換する
     author Koji Kawada
     data   2011.06.08
=cut 
##============================================================================


##============================================================================
=pod

[usage]
perl field_area_env_converter.pl excel_file.xls binary_file.bin

[引数]
excel_file.xls
入力するExcelファイル

binary_file.bin
生成されるバイナリファイル

=cut 
##============================================================================


# このソース自体をUTF8で記述し、UTF8で処理を行う
use utf8;
binmode STDIN,  ":encoding(shiftjis)";
binmode STDOUT, ":encoding(shiftjis)";
binmode STDERR, ":encoding(shiftjis)";

# インクルード
use Encode;


##============================================================================
=pod
    グローバル変数
=cut
##============================================================================
#### デバッグフラグ
$g_warning_enable  = 0;  # 0のとき警告コード無効、1のとき警告コード有効
$g_debug_enable    = 0;  # 0のときデバッグコード無効、1のときデバッグコード有効

#### 入力および出力
# 引数
$g_excel_file   = $ARGV[0];  # excel_file.xls
$g_binary_file  = $ARGV[1];  # binary_file.bin

# 入力ファイル
# なし

# 出力ファイル
# なし

# 使用するファイル
$g_excel_sheet_converter = $ENV{"GFL_TOOL_DIR"}."/exceltool/ExcelSeetConv.exe";   # Excelファイルからシートをcsvで抜き出すツール

# 一時的に生成してすぐに削除するcsvファイル
$g_csv_base_file_name = $g_excel_file;
$g_csv_base_file_name =~ s/^(.*)\..*$/$1/;  # 拡張子を取り除く
$g_csv_file = $g_csv_base_file_name;   # g_excel_fileから抜き出したシートのcsvファイル  # ShiftJIS版
$g_csv_file .= ".csv";
$g_csv_file_utf8 = $g_csv_base_file_name;  # g_csv_fileのUTF8版
$g_csv_file_utf8 .= "_utf8.csv";

#### 定数
# g_excel_fileにあるシートの名前
$g_excel_sheet = "field_area_env";

# g_excel_sheetのセル番号
# 1(A)スタートとした場合、(3,F)はrow3=3行目、column6=6(F)列目となる
$g_sheet_start_row =   5;  # 1スタート
$g_sheet_end_row   = 141;  # g_sheet_start_row<= <g_sheet_end_row
$g_sheet_start_col =   4;  # 1スタート
$g_sheet_end_col   =   8;  # g_sheet_start_col<= <g_sheet_end_col

#### 変数
# 2次元配列のテーブル
@g_table = ();  # g_table[row][col]


##=============================================================================
=pod
    メイン処理
=cut
##=============================================================================
&ConvertExcelToCsv( $g_excel_file, $g_excel_sheet, $g_csv_file );
&EncodeFileFromShiftjisToUtf8( $g_csv_file, $g_csv_file_utf8 );
&ReadCsvFile();
&WriteBinaryFile();
&RemoveCsv();

# 終了
exit;


##=============================================================================
=pod
    サブルーチン
=cut
##=============================================================================

##-------------------------------------
### Excelファイルからシートをcsvで抜き出す
### グローバル変数を使っているので、他では使えないサブルーチンです。
##-------------------------------------
sub ConvertExcelToCsv
{
  my( $xls_file, $sheet_name, $csv_file ) = @_;
  system( $g_excel_sheet_converter.' -o '.$csv_file.' -n '.$sheet_name.' -s csv '.$xls_file );
}

##-------------------------------------
### ShiftJISファイルからUTF8ファイルを作成する
### グローバル変数を一切使っていないので、他でも使うことができるサブルーチンです。
##=====================================
sub EncodeFileFromShiftjisToUtf8
{
  my $in_file   = $_[0];  # shiftjis
  my $out_file  = $_[1];  # utf8

  open( IN, "<", $in_file );
  open( OUT, ">", $out_file );

  while( <IN> )
  {
    #$line = Encode::decode( 'shiftjis', $_ );
    $line = Encode::decode( 'cp932', $_ );  # WindowsのShiftJISはcp932。これにしておかないとハイフンとかチルダがうまくいかないらしい。
    print OUT Encode::encode( 'utf8', $line );
  }

  close( OUT );
  close( IN );
}

##-------------------------------------
### csvからデータを読み込む
### グローバル変数を使っているので、他では使えないサブルーチンです。
##-------------------------------------
sub ReadCsvFile
{
  my $sheet_row_no    = 1;  # csvの行番号(1スタート)
  my $sheet_col_no    = 1;  # csvの列番号(1スタート)

  my $table_row_index = 0;  # テーブルの行番号(0スタート)
  my $table_col_index = 0;  # テーブルの列番号(0スタート)


  open( DATA, "<:encoding(utf8)", $g_csv_file_utf8 );

  # 値に改行コードを含む CSV形式を扱う

  while (my $line = <DATA>)
  {
    $line .= <DATA> while ($line =~ tr/"// % 2 and !eof(DATA));

    $line =~ s/(?:\x0D\x0A|[\x0D\x0A])?$/,/;
    @values = map {/^"(.*)"$/s ? scalar($_ = $1, s/""/"/g, $_) : $_}
                  ($line =~ /("[^"]*(?:""[^"]*)*"|[^,]*),/g);

    # @values を処理する
    

    if( $sheet_row_no >= $g_sheet_end_row )
    {
      last;
    }
    if( $sheet_row_no >= $g_sheet_start_row )
    {
      $sheet_col_no = 1;
      $table_col_index = 0;
      foreach my $word ( @values )
      {
        if( $sheet_col_no >= $g_sheet_end_col )
        {
          last;
        }
        if( $sheet_col_no >= $g_sheet_start_col )
        {
          $g_table[$table_row_index][$table_col_index] = $word;
          $table_col_index++;
        }
        $sheet_col_no++;
      }
      $table_row_index++;
    }
    $sheet_row_no++;


  }

  close( DATA );


}

##-------------------------------------
### バイナリファイルを書き出す
### グローバル変数を使っているので、他では使えないサブルーチンです。
##-------------------------------------
sub WriteBinaryFile
{
  open( FH_BIN,  ">", $g_binary_file );

  for( my $row=0; $row<$g_sheet_end_row-$g_sheet_start_row; $row++ )
  {
    for( my $col=0; $col<$g_sheet_end_col-$g_sheet_start_col; $col++ )
    {
      #my $buf = pack "e", $g_table[$row][$col];  # リトルエンディアンの単精度浮動小数点数(機種依存)
      #my $buf = pack "V", $g_table[$row][$col];  # "VAX"バイトオーダー(リトルエンディアン)のunsigned long
      my $buf = pack "f", $g_table[$row][$col];  # 機種依存の単精度浮動小数点数。あるマシンでパックした浮動小数点数は、別のマシンでは読めない可能性があります。
      print FH_BIN "$buf";

      if( $g_debug_enable == 1 )
      {
        # 標準エラー出力
        print STDERR "$g_table[$row][$col]".", ";
        #print STDERR "$buf".", ";  # $bufを出力しようとすると固まった
      }
    }

    if( $g_debug_enable == 1 )
    {
      # 標準エラー出力
      print STDERR "\r\n";  # 0D 0A
    }
  }

  close( FH_BIN );
}

##-------------------------------------
### 一時的に生成してすぐに削除するcsvファイルを削除する
### グローバル変数を使っているので、他では使えないサブルーチンです。
##-------------------------------------
sub RemoveCsv
{
  unlink( $g_csv_file_utf8 );
  unlink( $g_csv_file );
}


##============================================================================
=pod
# ファイルのコピーの例

use File::Copy;
$g_src = $ARGV[0];
$g_dst = $ARGV[1];
copy( $g_src $g_dst );

=cut 
##============================================================================
