//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file		FieldAreaEnv.cpp
 *	@brief  tB[h GÅݒ
 *	@author	Koji Kawada
 *	@date		2011.08.11
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

// CTR_SDK

// NW4C
#include <nw/gfx.h>

// gflib
#include <gflib.h>


#include "FieldAreaEnv.h"

// arc
#include "arc/arc_def.h"           // ARCID_ 
#include "arc/field_area_env.gaix"

namespace field {

//-----------------------------------------------------------------------------
/**
 *					NX`
*/
//-----------------------------------------------------------------------------

//-------------------------------------
///	tB[h GÅݒNX
//=====================================
void FieldAreaEnv::StartLoad(gfl::heap::HeapBase* heap_memory, u16 data_id)  // heap_memory̓foCXłȂĂ悢
{
  // [hĂȂƂ̂݁A[hJn\
  if(m_load_state == LOAD_STATE_NONE )
  {
    m_heap_memory = heap_memory;
    m_data_id     = data_id;

    // [hV[PXJn
    m_load_state = LOAD_STATE_START;
    m_arc_file = GFL_NEW(m_heap_memory) gfl::fs::ArcFile(ARCID_FIELD_AREA_ENV);

    // A[JCut@C[hɈڍs
    m_arc_file->StartSetupForFastMode(m_heap_memory);
    m_load_state = LOAD_STATE_UPDATE_FILE_MODE;
  }
}

b32  FieldAreaEnv::UpdateLoad(void)
{
  // [h[hI
  switch(m_load_state)
  {
  // A[JCut@C[hɈڍs
  case LOAD_STATE_UPDATE_FILE_MODE:
    {
      if( m_arc_file->WaitSetupForFastMode() )
      {
        // t@Cǂݍ
        u32 size = m_arc_file->GetDataSize( m_data_id );
        u32 size_align = 4;  // f32΂̃f[^Ȃ̂
        m_buffer = GflHeapAllocMemoryAlign( m_heap_memory, size, size_align );
        m_buffer_size = size;
        m_arc_file->StartAsyncRead( m_heap_memory, m_data_id, m_buffer, MAIN_THREAD_PRIORITY +1 );  // CXbh͒ႢDx
        
        m_load_state = LOAD_STATE_UPDATE_FILE_LOAD;
      }
    }
    break;
  // t@Cǂݍݒ
  case LOAD_STATE_UPDATE_FILE_LOAD:
    {
      if( !(m_arc_file->WaitAsyncRead()) )
      {
        // [hI
        m_load_state = LOAD_STATE_FINISH;

        {
          // j
          GFL_DELETE m_arc_file;
          m_arc_file = NULL;
  
          m_heap_memory = NULL;
        }
      }
    }
    break;
  }

  return this->IsLoadFinished();
}

b32  FieldAreaEnv::IsLoadFinished(void)
{
  return (m_load_state == LOAD_STATE_FINISH);
}

void FieldAreaEnv::Unload(void)
{
  // [hI[hĂȂ
  if(m_arc_file)
  {
    GFL_DELETE m_arc_file;
    m_arc_file = NULL;
  }
  if(m_buffer)
  {
    GflHeapFreeMemory(m_buffer);
    m_buffer = NULL;
    m_buffer_size = 0;
  }

  m_load_state = LOAD_STATE_NONE;
  m_heap_memory = NULL;
  m_data_id = 0;
}

}  // namespace field

